/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclaration;
import de.intarsys.tools.functor.ChainedArgs;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import java.util.Set;

public class DeclaredArgs
implements IArgs {
    private IArgs argsIn;
    private IArgs argsOut;
    private Args declaredArgs;
    private boolean lazy = true;
    private boolean strict = false;

    public static DeclaredArgs createStrict(IArgs args) {
        DeclaredArgs result = new DeclaredArgs(args);
        result.setLazy(false);
        result.setStrict(true);
        return result;
    }

    public static DeclaredArgs createStrictIfDeclared(IArgs args) {
        DeclaredArgs result = new DeclaredArgs(args);
        result.setLazy(true);
        result.setStrict(true);
        return result;
    }

    public static DeclaredArgs createTransparent(IArgs args) {
        DeclaredArgs result = new DeclaredArgs(args);
        result.setLazy(false);
        result.setStrict(false);
        return result;
    }

    protected DeclaredArgs(IArgs args) {
        this.argsIn = args;
        this.argsOut = args;
    }

    public void add(Object object) {
        this.switchArgs();
        this.declaredArgs.add(object);
    }

    public void clear() {
        this.switchArgs();
        this.declaredArgs.clear();
    }

    protected void declare(IFunctorCall call, ArgumentDeclaration argDecl) throws DeclarationException {
        this.declare(call, argDecl.getName(), argDecl.getIndex(), argDecl.getDefaultFunctor());
    }

    protected void declare(IFunctorCall call, String name, int index, IFunctor defaultFunctor) throws DeclarationException {
        this.switchArgs();
        Object value = null;
        if (this.argsIn.isNamed() ? (value = this.argsIn.get(name)) == null && this.argsIn.isDefined(name) : this.argsIn.isIndexed() && (value = this.argsIn.get(index)) == null && this.argsIn.isDefined(index)) {
            return;
        }
        if (value instanceof IArgs || value == null) {
            Object defaultValue = null;
            if (defaultFunctor != null) {
                try {
                    defaultValue = defaultFunctor.perform(call);
                }
                catch (FunctorInvocationException e) {
                    throw new DeclarationException(e);
                }
            }
            if (defaultValue instanceof IDeclaration[]) {
                if (value == null) {
                    value = Args.create();
                }
                DeclaredArgs childDeclaredArgs = new DeclaredArgs((IArgs)value);
                childDeclaredArgs.setLazy(this.isLazy());
                childDeclaredArgs.setStrict(this.isStrict());
                IDeclaration[] declarations = (IDeclaration[])defaultValue;
                int i = 0;
                while (i < declarations.length) {
                    IDeclaration declaration = declarations[i];
                    if (!(declaration instanceof ArgumentDeclaration)) {
                        throw new DeclarationException("ArgumentDeclaration expected");
                    }
                    ArgumentDeclaration argDecl = (ArgumentDeclaration)declaration;
                    childDeclaredArgs.declare(call, argDecl);
                    ++i;
                }
                value = childDeclaredArgs;
            } else if (value == null) {
                value = defaultValue;
            }
        }
        this.declaredArgs.put(index, value);
        this.declaredArgs.put(name, value);
    }

    public Object get(int pIndex) {
        return this.argsOut.get(pIndex);
    }

    public Object get(int pIndex, Object defaultValue) {
        return this.argsOut.get(pIndex, defaultValue);
    }

    public Object get(String name) {
        return this.argsOut.get(name);
    }

    public Object get(String name, Object defaultValue) {
        return this.argsOut.get(name, defaultValue);
    }

    public IArgs getArgsIn() {
        return this.argsIn;
    }

    public boolean isDefined(int index) {
        return this.argsOut.isDefined(index);
    }

    public boolean isDefined(String name) {
        return this.argsOut.isDefined(name);
    }

    public boolean isIndexed() {
        return true;
    }

    protected boolean isLazy() {
        return this.lazy;
    }

    public boolean isNamed() {
        return true;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    public Set names() {
        return this.argsOut.names();
    }

    public void put(int index, Object value) {
        this.switchArgs();
        this.declaredArgs.put(index, value);
    }

    public void put(String name, Object value) {
        this.switchArgs();
        this.declaredArgs.put(name, value);
    }

    protected void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    protected void setStrict(boolean strict) {
        this.strict = strict;
        if (strict && !this.lazy) {
            this.switchArgs();
        }
    }

    public int size() {
        return this.argsOut.size();
    }

    protected void switchArgs() {
        if (this.argsIn != this.argsOut) {
            return;
        }
        this.declaredArgs = new Args();
        this.argsOut = this.strict ? this.declaredArgs : new ChainedArgs(this.declaredArgs, this.argsIn);
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }
}

