/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.number.NumberWrapper;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;

public class NumberInstance
extends NumberWrapper {
    private Number n;

    public NumberInstance(double i) {
        this.n = new Double(i);
    }

    public NumberInstance(int i) {
        this.n = new Integer(i);
    }

    public NumberInstance(Number number) {
        this.n = number;
    }

    public NumberInstance(String numberValueInString) {
        int zahl = Integer.parseInt(numberValueInString);
        this.n = new Integer(zahl);
    }

    public Number getN() {
        return this.n;
    }

    public Iterator iterator() {
        return new SingleObjectIterator(this.getN());
    }

    public String toString() {
        return NumberFormat.getInstance().format(this.getN());
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean contains(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue() == this.n.doubleValue();
        }
        if (o instanceof NumberWrapper && !((NumberWrapper)o).isEmpty()) {
            return ((NumberWrapper)o).getFirst().doubleValue() == this.n.doubleValue();
        }
        return false;
    }

    public Object[] toArray() {
        return new Number[]{this.n};
    }

    public boolean add(Object arg0) {
        if (arg0 instanceof Number) {
            this.n = (Number)arg0;
            return true;
        }
        if (arg0 instanceof NumberWrapper && !((NumberWrapper)arg0).isEmpty()) {
            this.n = ((NumberWrapper)arg0).getFirst();
            return true;
        }
        throw new IllegalArgumentException("Only objects of type Number or NumberWrapper are supported.");
    }

    public boolean addAll(Collection arg0) {
        if (arg0.size() == 0) {
            return false;
        }
        Object o = arg0.iterator().next();
        if (o instanceof Number) {
            this.n = (Number)((Object)arg0);
            return true;
        }
        return false;
    }

    protected double getMin() {
        return this.n.doubleValue();
    }

    protected double getMax() {
        return this.n.doubleValue();
    }

    public void increment(int i) {
        this.n = new Integer(this.getN().intValue() + i);
    }
}

