/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Person;
import org.sciplore.resources.Resource;

@Entity
@Table(name="documents_persons")
public class DocumentPerson
extends Resource {
    public static final short DOCUMENTPERSON_TYPE_AUTHOR = 1;
    public static final short DOCUMENTPERSON_TYPE_EDITOR = 2;
    @ManyToOne
    @Fetch(value=FetchMode.JOIN)
    @JoinColumn(name="document_id")
    private Document document;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne
    @Fetch(value=FetchMode.JOIN)
    @JoinColumn(name="person_id")
    private Person person;
    @Column(nullable=false)
    private Short rank = 0;
    @Column(nullable=false)
    private Short type = 1;
    @Column(nullable=false)
    private Short valid = 1;

    public DocumentPerson getDocumentPerson(DocumentPerson dp) {
        if (dp.getId() != null) {
            return this.getDocumentPerson(dp.getId());
        }
        return this.getDocumentPerson(dp.getDocument(), dp.getPerson());
    }

    public DocumentPerson getDocumentPerson(Integer id) {
        return (DocumentPerson)this.getSession().get(DocumentPerson.class, (Serializable)id);
    }

    public DocumentPerson getDocumentPerson(Document d, Person p) {
        if (d != null && p != null && d.getId() != null && p.getId() != null) {
            return (DocumentPerson)this.getSession().createCriteria(DocumentPerson.class).add((Criterion)Restrictions.eq((String)"document", (Object)d)).add((Criterion)Restrictions.eq((String)"person", (Object)p)).setMaxResults(1).uniqueResult();
        }
        return null;
    }

    public DocumentPerson() {
    }

    public DocumentPerson(Session s) {
        this.setSession(s);
    }

    public DocumentPerson(Session s, Person p) {
        this.setSession(s);
        this.person = p;
    }

    public DocumentPerson(Session s, Person p, Short type) {
        this.setSession(s);
        this.person = p;
        this.type = type;
    }

    public DocumentPerson(Session s, Person p, Short type, Short rank) {
        this.setSession(s);
        this.person = p;
        this.type = type;
        this.rank = rank;
    }

    public Document getDocument() {
        return this.document;
    }

    public Integer getId() {
        return this.id;
    }

    public Person getPerson() {
        return this.person;
    }

    public Short getRank() {
        return this.rank;
    }

    public Short getType() {
        return this.type;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setRank(Short rank) {
        this.rank = rank;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

