/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class XmlBindingTools {
    private static XmlBindingTools instance;
    private static IBindingFactory mBindingFactory;

    private XmlBindingTools() {
    }

    public static XmlBindingTools getInstance() {
        if (instance == null) {
            instance = new XmlBindingTools();
            try {
                mBindingFactory = BindingDirectory.getFactory(XmlAction.class);
            }
            catch (JiBXException e) {
                Resources.getInstance().logException(e);
            }
        }
        return instance;
    }

    public IMarshallingContext createMarshaller() {
        try {
            return mBindingFactory.createMarshallingContext();
        }
        catch (JiBXException e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public IUnmarshallingContext createUnmarshaller() {
        try {
            return mBindingFactory.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }

    public void storeDialogPositions(Controller controller, JDialog dialog, WindowConfigurationStorage storage, String window_preference_storage_property) {
        String marshalled;
        storage.setX(dialog.getX());
        storage.setY(dialog.getY());
        storage.setWidth(dialog.getWidth());
        storage.setHeight(dialog.getHeight());
        String result = marshalled = this.marshall((XmlAction)storage);
        controller.setProperty(window_preference_storage_property, result);
    }

    public WindowConfigurationStorage decorateDialog(Controller controller, JDialog dialog, String window_preference_storage_property) {
        String marshalled = controller.getProperty(window_preference_storage_property);
        WindowConfigurationStorage result = this.decorateDialog(marshalled, dialog);
        return result;
    }

    public WindowConfigurationStorage decorateDialog(String marshalled, JDialog dialog) {
        WindowConfigurationStorage storage;
        if (marshalled != null && (storage = (WindowConfigurationStorage)this.unMarshall(marshalled)) != null) {
            Dimension screenSize;
            if (Resources.getInstance().getBoolProperty("place_dialogs_on_first_screen")) {
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                screenSize = defaultToolkit.getScreenSize();
            } else {
                screenSize = new Dimension();
                screenSize.height = Integer.MAX_VALUE;
                screenSize.width = Integer.MAX_VALUE;
            }
            int delta = 20;
            dialog.setLocation(Math.min(storage.getX(), screenSize.width - delta), Math.min(storage.getY(), screenSize.height - delta));
            dialog.setSize(new Dimension(storage.getWidth(), storage.getHeight()));
            return storage;
        }
        Frame rootFrame = JOptionPane.getFrameForComponent(dialog);
        Dimension prefSize = rootFrame.getSize();
        prefSize.width = prefSize.width * 3 / 4;
        prefSize.height = prefSize.height * 3 / 4;
        dialog.setSize(prefSize);
        return null;
    }

    public String marshall(XmlAction action) {
        StringWriter writer = new StringWriter();
        IMarshallingContext m = XmlBindingTools.getInstance().createMarshaller();
        try {
            m.marshalDocument((Object)action, "UTF-8", null, (Writer)writer);
        }
        catch (JiBXException e) {
            Resources.getInstance().logException(e);
            return null;
        }
        String result = writer.toString();
        return result;
    }

    public XmlAction unMarshall(String inputString) {
        return this.unMarshall(new StringReader(inputString));
    }

    public XmlAction unMarshall(Reader reader) {
        try {
            IUnmarshallingContext u = XmlBindingTools.getInstance().createUnmarshaller();
            XmlAction doAction = (XmlAction)u.unmarshalDocument(reader, null);
            return doAction;
        }
        catch (JiBXException e) {
            Resources.getInstance().logException(e);
            return null;
        }
    }
}

