/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.modes.LinkAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Logger;

public class LinkRegistryAdapter
implements MindMapLinkRegistry {
    protected HashMap TargetToID = new HashMap();
    protected HashMap IDToTarget = new HashMap();
    protected HashMap IDToLinks = new HashMap();
    protected HashMap IDToCutLinks = new HashMap();
    protected HashMap IDToLink = new HashMap();
    protected HashSet mLocallyLinkedIDs = new HashSet();
    private static Logger logger = Logger.getAnonymousLogger();
    protected static Random ran = new Random();

    @Override
    public String generateUniqueID(String proposedID) {
        return this.generateID(proposedID, this.IDToLinks, "ID_");
    }

    @Override
    public String generateUniqueLinkID(String proposedID) {
        return this.generateID(proposedID, this.IDToLink, "Arrow_ID_");
    }

    private String generateID(String proposedID, HashMap hashMap, String prefix) {
        String returnValue;
        String myProposedID = new String(proposedID != null ? proposedID : "");
        do {
            if (!myProposedID.equals("")) {
                returnValue = myProposedID;
                myProposedID = "";
                continue;
            }
            returnValue = prefix + Integer.toString(ran.nextInt(2000000000));
        } while (hashMap.containsKey(returnValue));
        return returnValue;
    }

    @Override
    public void registerLinkTarget(MindMapNode pTarget) {
        this._registerLinkTarget(pTarget);
    }

    @Override
    public String registerLinkTarget(MindMapNode pTarget, String pProposedID) {
        return this._registerLinkTarget(pTarget, pProposedID).getID();
    }

    public ID_Registered _registerLinkTarget(MindMapNode target) {
        return this._registerLinkTarget(target, null);
    }

    public ID_Registered _registerLinkTarget(MindMapNode target, String proposedID) {
        ID_BasicState state;
        if (this.TargetToID.containsKey(target) && (state = (ID_BasicState)this.TargetToID.get(target)) instanceof ID_Registered) {
            return (ID_Registered)state;
        }
        String newID = this.generateUniqueID(proposedID);
        ID_RegisteredAdapter state2 = new ID_RegisteredAdapter(target, newID);
        this.TargetToID.put(target, state2);
        this.IDToTarget.put(newID, target);
        this.getAssignedLinksVector(state2);
        return state2;
    }

    public ID_BasicState getState(MindMapNode node) {
        if (this.TargetToID.containsKey(node)) {
            return (ID_BasicState)this.TargetToID.get(node);
        }
        return new ID_BlankAdapter();
    }

    @Override
    public MindMapNode getTargetForID(String ID) {
        Object target = this.IDToTarget.get(ID);
        return (MindMapNode)target;
    }

    private Vector getAssignedLinksVector(ID_Registered state) {
        Vector vec;
        String id = state.getID();
        if (this.IDToLinks.containsKey(id)) {
            vec = (Vector)this.IDToLinks.get(id);
        } else {
            vec = new Vector();
            this.IDToLinks.put(id, vec);
        }
        return vec;
    }

    @Override
    public void deregisterLinkTarget(MindMapNode target) throws IllegalArgumentException {
        ID_BasicState state = this.getState(target);
        if (state instanceof ID_Registered) {
            Vector vec = this.getAssignedLinksVector((ID_Registered)state);
            for (int i = vec.size() - 1; i >= 0; --i) {
                this.deregisterLink((MindMapLink)vec.get(i));
            }
            this.TargetToID.remove(target);
            this.IDToTarget.remove(state.getID());
            this.IDToLinks.remove(state.getID());
        }
    }

    @Override
    public void registerLink(MindMapLink link) throws IllegalArgumentException {
        if (link.getSource() == null || link.getTarget() == null || link.getDestinationLabel() == null) {
            throw new IllegalArgumentException("Illegal link specification." + link);
        }
        MindMapNode source = link.getSource();
        MindMapNode target = link.getTarget();
        logger.info("Register link (" + link + ") from source node:" + source + " to target " + target);
        ID_Registered state = this._registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(state);
        for (int i = 0; i < vec.size(); ++i) {
            if (vec.get(i) != link) continue;
            return;
        }
        vec.add(link);
        String uniqueID = link.getUniqueID();
        if (uniqueID == null) {
            ((LinkAdapter)link).setUniqueID(this.generateUniqueLinkID(uniqueID));
            uniqueID = link.getUniqueID();
        }
        if (this.IDToLink.containsKey(uniqueID) && this.IDToLink.get(uniqueID) != link) {
            logger.warning("link with duplicated unique id found:" + link);
            ((LinkAdapter)link).setUniqueID(this.generateUniqueLinkID(uniqueID));
        }
        this.IDToLink.put(uniqueID, link);
    }

    @Override
    public void deregisterLink(MindMapLink link) {
        MindMapNode source = link.getSource();
        MindMapNode target = link.getTarget();
        ID_Registered state = this._registerLinkTarget(target);
        Vector vec = this.getAssignedLinksVector(state);
        for (int i = vec.size() - 1; i >= 0; --i) {
            if (vec.get(i) != link) continue;
            vec.removeElementAt(i);
        }
        this.IDToLink.remove(link.getUniqueID());
    }

    @Override
    public MindMapLink getLinkForID(String ID) {
        if (this.IDToLink.containsKey(ID)) {
            return (MindMapLink)this.IDToLink.get(ID);
        }
        return null;
    }

    public Vector getAllSources(MindMapNode target) {
        Vector<MindMapNode> returnValue = new Vector<MindMapNode>();
        ID_BasicState state = this.getState(target);
        if (state instanceof ID_Registered) {
            Vector vec = this.getAssignedLinksVector((ID_Registered)state);
            for (int i = 0; i < vec.size(); ++i) {
                returnValue.add(((MindMapLink)vec.get(i)).getSource());
            }
        }
        return returnValue;
    }

    @Override
    public Vector getAllLinks(MindMapNode node) {
        Vector returnValue = new Vector();
        returnValue.addAll(this.getAllLinksIntoMe(node));
        returnValue.addAll(this.getAllLinksFromMe(node));
        return returnValue;
    }

    @Override
    public Vector getAllLinksIntoMe(MindMapNode target) {
        Vector returnValue = new Vector();
        ID_BasicState state = this.getState(target);
        if (this.getState(target) instanceof ID_Registered) {
            Vector vec = this.getAssignedLinksVector((ID_Registered)state);
            returnValue.addAll(vec);
        }
        return returnValue;
    }

    @Override
    public Vector getAllLinksFromMe(MindMapNode source) {
        Vector<MindMapLink> returnValue = new Vector<MindMapLink>();
        Collection values = this.IDToLinks.values();
        for (Vector linkVector : values) {
            for (int j = 0; j < linkVector.size(); ++j) {
                MindMapLink link = (MindMapLink)linkVector.get(j);
                if (link.getSource() != source) continue;
                returnValue.add(link);
            }
        }
        return returnValue;
    }

    @Override
    public String getLabel(MindMapNode target) {
        ID_BasicState state = this.getState(target);
        if (this.getState(target) instanceof ID_Registered) {
            return ((ID_Registered)state).getID();
        }
        return null;
    }

    @Override
    public void cutNode(MindMapNode target) {
        ID_BasicState state = this.getState(target);
        if (state instanceof ID_Registered) {
            Vector vec;
            String id = this.getLabel(target);
            if (this.IDToCutLinks.containsKey(id)) {
                vec = (Vector)this.IDToCutLinks.get(id);
                vec.clear();
            } else {
                vec = new Vector();
                this.IDToCutLinks.put(id, vec);
            }
            Vector links = this.getAllLinksIntoMe(target);
            for (int i = links.size() - 1; i >= 0; --i) {
                MindMapLink link = (MindMapLink)links.get(i);
                vec.add(link);
                this.deregisterLink(link);
            }
            this.deregisterLinkTarget(target);
        }
        Vector links = this.getAllLinksFromMe(target);
        for (int i = links.size() - 1; i >= 0; --i) {
            MindMapLink link = (MindMapLink)links.get(i);
            this.deregisterLink(link);
        }
        ListIterator e = target.childrenUnfolded();
        while (e.hasNext()) {
            MindMapNode child = (MindMapNode)e.next();
            this.cutNode(child);
        }
    }

    @Override
    public void clearCuttedNodeBuffer() {
        this.IDToCutLinks.clear();
    }

    @Override
    public Vector getCuttedLinks(String oldTargetID) {
        Vector vec = this.IDToCutLinks.containsKey(oldTargetID) ? (Vector)this.IDToCutLinks.get(oldTargetID) : new Vector();
        return vec;
    }

    @Override
    public void registerLocalHyperlinkId(String pTargetId) {
        this.mLocallyLinkedIDs.add(pTargetId);
    }

    @Override
    public boolean isTargetOfLocalHyperlinks(String pTargetId) {
        return this.mLocallyLinkedIDs.contains(pTargetId);
    }

    protected class ID_RegisteredAdapter
    extends ID_UsedStateAdapter
    implements ID_Registered {
        public ID_RegisteredAdapter(MindMapNode target, String ID) {
            super(target, ID);
        }
    }

    protected abstract class ID_UsedStateAdapter
    extends ID_BasicStateAdapter
    implements ID_UsedState {
        protected MindMapNode target;

        @Override
        public MindMapNode getTarget() {
            return this.target;
        }

        public ID_UsedStateAdapter(MindMapNode target, String ID) {
            this.target = target;
            this.ID = ID;
        }

        protected ID_UsedStateAdapter() {
        }

        protected void clone(ID_UsedStateAdapter state) {
            this.target = state.target;
            this.ID = state.ID;
        }
    }

    public class ID_BlankAdapter
    extends ID_BasicStateAdapter
    implements ID_Blank {
    }

    public class ID_BasicStateAdapter
    implements ID_BasicState {
        protected String ID;

        @Override
        public String getID() {
            return this.ID;
        }

        @Override
        public String toString() {
            return "ID_BasicState, ID=" + (this.ID == null ? "null" : this.ID);
        }
    }

    public static interface ID_Registered
    extends ID_UsedState {
    }

    public static interface ID_UsedState
    extends ID_BasicState {
        public MindMapNode getTarget();
    }

    public static interface ID_Blank
    extends ID_BasicState {
    }

    public static interface ID_BasicState {
        public String getID();

        public String toString();
    }
}

