/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.main.Resources;
import freemind.modes.ControllerAdapter;
import freemind.modes.common.dialogs.PersistentEditableComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class BrowseToolBar
extends JToolBar {
    public static final String BROWSE_URL_STORAGE_KEY = "browse_url_storage";
    private ControllerAdapter c;
    private PersistentEditableComboBox urlfield = null;

    public BrowseToolBar(ControllerAdapter controller) {
        this.c = controller;
        this.urlfield = new PersistentEditableComboBox(controller, BROWSE_URL_STORAGE_KEY);
        this.setRollover(true);
        this.urlfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String urlText = BrowseToolBar.this.urlfield.getText();
                if ("".equals(urlText) || e.getActionCommand().equals("comboBoxEdited")) {
                    return;
                }
                try {
                    BrowseToolBar.this.c.load(new URL(urlText));
                }
                catch (Exception e1) {
                    Resources.getInstance().logException(e1);
                    BrowseToolBar.this.c.getController().errorMessage(e1);
                }
            }
        });
        this.add(new JLabel("URL:"));
        this.add(this.urlfield);
    }

    void setURLField(String text) {
        this.urlfield.setText(text);
    }
}

