/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.common.XmlBindingTools;
import freemind.controller.MenuItemEnabledListener;
import freemind.controller.MindMapNodesSelection;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.EditNoteToNodeAction;
import freemind.controller.actions.generated.instance.MenuActionBase;
import freemind.controller.actions.generated.instance.MenuCategoryBase;
import freemind.controller.actions.generated.instance.MenuCheckedAction;
import freemind.controller.actions.generated.instance.MenuRadioAction;
import freemind.controller.actions.generated.instance.MenuSeparator;
import freemind.controller.actions.generated.instance.MenuStructure;
import freemind.controller.actions.generated.instance.MenuSubmenu;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.PatternEdgeColor;
import freemind.controller.actions.generated.instance.PatternEdgeStyle;
import freemind.controller.actions.generated.instance.PatternEdgeWidth;
import freemind.controller.actions.generated.instance.PatternIcon;
import freemind.controller.actions.generated.instance.PatternNodeBackgroundColor;
import freemind.controller.actions.generated.instance.PatternNodeColor;
import freemind.controller.actions.generated.instance.PatternNodeFontBold;
import freemind.controller.actions.generated.instance.PatternNodeFontItalic;
import freemind.controller.actions.generated.instance.PatternNodeFontName;
import freemind.controller.actions.generated.instance.PatternNodeFontSize;
import freemind.controller.actions.generated.instance.PatternNodeStyle;
import freemind.controller.actions.generated.instance.PatternNodeText;
import freemind.controller.actions.generated.instance.WindowConfigurationStorage;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookFactory;
import freemind.extensions.HookRegistration;
import freemind.extensions.ModeControllerHook;
import freemind.extensions.NodeHook;
import freemind.extensions.PermanentNodeHook;
import freemind.extensions.UndoEventReceiver;
import freemind.main.ExampleFileFilter;
import freemind.main.FixedHTMLWriter;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.NodeDownAction;
import freemind.modes.StylePatternFactory;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.common.CommonNodeKeyListener;
import freemind.modes.common.GotoLinkNodeAction;
import freemind.modes.common.actions.FindAction;
import freemind.modes.common.actions.NewMapAction;
import freemind.modes.common.listeners.CommonNodeMouseMotionListener;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapHTMLWriter;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.MindMapPopupMenu;
import freemind.modes.mindmapmode.MindMapToolBar;
import freemind.modes.mindmapmode.MindMapXMLElement;
import freemind.modes.mindmapmode.actions.AddArrowLinkAction;
import freemind.modes.mindmapmode.actions.AddLocalLinkAction;
import freemind.modes.mindmapmode.actions.ApplyPatternAction;
import freemind.modes.mindmapmode.actions.BoldAction;
import freemind.modes.mindmapmode.actions.ChangeArrowLinkEndPoints;
import freemind.modes.mindmapmode.actions.ChangeArrowsInArrowLinkAction;
import freemind.modes.mindmapmode.actions.CloudAction;
import freemind.modes.mindmapmode.actions.CloudColorAction;
import freemind.modes.mindmapmode.actions.ColorArrowLinkAction;
import freemind.modes.mindmapmode.actions.CompoundActionHandler;
import freemind.modes.mindmapmode.actions.CopyAction;
import freemind.modes.mindmapmode.actions.CopySingleAction;
import freemind.modes.mindmapmode.actions.CutAction;
import freemind.modes.mindmapmode.actions.DeleteChildAction;
import freemind.modes.mindmapmode.actions.EdgeColorAction;
import freemind.modes.mindmapmode.actions.EdgeStyleAction;
import freemind.modes.mindmapmode.actions.EdgeWidthAction;
import freemind.modes.mindmapmode.actions.EditAction;
import freemind.modes.mindmapmode.actions.ExportBranchAction;
import freemind.modes.mindmapmode.actions.FontFamilyAction;
import freemind.modes.mindmapmode.actions.FontSizeAction;
import freemind.modes.mindmapmode.actions.HookAction;
import freemind.modes.mindmapmode.actions.IconAction;
import freemind.modes.mindmapmode.actions.ImportExplorerFavoritesAction;
import freemind.modes.mindmapmode.actions.ImportFolderStructureAction;
import freemind.modes.mindmapmode.actions.ItalicAction;
import freemind.modes.mindmapmode.actions.JoinNodesAction;
import freemind.modes.mindmapmode.actions.MindMapActions;
import freemind.modes.mindmapmode.actions.MindMapControllerHookAction;
import freemind.modes.mindmapmode.actions.ModeControllerActionHandler;
import freemind.modes.mindmapmode.actions.MoveNodeAction;
import freemind.modes.mindmapmode.actions.NewChildAction;
import freemind.modes.mindmapmode.actions.NewPreviousSiblingAction;
import freemind.modes.mindmapmode.actions.NewSiblingAction;
import freemind.modes.mindmapmode.actions.NodeBackgroundColorAction;
import freemind.modes.mindmapmode.actions.NodeColorAction;
import freemind.modes.mindmapmode.actions.NodeColorBlendAction;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.NodeHookAction;
import freemind.modes.mindmapmode.actions.NodeStyleAction;
import freemind.modes.mindmapmode.actions.NodeUpAction;
import freemind.modes.mindmapmode.actions.PasteAction;
import freemind.modes.mindmapmode.actions.RedoAction;
import freemind.modes.mindmapmode.actions.RemoveAllIconsAction;
import freemind.modes.mindmapmode.actions.RemoveArrowLinkAction;
import freemind.modes.mindmapmode.actions.RemoveIconAction;
import freemind.modes.mindmapmode.actions.RevertAction;
import freemind.modes.mindmapmode.actions.SelectAllAction;
import freemind.modes.mindmapmode.actions.SelectBranchAction;
import freemind.modes.mindmapmode.actions.SetLinkByTextFieldAction;
import freemind.modes.mindmapmode.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.actions.ToggleChildrenFoldedAction;
import freemind.modes.mindmapmode.actions.ToggleFoldedAction;
import freemind.modes.mindmapmode.actions.UnderlinedAction;
import freemind.modes.mindmapmode.actions.UndoAction;
import freemind.modes.mindmapmode.actions.UsePlainTextAction;
import freemind.modes.mindmapmode.actions.UseRichFormattingAction;
import freemind.modes.mindmapmode.actions.xml.ActionFactory;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.NodeHookUndoableContentActor;
import freemind.modes.mindmapmode.actions.xml.PrintActionHandler;
import freemind.modes.mindmapmode.actions.xml.UndoActionHandler;
import freemind.modes.mindmapmode.attributeactors.AssignAttributeDialog;
import freemind.modes.mindmapmode.attributeactors.MindMapModeAttributeController;
import freemind.modes.mindmapmode.hooks.MindMapHookFactory;
import freemind.modes.mindmapmode.listeners.MindMapMouseMotionManager;
import freemind.modes.mindmapmode.listeners.MindMapNodeDropListener;
import freemind.modes.mindmapmode.listeners.MindMapNodeMotionListener;
import freemind.view.MapModule;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.attributeview.AttributePopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import splmm.Actions.AddMonitoringDirAction;
import splmm.Actions.AddReferenceAttributeAction;
import splmm.Actions.AllUpdateMonitoringAction;
import splmm.Actions.CheckBoxAction;
import splmm.Actions.ContactAction;
import splmm.Actions.CopyCiteReferenceAttributeAction;
import splmm.Actions.CopyReferenceAttributeAction;
import splmm.Actions.DeleteReferenceAttributeAction;
import splmm.Actions.EditMonitoringDirAction;
import splmm.Actions.EditReferenceAttributeAction;
import splmm.Actions.HelpAction;
import splmm.Actions.ImportAllBookmarksAction;
import splmm.Actions.PreferencesAction;
import splmm.Actions.RemoveMonitoringDirAction;
import splmm.Actions.SmartImportBookmarksAction;
import splmm.Actions.SmartUpdateMonitoringDirAction;
import splmm.Actions.UpdateAction;
import splmm.Actions.ViewLogsAction;
import splmm.Listeners.TripleStateItemListener;
import splmm.Listeners.TripleStateNodeSelectionListener;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class MindMapController
extends ControllerAdapter
implements MindMapActions {
    private static final String ACCESSORIES_PLUGINS_NODE_NOTE = "accessories.plugins.NodeNote";
    private static final String RESOURCE_UNFOLD_ON_PASTE = "unfold_on_paste";
    private static Logger logger;
    private HashSet mRegisteredMouseWheelEventHandler = new HashSet();
    private ActionFactory actionFactory;
    private Vector hookActions;
    private MindMapPopupMenu popupmenu;
    private MindMapToolBar toolbar;
    private boolean addAsChildMode = false;
    private Clipboard clipboard;
    private Clipboard selection;
    private HookFactory nodeHookFactory;
    private CompoundActionHandler compound = null;
    public ApplyPatternAction[] patterns = new ApplyPatternAction[0];
    public Action newMap = new NewMapAction(this);
    public Action open = new ControllerAdapter.OpenAction(this);
    public Action save = new ControllerAdapter.SaveAction(this);
    public Action saveAs = new ControllerAdapter.SaveAsAction(this);
    public Action exportToHTML = new ExportToHTMLAction(this);
    public Action exportBranchToHTML = new ExportBranchToHTMLAction(this);
    public Action editLong = new EditLongAction();
    public Action editAttributes = new ControllerAdapter.EditAttributesAction();
    public Action updateAction = new UpdateAction(this);
    public Action helpAction = new HelpAction(this);
    public Action contactAction = new ContactAction(this);
    public Action viewLogsAction = new ViewLogsAction(this);
    public Action preferencesAction = new PreferencesAction(this);
    public Action smartImportBookmarks = new SmartImportBookmarksAction(this);
    public Action importAllBookmarks = new ImportAllBookmarksAction(this);
    public Action addReference = new AddReferenceAttributeAction(this);
    public Action editReference = new EditReferenceAttributeAction(this);
    public Action copyReference = new CopyReferenceAttributeAction(this);
    public Action copyCiteReference = new CopyCiteReferenceAttributeAction(this);
    public Action deleteReference = new DeleteReferenceAttributeAction(this);
    public Action addMontoringDir = new AddMonitoringDirAction(this);
    public Action removeMontoringDir = new RemoveMonitoringDirAction(this);
    public Action editMontoringDir = new EditMonitoringDirAction(this);
    public SmartUpdateMonitoringDirAction smartUpdateMontoringDir = new SmartUpdateMonitoringDirAction(this);
    public Action allUpdateMontoringDir = new AllUpdateMonitoringAction(this);
    public JMenu popupSettingsMenu;
    public JMenu menubarSettingsMenu;
    protected AssignAttributeDialog assignAttributeDialog = null;
    public Action assignAttributes = new AssignAttributesAction();
    public Action newSibling = new NewSiblingAction(this);
    public Action newPreviousSibling = new NewPreviousSiblingAction(this);
    public Action setLinkByFileChooser = new SetLinkByFileChooserAction();
    public Action setImageByFileChooser = new SetImageByFileChooserAction();
    public Action followLink = new FollowLinkAction();
    public Action exportBranch = new ExportBranchAction(this);
    public Action importBranch = new ImportBranchAction();
    public Action importLinkedBranch = new ImportLinkedBranchAction();
    public Action importLinkedBranchWithoutRoot = new ImportLinkedBranchWithoutRootAction();
    public Action showAttributeManagerAction = null;
    public Action propertyAction = null;
    public Action increaseNodeFont = new NodeGeneralAction(this, "increase_node_font_size", null, new SingleNodeOperation(){

        @Override
        public void apply(MindMapMapModel map, MindMapNodeModel node) {
            MindMapController.this.increaseFontSize(node, 1);
        }
    });
    public Action decreaseNodeFont = new NodeGeneralAction(this, "decrease_node_font_size", null, new SingleNodeOperation(){

        @Override
        public void apply(MindMapMapModel map, MindMapNodeModel node) {
            MindMapController.this.increaseFontSize(node, -1);
        }
    });
    public UndoAction undo = null;
    public RedoAction redo = null;
    public CopyAction copy = null;
    public Action copySingle = null;
    public CutAction cut = null;
    public PasteAction paste = null;
    public BoldAction bold = null;
    public ItalicAction italic = null;
    public UnderlinedAction underlined = null;
    public FontSizeAction fontSize = null;
    public FontFamilyAction fontFamily = null;
    public NodeColorAction nodeColor = null;
    public EditAction edit = null;
    public NewChildAction newChild = null;
    public DeleteChildAction deleteChild = null;
    public ToggleFoldedAction toggleFolded = null;
    public ToggleChildrenFoldedAction toggleChildrenFolded = null;
    public UseRichFormattingAction useRichFormatting = null;
    public UsePlainTextAction usePlainText = null;
    public NodeUpAction nodeUp = null;
    public NodeDownAction nodeDown = null;
    public EdgeColorAction edgeColor = null;
    public EdgeWidthAction EdgeWidth_WIDTH_PARENT = null;
    public EdgeWidthAction EdgeWidth_WIDTH_THIN = null;
    public EdgeWidthAction EdgeWidth_1 = null;
    public EdgeWidthAction EdgeWidth_2 = null;
    public EdgeWidthAction EdgeWidth_4 = null;
    public EdgeWidthAction EdgeWidth_8 = null;
    public EdgeWidthAction[] edgeWidths = null;
    public EdgeStyleAction EdgeStyle_linear = null;
    public EdgeStyleAction EdgeStyle_bezier = null;
    public EdgeStyleAction EdgeStyle_sharp_linear = null;
    public EdgeStyleAction EdgeStyle_sharp_bezier = null;
    public EdgeStyleAction[] edgeStyles = null;
    public NodeColorBlendAction nodeColorBlend = null;
    public NodeStyleAction fork = null;
    public NodeStyleAction bubble = null;
    public CloudAction cloud = null;
    public CloudColorAction cloudColor = null;
    public AddArrowLinkAction addArrowLinkAction = null;
    public RemoveArrowLinkAction removeArrowLinkAction = null;
    public ColorArrowLinkAction colorArrowLinkAction = null;
    public ChangeArrowsInArrowLinkAction changeArrowsInArrowLinkAction = null;
    public NodeBackgroundColorAction nodeBackgroundColor = null;
    public NodeBackgroundColorAction.RemoveNodeBackgroundColorAction removeNodeBackgroundColor = null;
    public IconAction unknownIconAction = null;
    public RemoveIconAction removeLastIconAction = null;
    public RemoveAllIconsAction removeAllIconsAction = null;
    public SetLinkByTextFieldAction setLinkByTextField = null;
    public AddLocalLinkAction addLocalLinkAction = null;
    public GotoLinkNodeAction gotoLinkNodeAction = null;
    public JoinNodesAction joinNodes = null;
    public MoveNodeAction moveNodeAction = null;
    public ImportExplorerFavoritesAction importExplorerFavorites = null;
    public ImportFolderStructureAction importFolderStructure = null;
    public ChangeArrowLinkEndPoints changeArrowLinkEndPoints = null;
    public FindAction find = null;
    public FindAction.FindNextAction findNext = null;
    public NodeHookAction nodeHookAction = null;
    public RevertAction revertAction = null;
    public SelectBranchAction selectBranchAction = null;
    public SelectAllAction selectAllAction = null;
    public Vector iconActions = new Vector();
    public NodeHookUndoableContentActor undoableHookContentActor = null;
    FileFilter filefilter = new MindMapFilter();
    private MenuStructure mMenuStructure;
    private List mRegistrations;
    private List mPatternsList = new Vector();
    private NewNodeCreator myNewNodeCreator = null;
    private MindMapModeAttributeController attributeController;
    private HashSet mPlugins = new HashSet();

    public MindMapController(Mode mode) {
        super(mode);
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
        this.actionFactory = new ActionFactory(this.getController());
        this.compound = new CompoundActionHandler(this);
        logger.info("createIconActions");
        this.createStandardActions();
        this.createIconActions();
        logger.info("createNodeHookActions");
        this.createNodeHookActions();
        logger.info("mindmap_menus");
        try {
            InputStream in = this.getFrame().getResource("mindmap_menus.xml").openStream();
            this.mMenuStructure = this.updateMenusFromXml(in);
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        logger.info("MindMapPopupMenu");
        this.popupmenu = new MindMapPopupMenu(this);
        logger.info("MindMapToolBar");
        this.toolbar = new MindMapToolBar(this);
        this.setAllActions(false);
        this.addAsChildMode = Resources.getInstance().getBoolProperty("add_as_child");
        this.mRegistrations = new Vector();
        Toolkit toolkit = this.getFrame().getViewport().getToolkit();
        this.selection = toolkit.getSystemSelection();
        this.clipboard = toolkit.getSystemClipboard();
        this.attributeController = new MindMapModeAttributeController(this);
        this.showAttributeManagerAction = this.getController().showAttributeManagerAction;
        this.propertyAction = this.getController().propertyAction;
    }

    private void createStandardActions() {
        this.undo = new UndoAction(this);
        this.redo = new RedoAction(this);
        this.getActionFactory().registerHandler(new ModeControllerActionHandler(this.getActionFactory()));
        this.getActionFactory().registerUndoHandler(new UndoActionHandler(this, this.undo, this.redo));
        this.getActionFactory().registerHandler(new PrintActionHandler(this));
        this.cut = new CutAction(this);
        this.paste = new PasteAction(this);
        this.copy = new CopyAction(this);
        this.copySingle = new CopySingleAction(this);
        this.bold = new BoldAction(this);
        this.italic = new ItalicAction(this);
        this.underlined = new UnderlinedAction(this);
        this.fontSize = new FontSizeAction(this);
        this.fontFamily = new FontFamilyAction(this);
        this.edit = new EditAction(this);
        this.useRichFormatting = new UseRichFormattingAction(this);
        this.usePlainText = new UsePlainTextAction(this);
        this.newChild = new NewChildAction(this);
        this.deleteChild = new DeleteChildAction(this);
        this.toggleFolded = new ToggleFoldedAction(this);
        this.toggleChildrenFolded = new ToggleChildrenFoldedAction(this);
        this.nodeUp = new NodeUpAction(this);
        this.nodeDown = new NodeDownAction(this);
        this.edgeColor = new EdgeColorAction(this);
        this.nodeColor = new NodeColorAction(this);
        this.nodeColorBlend = new NodeColorBlendAction(this);
        this.fork = new NodeStyleAction(this, "fork");
        this.bubble = new NodeStyleAction(this, "bubble");
        this.removeLastIconAction = new RemoveIconAction(this);
        this.unknownIconAction = new IconAction(this, MindIcon.factory((String)MindIcon.getAllIconNames().get(0)), this.removeLastIconAction);
        this.removeLastIconAction.setIconAction(this.unknownIconAction);
        this.removeAllIconsAction = new RemoveAllIconsAction(this, this.unknownIconAction);
        this.loadPatternActions();
        this.EdgeWidth_WIDTH_PARENT = new EdgeWidthAction(this, -1);
        this.EdgeWidth_WIDTH_THIN = new EdgeWidthAction(this, 0);
        this.EdgeWidth_1 = new EdgeWidthAction(this, 1);
        this.EdgeWidth_2 = new EdgeWidthAction(this, 2);
        this.EdgeWidth_4 = new EdgeWidthAction(this, 4);
        this.EdgeWidth_8 = new EdgeWidthAction(this, 8);
        this.edgeWidths = new EdgeWidthAction[]{this.EdgeWidth_WIDTH_PARENT, this.EdgeWidth_WIDTH_THIN, this.EdgeWidth_1, this.EdgeWidth_2, this.EdgeWidth_4, this.EdgeWidth_8};
        this.EdgeStyle_linear = new EdgeStyleAction(this, "linear");
        this.EdgeStyle_bezier = new EdgeStyleAction(this, "bezier");
        this.EdgeStyle_sharp_linear = new EdgeStyleAction(this, "sharp_linear");
        this.EdgeStyle_sharp_bezier = new EdgeStyleAction(this, "sharp_bezier");
        this.edgeStyles = new EdgeStyleAction[]{this.EdgeStyle_linear, this.EdgeStyle_bezier, this.EdgeStyle_sharp_linear, this.EdgeStyle_sharp_bezier};
        this.cloud = new CloudAction(this);
        this.cloudColor = new CloudColorAction(this);
        this.addArrowLinkAction = new AddArrowLinkAction(this);
        this.removeArrowLinkAction = new RemoveArrowLinkAction(this, null);
        this.addArrowLinkAction.setRemoveAction(this.removeArrowLinkAction);
        this.colorArrowLinkAction = new ColorArrowLinkAction(this, null);
        this.changeArrowsInArrowLinkAction = new ChangeArrowsInArrowLinkAction(this, "none", null, null, true, true);
        this.nodeBackgroundColor = new NodeBackgroundColorAction(this);
        this.removeNodeBackgroundColor = new NodeBackgroundColorAction.RemoveNodeBackgroundColorAction(this);
        this.setLinkByTextField = new SetLinkByTextFieldAction(this);
        this.addLocalLinkAction = new AddLocalLinkAction(this);
        this.gotoLinkNodeAction = new GotoLinkNodeAction(this, null);
        this.moveNodeAction = new MoveNodeAction(this);
        this.joinNodes = new JoinNodesAction(this);
        this.importExplorerFavorites = new ImportExplorerFavoritesAction(this);
        this.importFolderStructure = new ImportFolderStructureAction(this);
        this.changeArrowLinkEndPoints = new ChangeArrowLinkEndPoints(this);
        this.find = new FindAction(this);
        this.findNext = new FindAction.FindNextAction(this, this.find);
        this.nodeHookAction = new NodeHookAction("no_title", this);
        this.revertAction = new RevertAction(this);
        this.selectBranchAction = new SelectBranchAction(this);
        this.selectAllAction = new SelectAllAction(this);
        this.undoableHookContentActor = new NodeHookUndoableContentActor(this);
    }

    private void loadPatternActions() {
        block5: {
            try {
                this.loadPatterns(this.getPatternReader());
            }
            catch (Exception ex) {
                System.err.println("Patterns not loaded:" + ex);
                String repairTitle = "Repair patterns";
                File patternsFile = this.getFrame().getPatternsFile();
                int result = JOptionPane.showConfirmDialog(null, "<html>The pattern file format has changed, <br>and it seems, that your pattern file<br>'" + patternsFile.getAbsolutePath() + "'<br> is formatted in the old way. <br>" + "Should I try to repair the pattern file <br>" + "(otherwise, you should update it by hand or delete it)?", repairTitle, 0);
                if (result != 0) break block5;
                boolean success = false;
                try {
                    this.loadPatterns(Tools.getUpdateReader(patternsFile, "patterns_updater.xslt", this.getFrame()));
                    StylePatternFactory.savePatterns(new FileWriter(patternsFile), this.mPatternsList);
                    success = true;
                }
                catch (Exception e) {
                    Resources.getInstance().logException(e);
                }
                if (success) {
                    JOptionPane.showMessageDialog(null, "Successfully repaired the pattern file.", repairTitle, -1);
                }
                JOptionPane.showMessageDialog(null, "An error occured repairing the pattern file.", repairTitle, 2);
            }
        }
    }

    public Reader getPatternReader() throws FileNotFoundException, IOException {
        InputStreamReader reader = null;
        File patternsFile = this.getFrame().getPatternsFile();
        if (patternsFile != null && patternsFile.exists()) {
            reader = new FileReader(patternsFile);
        } else {
            System.out.println("User patterns file " + patternsFile + " not found.");
            reader = new InputStreamReader(this.getResource("patterns.xml").openStream());
        }
        return reader;
    }

    @Override
    public boolean isUndoAction() {
        return this.undo.isUndoAction() || this.redo.isUndoAction();
    }

    @Override
    public void load(String xmlMapContents) {
        this.revertAction.openXmlInsteadOfMap(xmlMapContents);
    }

    public void loadPatterns(Reader reader) throws Exception {
        this.createPatterns(StylePatternFactory.loadPatterns(reader));
    }

    private void createPatterns(List patternsList) throws Exception {
        this.mPatternsList = patternsList;
        this.patterns = new ApplyPatternAction[patternsList.size()];
        for (int i = 0; i < this.patterns.length; ++i) {
            Pattern actualPattern = (Pattern)patternsList.get(i);
            this.patterns[i] = new ApplyPatternAction(this, actualPattern);
            PatternIcon patternIcon = actualPattern.getPatternIcon();
            if (patternIcon == null || patternIcon.getValue() == null) continue;
            this.patterns[i].putValue("SmallIcon", MindIcon.factory(patternIcon.getValue()).getIcon());
        }
    }

    @Override
    public void startupController() {
        super.startupController();
        HookFactory hookFactory = this.getHookFactory();
        List pluginRegistrations = hookFactory.getRegistrations();
        logger.fine("mScheduledActions are executed: " + pluginRegistrations.size());
        Iterator i = pluginRegistrations.iterator();
        while (i.hasNext()) {
            try {
                HookFactory.RegistrationContainer container = (HookFactory.RegistrationContainer)i.next();
                Class registrationClass = container.hookRegistrationClass;
                Constructor hookConstructor = registrationClass.getConstructor(ModeController.class, MindMap.class);
                HookRegistration registrationInstance = (HookRegistration)hookConstructor.newInstance(this, this.getMap());
                hookFactory.registerRegistrationContainer(container, registrationInstance);
                registrationInstance.register();
                this.mRegistrations.add(registrationInstance);
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
        this.getController().getMapMouseMotionListener().register(new MindMapMouseMotionManager(this));
        this.getController().getNodeDropListener().register(new MindMapNodeDropListener(this));
        this.getController().getNodeKeyListener().register(new CommonNodeKeyListener(this, new CommonNodeKeyListener.EditHandler(){

            @Override
            public void edit(KeyEvent e, boolean addNew, boolean editLong) {
                MindMapController.this.edit(e, addNew, editLong);
            }
        }));
        this.getController().getNodeMotionListener().register(new MindMapNodeMotionListener(this));
        this.getController().getNodeMouseMotionListener().register(new CommonNodeMouseMotionListener(this));
    }

    @Override
    public void shutdownController() {
        super.shutdownController();
        for (HookRegistration registrationInstance : this.mRegistrations) {
            registrationInstance.deRegister();
        }
        this.getHookFactory().deregisterAllRegistrationContainer();
        this.mRegistrations.clear();
        this.getController().getMapMouseMotionListener().deregister();
        this.getController().getNodeDropListener().deregister();
        this.getController().getNodeKeyListener().deregister();
        this.getController().getNodeMotionListener().deregister();
        this.getController().getNodeMouseMotionListener().deregister();
    }

    @Override
    public MapAdapter newModel(ModeController modeController) {
        return new MindMapMapModel(this.getFrame(), modeController);
    }

    private void createIconActions() {
        String[] userIconArray;
        Vector iconNames = MindIcon.getAllIconNames();
        File iconDir = new File(Resources.getInstance().getFreemindDirectory(), "icons");
        if (iconDir.exists() && (userIconArray = iconDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".*\\.png");
            }
        })) != null) {
            for (int i = 0; i < userIconArray.length; ++i) {
                String iconName = userIconArray[i];
                if ((iconName = iconName.substring(0, iconName.length() - 4)).equals("")) continue;
                iconNames.add(iconName);
            }
        }
        for (int i = 0; i < iconNames.size(); ++i) {
            String iconName = (String)iconNames.get(i);
            MindIcon myIcon = MindIcon.factory(iconName);
            IconAction myAction = new IconAction(this, myIcon, this.removeLastIconAction);
            this.iconActions.add(myAction);
        }
    }

    private void createNodeHookActions() {
        if (this.hookActions == null) {
            this.hookActions = new Vector();
            MindMapHookFactory factory = (MindMapHookFactory)this.getHookFactory();
            Vector nodeHookNames = factory.getPossibleNodeHooks();
            for (String hookName : nodeHookNames) {
                NodeHookAction action = new NodeHookAction(hookName, this);
                this.hookActions.add(action);
            }
            Vector modeControllerHookNames = factory.getPossibleModeControllerHooks();
            for (String hookName : modeControllerHookNames) {
                MindMapControllerHookAction action = new MindMapControllerHookAction(hookName, this);
                this.hookActions.add(action);
            }
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return this.filefilter;
    }

    @Override
    public void nodeChanged(MindMapNode n) {
        super.nodeChanged(n);
        MapModule mapModule = this.getController().getMapModule();
        if (mapModule != null && n == mapModule.getView().getSelected()) {
            this.updateToolbar(n);
        }
    }

    @Override
    public void onSelectHook(NodeView n) {
        super.onSelectHook(n);
        this.updateToolbar(n.getModel());
    }

    private void updateToolbar(MindMapNode n) {
        this.UpdateMonitoringActions();
        this.toolbar.selectFontSize(n.getFontSize());
        this.toolbar.selectFontName(n.getFontFamilyName());
    }

    public void setNewNodeCreator(NewNodeCreator creator) {
        this.myNewNodeCreator = creator;
    }

    @Override
    public MindMapNode newNode(Object userObject, MindMap map) {
        if (this.myNewNodeCreator == null) {
            this.myNewNodeCreator = new DefaultMindMapNodeCreator();
        }
        return this.myNewNodeCreator.createNode(userObject, map);
    }

    @Override
    public void updateMenus(StructuredMenuHolder holder) {
        this.processMenuCategory(holder, this.mMenuStructure.getListChoiceList(), "");
        MindMapHookFactory hookFactory = (MindMapHookFactory)this.getHookFactory();
        for (int i = 0; i < this.hookActions.size(); ++i) {
            AbstractAction hookAction = (AbstractAction)this.hookActions.get(i);
            String hookName = ((HookAction)((Object)hookAction)).getHookName();
            hookFactory.decorateAction(hookName, hookAction);
            List hookMenuPositions = hookFactory.getHookMenuPositions(hookName);
            for (String pos : hookMenuPositions) {
                holder.addMenuItem(hookFactory.getMenuItem(hookName, hookAction), pos);
            }
        }
        this.popupmenu.update(holder);
        this.toolbar.update(holder);
        String formatMenuString = "menu_bar/format/";
        this.createPatternSubMenu(holder, formatMenuString);
        this.addIconsToMenu(holder, "menu_bar/insert/icons");
    }

    public void addIconsToMenu(StructuredMenuHolder holder, String iconMenuString) {
        JMenu iconMenu = holder.addMenu(new JMenu(this.getText("icon_menu")), iconMenuString + "/.");
        holder.addAction(this.removeLastIconAction, iconMenuString + "/removeLastIcon");
        holder.addAction(this.removeAllIconsAction, iconMenuString + "/removeAllIcons");
        holder.addSeparator(iconMenuString);
        for (int i = 0; i < this.iconActions.size(); ++i) {
            JMenuItem item = holder.addAction((Action)this.iconActions.get(i), iconMenuString + "/" + i);
        }
    }

    public void createPatternSubMenu(StructuredMenuHolder holder, String formatMenuString) {
        for (int i = 0; i < this.patterns.length; ++i) {
            JMenuItem item = holder.addAction(this.patterns[i], formatMenuString + "patterns/patterns/" + i);
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getAdjustableProperty("keystroke_apply_pattern_" + (i + 1))));
        }
    }

    public MenuStructure updateMenusFromXml(InputStream in) {
        try {
            IUnmarshallingContext unmarshaller = XmlBindingTools.getInstance().createUnmarshaller();
            MenuStructure menus = (MenuStructure)unmarshaller.unmarshalDocument(in, null);
            return menus;
        }
        catch (JiBXException e) {
            Resources.getInstance().logException(e);
            throw new IllegalArgumentException("Menu structure could not be read.");
        }
    }

    public void processMenuCategory(StructuredMenuHolder holder, List list, String category) {
        TripleStateNodeSelectionListener nodeSelectionListener;
        TripleStateItemListener itemListener;
        JMenuItem def;
        JMenuItem off;
        JMenuItem on;
        String categoryCopy = category;
        ButtonGroup buttonGroup = null;
        for (Object obj : list) {
            if (obj instanceof MenuCategoryBase) {
                MenuCategoryBase cat = (MenuCategoryBase)obj;
                String newCategory = categoryCopy + "/" + cat.getName();
                holder.addCategory(newCategory);
                if (cat instanceof MenuSubmenu) {
                    MenuSubmenu submenu = (MenuSubmenu)cat;
                    if (submenu.getNameRef().equals("splmm_popup_menu_submenu_settingsfolder")) {
                        if (newCategory.equals("/mindmapmode_popup/edit/submenu_monitoringfolder/submenu_settingsfolder")) {
                            this.popupSettingsMenu = holder.addMenu(new JMenu(this.getText(submenu.getNameRef())), newCategory + "/.");
                        }
                        if (newCategory.equals("/menu_bar/sciplore/sciplore_sub_menu/submenu_monitoringfolder/submenu_settingsfolder")) {
                            this.menubarSettingsMenu = holder.addMenu(new JMenu(this.getText(submenu.getNameRef())), newCategory + "/.");
                        }
                    } else {
                        holder.addMenu(new JMenu(this.getText(submenu.getNameRef())), newCategory + "/.");
                    }
                }
                this.processMenuCategory(holder, cat.getListChoiceList(), newCategory);
                continue;
            }
            if (obj instanceof MenuActionBase) {
                MenuActionBase action = (MenuActionBase)obj;
                String field = action.getField();
                String name = action.getName();
                if (name == null) {
                    name = field;
                }
                String keystroke = action.getKeyRef();
                try {
                    Action theAction = (Action)this.getClass().getField(field).get(this);
                    String theCategory = categoryCopy + "/" + name;
                    if (obj instanceof MenuCheckedAction) {
                        this.addCheckBox(holder, theCategory, theAction, keystroke);
                        continue;
                    }
                    if (obj instanceof MenuRadioAction) {
                        JRadioButtonMenuItem item = (JRadioButtonMenuItem)this.addRadioItem(holder, theCategory, theAction, keystroke, ((MenuRadioAction)obj).getSelected());
                        if (buttonGroup == null) {
                            buttonGroup = new ButtonGroup();
                        }
                        buttonGroup.add(item);
                        continue;
                    }
                    this.add(holder, theCategory, theAction, keystroke);
                }
                catch (Exception e1) {
                    Resources.getInstance().logException(e1);
                }
                continue;
            }
            if (!(obj instanceof MenuSeparator)) continue;
            holder.addSeparator(categoryCopy);
        }
        if (categoryCopy.equalsIgnoreCase("/mindmapmode_popup/edit/submenu_monitoringfolder/submenu_settingsfolder/submenu_autoupdatefolder") || categoryCopy.equalsIgnoreCase("/menu_bar/sciplore/sciplore_sub_menu/submenu_monitoringfolder/submenu_settingsfolder/submenu_autoupdatefolder")) {
            on = this.addCheckBox(holder, categoryCopy + "/on", new CheckBoxAction("on"), null);
            off = this.addCheckBox(holder, categoryCopy + "/off", new CheckBoxAction("off"), null);
            def = this.addCheckBox(holder, categoryCopy + "/default", new CheckBoxAction("default"), null);
            itemListener = new TripleStateItemListener(this, SciPloreUtils.SPLMM_DIRMON_AUTO, on, off, def);
            nodeSelectionListener = new TripleStateNodeSelectionListener(SciPloreUtils.SPLMM_DIRMON_AUTO, on, off, def);
            this.registerNodeSelectionListener(nodeSelectionListener);
            on.addItemListener(itemListener);
            off.addItemListener(itemListener);
            def.addItemListener(itemListener);
        }
        if (categoryCopy.equalsIgnoreCase("/mindmapmode_popup/edit/submenu_monitoringfolder/submenu_settingsfolder/submenu_readsub-foldersfolder") || categoryCopy.equalsIgnoreCase("/menu_bar/sciplore/sciplore_sub_menu/submenu_monitoringfolder/submenu_settingsfolder/submenu_readsub-foldersfolder")) {
            on = this.addCheckBox(holder, categoryCopy + "/on", new CheckBoxAction("on"), null);
            off = this.addCheckBox(holder, categoryCopy + "/off", new CheckBoxAction("off"), null);
            def = this.addCheckBox(holder, categoryCopy + "/default", new CheckBoxAction("default"), null);
            itemListener = new TripleStateItemListener(this, SciPloreUtils.SPLMM_DIRMON_SUBDIRS, on, off, def);
            nodeSelectionListener = new TripleStateNodeSelectionListener(SciPloreUtils.SPLMM_DIRMON_SUBDIRS, on, off, def);
            this.registerNodeSelectionListener(nodeSelectionListener);
            on.addItemListener(itemListener);
            off.addItemListener(itemListener);
            def.addItemListener(itemListener);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.UpdateMonitoringActions();
        this.UpdateImportActions();
        this.UpdateReferenceActions();
        return this.popupmenu;
    }

    public void UpdateMonitoringActions() {
        if (SciPloreUtils.isMonitoringNode(this.getSelected())) {
            this.addMontoringDir.setEnabled(false);
            this.removeMontoringDir.setEnabled(true);
            this.editMontoringDir.setEnabled(true);
            this.smartUpdateMontoringDir.setEnabled(true);
            this.allUpdateMontoringDir.setEnabled(true);
            if (this.popupSettingsMenu != null) {
                this.popupSettingsMenu.setEnabled(true);
            }
            if (this.menubarSettingsMenu != null) {
                this.menubarSettingsMenu.setEnabled(true);
            }
        } else {
            this.addMontoringDir.setEnabled(true);
            this.removeMontoringDir.setEnabled(false);
            this.editMontoringDir.setEnabled(false);
            this.smartUpdateMontoringDir.setEnabled(false);
            this.allUpdateMontoringDir.setEnabled(false);
            if (this.popupSettingsMenu != null) {
                this.popupSettingsMenu.setEnabled(false);
            }
            if (this.menubarSettingsMenu != null) {
                this.menubarSettingsMenu.setEnabled(false);
            }
        }
    }

    public void UpdateReferenceActions() {
        if (this.isReferenceNode(this.getSelected())) {
            this.addReference.setEnabled(false);
            this.editReference.setEnabled(true);
            this.copyReference.setEnabled(true);
            this.copyCiteReference.setEnabled(true);
            this.deleteReference.setEnabled(true);
        } else {
            this.addReference.setEnabled(true);
            this.editReference.setEnabled(false);
            this.copyReference.setEnabled(false);
            this.copyCiteReference.setEnabled(false);
            this.deleteReference.setEnabled(false);
        }
    }

    private boolean isReferenceNode(MindMapNode selected) {
        if (selected.getAttributeTableLength() > 0) {
            List keys = selected.getAttributeKeyList();
            return keys.contains(SciPloreUtils.SPLMM_REFKEY_NAME);
        }
        return false;
    }

    public void UpdateImportActions() {
        if (this.isPdfLinkedNode(this.getSelected())) {
            this.smartImportBookmarks.setEnabled(true);
            this.importAllBookmarks.setEnabled(true);
        } else {
            this.smartImportBookmarks.setEnabled(false);
            this.importAllBookmarks.setEnabled(false);
        }
    }

    private boolean isPdfLinkedNode(MindMapNode selected) {
        String link = selected.getLink();
        if (link == null) {
            return false;
        }
        if (!link.contains(".")) {
            return false;
        }
        String dateiendung = link.substring(link.lastIndexOf("."));
        Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
        if (hasPDFendung.booleanValue()) {
            File file = this.getFileFromLink(selected);
            return file != null && file.exists();
        }
        return false;
    }

    protected File getFileFromLink(MindMapNode node) {
        File pdfFile;
        block16: {
            pdfFile = new File(SciPloreUtils.getLink(node, this.getController()));
            if (!pdfFile.isAbsolute()) {
                pdfFile = new File(this.getModel().getFile().getParent() + "\\\\" + node.getLink());
                if (pdfFile.exists()) {
                    try {
                        return pdfFile.getCanonicalFile();
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        break block16;
                    }
                }
                try {
                    URI uri = new URI("file:/" + node.getLink());
                    pdfFile = new File(uri);
                    pdfFile = new File(this.getModel().getFile().getParent() + pdfFile.getPath());
                    if (pdfFile.exists()) {
                        try {
                            return pdfFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                            break block16;
                        }
                    }
                    try {
                        uri = new URI(node.getLink());
                        pdfFile = new File(uri);
                        if (pdfFile.exists()) {
                            try {
                                return pdfFile.getCanonicalFile();
                            }
                            catch (IOException e) {
                                SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                            }
                        }
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                    }
                }
                catch (Exception e) {
                    SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                }
            }
        }
        try {
            return pdfFile.getCanonicalFile();
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
            return null;
        }
    }

    @Override
    public JPopupMenu getPopupForModel(Object obj) {
        if (obj instanceof MindMapArrowLinkModel) {
            MindMapArrowLinkModel link = (MindMapArrowLinkModel)obj;
            JPopupMenu arrowLinkPopup = new JPopupMenu();
            arrowLinkPopup.addPopupMenuListener(this.popupListenerSingleton);
            this.removeArrowLinkAction.setArrowLink(link);
            arrowLinkPopup.add(new RemoveArrowLinkAction(this, link));
            arrowLinkPopup.add(new ColorArrowLinkAction(this, link));
            arrowLinkPopup.addSeparator();
            JRadioButtonMenuItem itemnn = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "none", "images/arrow-mode-none.png", link, false, false));
            JRadioButtonMenuItem itemnt = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "forward", "images/arrow-mode-forward.png", link, false, true));
            JRadioButtonMenuItem itemtn = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "backward", "images/arrow-mode-backward.png", link, true, false));
            JRadioButtonMenuItem itemtt = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "both", "images/arrow-mode-both.png", link, true, true));
            itemnn.setText(null);
            itemnt.setText(null);
            itemtn.setText(null);
            itemtt.setText(null);
            arrowLinkPopup.add(itemnn);
            arrowLinkPopup.add(itemnt);
            arrowLinkPopup.add(itemtn);
            arrowLinkPopup.add(itemtt);
            boolean a = !link.getStartArrow().equals("None");
            boolean b = !link.getEndArrow().equals("None");
            itemtt.setSelected(a && b);
            itemnt.setSelected(!a && b);
            itemtn.setSelected(a && !b);
            itemnn.setSelected(!a && !b);
            arrowLinkPopup.addSeparator();
            arrowLinkPopup.add(new GotoLinkNodeAction(this, link.getSource()));
            arrowLinkPopup.add(new GotoLinkNodeAction(this, link.getTarget()));
            arrowLinkPopup.addSeparator();
            HashSet<MindMapNode> NodeAlreadyVisited = new HashSet<MindMapNode>();
            NodeAlreadyVisited.add(link.getSource());
            NodeAlreadyVisited.add(link.getTarget());
            Vector links = this.getMindMapMapModel().getLinkRegistry().getAllLinks(link.getSource());
            links.addAll(this.getMindMapMapModel().getLinkRegistry().getAllLinks(link.getTarget()));
            for (int i = 0; i < links.size(); ++i) {
                MindMapArrowLinkModel foreign_link = (MindMapArrowLinkModel)links.get(i);
                if (NodeAlreadyVisited.add(foreign_link.getTarget())) {
                    arrowLinkPopup.add(new GotoLinkNodeAction(this, foreign_link.getTarget()));
                }
                if (!NodeAlreadyVisited.add(foreign_link.getSource())) continue;
                arrowLinkPopup.add(new GotoLinkNodeAction(this, foreign_link.getSource()));
            }
            return arrowLinkPopup;
        }
        return null;
    }

    private MindMapMapModel getMindMapMapModel() {
        return (MindMapMapModel)this.getMap();
    }

    @Override
    public JToolBar getModeToolBar() {
        return this.getToolBar();
    }

    MindMapToolBar getToolBar() {
        return this.toolbar;
    }

    @Override
    public Component getLeftToolBar() {
        return this.toolbar.getLeftToolBar();
    }

    @Override
    protected void setAllActions(boolean enabled) {
        int i;
        logger.fine("setAllActions:" + enabled);
        super.setAllActions(enabled);
        this.increaseNodeFont.setEnabled(enabled);
        this.decreaseNodeFont.setEnabled(enabled);
        this.exportBranch.setEnabled(enabled);
        this.exportBranchToHTML.setEnabled(enabled);
        this.editLong.setEnabled(enabled);
        this.newSibling.setEnabled(enabled);
        this.newPreviousSibling.setEnabled(enabled);
        this.setLinkByFileChooser.setEnabled(enabled);
        this.setImageByFileChooser.setEnabled(enabled);
        this.followLink.setEnabled(enabled);
        for (i = 0; i < this.iconActions.size(); ++i) {
            ((Action)this.iconActions.get(i)).setEnabled(enabled);
        }
        this.save.setEnabled(enabled);
        this.saveAs.setEnabled(enabled);
        this.getToolBar().setAllActions(enabled);
        this.exportBranch.setEnabled(enabled);
        this.exportToHTML.setEnabled(enabled);
        this.importBranch.setEnabled(enabled);
        this.importLinkedBranch.setEnabled(enabled);
        this.importLinkedBranchWithoutRoot.setEnabled(enabled);
        for (i = 0; i < this.hookActions.size(); ++i) {
            ((Action)this.hookActions.get(i)).setEnabled(enabled);
        }
        this.cut.setEnabled(enabled);
        this.copy.setEnabled(enabled);
        this.copySingle.setEnabled(enabled);
        this.paste.setEnabled(enabled);
        this.undo.setEnabled(enabled);
        this.redo.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.newChild.setEnabled(enabled);
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
        this.setLinkByTextField.setEnabled(enabled);
        this.italic.setEnabled(enabled);
        this.bold.setEnabled(enabled);
        this.find.setEnabled(enabled);
        this.findNext.setEnabled(enabled);
        this.addArrowLinkAction.setEnabled(enabled);
        this.addLocalLinkAction.setEnabled(enabled);
        this.nodeColorBlend.setEnabled(enabled);
        this.nodeUp.setEnabled(enabled);
        this.nodeBackgroundColor.setEnabled(enabled);
        this.nodeDown.setEnabled(enabled);
        this.importExplorerFavorites.setEnabled(enabled);
        this.importFolderStructure.setEnabled(enabled);
        this.joinNodes.setEnabled(enabled);
        this.deleteChild.setEnabled(enabled);
        this.cloud.setEnabled(enabled);
        this.cloudColor.setEnabled(enabled);
        this.nodeColor.setEnabled(enabled);
        this.edgeColor.setEnabled(enabled);
        this.removeLastIconAction.setEnabled(enabled);
        this.removeAllIconsAction.setEnabled(enabled);
        this.selectAllAction.setEnabled(enabled);
        this.selectBranchAction.setEnabled(enabled);
        this.removeNodeBackgroundColor.setEnabled(enabled);
        this.moveNodeAction.setEnabled(enabled);
        this.revertAction.setEnabled(enabled);
        for (i = 0; i < this.edgeWidths.length; ++i) {
            this.edgeWidths[i].setEnabled(enabled);
        }
        this.fork.setEnabled(enabled);
        this.bubble.setEnabled(enabled);
        for (i = 0; i < this.edgeStyles.length; ++i) {
            this.edgeStyles[i].setEnabled(enabled);
        }
        for (i = 0; i < this.patterns.length; ++i) {
            this.patterns[i].setEnabled(enabled);
        }
        this.useRichFormatting.setEnabled(enabled);
        this.usePlainText.setEnabled(enabled);
        this.editAttributes.setEnabled(enabled);
        this.assignAttributes.setEnabled(enabled);
    }

    @Override
    public void setBold(MindMapNode node, boolean bolded) {
        this.bold.setBold(node, bolded);
    }

    @Override
    public void setItalic(MindMapNode node, boolean isItalic) {
        this.italic.setItalic(node, isItalic);
    }

    @Override
    public void setCloud(MindMapNode node, boolean enable) {
        this.cloud.setCloud(node, enable);
    }

    @Override
    public void setCloudColor(MindMapNode node, Color color) {
        this.cloudColor.setCloudColor(node, color);
    }

    @Override
    public void setFontSize(MindMapNode node, String fontSizeValue) {
        this.fontSize.setFontSize(node, fontSizeValue);
    }

    @Override
    public void increaseFontSize(MindMapNode node, int increment) {
        int newSize = Integer.valueOf(node.getFontSize()) + increment;
        if (newSize > 0) {
            this.setFontSize(node, Integer.toString(newSize));
        }
    }

    @Override
    public void setFontFamily(MindMapNode node, String fontFamilyValue) {
        this.fontFamily.setFontFamily(node, fontFamilyValue);
    }

    @Override
    public void setNodeColor(MindMapNode node, Color color) {
        this.nodeColor.setNodeColor(node, color);
    }

    @Override
    public void setNodeBackgroundColor(MindMapNode node, Color color) {
        this.nodeBackgroundColor.setNodeBackgroundColor(node, color);
    }

    @Override
    public void blendNodeColor(MindMapNode node) {
        Color mapColor = this.getView().getBackground();
        Color nodeColor = node.getColor();
        if (nodeColor == null) {
            nodeColor = MapView.standardNodeTextColor;
        }
        this.setNodeColor(node, new Color((3 * mapColor.getRed() + nodeColor.getRed()) / 4, (3 * mapColor.getGreen() + nodeColor.getGreen()) / 4, (3 * mapColor.getBlue() + nodeColor.getBlue()) / 4));
    }

    @Override
    public void setEdgeColor(MindMapNode node, Color color) {
        this.edgeColor.setEdgeColor(node, color);
    }

    @Override
    public void applyPattern(MindMapNode node, String patternName) {
        for (int i = 0; i < this.patterns.length; ++i) {
            ApplyPatternAction patternAction = this.patterns[i];
            if (!patternAction.getPattern().getName().equals(patternName)) continue;
            patternAction.applyPattern(node, patternAction.getPattern());
            break;
        }
    }

    @Override
    public void applyPattern(MindMapNode node, Pattern pattern) {
        if (this.patterns.length <= 0) {
            throw new IllegalArgumentException("No pattern defined.");
        }
        this.patterns[0].applyPattern(node, pattern);
    }

    @Override
    public void addIcon(MindMapNode node, MindIcon icon) {
        this.unknownIconAction.addIcon(node, icon);
    }

    @Override
    public void removeAllIcons(MindMapNode node) {
        this.removeAllIconsAction.removeAllIcons(node);
    }

    @Override
    public int removeLastIcon(MindMapNode node) {
        return this.removeLastIconAction.removeLastIcon(node);
    }

    @Override
    public void addLink(MindMapNode source, MindMapNode target) {
        this.addArrowLinkAction.addLink(source, target);
    }

    @Override
    public void removeReference(MindMapLink arrowLink) {
        this.removeArrowLinkAction.removeReference(arrowLink);
    }

    @Override
    public void setArrowLinkColor(MindMapLink arrowLink, Color color) {
        this.colorArrowLinkAction.setArrowLinkColor(arrowLink, color);
    }

    @Override
    public void changeArrowsOfArrowLink(MindMapArrowLinkModel arrowLink, boolean hasStartArrow, boolean hasEndArrow) {
        this.changeArrowsInArrowLinkAction.changeArrowsOfArrowLink(arrowLink, hasStartArrow, hasEndArrow);
    }

    @Override
    public void setArrowLinkEndPoints(MindMapArrowLink link, Point startPoint, Point endPoint) {
        this.changeArrowLinkEndPoints.setArrowLinkEndPoints(link, startPoint, endPoint);
    }

    @Override
    public void setLink(MindMapNode node, String link) {
        this.setLinkByTextField.setLink(node, link);
    }

    @Override
    public void setToolTip(MindMapNode node, String key, String value) {
        node.setToolTip(key, value);
        this.nodeRefresh(node);
    }

    @Override
    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
        this.edit.edit(e, addNew, editLong);
    }

    @Override
    public void setNodeText(MindMapNode selected, String newText) {
        this.edit.setNodeText(selected, newText);
    }

    @Override
    public void setEdgeWidth(MindMapNode node, int width) {
        this.EdgeWidth_1.setEdgeWidth(node, width);
    }

    @Override
    public void setEdgeStyle(MindMapNode node, String style) {
        this.EdgeStyle_bezier.setEdgeStyle(node, style);
    }

    @Override
    public void setNodeStyle(MindMapNode node, String style) {
        this.fork.setStyle(node, style);
    }

    @Override
    public Transferable copy(MindMapNode node, boolean saveInvisible) {
        StringWriter stringWriter = new StringWriter();
        try {
            ((MindMapNodeModel)node).save(stringWriter, this.getMap().getLinkRegistry(), saveInvisible, true);
        }
        catch (IOException e) {
            // empty catch block
        }
        return new MindMapNodesSelection(stringWriter.toString(), null, null, null, null, null, null);
    }

    @Override
    public Transferable cut() {
        return this.cut(this.getView().getSelectedNodesSortedByY());
    }

    @Override
    public Transferable cut(List nodeList) {
        return this.cut.cut(nodeList);
    }

    @Override
    public void paste(Transferable t, MindMapNode parent) {
        this.paste(t, parent, false, parent.isNewChildLeft());
    }

    @Override
    public boolean paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        if (!asSibling && target.isFolded() && Resources.getInstance().getBoolProperty(RESOURCE_UNFOLD_ON_PASTE)) {
            this.setFolded(target, false);
        }
        return this.paste.paste(t, target, asSibling, isLeft);
    }

    @Override
    public void paste(MindMapNode node, MindMapNode parent) {
        this.paste.paste(node, parent);
    }

    @Override
    public MindMapNode addNew(MindMapNode target, int newNodeMode, KeyEvent e) {
        this.edit.stopEditing();
        return this.newChild.addNew(target, newNodeMode, e);
    }

    @Override
    public MindMapNode addNewNode(MindMapNode parent, int index, boolean newNodeIsLeft) {
        return this.newChild.addNewNode(parent, index, newNodeIsLeft);
    }

    @Override
    public void deleteNode(MindMapNode selectedNode) {
        this.deleteChild.deleteNode(selectedNode);
    }

    @Override
    public void toggleFolded() {
        this.toggleFolded.toggleFolded();
    }

    @Override
    public void setFolded(MindMapNode node, boolean folded) {
        this.toggleFolded.setFolded(node, folded);
    }

    @Override
    public void moveNodes(MindMapNode selected, List selecteds, int direction) {
        this.nodeUp.moveNodes(selected, selecteds, direction);
    }

    @Override
    public void joinNodes(MindMapNode selectedNode, List selectedNodes) {
        this.joinNodes.joinNodes(selectedNode, selectedNodes);
    }

    protected void setLinkByFileChooser() {
        String relative = this.getLinkByFileChooser(this.getFileFilter());
        if (relative != null) {
            this.setLink((NodeAdapter)this.getSelected(), relative);
            if (SplmmPreferences.getAutoImport().booleanValue()) {
                SmartImportBookmarksAction smartImportBookmarks = new SmartImportBookmarksAction(this);
                smartImportBookmarks.importBookmarks(this.getSelected(), false);
            }
        }
    }

    protected void setImageByFileChooser() {
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("jpeg");
        filter.addExtension("png");
        filter.addExtension("gif");
        filter.setDescription("JPG, PNG and GIF Images");
        boolean picturesAmongSelecteds = false;
        ListIterator e = this.getSelecteds().listIterator();
        while (e.hasNext()) {
            String link = ((MindMapNode)e.next()).getLink();
            if (link == null || !filter.accept(new File(link))) continue;
            picturesAmongSelecteds = true;
            break;
        }
        try {
            if (picturesAmongSelecteds) {
                e = this.getSelecteds().listIterator();
                while (e.hasNext()) {
                    String possiblyRelative;
                    String relative;
                    MindMapNode node = (MindMapNode)e.next();
                    if (node.getLink() == null || (relative = Tools.isAbsolutePath(possiblyRelative = node.getLink()) ? Tools.fileToUrl(new File(possiblyRelative)).toString() : possiblyRelative) == null) continue;
                    String strText = "<html><img src=\"" + relative + "\">";
                    this.setLink(node, null);
                    this.setNodeText(node, strText);
                }
            } else {
                String relative = this.getLinkByFileChooser(filter);
                if (relative != null) {
                    String strText = "<html><img src=\"" + relative + "\">";
                    this.setNodeText(this.getSelected(), strText);
                }
            }
        }
        catch (MalformedURLException e2) {
            Resources.getInstance().logException(e2);
        }
    }

    protected String getLinkByFileChooser(FileFilter fileFilter) {
        String relative = null;
        JFileChooser chooser = null;
        if (this.getMap().getFile() == null) {
            JOptionPane.showMessageDialog(this.getFrame().getContentPane(), this.getText("not_saved_for_link_error"), "FreeMind", 2);
            return null;
        }
        chooser = this.getLastCurrentDir() != null ? new JFileChooser(this.getLastCurrentDir()) : new JFileChooser();
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        } else {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        int returnVal = chooser.showOpenDialog(this.getFrame().getContentPane());
        if (returnVal == 0) {
            URL link;
            File input = chooser.getSelectedFile();
            this.setLastCurrentDir(input.getParentFile());
            try {
                link = Tools.fileToUrl(input);
                relative = link.toString();
            }
            catch (MalformedURLException ex) {
                this.getController().errorMessage(this.getText("url_error"));
                return null;
            }
            if (this.getFrame().getProperty("links").equals("relative")) {
                try {
                    relative = Tools.toRelativeURL(Tools.fileToUrl(this.getMap().getFile()), link);
                }
                catch (MalformedURLException ex) {
                    this.getController().errorMessage(this.getText("url_error"));
                    return null;
                }
            }
        }
        return relative;
    }

    @Override
    public void loadURL(String relative) {
        if (this.getMap().getFile() == null) {
            this.getFrame().out("You must save the current map first!");
            boolean result = this.save();
            if (!result) {
                return;
            }
        }
        super.loadURL(relative);
    }

    @Override
    public void addHook(MindMapNode focussed, List selecteds, String hookName) {
        this.nodeHookAction.addHook(focussed, selecteds, hookName);
    }

    @Override
    public void moveNodePosition(MindMapNode node, int parentVGap, int hGap, int shiftY) {
        this.moveNodeAction.moveNodeTo(node, parentVGap, hGap, shiftY);
    }

    @Override
    public void plainClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MainView component = (MainView)e.getComponent();
        if (component.isInFollowLinkRegion(e.getX())) {
            this.loadURL();
        } else {
            MindMapNode node = component.getNodeView().getModel();
            if (!node.hasChildren()) {
                this.doubleClick(e);
                return;
            }
            this.toggleFolded();
        }
    }

    @Override
    public HookFactory getHookFactory() {
        if (this.nodeHookFactory == null) {
            this.nodeHookFactory = new MindMapHookFactory(this.getFrame());
        }
        return this.nodeHookFactory;
    }

    @Override
    public NodeHook createNodeHook(String hookName, MindMapNode node, MindMap map) {
        HookFactory hookFactory = this.getHookFactory();
        NodeHook hook = hookFactory.createNodeHook(hookName);
        hook.setController(this);
        hook.setMap(map);
        if (hook instanceof PermanentNodeHook) {
            PermanentNodeHook otherHook;
            PermanentNodeHook permHook = (PermanentNodeHook)hook;
            if (hookFactory.getInstanciationMethod(hookName).isSingleton() && (otherHook = hookFactory.getHookInNode(node, hookName)) != null) {
                return otherHook;
            }
            node.addHook(permHook);
        }
        return hook;
    }

    @Override
    public void invokeHook(ModeControllerHook hook) {
        try {
            hook.setController(this);
            hook.startupMapHook();
            hook.shutdownMapHook();
        }
        catch (Exception e) {
            Resources.getInstance().logException(e);
        }
    }

    @Override
    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public static void saveHTML(MindMapNodeModel rootNodeOfBranch, File file) throws IOException {
        BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(fileout);
        htmlWriter.saveHTML(rootNodeOfBranch);
    }

    public static void saveHTML(List mindMapNodes, Writer fileout) throws IOException {
        MindMapHTMLWriter htmlWriter = new MindMapHTMLWriter(fileout);
        htmlWriter.saveHTML(mindMapNodes);
    }

    @Override
    public void splitNode(MindMapNode node, int caretPosition, String newText) {
        if (node.isRoot()) {
            return;
        }
        String futureText = newText != null ? newText : ((Object)node).toString();
        String[] strings = this.getContent(futureText, caretPosition);
        if (strings == null) {
            return;
        }
        String newUpperContent = strings[0];
        String newLowerContent = strings[1];
        this.setNodeText(node, newUpperContent);
        MindMapNode parent = node.getParentNode();
        MindMapNode lowerNode = this.addNewNode(parent, parent.getChildPosition(node) + 1, node.isLeft());
        lowerNode.setColor(node.getColor());
        lowerNode.setFont(node.getFont());
        this.setNodeText(lowerNode, newLowerContent);
    }

    private String[] getContent(String text, int pos) {
        if (pos <= 0) {
            return null;
        }
        String[] strings = new String[2];
        if (text.startsWith("<html>")) {
            HTMLEditorKit kit = new HTMLEditorKit();
            HTMLDocument doc = new HTMLDocument();
            StringReader buf = new StringReader(text);
            try {
                int secondStart;
                int firstStart;
                kit.read(buf, (Document)doc, 0);
                char[] firstText = doc.getText(0, pos).toCharArray();
                int firstLen = pos;
                for (firstStart = 0; firstStart < firstLen && firstText[firstStart] <= ' '; ++firstStart) {
                }
                while (firstStart < firstLen && firstText[firstLen - 1] <= ' ') {
                    --firstLen;
                }
                int secondLen = doc.getLength() - pos;
                char[] secondText = doc.getText(pos, secondLen).toCharArray();
                for (secondStart = 0; secondStart < secondLen && secondText[secondStart] <= ' '; ++secondStart) {
                }
                while (secondStart < secondLen && secondText[secondLen - 1] <= ' ') {
                    --secondLen;
                }
                if (firstStart == firstLen || secondStart == secondLen) {
                    return null;
                }
                StringWriter out = new StringWriter();
                new FixedHTMLWriter((Writer)out, doc, firstStart, firstLen - firstStart).write();
                strings[0] = out.toString();
                out = new StringWriter();
                new FixedHTMLWriter((Writer)out, doc, pos + secondStart, secondLen - secondStart).write();
                strings[1] = out.toString();
                return strings;
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
            catch (BadLocationException e) {
                Resources.getInstance().logException(e);
            }
        } else {
            if (pos >= text.length()) {
                return null;
            }
            strings[0] = text.substring(0, pos);
            strings[1] = text.substring(pos);
        }
        return strings;
    }

    @Override
    protected void updateNode(MindMapNode node) {
        super.updateNode(node);
        this.recursiveCallUpdateHooks(node, node);
    }

    private void recursiveCallUpdateHooks(MindMapNode node, MindMapNode changedNode) {
        if (node instanceof MindMapNode) {
            for (PermanentNodeHook hook : node.getActivatedHooks()) {
                if (this.isUndoAction() && !(hook instanceof UndoEventReceiver)) continue;
                if (node == changedNode) {
                    hook.onUpdateNodeHook();
                    continue;
                }
                hook.onUpdateChildrenHook(changedNode);
            }
        }
        if (!node.isRoot() && node.getParentNode() != null) {
            this.recursiveCallUpdateHooks(node.getParentNode(), changedNode);
        }
    }

    @Override
    public void doubleClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MindMapNode node = ((MainView)e.getComponent()).getNodeView().getModel();
        if (!(e.isAltDown() || e.isControlDown() || e.isShiftDown() || e.isPopupTrigger() || e.getButton() != 1 || node.getLink() != null)) {
            this.edit(null, false, false);
        }
    }

    @Override
    public void select(NodeView node) {
        if (node == null) {
            logger.warning("Select with null NodeView called!");
            return;
        }
        this.getView().scrollNodeToVisible(node);
        this.getView().selectAsTheOnlyOneSelected(node);
        this.getView().setSiblingMaxLevel(node.getModel().getNodeLevel());
    }

    public void selectMultipleNodes(NodeView focussed, Collection selecteds) {
        this.selectMultipleNodesImpl(focussed, selecteds);
    }

    public void selectMultipleNodes(MindMapNode focussed, Collection selecteds) {
        this.selectMultipleNodesImpl(focussed, selecteds);
    }

    private void selectMultipleNodesImpl(Object focussed, Collection selecteds) {
        for (Object node : selecteds) {
            this.displayNode((MindMapNode)node);
        }
        this.select(this.getNodeView(focussed));
        Iterator i = selecteds.iterator();
        while (i.hasNext()) {
            Object node;
            node = this.getNodeView(i.next());
            this.getView().makeTheSelected((NodeView)node);
        }
        this.getController().obtainFocusForSelected();
    }

    private NodeView getNodeView(Object object) {
        if (object instanceof NodeView) {
            return (NodeView)object;
        }
        if (object instanceof MindMapNode) {
            return this.getView().getNodeView((MindMapNode)object);
        }
        throw new ClassCastException();
    }

    public void selectBranch(NodeView selected, boolean extend) {
        this.displayNode(selected.getModel());
        this.getView().selectBranch(selected, extend);
    }

    @Override
    public boolean extendSelection(MouseEvent e) {
        NodeView newlySelectedNodeView = ((MainView)e.getComponent()).getNodeView();
        boolean extend = e.isControlDown();
        if (Tools.isMacOsX()) {
            extend |= e.isMetaDown();
        }
        boolean range = e.isShiftDown();
        boolean branch = e.isAltGraphDown() || e.isAltDown();
        boolean retValue = false;
        if (extend || range || branch || !this.getView().isSelected(newlySelectedNodeView)) {
            if (!range) {
                if (extend) {
                    this.getView().toggleSelected(newlySelectedNodeView);
                } else {
                    this.select(newlySelectedNodeView);
                }
                retValue = true;
            } else {
                retValue = this.getView().selectContinuous(newlySelectedNodeView);
            }
            if (branch) {
                this.getView().selectBranch(newlySelectedNodeView, extend);
                retValue = true;
            }
        }
        if (retValue) {
            e.consume();
            String link = newlySelectedNodeView.getModel().getLink();
            link = link != null ? link : " ";
            this.getController().getFrame().out(link);
        }
        logger.fine("MouseEvent: extend:" + extend + ", range:" + range + ", branch:" + branch + ", event:" + e + ", retValue:" + retValue);
        return retValue;
    }

    @Override
    public void registerMouseWheelEventHandler(MindMapActions.MouseWheelEventHandler handler) {
        logger.fine("Registered   MouseWheelEventHandler " + handler);
        this.mRegisteredMouseWheelEventHandler.add(handler);
    }

    @Override
    public void deRegisterMouseWheelEventHandler(MindMapActions.MouseWheelEventHandler handler) {
        logger.fine("Deregistered MouseWheelEventHandler " + handler);
        this.mRegisteredMouseWheelEventHandler.remove(handler);
    }

    @Override
    public Set getRegisteredMouseWheelEventHandler() {
        return Collections.unmodifiableSet(this.mRegisteredMouseWheelEventHandler);
    }

    @Override
    public String marshall(XmlAction action) {
        return XmlBindingTools.getInstance().marshall(action);
    }

    @Override
    public XmlAction unMarshall(String inputString) {
        return XmlBindingTools.getInstance().unMarshall(inputString);
    }

    public void storeDialogPositions(JDialog dialog, WindowConfigurationStorage pStorage, String window_preference_storage_property) {
        XmlBindingTools.getInstance().storeDialogPositions(this.getController(), dialog, pStorage, window_preference_storage_property);
    }

    public WindowConfigurationStorage decorateDialog(JDialog dialog, String window_preference_storage_property) {
        return XmlBindingTools.getInstance().decorateDialog(this.getController(), dialog, window_preference_storage_property);
    }

    @Override
    public AttributeController getAttributeController() {
        return this.attributeController;
    }

    public AttributePopupMenu getAttributeTablePopupMenu() {
        return new AttributePopupMenu();
    }

    @Override
    public XMLElement createXMLElement() {
        return new MindMapXMLElement(this);
    }

    @Override
    public void setAttribute(MindMapNode pNode, int pPosition, Attribute pAttribute) {
        pNode.createAttributeTableModel();
        pNode.getAttributes().setValueAt(pAttribute.getName(), pPosition, 0);
        pNode.getAttributes().setValueAt(pAttribute.getValue(), pPosition, 1);
    }

    @Override
    public void removeAttribute(MindMapNode pNode, int pPosition) {
        pNode.createAttributeTableModel();
        pNode.getAttributes().getAttributeController().performRemoveRow(pNode.getAttributes(), pPosition);
    }

    @Override
    public int addAttribute(MindMapNode node, Attribute pAttribute) {
        node.createAttributeTableModel();
        NodeAttributeTableModel attributes = node.getAttributes();
        int rowCount = attributes.getRowCount();
        attributes.getAttributeController().performInsertRow(attributes, rowCount, pAttribute.getName(), pAttribute.getValue());
        return rowCount;
    }

    @Override
    public int editAttribute(MindMapNode pNode, String pName, String pNewValue) {
        pNode.createAttributeTableModel();
        Attribute newAttribute = new Attribute(pName, pNewValue);
        NodeAttributeTableModel attributes = pNode.getAttributes();
        for (int i = 0; i < attributes.getRowCount(); ++i) {
            if (!pName.equals(attributes.getAttribute(i).getName())) continue;
            if (pNewValue != null) {
                this.setAttribute(pNode, i, newAttribute);
            } else {
                this.removeAttribute(pNode, i);
            }
            return i;
        }
        if (pNewValue == null) {
            return -1;
        }
        return this.addAttribute(pNode, newAttribute);
    }

    @Override
    public void insertNodeInto(MindMapNode newNode, MindMapNode parent, int index) {
        this.getModel().setSaved(false);
        super.insertNodeInto(newNode, parent, index);
    }

    public void removeNodeFromParent(MindMapNode selectedNode) {
        this.getModel().setSaved(false);
        this.getModel().removeNodeFromParent(selectedNode);
    }

    public void nodeStyleChanged(MindMapNode node) {
        this.nodeChanged(node);
        ListIterator childrenFolded = node.childrenFolded();
        while (childrenFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenFolded.next();
            if (child.hasStyle() && child.getEdge().hasStyle()) continue;
            this.nodeStyleChanged(child);
        }
    }

    public void repaintMap() {
        this.getView().repaint();
    }

    @Override
    public void clearNodeContents(MindMapNode pNode) {
        Pattern erasePattern = new Pattern();
        erasePattern.setPatternEdgeColor(new PatternEdgeColor());
        erasePattern.setPatternEdgeStyle(new PatternEdgeStyle());
        erasePattern.setPatternEdgeWidth(new PatternEdgeWidth());
        erasePattern.setPatternIcon(new PatternIcon());
        erasePattern.setPatternNodeBackgroundColor(new PatternNodeBackgroundColor());
        erasePattern.setPatternNodeColor(new PatternNodeColor());
        erasePattern.setPatternNodeFontBold(new PatternNodeFontBold());
        erasePattern.setPatternNodeFontItalic(new PatternNodeFontItalic());
        erasePattern.setPatternNodeFontName(new PatternNodeFontName());
        erasePattern.setPatternNodeFontSize(new PatternNodeFontSize());
        erasePattern.setPatternNodeStyle(new PatternNodeStyle());
        erasePattern.setPatternNodeText(new PatternNodeText());
        this.applyPattern(pNode, erasePattern);
        List attributeKeyList = pNode.getAttributeKeyList();
        for (String key : attributeKeyList) {
            this.getAttributeController().performRemoveAttribute(key);
        }
        this.setNoteText(pNode, null);
    }

    public EditNoteToNodeAction createEditNoteToNodeAction(MindMapNode node, String text) {
        EditNoteToNodeAction nodeAction = new EditNoteToNodeAction();
        nodeAction.setNode(node.getObjectId(this));
        if (text != null && (HtmlTools.htmlToPlain(text).length() != 0 || text.indexOf("<img") >= 0)) {
            nodeAction.setText(text);
        } else {
            nodeAction.setText(null);
        }
        return nodeAction;
    }

    @Override
    public void setNoteText(MindMapNode node, String text) {
        String oldNoteText = node.getNoteText();
        if (Tools.safeEquals(text, oldNoteText)) {
            return;
        }
        logger.info("Old Note Text:'" + oldNoteText + ", new:'" + text + "'.");
        logger.info(Tools.compareText(oldNoteText, text));
        EditNoteToNodeAction doAction = this.createEditNoteToNodeAction(node, text);
        EditNoteToNodeAction undoAction = this.createEditNoteToNodeAction(node, oldNoteText);
        this.getActionFactory().startTransaction(ACCESSORIES_PLUGINS_NODE_NOTE);
        this.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.getActionFactory().endTransaction(ACCESSORIES_PLUGINS_NODE_NOTE);
    }

    public void registerPlugin(MindMapControllerPlugin pPlugin) {
        this.mPlugins.add(pPlugin);
    }

    public void deregisterPlugin(MindMapControllerPlugin pPlugin) {
        this.mPlugins.remove(pPlugin);
    }

    public Set getPlugins() {
        return Collections.unmodifiableSet(this.mPlugins);
    }

    public Transferable getClipboardContents() {
        return this.clipboard.getContents(this);
    }

    public void setClipboardContents(Transferable t) {
        this.clipboard.setContents(t, null);
        if (this.selection != null) {
            this.selection.setContents(t, null);
        }
    }

    protected class EditLongAction
    extends AbstractAction {
        public EditLongAction() {
            super(MindMapController.this.getText("edit_long_node"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMapController.this.edit(null, false, true);
        }
    }

    protected class FollowLinkAction
    extends AbstractAction
    implements MenuItemEnabledListener {
        public FollowLinkAction() {
            super(MindMapController.this.getText("follow_link"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MindMapNode selNode : MindMapController.this.getSelecteds()) {
                if (selNode.getLink() == null) continue;
                MindMapController.this.loadURL(selNode.getLink());
            }
        }

        @Override
        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            for (MindMapNode selNode : MindMapController.this.getSelecteds()) {
                if (selNode.getLink() == null) continue;
                return true;
            }
            return false;
        }
    }

    protected class SetImageByFileChooserAction
    extends AbstractAction {
        public SetImageByFileChooserAction() {
            super(MindMapController.this.getText("set_image_by_filechooser"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMapController.this.setImageByFileChooser();
            MindMapController.this.getController().obtainFocusForSelected();
        }
    }

    protected class SetLinkByFileChooserAction
    extends AbstractAction {
        public SetLinkByFileChooserAction() {
            super(MindMapController.this.getText("set_link_by_filechooser"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMapController.this.setLinkByFileChooser();
        }
    }

    private class MindMapFilter
    extends FileFilter {
        private MindMapFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Tools.getExtension(f.getName());
            if (extension != null) {
                return extension.equals("mm");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return MindMapController.this.getText("mindmaps_desc");
        }
    }

    private class ImportLinkedBranchWithoutRootAction
    extends AbstractAction {
        ImportLinkedBranchWithoutRootAction() {
            super(MindMapController.this.getText("import_linked_branch_without_root"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMapNodeModel selected = (MindMapNodeModel)MindMapController.this.getSelected();
            if (selected == null || selected.getLink() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), MindMapController.this.getText("import_linked_branch_no_link"));
                return;
            }
            URL absolute = null;
            try {
                String relative = selected.getLink();
                absolute = Tools.isAbsolutePath(relative) ? Tools.fileToUrl(new File(relative)) : new URL(Tools.fileToUrl(MindMapController.this.getMap().getFile()), relative);
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), "Couldn't create valid URL.");
                return;
            }
            try {
                MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(Tools.urlToFile(absolute));
                ListIterator i = node.childrenUnfolded();
                while (i.hasNext()) {
                    MindMapNodeModel importNode = (MindMapNodeModel)i.next();
                    MindMapController.this.paste(importNode, (MindMapNode)selected);
                    MindMapController.this.invokeHooksRecursively(importNode, MindMapController.this.getMindMapMapModel());
                }
            }
            catch (Exception ex) {
                MindMapController.this.handleLoadingException(ex);
            }
        }
    }

    private class ImportLinkedBranchAction
    extends AbstractAction {
        ImportLinkedBranchAction() {
            super(MindMapController.this.getText("import_linked_branch"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MindMapNodeModel selected = (MindMapNodeModel)MindMapController.this.getSelected();
            if (selected == null || selected.getLink() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), MindMapController.this.getText("import_linked_branch_no_link"));
                return;
            }
            URL absolute = null;
            try {
                String relative = selected.getLink();
                absolute = Tools.isAbsolutePath(relative) ? Tools.fileToUrl(new File(relative)) : new URL(Tools.fileToUrl(MindMapController.this.getMap().getFile()), relative);
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), "Couldn't create valid URL for:" + MindMapController.this.getMap().getFile());
                Resources.getInstance().logException(ex);
                return;
            }
            try {
                MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(Tools.urlToFile(absolute));
                MindMapController.this.paste(node, (MindMapNode)selected);
                MindMapController.this.invokeHooksRecursively(node, MindMapController.this.getMindMapMapModel());
            }
            catch (Exception ex) {
                MindMapController.this.handleLoadingException(ex);
            }
        }
    }

    private class ImportBranchAction
    extends AbstractAction {
        ImportBranchAction() {
            super(MindMapController.this.getText("import_branch"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            MindMapNodeModel parent = (MindMapNodeModel)MindMapController.this.getSelected();
            if (parent == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            if (MindMapController.this.getFileFilter() != null) {
                chooser.addChoosableFileFilter(MindMapController.this.getFileFilter());
            }
            if ((returnVal = chooser.showOpenDialog(MindMapController.this.getFrame().getContentPane())) == 0) {
                try {
                    MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(chooser.getSelectedFile());
                    MindMapController.this.paste(node, (MindMapNode)parent);
                    MindMapController.this.invokeHooksRecursively(node, MindMapController.this.getMindMapMapModel());
                }
                catch (Exception ex) {
                    MindMapController.this.handleLoadingException(ex);
                }
            }
        }
    }

    protected class ExportBranchToHTMLAction
    extends AbstractAction {
        MindMapController c;

        public ExportBranchToHTMLAction(MindMapController controller) {
            super(MindMapController.this.getText("export_branch_to_html"));
            this.c = controller;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MindMapController.this.getMap().getFile() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getFrame().getContentPane(), MindMapController.this.getText("map_not_saved"), "FreeMind", 2);
                return;
            }
            try {
                File file = File.createTempFile("tmm", ".html");
                MindMapController.saveHTML((MindMapNodeModel)MindMapController.this.getSelected(), file);
                MindMapController.this.loadURL(file.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class ExportToHTMLAction
    extends AbstractAction {
        MindMapController c;

        public ExportToHTMLAction(MindMapController controller) {
            super(MindMapController.this.getText("export_to_html"));
            this.c = controller;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MindMapController.this.getMap().getFile() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getFrame().getContentPane(), MindMapController.this.getText("map_not_saved"), "FreeMind", 2);
                return;
            }
            try {
                File file = new File(this.c.getMindMapMapModel().getFile() + ".html");
                MindMapController.saveHTML((MindMapNodeModel)this.c.getMindMapMapModel().getRoot(), file);
                MindMapController.this.loadURL(file.toString());
            }
            catch (IOException ex) {
                Resources.getInstance().logException(ex);
            }
        }
    }

    public class DefaultMindMapNodeCreator
    implements NewNodeCreator {
        @Override
        public MindMapNode createNode(Object userObject, MindMap map) {
            return new MindMapNodeModel(userObject, MindMapController.this.getFrame(), map);
        }
    }

    public static interface NewNodeCreator {
        public MindMapNode createNode(Object var1, MindMap var2);
    }

    public static interface MindMapControllerPlugin {
    }

    protected class AssignAttributesAction
    extends AbstractAction {
        public AssignAttributesAction() {
            super(MindMapController.this.getText("attributes_assign_dialog"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MindMapController.this.assignAttributeDialog == null) {
                MindMapController.this.assignAttributeDialog = new AssignAttributeDialog(MindMapController.this.getView());
            }
            MindMapController.this.assignAttributeDialog.show();
        }
    }
}

