/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.controller.Controller;
import freemind.controller.NodeKeyListener;
import freemind.controller.NodeMotionListener;
import freemind.controller.NodeMouseMotionListener;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapNode;
import freemind.preferences.FreemindPropertyListener;
import freemind.view.mindmapview.ArrowLinkView;
import freemind.view.mindmapview.MindMapLayout;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.NodeViewFactory;
import freemind.view.mindmapview.PathBBox;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class MapView
extends JPanel
implements Printable,
Autoscroll {
    int mPaintingTime;
    int mPaintingAmount;
    static boolean printOnWhiteBackground;
    static Color standardMapBackgroundColor;
    static Color standardSelectColor;
    static Color standardSelectRectangleColor;
    public static Color standardNodeTextColor;
    static boolean standardDrawRectangleForSelection;
    private static Stroke standardSelectionStroke;
    private static FreemindPropertyListener propertyChangeListener;
    private static Logger logger;
    private MindMap model;
    private NodeView rootView = null;
    private Selected selected = new Selected();
    private Controller controller = null;
    private float zoom = 1.0f;
    private boolean disableMoveCursor = true;
    private int siblingMaxLevel;
    private boolean isPrinting = false;
    private NodeView shiftSelectionOrigin = null;
    private int maxNodeWidth = 0;
    private Color background = null;
    private Rectangle boundingRectangle = null;
    private boolean fitToPage = true;
    private Vector ArrowLinkViews;
    private Point rootContentLocation;
    private NodeView nodeToBeVisible = null;
    private int extraWidth;
    private boolean selectedsValid = true;
    static boolean NEED_PREF_SIZE_BUG_FIX;
    private static final int margin = 20;

    public MapView(MindMap model, Controller controller) {
        this.model = model;
        this.controller = controller;
        if (standardNodeTextColor == null) {
            String stdcolor;
            try {
                stdcolor = this.getController().getFrame().getProperty("standardbackgroundcolor");
                standardMapBackgroundColor = Tools.xmlToColor(stdcolor);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                standardMapBackgroundColor = Color.WHITE;
            }
            try {
                stdcolor = this.getController().getFrame().getProperty("standardnodetextcolor");
                standardNodeTextColor = Tools.xmlToColor(stdcolor);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                standardSelectColor = Color.WHITE;
            }
            try {
                stdcolor = this.getController().getFrame().getProperty("standardselectednodecolor");
                standardSelectColor = Tools.xmlToColor(stdcolor);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                standardSelectColor = Color.BLUE.darker();
            }
            try {
                String stdtextcolor = this.getController().getFrame().getProperty("standardselectednoderectanglecolor");
                standardSelectRectangleColor = Tools.xmlToColor(stdtextcolor);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                standardSelectRectangleColor = Color.WHITE;
            }
            try {
                String drawCircle = this.getController().getFrame().getProperty("standarddrawrectangleforselection");
                standardDrawRectangleForSelection = Tools.xmlToBoolean(drawCircle);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                standardDrawRectangleForSelection = false;
            }
            try {
                String printOnWhite = this.getController().getFrame().getProperty("printonwhitebackground");
                printOnWhiteBackground = Tools.xmlToBoolean(printOnWhite);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
                printOnWhiteBackground = true;
            }
            this.createPropertyChangeListener();
        }
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        this.setAutoscrolls(true);
        this.setLayout(new MindMapLayout());
        this.initRoot();
        this.setBackground(standardMapBackgroundColor);
        this.addMouseListener(controller.getMapMouseMotionListener());
        this.addMouseMotionListener(controller.getMapMouseMotionListener());
        this.addMouseWheelListener(controller.getMapMouseWheelListener());
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(2, Collections.EMPTY_SET);
        this.disableMoveCursor = Resources.getInstance().getBoolProperty("disable_cursor_move_paper");
        this.addComponentListener(new ResizeListener());
    }

    private void createPropertyChangeListener() {
        propertyChangeListener = new FreemindPropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("standardnodetextcolor")) {
                    standardNodeTextColor = Tools.xmlToColor(newValue);
                    MapView.this.controller.getMapModule().getView().getRoot().updateAll();
                } else if (propertyName.equals("standardbackgroundcolor")) {
                    standardMapBackgroundColor = Tools.xmlToColor(newValue);
                    MapView.this.controller.getMapModule().getView().setBackground(standardMapBackgroundColor);
                } else if (propertyName.equals("standardselectednodecolor")) {
                    standardSelectColor = Tools.xmlToColor(newValue);
                    MapView.this.controller.getMapModule().getView().repaintSelecteds();
                } else if (propertyName.equals("standardselectednoderectanglecolor")) {
                    standardSelectRectangleColor = Tools.xmlToColor(newValue);
                    MapView.this.controller.getMapModule().getView().repaintSelecteds();
                } else if (propertyName.equals("standarddrawrectangleforselection")) {
                    standardDrawRectangleForSelection = Tools.xmlToBoolean(newValue);
                    MapView.this.controller.getMapModule().getView().repaintSelecteds();
                } else if (propertyName.equals("printonwhitebackground")) {
                    printOnWhiteBackground = Tools.xmlToBoolean(newValue);
                }
            }
        };
        Controller.addPropertyChangeListener(propertyChangeListener);
    }

    public void initRoot() {
        this.rootContentLocation = new Point();
        this.rootView = NodeViewFactory.getInstance().newNodeView(this.getModel().getRootNode(), 0, this, this);
        this.rootView.insert();
        this.revalidate();
    }

    public int getMaxNodeWidth() {
        if (this.maxNodeWidth == 0) {
            try {
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("max_node_width"));
            }
            catch (NumberFormatException e) {
                Resources.getInstance().logException(e);
                this.maxNodeWidth = Integer.parseInt(this.controller.getProperty("el__max_default_window_width"));
            }
        }
        return this.maxNodeWidth;
    }

    public void centerNode(final NodeView node) {
        JViewport viewPort = (JViewport)this.getParent();
        Tools.waitForEventQueue();
        if (!this.isValid()) {
            class CenterNodeRunnable
            implements Runnable {
                private int counter = 1;

                @Override
                public void run() {
                    if (this.counter-- == 0) {
                        MapView.this.centerNode(node);
                    } else {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            Resources.getInstance().logException(e);
                        }
                        EventQueue.invokeLater(this);
                    }
                }
            }
            EventQueue.invokeLater(new CenterNodeRunnable());
            return;
        }
        Dimension d = viewPort.getExtentSize();
        JComponent content = node.getContent();
        Rectangle rect = new Rectangle(content.getWidth() / 2 - d.width / 2, content.getHeight() / 2 - d.height / 2, d.width, d.height);
        logger.fine("Scroll to " + rect + ", pref size=" + viewPort.getPreferredSize() + ", " + this.getPreferredSize());
        content.scrollRectToVisible(rect);
    }

    public void scrollNodeToVisible(NodeView node) {
        this.scrollNodeToVisible(node, 0);
    }

    public void scrollNodeToVisible(NodeView node, int extraWidth) {
        if (!this.isValid()) {
            this.nodeToBeVisible = node;
            this.extraWidth = extraWidth;
            return;
        }
        int HORIZ_SPACE = 10;
        int HORIZ_SPACE2 = 20;
        int VERT_SPACE = 5;
        int VERT_SPACE2 = 10;
        JComponent nodeContent = node.getContent();
        int width = nodeContent.getWidth();
        if (extraWidth < 0) {
            nodeContent.scrollRectToVisible(new Rectangle(-10 + extraWidth, -5, (width -= extraWidth) + 20, nodeContent.getHeight() + 10));
        } else {
            nodeContent.scrollRectToVisible(new Rectangle(-10, -5, (width += extraWidth) + 20, nodeContent.getHeight() + 10));
        }
    }

    public Dimension getViewportSize() {
        JViewport mapViewport = (JViewport)this.getParent();
        return mapViewport == null ? null : mapViewport.getSize();
    }

    public void scrollBy(int x, int y) {
        JViewport mapViewport = (JViewport)this.getParent();
        if (mapViewport != null) {
            Point currentPoint = mapViewport.getViewPosition();
            currentPoint.translate(x, y);
            if (currentPoint.getX() < 0.0) {
                currentPoint.setLocation(0.0, currentPoint.getY());
            }
            if (currentPoint.getY() < 0.0) {
                currentPoint.setLocation(currentPoint.getX(), 0.0);
            }
            double maxX = this.getSize().getWidth() - mapViewport.getExtentSize().getWidth();
            double maxY = this.getSize().getHeight() - mapViewport.getExtentSize().getHeight();
            if (currentPoint.getX() > maxX) {
                currentPoint.setLocation(maxX, currentPoint.getY());
            }
            if (currentPoint.getY() > maxY) {
                currentPoint.setLocation(currentPoint.getX(), maxY);
            }
            mapViewport.setViewPosition(currentPoint);
        }
    }

    private NodeView getVisibleLeft(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        if (oldSelected.getModel().isRoot()) {
            newSelected = oldSelected.getPreferredVisibleChild(true);
        } else if (!oldSelected.isLeft()) {
            newSelected = oldSelected.getVisibleParentView();
        } else {
            if (oldSelected.getModel().isFolded()) {
                this.model.getModeController().setFolded(oldSelected.getModel(), false);
                return oldSelected;
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(true); newSelected != null && !newSelected.isContentVisible(); newSelected = newSelected.getPreferredVisibleChild(true)) {
            }
        }
        return newSelected;
    }

    private NodeView getVisibleRight(NodeView oldSelected) {
        NodeView newSelected = oldSelected;
        if (oldSelected.getModel().isRoot()) {
            newSelected = oldSelected.getPreferredVisibleChild(false);
        } else if (oldSelected.isLeft()) {
            newSelected = oldSelected.getVisibleParentView();
        } else {
            if (oldSelected.getModel().isFolded()) {
                this.model.getModeController().setFolded(oldSelected.getModel(), false);
                return oldSelected;
            }
            for (newSelected = oldSelected.getPreferredVisibleChild(false); newSelected != null && !newSelected.isContentVisible(); newSelected = newSelected.getPreferredVisibleChild(false)) {
            }
        }
        return newSelected;
    }

    private NodeView getVisibleNeighbour(int directionCode) {
        NodeView oldSelected = this.getSelected();
        NodeView newSelected = null;
        switch (directionCode) {
            case 37: {
                newSelected = this.getVisibleLeft(oldSelected);
                if (newSelected != null) {
                    this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                }
                return newSelected;
            }
            case 39: {
                newSelected = this.getVisibleRight(oldSelected);
                if (newSelected != null) {
                    this.setSiblingMaxLevel(newSelected.getModel().getNodeLevel());
                }
                return newSelected;
            }
            case 38: {
                newSelected = oldSelected.getPreviousVisibleSibling();
                break;
            }
            case 40: {
                newSelected = oldSelected.getNextVisibleSibling();
                break;
            }
            case 33: {
                newSelected = oldSelected.getPreviousPage();
                break;
            }
            case 34: {
                newSelected = oldSelected.getNextPage();
            }
        }
        return newSelected != oldSelected ? newSelected : null;
    }

    public void move(KeyEvent e) {
        NodeView newSelected = this.getVisibleNeighbour(e.getKeyCode());
        if (newSelected != null) {
            if (newSelected != this.getSelected()) {
                this.extendSelectionWithKeyMove(newSelected, e);
                this.scrollNodeToVisible(newSelected);
            }
            e.consume();
        }
    }

    public void resetShiftSelectionOrigin() {
        this.shiftSelectionOrigin = null;
    }

    private void extendSelectionWithKeyMove(NodeView newlySelectedNodeView, KeyEvent e) {
        if (e.isShiftDown()) {
            boolean enlargingMove;
            if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                this.shiftSelectionOrigin = null;
                NodeView toBeNewSelected = newlySelectedNodeView.isParentOf(this.getSelected()) ? newlySelectedNodeView : this.getSelected();
                this.selectBranch(toBeNewSelected, false);
                this.makeTheSelected(toBeNewSelected);
                return;
            }
            if (this.shiftSelectionOrigin == null) {
                this.shiftSelectionOrigin = this.getSelected();
            }
            int newY = this.getMainViewY(newlySelectedNodeView);
            int selectionOriginY = this.getMainViewY(this.shiftSelectionOrigin);
            int deltaY = newY - selectionOriginY;
            NodeView currentSelected = this.getSelected();
            if (e.getKeyCode() == 33) {
                while (true) {
                    int currentSelectedY;
                    if ((currentSelectedY = this.getMainViewY(currentSelected)) > selectionOriginY) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelectedY <= newY) break;
                    currentSelected = currentSelected.getPreviousVisibleSibling();
                }
                return;
            }
            if (e.getKeyCode() == 34) {
                while (true) {
                    int currentSelectedY;
                    if ((currentSelectedY = this.getMainViewY(currentSelected)) < selectionOriginY) {
                        this.deselect(currentSelected);
                    } else {
                        this.makeTheSelected(currentSelected);
                    }
                    if (currentSelectedY >= newY) break;
                    currentSelected = currentSelected.getNextVisibleSibling();
                }
                return;
            }
            boolean bl = enlargingMove = deltaY > 0 && e.getKeyCode() == 40 || deltaY < 0 && e.getKeyCode() == 38;
            if (enlargingMove) {
                this.toggleSelected(newlySelectedNodeView);
            } else {
                this.toggleSelected(this.getSelected());
                this.makeTheSelected(newlySelectedNodeView);
            }
        } else {
            this.shiftSelectionOrigin = null;
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        }
    }

    private int getMainViewY(NodeView node) {
        Point newSelectedLocation = new Point();
        Tools.convertPointToAncestor((Component)node.getMainView(), newSelectedLocation, this);
        int newY = newSelectedLocation.y;
        return newY;
    }

    public void moveToRoot() {
        this.selectAsTheOnlyOneSelected(this.getRoot());
        this.centerNode(this.getRoot());
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected) {
        this.selectAsTheOnlyOneSelected(newSelected, true);
    }

    public void selectAsTheOnlyOneSelected(NodeView newSelected, boolean requestFocus) {
        logger.finest("selectAsTheOnlyOneSelected");
        LinkedList oldSelecteds = this.getSelecteds();
        this.selected.clear();
        this.selected.add(newSelected);
        if (requestFocus) {
            newSelected.requestFocus();
        }
        if (newSelected.getModel().getParentNode() != null) {
            ((NodeView)newSelected.getParent()).setPreferredChild(newSelected);
        }
        this.scrollNodeToVisible(newSelected);
        newSelected.repaintSelected();
        ListIterator e = oldSelecteds.listIterator();
        while (e.hasNext()) {
            NodeView oldSelected = (NodeView)e.next();
            if (oldSelected == null) continue;
            oldSelected.repaintSelected();
        }
    }

    public void toggleSelected(NodeView newSelected) {
        logger.finest("toggleSelected");
        NodeView oldSelected = this.getSelected();
        if (this.isSelected(newSelected)) {
            if (this.selected.size() > 1) {
                this.selected.remove(newSelected);
                oldSelected = newSelected;
            }
        } else {
            this.selected.add(newSelected);
        }
        this.getSelected().requestFocus();
        this.getSelected().repaintSelected();
        if (oldSelected != null) {
            oldSelected.repaintSelected();
        }
    }

    public void makeTheSelected(NodeView newSelected) {
        logger.finest("makeTheSelected");
        if (this.isSelected(newSelected)) {
            this.selected.moveToFirst(newSelected);
        } else {
            this.selected.add(newSelected);
        }
        this.getSelected().requestFocus();
        this.getSelected().repaintSelected();
    }

    public void deselect(NodeView newSelected) {
        if (this.isSelected(newSelected)) {
            this.selected.remove(newSelected);
            newSelected.repaintSelected();
        }
    }

    public void selectBranch(NodeView newlySelectedNodeView, boolean extend) {
        if (!extend) {
            this.selectAsTheOnlyOneSelected(newlySelectedNodeView);
        } else if (!this.isSelected(newlySelectedNodeView) && newlySelectedNodeView.isContentVisible()) {
            this.toggleSelected(newlySelectedNodeView);
        }
        ListIterator e = newlySelectedNodeView.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.selectBranch(target, true);
        }
    }

    public boolean selectContinuous(NodeView newSelected) {
        NodeView nodeView;
        NodeView nodeView2;
        NodeView oldSelected = null;
        LinkedList selList = this.getSelecteds();
        ListIterator j = selList.listIterator();
        while (j.hasNext()) {
            NodeView selectedNode = (NodeView)j.next();
            if (selectedNode == newSelected || !newSelected.isSiblingOf(selectedNode)) continue;
            oldSelected = selectedNode;
            break;
        }
        if (oldSelected == null) {
            if (!this.isSelected(newSelected) && newSelected.isContentVisible()) {
                this.toggleSelected(newSelected);
                return true;
            }
            return false;
        }
        boolean oldPositionLeft = oldSelected.isLeft();
        boolean newPositionLeft = newSelected.isLeft();
        ListIterator i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext() && (nodeView2 = (NodeView)i.next()) != oldSelected) {
        }
        ListIterator i_backup = i;
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
            if (!this.isSelected(nodeView)) break;
            this.deselect(nodeView);
        }
        if ((i = i_backup).hasPrevious()) {
            i.previous();
            while (i.hasPrevious()) {
                nodeView = (NodeView)i.previous();
                if (nodeView.isLeft() != oldPositionLeft && nodeView.isLeft() != newPositionLeft) continue;
                if (!this.isSelected(nodeView)) break;
                this.deselect(nodeView);
            }
        }
        i = newSelected.getSiblingViews().listIterator();
        i = newSelected.getSiblingViews().listIterator();
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            if (this.isSelected(nodeView) || !nodeView.isContentVisible()) break;
            this.toggleSelected(nodeView);
            break;
        }
        while (i.hasNext()) {
            nodeView = (NodeView)i.next();
            if ((nodeView.isLeft() == oldPositionLeft || nodeView.isLeft() == newPositionLeft) && !this.isSelected(nodeView) && nodeView.isContentVisible()) {
                this.toggleSelected(nodeView);
            }
            if (nodeView != newSelected && nodeView != oldSelected) continue;
            break;
        }
        this.toggleSelected(oldSelected);
        this.toggleSelected(oldSelected);
        return true;
    }

    public MindMap getModel() {
        return this.model;
    }

    public void setMoveCursor(boolean isHand) {
        int requiredCursor;
        int n = requiredCursor = isHand && !this.disableMoveCursor ? 13 : 0;
        if (this.getCursor().getType() != requiredCursor) {
            this.setCursor(requiredCursor != 0 ? new Cursor(requiredCursor) : null);
        }
    }

    NodeMouseMotionListener getNodeMouseMotionListener() {
        return this.getController().getNodeMouseMotionListener();
    }

    NodeMotionListener getNodeMotionListener() {
        return this.getController().getNodeMotionListener();
    }

    NodeKeyListener getNodeKeyListener() {
        return this.getController().getNodeKeyListener();
    }

    DragGestureListener getNodeDragListener() {
        return this.getController().getNodeDragListener();
    }

    DropTargetListener getNodeDropListener() {
        return this.getController().getNodeDropListener();
    }

    public NodeView getSelected() {
        if (this.selected.size() > 0) {
            return this.selected.get(0);
        }
        return null;
    }

    private NodeView getSelected(int i) {
        return this.selected.get(i);
    }

    public LinkedList getSelecteds() {
        LinkedList<NodeView> result = new LinkedList<NodeView>();
        for (int i = 0; i < this.selected.size(); ++i) {
            result.add(this.getSelected(i));
        }
        return result;
    }

    public ArrayList getSelectedNodesSortedByY() {
        HashSet<MindMapNode> selectedNodesSet = new HashSet<MindMapNode>();
        for (int i = 0; i < this.selected.size(); ++i) {
            selectedNodesSet.add(this.getSelected(i).getModel());
        }
        LinkedList<Tools.Pair> pointNodePairs = new LinkedList<Tools.Pair>();
        Point point = new Point();
        block1: for (int i = 0; i < this.selected.size(); ++i) {
            NodeView view = this.getSelected(i);
            MindMapNode node = view.getModel();
            for (MindMapNode parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (selectedNodesSet.contains(parent)) continue block1;
            }
            view.getContent().getLocation(point);
            Tools.convertPointToAncestor((Component)view, point, this);
            pointNodePairs.add(new Tools.Pair(new Integer(point.y), node));
        }
        Collections.sort(pointNodePairs, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof Tools.Pair) {
                    Tools.Pair pair0 = (Tools.Pair)arg0;
                    if (arg1 instanceof Tools.Pair) {
                        Tools.Pair pair1 = (Tools.Pair)arg1;
                        Integer int0 = (Integer)pair0.getFirst();
                        Integer int1 = (Integer)pair1.getFirst();
                        return int0.compareTo(int1);
                    }
                }
                throw new IllegalArgumentException("Wrong compare arguments " + arg0 + ", " + arg1);
            }
        });
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        Iterator it = pointNodePairs.iterator();
        while (it.hasNext()) {
            selectedNodes.add(((Tools.Pair)it.next()).getSecond());
        }
        return selectedNodes;
    }

    public ArrayList getSingleSelectedNodes() {
        ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>(this.selected.size());
        for (int i = this.selected.size() - 1; i >= 0; --i) {
            selectedNodes.add(this.getSelected(i).getModel().shallowCopy());
        }
        return selectedNodes;
    }

    public boolean isSelected(NodeView n) {
        if (this.isPrinting) {
            return false;
        }
        return this.selected.contains(n);
    }

    public float getZoom() {
        return this.zoom;
    }

    public int getZoomed(int number) {
        return (int)((float)number * this.zoom);
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        this.getRoot().updateAll();
        this.revalidate();
        this.nodeToBeVisible = this.getSelected();
    }

    @Override
    protected void validateTree() {
        this.validateSelecteds();
        super.validateTree();
        this.setViewPositionAfterValidate();
    }

    private void setViewPositionAfterValidate() {
        int scrollMode;
        JViewport vp = (JViewport)this.getParent();
        Point viewPosition = vp.getViewPosition();
        Point oldRootContentLocation = this.rootContentLocation;
        NodeView root = this.getRoot();
        Point newRootContentLocation = root.getContent().getLocation();
        Tools.convertPointToAncestor((Component)this.getRoot(), newRootContentLocation, this.getParent());
        int deltaX = newRootContentLocation.x - oldRootContentLocation.x;
        int deltaY = newRootContentLocation.y - oldRootContentLocation.y;
        if (deltaX != 0 || deltaY != 0) {
            viewPosition.x += deltaX;
            viewPosition.y += deltaY;
            scrollMode = vp.getScrollMode();
            vp.setScrollMode(0);
            vp.setViewPosition(viewPosition);
            vp.setScrollMode(scrollMode);
        } else {
            vp.repaint();
        }
        if (this.nodeToBeVisible != null) {
            scrollMode = vp.getScrollMode();
            vp.setScrollMode(0);
            this.scrollNodeToVisible(this.nodeToBeVisible, this.extraWidth);
            vp.setScrollMode(scrollMode);
            this.nodeToBeVisible = null;
        }
    }

    @Override
    public void paint(Graphics g) {
        Object newRenderingHintFM;
        long startMilli = System.currentTimeMillis();
        if (this.isValid()) {
            this.getRoot().getContent().getLocation(this.rootContentLocation);
            Tools.convertPointToAncestor((Component)this.getRoot(), this.rootContentLocation, this.getParent());
        }
        Graphics2D g2 = (Graphics2D)g;
        Object renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object renderingTextHint = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        this.getController().setTextRenderingHint(g2);
        Object oldRenderingHintFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        Object object = newRenderingHintFM = this.getZoom() != 1.0f ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        if (oldRenderingHintFM != newRenderingHintFM) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, newRenderingHintFM);
        }
        super.paint(g);
        if (oldRenderingHintFM != newRenderingHintFM && RenderingHints.KEY_FRACTIONALMETRICS.isCompatibleValue(oldRenderingHintFM)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldRenderingHintFM);
        }
        if (RenderingHints.KEY_ANTIALIASING.isCompatibleValue(renderingHint)) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
        if (RenderingHints.KEY_TEXT_ANTIALIASING.isCompatibleValue(renderingTextHint)) {
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, renderingTextHint);
        }
        long localTime = System.currentTimeMillis() - startMilli;
        ++this.mPaintingAmount;
        this.mPaintingTime = (int)((long)this.mPaintingTime + localTime);
        logger.fine("End paint in " + localTime + ". Mean time:" + this.mPaintingTime / this.mPaintingAmount);
    }

    @Override
    public void paintChildren(Graphics graphics) {
        HashMap labels = new HashMap();
        this.ArrowLinkViews = new Vector();
        this.collectLabels(this.rootView, labels);
        super.paintChildren(graphics);
        Graphics2D graphics2d = (Graphics2D)graphics;
        Object renderingHint = this.getController().setEdgesRenderingHint(graphics2d);
        this.paintLinks(this.rootView, graphics2d, labels, null);
        Tools.restoreAntialiasing(graphics2d, renderingHint);
        this.paintSelecteds(graphics2d);
    }

    private void paintSelecteds(Graphics2D g) {
        if (!standardDrawRectangleForSelection || this.isCurrentlyPrinting()) {
            return;
        }
        Color c = g.getColor();
        Stroke s = g.getStroke();
        g.setColor(standardSelectRectangleColor);
        if (standardSelectionStroke == null) {
            standardSelectionStroke = new BasicStroke(2.0f);
        }
        g.setStroke(standardSelectionStroke);
        Object renderingHint = this.getController().setEdgesRenderingHint(g);
        for (NodeView selected : this.getSelecteds()) {
            this.paintSelected(g, selected);
        }
        Tools.restoreAntialiasing(g, renderingHint);
        g.setColor(c);
        g.setStroke(s);
    }

    private void paintSelected(Graphics2D g, NodeView selected) {
        int arcWidth = 4;
        JComponent content = selected.getContent();
        Point contentLocation = new Point();
        Tools.convertPointToAncestor((Component)content, contentLocation, this);
        g.drawRoundRect(contentLocation.x - 4, contentLocation.y - 4, content.getWidth() + 8, content.getHeight() + 8, 15, 15);
    }

    protected void collectLabels(NodeView source, HashMap labels) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        String label = this.getModel().getLinkRegistry().getLabel(source.getModel());
        if (label != null) {
            labels.put(label, source);
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.collectLabels(target, labels);
        }
    }

    protected void paintLinks(NodeView source, Graphics2D graphics, HashMap labels, HashSet LinkAlreadyVisited) {
        if (this.getModel().getLinkRegistry() == null) {
            return;
        }
        if (LinkAlreadyVisited == null) {
            LinkAlreadyVisited = new HashSet<MindMapLink>();
        }
        Vector vec = this.getModel().getLinkRegistry().getAllLinks(source.getModel());
        for (int i = 0; i < vec.size(); ++i) {
            MindMapLink ref = (MindMapLink)vec.get(i);
            if (!LinkAlreadyVisited.add(ref) || !(ref instanceof MindMapArrowLink)) continue;
            ArrowLinkView arrowLink = new ArrowLinkView((MindMapArrowLink)ref, this.getNodeView(ref.getSource()), this.getNodeView(ref.getTarget()));
            arrowLink.paint(graphics);
            this.ArrowLinkViews.add(arrowLink);
        }
        ListIterator e = source.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView target = (NodeView)e.next();
            this.paintLinks(target, graphics, labels, LinkAlreadyVisited);
        }
    }

    public MindMapArrowLink detectCollision(Point p) {
        if (this.ArrowLinkViews == null) {
            return null;
        }
        for (int i = 0; i < this.ArrowLinkViews.size(); ++i) {
            ArrowLinkView arrowView = (ArrowLinkView)this.ArrowLinkViews.get(i);
            if (!arrowView.detectCollision(p)) continue;
            return arrowView.getModel();
        }
        return null;
    }

    public void preparePrinting() {
        if (!this.isPrinting) {
            this.isPrinting = true;
            if (NEED_PREF_SIZE_BUG_FIX) {
                this.getRoot().updateAll();
                this.validate();
            } else {
                this.repaintSelecteds();
            }
            if (printOnWhiteBackground) {
                this.background = this.getBackground();
                this.setBackground(Color.WHITE);
            }
            this.boundingRectangle = this.getInnerBounds();
            this.fitToPage = Resources.getInstance().getBoolProperty("fit_to_page");
        } else {
            logger.warning("Called preparePrinting although isPrinting is true.");
        }
    }

    public void repaintSelecteds() {
        for (NodeView next : this.getSelecteds()) {
            next.repaintSelected();
        }
    }

    public void endPrinting() {
        if (this.isPrinting) {
            this.isPrinting = false;
            if (printOnWhiteBackground) {
                this.setBackground(this.background);
            }
            if (NEED_PREF_SIZE_BUG_FIX) {
                this.getRoot().updateAll();
                this.validate();
            } else {
                this.repaintSelecteds();
            }
        } else {
            logger.warning("Called endPrinting although isPrinting is false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        double userZoomFactor = 1.0;
        try {
            userZoomFactor = Double.parseDouble(this.controller.getProperty("user_zoom"));
        }
        catch (Exception e) {
            // empty catch block
        }
        userZoomFactor = Math.max(0.0, userZoomFactor);
        userZoomFactor = Math.min(2.0, userZoomFactor);
        if (this.fitToPage && pageIndex > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            this.preparePrinting();
            double zoomFactor = 1.0;
            if (this.fitToPage) {
                double zoomFactorX = pageFormat.getImageableWidth() / this.boundingRectangle.getWidth();
                double zoomFactorY = pageFormat.getImageableHeight() / this.boundingRectangle.getHeight();
                zoomFactor = Math.min(zoomFactorX, zoomFactorY);
            } else {
                int nrPagesInHeight;
                zoomFactor = userZoomFactor;
                int nrPagesInWidth = (int)Math.ceil(zoomFactor * this.boundingRectangle.getWidth() / pageFormat.getImageableWidth());
                if (pageIndex >= nrPagesInWidth * (nrPagesInHeight = (int)Math.ceil(zoomFactor * this.boundingRectangle.getHeight() / pageFormat.getImageableHeight()))) {
                    int zoomFactorY = 1;
                    return zoomFactorY;
                }
                int yPageCoord = (int)Math.floor(pageIndex / nrPagesInWidth);
                int xPageCoord = pageIndex - yPageCoord * nrPagesInWidth;
                graphics2D.translate(-pageFormat.getImageableWidth() * (double)xPageCoord, -pageFormat.getImageableHeight() * (double)yPageCoord);
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.scale(zoomFactor, zoomFactor);
            graphics2D.translate(-this.boundingRectangle.getX(), -this.boundingRectangle.getY());
            this.print(graphics2D);
        }
        finally {
            this.endPrinting();
        }
        return 0;
    }

    public boolean isCurrentlyPrinting() {
        return this.isPrinting;
    }

    public Rectangle getInnerBounds() {
        Rectangle innerBounds = this.getRoot().getInnerBounds();
        innerBounds.x += this.getRoot().getX();
        innerBounds.y += this.getRoot().getY();
        Rectangle maxBounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        for (int i = 0; i < this.ArrowLinkViews.size(); ++i) {
            Rectangle arrowViewBigBounds;
            ArrowLinkView arrowView = (ArrowLinkView)this.ArrowLinkViews.get(i);
            CubicCurve2D arrowLinkCurve = arrowView.arrowLinkCurve;
            if (arrowLinkCurve == null || innerBounds.contains(arrowViewBigBounds = arrowLinkCurve.getBounds())) continue;
            Rectangle arrowViewBounds = PathBBox.getBBox(arrowLinkCurve).getBounds();
            innerBounds.add(arrowViewBounds);
        }
        return innerBounds.intersection(maxBounds);
    }

    public NodeView getRoot() {
        return this.rootView;
    }

    private MindMapLayout getMindMapLayout() {
        return (MindMapLayout)this.getLayout();
    }

    private MapView getMap() {
        return this;
    }

    public Controller getController() {
        return this.controller;
    }

    public int getSiblingMaxLevel() {
        return this.siblingMaxLevel;
    }

    public void setSiblingMaxLevel(int level) {
        this.siblingMaxLevel = level;
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + 20, inner.x - outer.x + 20, outer.height - inner.height - inner.y + outer.y + 20, outer.width - inner.width - inner.x + outer.x + 20);
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        Rectangle r = new Rectangle((int)cursorLocn.getX() - 20, (int)cursorLocn.getY() - 20, 41, 41);
        this.scrollRectToVisible(r);
    }

    public NodeView getNodeView(MindMapNode node) {
        if (node == null) {
            return null;
        }
        Collection viewers = node.getViewers();
        for (NodeView candidateView : viewers) {
            if (candidateView.getMap() != this) continue;
            return candidateView;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.getParent().isValid()) {
            Dimension preferredLayoutSize = this.getLayout().preferredLayoutSize(this);
            return preferredLayoutSize;
        }
        return super.getPreferredSize();
    }

    void revalidateSelecteds() {
        this.selectedsValid = false;
    }

    private void validateSelecteds() {
        if (this.selectedsValid) {
            return;
        }
        this.selectedsValid = true;
        logger.finest("validateSelecteds");
        ArrayList<NodeView> selectedNodes = new ArrayList<NodeView>();
        ListIterator it = this.getSelecteds().listIterator();
        while (it.hasNext()) {
            NodeView nodeView = (NodeView)it.next();
            if (nodeView == null) continue;
            selectedNodes.add(nodeView);
        }
        this.selected.clear();
        it = selectedNodes.listIterator();
        while (it.hasNext()) {
            NodeView newNodeView;
            NodeView oldNodeView = (NodeView)it.next();
            if (!oldNodeView.isContentVisible() || (newNodeView = this.getNodeView(oldNodeView.getModel())) == null) continue;
            this.selected.add(newNodeView);
        }
        NodeView focussedNodeView = this.getSelected();
        if (focussedNodeView == null) {
            focussedNodeView = this.getRoot();
        }
        focussedNodeView.requestFocus();
    }

    public Point getNodeContentLocation(NodeView nodeView) {
        Point contentXY = new Point(0, 0);
        Tools.convertPointToAncestor((Component)nodeView.getContent(), contentXY, this);
        return contentXY;
    }

    static {
        NEED_PREF_SIZE_BUG_FIX = Controller.JAVA_VERSION.compareTo("1.5.0") < 0;
    }

    private class Selected {
        private Vector mySelected = new Vector();

        public void clear() {
            if (this.size() > 0) {
                this.removeSelectionForHooks(this.get(0));
            }
            this.mySelected.clear();
            logger.finest("Cleared selected.");
        }

        public int size() {
            return this.mySelected.size();
        }

        public void remove(NodeView node) {
            if (this.mySelected.indexOf(node) == 0) {
                this.removeSelectionForHooks(node);
            }
            this.mySelected.remove(node);
            logger.finest("Removed selected " + node);
        }

        public void add(NodeView node) {
            if (this.size() > 0) {
                this.removeSelectionForHooks(this.get(0));
            }
            this.mySelected.add(0, node);
            this.addSelectionForHooks(node);
            logger.finest("Added selected " + node + "\nAll=" + this.mySelected);
        }

        private void removeSelectionForHooks(NodeView node) {
            if (node.getModel() == null) {
                return;
            }
            MapView.this.getModel().getModeController().onDeselectHook(node);
        }

        private void addSelectionForHooks(NodeView node) {
            MapView.this.getModel().getModeController().onSelectHook(node);
        }

        public NodeView get(int i) {
            return (NodeView)this.mySelected.get(i);
        }

        public boolean contains(NodeView node) {
            return this.mySelected.contains(node);
        }

        public void moveToFirst(NodeView newSelected) {
            if (this.contains(newSelected)) {
                int pos = this.mySelected.indexOf(newSelected);
                if (pos > 0) {
                    if (this.size() > 0) {
                        this.removeSelectionForHooks(this.get(0));
                    }
                    this.mySelected.remove(newSelected);
                    this.mySelected.add(0, newSelected);
                }
            } else {
                this.add(newSelected);
            }
            this.addSelectionForHooks(newSelected);
            logger.finest("MovedToFront selected " + newSelected + "\nAll=" + this.mySelected);
        }
    }

    public static class ScrollPane
    extends JScrollPane {
        @Override
        protected void validateTree() {
            Component view = this.getViewport().getView();
            if (view != null) {
                view.validate();
            }
            super.validateTree();
        }
    }

    private final class ResizeListener
    extends ComponentAdapter {
        Dimension mSize;

        ResizeListener() {
            this.mSize = MapView.this.getSize();
        }

        @Override
        public void componentResized(ComponentEvent pE) {
            logger.fine("Component resized " + pE + " old size " + this.mSize + " new size " + MapView.this.getSize());
            int deltaWidth = this.mSize.width - MapView.this.getWidth();
            int deltaHeight = this.mSize.height - MapView.this.getHeight();
            JViewport mapViewport = (JViewport)MapView.this.getParent();
            Point viewPosition = mapViewport.getViewPosition();
            viewPosition.x += deltaWidth / 2;
            viewPosition.y += deltaHeight / 2;
            this.mSize = MapView.this.getSize();
        }
    }
}

