/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapController;
import freemind.view.mindmapview.attributeview.AttributeTable;
import freemind.view.mindmapview.attributeview.AttributeView;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import splmm.Listeners.SplmmAttributeListener;
import splmm.Listeners.SplmmNodeSelectionListener;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;

public class AddReferenceAttributeAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    MindMapController controller;

    public AddReferenceAttributeAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_attributes_add"));
        this.controller = controller;
        this.controller.registerNodeSelectionListener(new SplmmNodeSelectionListener(this.controller));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean attributesClosed;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        AttributeView attributeView = this.controller.getView().getSelected().getAttributeView();
        boolean bl = attributesClosed = null == SwingUtilities.getAncestorOfClass(AttributeTable.class, focusOwner);
        if (attributesClosed) {
            attributeView.getAttributes().addTableModelListener(new SplmmAttributeListener(attributeView.getAttributes(), SciPloreUtils.EVENT_ADD_REFKEYS));
            Vector attributes = attributeView.getAttributes().getAttributes();
            boolean hasReference = false;
            for (Attribute attribute : attributes) {
                if (!attribute.getName().equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME)) continue;
                hasReference = true;
                break;
            }
            if (!hasReference) {
                Attribute attribute = new Attribute(SciPloreUtils.SPLMM_REFKEY_NAME);
                attributeView.getAttributes().addRowNoUndo(attribute);
                int referenceIndex = attributeView.getAttributes().getAttributes().indexOf(attribute);
                attributeView.startReferenceEditing(referenceIndex);
            }
        } else {
            attributeView.stopEditing();
        }
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }
}

