/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BookmarkMindMapNode;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class SmartUpdateMonitoringDirAction
extends AbstractMonitoringAction {
    JTree tree;

    public SmartUpdateMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_update"), controller);
    }

    public SmartUpdateMonitoringDirAction(MindMapController controller, JTree tree) {
        super(LocalizationSupport.message("splmm_monitoringDir_update"), controller);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.tree != null ? SciPloreUtils.getMonitoringNodeFromPath(this.tree.getSelectionPath()) : this.controller.getSelected();
        this.updateMonitoringNode();
    }

    public void performAction(MindMapNode node) {
        this.selected = node;
        this.updateMonitoringNode();
    }

    private void updateMonitoringNode() {
        String link = SciPloreUtils.getLink(this.controller.getController(), this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH));
        this.directory = new File(link);
        if (!this.directory.exists()) {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_dirNotFound"));
            return;
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
        if (this.isNotUnsavedMapWithRelativePathes()) {
            MindMapMapModel model = (MindMapMapModel)this.selected.getMap();
            model.setAutomaticSaveLock(true);
            this.ExecuteMyTask(new MyTask(), this);
            model.setAutomaticSaveLock(false);
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.name = "update";
            SmartUpdateMonitoringDirAction.this.newFileCounter = 0;
            SmartUpdateMonitoringDirAction.this.bibTexMap = BookmarkMindMapNode.ReadBibtexFile();
            SmartUpdateMonitoringDirAction.this.newBookmarkNodes = new ArrayList();
            SmartUpdateMonitoringDirAction.this.newFileNodes = new ArrayList();
            SmartUpdateMonitoringDirAction.this.controller = (MindMapController)SmartUpdateMonitoringDirAction.this.selected.getMap().getModeController();
            Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles = SmartUpdateMonitoringDirAction.this.getMonFileLinkedNodes(SmartUpdateMonitoringDirAction.this.controller.getRootNode(), new HashMap<String, Collection<MindMapNode>>());
            if (this.canceled) {
                return null;
            }
            List<File> filesFromMonDir = SmartUpdateMonitoringDirAction.this.getMonDirFiles(SmartUpdateMonitoringDirAction.this.directory);
            if (this.canceled) {
                return null;
            }
            List<File> importedFiles = SmartUpdateMonitoringDirAction.this.importNewMonDirFiles(nodesLinkedToMonFiles, filesFromMonDir);
            if (this.canceled) {
                return null;
            }
            if (SplmmPreferences.getAutoImport().booleanValue()) {
                filesFromMonDir = SmartUpdateMonitoringDirAction.this.removeImportedFiles(filesFromMonDir, importedFiles);
                if (this.canceled) {
                    return null;
                }
                filesFromMonDir = SmartUpdateMonitoringDirAction.this.removeUpToDateFiles(filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
                SmartUpdateMonitoringDirAction.this.importNewBookMarks(this, filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
                SmartUpdateMonitoringDirAction.this.setAllNodesUpToDate(filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
            }
            SmartUpdateMonitoringDirAction.this.pasteAllNodes(this);
            if (this.canceled) {
                return null;
            }
            new EventSenderThread(SciPloreUtils.EVENT_READ_MON_DIR, "" + SmartUpdateMonitoringDirAction.this.newFileCounter);
            return null;
        }
    }
}

