/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperator;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.content.CSVirtualDevice;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSConverter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.IResourcesProvider;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.string.StringTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;

public class CSCreator
extends CSVirtualDevice {
    public static final float KAPPA = 0.5522848f;
    private static final float THOUSAND = 1000.0f;
    public static final int VALUE_COLOR_PRECISION = 3;
    public static final int VALUE_COORDINATE_PRECISION = 3;
    public static final int VALUE_DASH_PRECISION = 2;
    public static final int VALUE_FACTOR_PRECISION = 4;
    public static final int VALUE_FLATNESS_PRECISION = 3;
    public static final int VALUE_FONT_PRECISION = 2;
    public static final int VALUE_GRAY_PRECISION = 3;
    public static final int VALUE_WIDTH_PRECISION = 3;
    private boolean applyOperation = false;
    private final CSContent content;
    private final IContentStreamProvider contentStreamProvider;
    private PDResources resources;
    private final IResourcesProvider resourcesProvider;
    private List strings;
    private ByteArrayOutputStream textBuffer;
    private boolean textMode = false;

    public static CSCreator createFromContent(CSContent content, IResourcesProvider resourcesProvider) {
        CSCreator result = new CSCreator(content, null, resourcesProvider);
        return result;
    }

    public static CSCreator createFromProvider(IContentStreamProvider provider) {
        CSCreator result = new CSCreator(provider.getContentStream(), provider, provider);
        return result;
    }

    public static CSCreator createNew(IContentStreamProvider provider) {
        CSContent content = CSContent.createNew();
        CSCreator result = new CSCreator(content, provider, provider);
        return result;
    }

    public static CSCreator createNewDetached(IResourcesProvider provider) {
        CSContent content = CSContent.createNew();
        CSCreator result = new CSCreator(content, null, provider);
        return result;
    }

    protected CSCreator(CSContent content, IContentStreamProvider contentStreamProvider, IResourcesProvider resourcesProvider) {
        this.content = content;
        this.contentStreamProvider = contentStreamProvider;
        this.resourcesProvider = resourcesProvider;
        this.open(null);
    }

    protected void basicSetNonStrokeColorSpace(PDColorSpace colorSpace) {
        super.basicSetNonStrokeColorSpace(colorSpace);
        this.applyOperation = true;
    }

    protected void basicSetNonStrokeColorValues(float[] values) {
        super.basicSetNonStrokeColorValues(values);
        this.applyOperation = true;
    }

    protected void basicSetStrokeColorSpace(PDColorSpace colorSpace) {
        super.basicSetStrokeColorSpace(colorSpace);
        this.applyOperation = true;
    }

    protected void basicSetStrokeColorValues(float[] values) {
        super.basicSetStrokeColorValues(values);
        this.applyOperation = true;
    }

    protected void basicTextShow(byte[] text) {
        CSOperation operation = new CSOperation(CSOperators.CSO_Tj);
        operation.addOperand(COSString.create(text));
        this.getContent().addOperation(operation);
    }

    protected COSName checkResource(COSName resourceType, PDObject.MetaClass metaClass, COSName resourceName, PDObject resource) {
        if (this.getResources() == null) {
            throw new IllegalStateException("must have resource dictionary");
        }
        if (resourceName == null) {
            resourceName = this.getResources().createResource(resourceType, resource);
        } else {
            PDObject temp = this.getResources().getResource(resourceType, metaClass, resourceName);
            if (temp == null) {
                this.getResources().addResource(resourceType, resourceName, resource);
            } else if (resource != temp) {
                resourceName = this.getResources().createResource(resourceType, resource);
            }
        }
        return resourceName;
    }

    public void close() {
        this.flush();
        super.close();
    }

    public void compatibilityBegin() {
        super.compatibilityBegin();
        CSOperation operation = new CSOperation(CSOperators.CSO_BX);
        this.getContent().addOperation(operation);
    }

    public void compatibilityEnd() {
        super.compatibilityEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_EX);
        this.getContent().addOperation(operation);
    }

    public void copy(CSContent otherContent) {
        int len = otherContent.size();
        int i = 0;
        while (i < len) {
            CSOperation operation = otherContent.getOperation(i);
            this.operationAdd(operation);
            ++i;
        }
    }

    public void doShading(COSName name, PDShading shading) {
        this.textEnd();
        name = this.checkResource(PDResources.CN_RT_Shading, PDShading.META, name, shading);
        CSOperation operation = new CSOperation(CSOperators.CSO_sh);
        operation.addOperand(name);
        this.getContent().addOperation(operation);
    }

    public void doXObject(COSName name, PDXObject xObject) {
        this.textEnd();
        name = this.checkResource(PDResources.CN_RT_XObject, PDXObject.META, name, xObject);
        CSOperation operation = new CSOperation(CSOperators.CSO_Do);
        operation.addOperand(name);
        this.getContent().addOperation(operation);
    }

    public void flush() {
        this.textEnd();
        if (this.getContentStreamProvider() != null) {
            this.getContentStreamProvider().setContentStream(this.getContent());
        }
    }

    public CSContent getContent() {
        return this.content;
    }

    public IContentStreamProvider getContentStreamProvider() {
        return this.contentStreamProvider;
    }

    protected PDResources getResources() {
        if (this.resources == null) {
            this.resources = this.getResourcesProvider().getResources();
            if (this.resources == null) {
                this.resources = (PDResources)PDResources.META.createNew();
                this.getResourcesProvider().setResources(this.resources);
            }
        }
        return this.resources;
    }

    public IResourcesProvider getResourcesProvider() {
        return this.resourcesProvider;
    }

    protected List getStrings() {
        return this.strings;
    }

    protected ByteArrayOutputStream getTextBuffer() {
        return this.textBuffer;
    }

    public void inlineImage(PDImage img) {
    }

    protected boolean isFont(PDFont queryFont, float queryFontSize) {
        TextState tempTextState = this.textState;
        return tempTextState.font != null && tempTextState.font.equals(queryFont) && tempTextState.fontSize == queryFontSize;
    }

    protected boolean isTextMode() {
        return this.textMode;
    }

    public void markedContentBegin(COSName tag) {
        CSOperation operation = new CSOperation(CSOperators.CSO_BMC);
        operation.addOperand(tag.copyOptional());
        this.getContent().addOperation(operation);
    }

    public void markedContentBeginProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    public void markedContentEnd() {
        CSOperation operation = new CSOperation(CSOperators.CSO_EMC);
        this.getContent().addOperation(operation);
    }

    public void markedContentPoint(COSName tag) {
        CSOperation operation = new CSOperation(CSOperators.CSO_MP);
        operation.addOperand(tag.copyOptional());
        this.getContent().addOperation(operation);
    }

    public void markedContentPointProperties(COSName tag, COSName resourceName, COSDictionary properties) {
    }

    public void open(ICSInterpreter pInterpreter) {
        super.open(pInterpreter);
        this.resetStrings();
    }

    protected void operationAdd(CSOperation operation) {
        this.getContent().addOperation(operation);
    }

    public void pathClipEvenOdd() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_Wstar);
        this.getContent().addOperation(operation);
    }

    public void pathClipNonZero() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_W);
        this.getContent().addOperation(operation);
    }

    public void pathClose() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_h);
        this.getContent().addOperation(operation);
    }

    public void pathCloseFillStrokeEvenOdd() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_bstar);
        this.getContent().addOperation(operation);
    }

    public void pathCloseFillStrokeNonZero() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_b);
        this.getContent().addOperation(operation);
    }

    public void pathCloseStroke() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_s);
        this.getContent().addOperation(operation);
    }

    public void pathEnd() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_n);
        this.getContent().addOperation(operation);
    }

    public void pathFillEvenOdd() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_fstar);
        this.getContent().addOperation(operation);
    }

    public void pathFillNonZero() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_f);
        this.getContent().addOperation(operation);
    }

    public void pathFillStrokeEvenOdd() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_Bstar);
        this.getContent().addOperation(operation);
    }

    public void pathFillStrokeNonZero() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_B);
        this.getContent().addOperation(operation);
    }

    public void pathStroke() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_S);
        this.getContent().addOperation(operation);
    }

    public void penCircle(float x, float y, float r) {
        this.penEllipse(x, y, r, r);
    }

    public void penCurveToC(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_c);
        operation.addOperand(COSFixed.create(x1));
        operation.addOperand(COSFixed.create(y1));
        operation.addOperand(COSFixed.create(x2));
        operation.addOperand(COSFixed.create(y2));
        operation.addOperand(COSFixed.create(x3));
        operation.addOperand(COSFixed.create(y3));
        this.getContent().addOperation(operation);
    }

    public void penCurveToV(float x2, float y2, float x3, float y3) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_v);
        operation.addOperand(COSFixed.create(x2));
        operation.addOperand(COSFixed.create(y2));
        operation.addOperand(COSFixed.create(x3));
        operation.addOperand(COSFixed.create(y3));
        this.getContent().addOperation(operation);
    }

    public void penCurveToY(float x1, float y1, float x3, float y3) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_y);
        operation.addOperand(COSFixed.create(x1));
        operation.addOperand(COSFixed.create(y1));
        operation.addOperand(COSFixed.create(x3));
        operation.addOperand(COSFixed.create(y3));
        this.getContent().addOperation(operation);
    }

    public void penEllipse(float x, float y, float rx, float ry) {
        this.textEnd();
        float rxkappa = rx * 0.5522848f;
        float rykappa = ry * 0.5522848f;
        this.penMoveTo(x + rx, y);
        this.penCurveToC(x + rx, y + rykappa, x + rxkappa, y + ry, x, y + ry);
        this.penCurveToC(x - rxkappa, y + ry, x - rx, y + rykappa, x - rx, y);
        this.penCurveToC(x - rx, y - rykappa, x - rxkappa, y - ry, x, y - ry);
        this.penCurveToC(x + rxkappa, y - ry, x + rx, y - rykappa, x + rx, y);
    }

    public void penLineTo(float x, float y) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_l);
        operation.addOperand(COSFixed.create(x, 3));
        operation.addOperand(COSFixed.create(y, 3));
        this.getContent().addOperation(operation);
    }

    public void penMoveTo(float x, float y) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_m);
        operation.addOperand(COSFixed.create(x, 3));
        operation.addOperand(COSFixed.create(y, 3));
        this.getContent().addOperation(operation);
    }

    public void penRectangle(CDSRectangle rect) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_re);
        operation.addOperand(COSFixed.create(rect.getLowerLeftX(), 3));
        operation.addOperand(COSFixed.create(rect.getLowerLeftY(), 3));
        operation.addOperand(COSFixed.create(rect.getWidth(), 3));
        operation.addOperand(COSFixed.create(rect.getHeight(), 3));
        this.getContent().addOperation(operation);
    }

    public void penRectangle(float x, float y, float w, float h) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_re);
        operation.addOperand(COSFixed.create(x, 3));
        operation.addOperand(COSFixed.create(y, 3));
        operation.addOperand(COSFixed.create(w, 3));
        operation.addOperand(COSFixed.create(h, 3));
        this.getContent().addOperation(operation);
    }

    public void penRectangle(Rectangle2D rect) {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_re);
        operation.addOperand(COSFixed.create(rect.getX(), 3));
        operation.addOperand(COSFixed.create(rect.getY(), 3));
        operation.addOperand(COSFixed.create(rect.getWidth(), 3));
        operation.addOperand(COSFixed.create(rect.getHeight(), 3));
        this.getContent().addOperation(operation);
    }

    public void perform(byte[] bytes, COSObject ... operand) {
        CSOperation literal = new CSOperation(bytes, operand);
        this.getContent().addOperation(literal);
    }

    public void perform(CSOperator operator, COSObject ... operand) {
        CSOperation literal = new CSOperation(operator, operand);
        this.getContent().addOperation(literal);
    }

    public void perform(String string, COSObject ... operand) {
        CSOperation literal = new CSOperation(StringTools.toByteArray((String)string), operand);
        this.getContent().addOperation(literal);
    }

    protected void resetStrings() {
        this.strings = new ArrayList();
        this.resetTextBuffer();
    }

    protected void resetTextBuffer() {
        this.textBuffer = new ByteArrayOutputStream();
    }

    public void restoreState() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_Q);
        this.getContent().addOperation(operation);
        super.restoreState();
    }

    public void saveState() {
        this.textEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_q);
        this.getContent().addOperation(operation);
        super.saveState();
    }

    public void setExtendedState(COSName name, PDExtGState gstate) {
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_ExtGState, PDExtGState.META, name, gstate);
        super.setExtendedState(name, gstate);
        CSOperation operation = new CSOperation(CSOperators.CSO_gs);
        operation.addOperand(name);
        this.getContent().addOperation(operation);
    }

    public void setFlatnessTolerance(float flatness) {
        this.streamEnd();
        super.setFlatnessTolerance(flatness);
        CSOperation operation = new CSOperation(CSOperators.CSO_i);
        operation.addOperand(COSFixed.create(flatness, 3));
        this.getContent().addOperation(operation);
    }

    public void setLineCap(int style) {
        this.streamEnd();
        super.setLineCap(style);
        CSOperation operation = new CSOperation(CSOperators.CSO_J);
        operation.addOperand(COSInteger.create(style));
        this.getContent().addOperation(operation);
    }

    public void setLineDash(float unitsOn, float unitsOff, float phase) {
        this.setLineDash(new float[]{unitsOn, unitsOff}, phase);
    }

    public void setLineDash(float[] pattern, float phase) {
        this.streamEnd();
        super.setLineDash(pattern, phase);
        CSOperation operation = new CSOperation(CSOperators.CSO_d);
        operation.addOperand(COSConverter.toCos(pattern));
        operation.addOperand(COSFixed.create(phase, 2));
        this.getContent().addOperation(operation);
    }

    public void setLineJoin(int style) {
        this.streamEnd();
        super.setLineJoin(style);
        CSOperation operation = new CSOperation(CSOperators.CSO_j);
        operation.addOperand(COSInteger.create(style));
        this.getContent().addOperation(operation);
    }

    public void setLineWidth(float w) {
        if (this.graphicsState.lineWidth == w) {
            return;
        }
        this.streamEnd();
        super.setLineWidth(w);
        CSOperation operation = new CSOperation(CSOperators.CSO_w);
        operation.addOperand(COSFixed.create(w, 3));
        this.getContent().addOperation(operation);
    }

    public void setMiterLimit(float miterLimit) {
        this.streamEnd();
        super.setMiterLimit(miterLimit);
        CSOperation operation = new CSOperation(CSOperators.CSO_M);
        operation.addOperand(COSFixed.create(miterLimit));
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorCMYK(float c, float m, float y, float k) {
        c = Math.max(0.0f, Math.min(1.0f, c));
        m = Math.max(0.0f, Math.min(1.0f, m));
        y = Math.max(0.0f, Math.min(1.0f, y));
        k = Math.max(0.0f, Math.min(1.0f, k));
        super.setNonStrokeColorCMYK(c, m, y, k);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_k);
        operation.addOperand(COSFixed.create(c, 3));
        operation.addOperand(COSFixed.create(m, 3));
        operation.addOperand(COSFixed.create(y, 3));
        operation.addOperand(COSFixed.create(k, 3));
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorGray(float gray) {
        super.setNonStrokeColorGray(gray);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_g);
        operation.addOperand(COSFixed.create(gray, 3));
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorRGB(float r, float g, float b) {
        r = Math.max(0.0f, Math.min(1.0f, r));
        g = Math.max(0.0f, Math.min(1.0f, g));
        b = Math.max(0.0f, Math.min(1.0f, b));
        super.setNonStrokeColorRGB(r, g, b);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_rg);
        operation.addOperand(COSFixed.create(r, 3));
        operation.addOperand(COSFixed.create(g, 3));
        operation.addOperand(COSFixed.create(b, 3));
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        super.setNonStrokeColorSpace(name, colorSpace);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_ColorSpace, PDColorSpace.META, name, colorSpace);
        CSOperation operation = new CSOperation(CSOperators.CSO_cs);
        operation.addOperand(name.copyOptional());
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorValues(float[] values) {
        super.setNonStrokeColorValues(values);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_sc);
        int i = 0;
        while (i < values.length) {
            operation.addOperand(COSFixed.create(values[i], 3));
            ++i;
        }
        this.getContent().addOperation(operation);
    }

    public void setNonStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_Pattern, PDPattern.META, name, pattern);
        this.graphicsState.nonStrokeColorValues = values;
        CSOperation operation = new CSOperation(CSOperators.CSO_scn);
        int i = 0;
        while (i < values.length) {
            operation.addOperand(COSFixed.create(values[i], 3));
            ++i;
        }
        if (name != null) {
            operation.addOperand(name.copyShallow());
        }
        this.getContent().addOperation(operation);
    }

    public void setRenderingIntent(COSName intent) {
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_ri);
        operation.addOperand(intent.copyOptional());
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorCMYK(float c, float m, float y, float k) {
        c = Math.max(0.0f, Math.min(1.0f, c));
        m = Math.max(0.0f, Math.min(1.0f, m));
        y = Math.max(0.0f, Math.min(1.0f, y));
        k = Math.max(0.0f, Math.min(1.0f, k));
        super.setStrokeColorCMYK(c, m, y, k);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_K);
        operation.addOperand(COSFixed.create(c, 3));
        operation.addOperand(COSFixed.create(m, 3));
        operation.addOperand(COSFixed.create(y, 3));
        operation.addOperand(COSFixed.create(k, 3));
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorGray(float gray) {
        super.setStrokeColorGray(gray);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_G);
        operation.addOperand(COSFixed.create(gray, 3));
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorRGB(float r, float g, float b) {
        r = Math.max(0.0f, Math.min(1.0f, r));
        g = Math.max(0.0f, Math.min(1.0f, g));
        b = Math.max(0.0f, Math.min(1.0f, b));
        super.setStrokeColorRGB(r, g, b);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_RG);
        operation.addOperand(COSFixed.create(r, 3));
        operation.addOperand(COSFixed.create(g, 3));
        operation.addOperand(COSFixed.create(b, 3));
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorSpace(COSName name, PDColorSpace colorSpace) {
        super.setStrokeColorSpace(name, colorSpace);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_ColorSpace, PDColorSpace.META, name, colorSpace);
        CSOperation operation = new CSOperation(CSOperators.CSO_CS);
        operation.addOperand(name);
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorValues(float[] values) {
        super.setStrokeColorValues(values);
        if (!this.applyOperation) {
            return;
        }
        this.applyOperation = false;
        this.streamEnd();
        CSOperation operation = new CSOperation(CSOperators.CSO_SC);
        int i = 0;
        while (i < values.length) {
            operation.addOperand(COSFixed.create(values[i], 3));
            ++i;
        }
        this.getContent().addOperation(operation);
    }

    public void setStrokeColorValues(float[] values, COSName name, PDPattern pattern) {
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_Pattern, PDPattern.META, name, pattern);
        this.graphicsState.strokeColorValues = values;
        CSOperation operation = new CSOperation(CSOperators.CSO_SCN);
        int i = 0;
        while (i < values.length) {
            operation.addOperand(COSFixed.create(values[i], 3));
            ++i;
        }
        if (name != null) {
            operation.addOperand(name.copyShallow());
        }
        this.getContent().addOperation(operation);
    }

    protected void setTextMode(boolean b) {
        this.textMode = b;
    }

    protected void streamEnd() {
        this.streamEndRun();
        int size = this.getStrings().size();
        if (size == 1) {
            Object element = this.getStrings().get(0);
            if (element instanceof byte[]) {
                byte[] bytes = (byte[])element;
                this.basicTextShow(bytes);
            }
        } else if (size > 1) {
            COSArray cosStrings = COSArray.create(size);
            for (Object element : this.getStrings()) {
                if (element instanceof byte[]) {
                    byte[] data = (byte[])element;
                    COSString cosString = COSString.create(data);
                    cosStrings.add(cosString);
                    continue;
                }
                Integer move = (Integer)element;
                COSInteger cosMove = COSInteger.create(move);
                cosStrings.add(cosMove);
            }
            this.streamEndShow(cosStrings);
        }
        this.resetStrings();
    }

    protected void streamEndRun() {
        if (this.getTextBuffer().toByteArray().length > 0) {
            this.getStrings().add(this.getTextBuffer().toByteArray());
        }
        this.resetTextBuffer();
    }

    protected void streamEndShow(COSArray theStrings) {
        CSOperation operation = new CSOperation(CSOperators.CSO_TJ);
        operation.addOperand(theStrings);
        this.getContent().addOperation(operation);
    }

    public void textBegin() {
        if (this.isTextMode()) {
            return;
        }
        super.textBegin();
        this.setTextMode(true);
        CSOperation operation = new CSOperation(CSOperators.CSO_BT);
        this.getContent().addOperation(operation);
    }

    public void textEnd() {
        if (!this.isTextMode()) {
            return;
        }
        this.streamEnd();
        super.textEnd();
        this.setTextMode(false);
        CSOperation lastOper = this.getContent().getLastOperation();
        if (lastOper != null && lastOper.matchesOperator(CSOperators.CSO_BT)) {
            this.getContent().removeLastOperation();
            return;
        }
        CSOperation operation = new CSOperation(CSOperators.CSO_ET);
        this.getContent().addOperation(operation);
    }

    public void textLineMove(float dx, float dy) {
        this.textBegin();
        this.streamEnd();
        super.textLineMove(dx, dy);
        CSOperation operation = new CSOperation(CSOperators.CSO_Td);
        operation.addOperand(COSFixed.create(dx, 3));
        operation.addOperand(COSFixed.create(dy, 3));
        this.getContent().addOperation(operation);
    }

    public void textLineMoveSetLeading(float dx, float dy) {
        this.textBegin();
        this.streamEnd();
        super.textLineMove(dx, dy);
        super.textSetLeading(dy);
        CSOperation operation = new CSOperation(CSOperators.CSO_TD);
        operation.addOperand(COSFixed.create(dx, 3));
        operation.addOperand(COSFixed.create(dy, 3));
        this.getContent().addOperation(operation);
    }

    public void textLineMoveTo(float x, float y) {
        AffineTransform tx = this.textState.lineTransform;
        this.textSetTransform((float)tx.getScaleX(), (float)tx.getShearY(), (float)tx.getShearX(), (float)tx.getScaleY(), x, y);
    }

    public void textLineNew() {
        this.textBegin();
        this.streamEnd();
        super.textLineNew();
        CSOperation operation = new CSOperation(CSOperators.CSO_Tstar);
        this.getContent().addOperation(operation);
    }

    public void textMove(float dx, float dy) {
        int iDelta;
        this.textBegin();
        if (dy != 0.0f) {
            AffineTransform tm = this.textState.transform;
            this.textSetTransform((float)tm.getScaleX(), (float)tm.getShearY(), (float)tm.getShearX(), (float)tm.getScaleY(), (float)tm.getTranslateX() + dx, (float)tm.getTranslateY() + dy);
            return;
        }
        if (dx != 0.0f && (iDelta = (int)(-dx * 1000.0f / this.textState.fontSize)) != 0) {
            if (iDelta < -10000) {
                AffineTransform tm = this.textState.transform;
                this.textSetTransform((float)tm.getScaleX(), (float)tm.getShearY(), (float)tm.getShearX(), (float)tm.getScaleY(), (float)tm.getTranslateX() + dx, (float)tm.getTranslateY() + dy);
            } else {
                this.streamEndRun();
                this.getStrings().add(new Integer(iDelta));
                this.textState.transform.translate(dx, 0.0);
                this.textState.globalTransform.translate(dx, 0.0);
            }
        }
    }

    public void textMoveTo(float x, float y) {
        int iDelta;
        this.textBegin();
        AffineTransform tm = this.textState.transform;
        float dDeltaY = y - (float)tm.getTranslateY();
        if (dDeltaY != 0.0f) {
            this.textSetTransform((float)tm.getScaleX(), (float)tm.getShearY(), (float)tm.getShearX(), (float)tm.getScaleY(), x, y);
            return;
        }
        float dDeltaX = x - (float)tm.getTranslateX();
        if (dDeltaX != 0.0f && (iDelta = (int)(-dDeltaX * 1000.0f / this.textState.fontSize)) != 0) {
            if (iDelta < -10000) {
                this.textSetTransform((float)tm.getScaleX(), (float)tm.getShearY(), (float)tm.getShearX(), (float)tm.getScaleY(), x, y);
            } else {
                this.streamEndRun();
                this.getStrings().add(new Integer(iDelta));
                this.textState.transform.translate(dDeltaX, 0.0);
                this.textState.globalTransform.translate(dDeltaX, 0.0);
            }
        }
    }

    public void textSetCharSpacing(float charSpace) {
        this.textBegin();
        this.streamEnd();
        super.textSetCharSpacing(charSpace);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tc);
        operation.addOperand(COSFixed.create(charSpace));
        this.getContent().addOperation(operation);
    }

    public void textSetFont(COSName name, PDFont font, float size) {
        this.textBegin();
        if (this.isFont(font, size)) {
            return;
        }
        this.streamEnd();
        name = this.checkResource(PDResources.CN_RT_Font, PDFont.META, name, font);
        super.textSetFont(name, font, size);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tf);
        operation.addOperand(name);
        operation.addOperand(COSFixed.create(size, 2));
        this.getContent().addOperation(operation);
    }

    public void textSetHorizontalScaling(float scale) {
        this.textBegin();
        this.streamEnd();
        super.textSetHorizontalScaling(scale);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tz);
        operation.addOperand(COSFixed.create(scale));
        this.getContent().addOperation(operation);
    }

    public void textSetLeading(float leading) {
        this.textBegin();
        this.streamEnd();
        super.textSetLeading(leading);
        CSOperation operation = new CSOperation(CSOperators.CSO_TL);
        operation.addOperand(COSFixed.create(leading));
        this.getContent().addOperation(operation);
    }

    public void textSetRenderingMode(int rendering) {
        this.textBegin();
        this.streamEnd();
        super.textSetRenderingMode(rendering);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tr);
        operation.addOperand(COSInteger.create(rendering));
        this.getContent().addOperation(operation);
    }

    public void textSetRise(float rise) {
        this.textBegin();
        this.streamEnd();
        super.textSetRise(rise);
        CSOperation operation = new CSOperation(CSOperators.CSO_Ts);
        operation.addOperand(COSFixed.create(rise));
        this.getContent().addOperation(operation);
    }

    public void textSetTransform(float a, float b, float c, float d, float e, float f) {
        this.textBegin();
        this.streamEnd();
        super.textSetTransform(a, b, c, d, e, f);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tm);
        operation.addOperand(COSFixed.create(a, 4));
        operation.addOperand(COSFixed.create(b, 4));
        operation.addOperand(COSFixed.create(c, 4));
        operation.addOperand(COSFixed.create(d, 4));
        operation.addOperand(COSFixed.create(e, 3));
        operation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(operation);
    }

    public void textSetWordSpacing(float wordSpace) {
        this.textBegin();
        this.streamEnd();
        super.textSetWordSpacing(wordSpace);
        CSOperation operation = new CSOperation(CSOperators.CSO_Tw);
        operation.addOperand(COSFixed.create(wordSpace));
        this.getContent().addOperation(operation);
    }

    public void textShow(byte[] text, int offset, int length) {
        this.textBegin();
        this.getTextBuffer().write(text, offset, length);
        float width = PDFontTools.getGlyphWidthEncoded(this.textState.font, text, offset, length);
        width = this.textState.fontSize * width / 1000.0f;
        this.textState.transform.translate(width, 0.0);
        this.textState.globalTransform.translate(width, 0.0);
    }

    public void textT3SetGlyphWidth(float x, float y) {
        this.textBegin();
        this.streamEnd();
        super.textT3SetGlyphWidth(x, y);
        CSOperation operation = new CSOperation(CSOperators.CSO_d0);
        operation.addOperand(COSFixed.create(x));
        operation.addOperand(COSFixed.create(y));
        this.getContent().addOperation(operation);
    }

    public void textT3SetGlyphWidthBB(float x, float y, float llx, float lly, float urx, float ury) {
        this.textBegin();
        this.streamEnd();
        super.textT3SetGlyphWidthBB(x, y, llx, lly, urx, ury);
        CSOperation operation = new CSOperation(CSOperators.CSO_d1);
        operation.addOperand(COSFixed.create(x));
        operation.addOperand(COSFixed.create(y));
        operation.addOperand(COSFixed.create(llx));
        operation.addOperand(COSFixed.create(lly));
        operation.addOperand(COSFixed.create(urx));
        operation.addOperand(COSFixed.create(ury));
        this.getContent().addOperation(operation);
    }

    public void transform(float a, float b, float c, float d, float e, float f) {
        this.textEnd();
        super.transform(a, b, c, d, e, f);
        CSOperation operation = new CSOperation(CSOperators.CSO_cm);
        operation.addOperand(COSFixed.create(a, 4));
        operation.addOperand(COSFixed.create(b, 4));
        operation.addOperand(COSFixed.create(c, 4));
        operation.addOperand(COSFixed.create(d, 4));
        operation.addOperand(COSFixed.create(e, 3));
        operation.addOperand(COSFixed.create(f, 3));
        this.getContent().addOperation(operation);
    }
}

