/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCII85InputStream
extends FilterInputStream {
    private static final long CONST_85 = 85L;
    private static final long HIGH_BYTE = 255L;
    private byte[] ascii = new byte[5];
    private byte[] b = new byte[4];
    private boolean eof = false;
    private int index = 0;
    private int n = 0;

    public ASCII85InputStream(InputStream is) {
        super(is);
    }

    public final int read() throws IOException {
        if (this.index >= this.n) {
            byte zz;
            byte z;
            if (this.eof) {
                return -1;
            }
            this.index = 0;
            do {
                if ((zz = (byte)this.in.read()) != -1) continue;
                this.eof = true;
                return -1;
            } while ((z = (byte)zz) == 10 || z == 13 || z == 32);
            if (z == 126 | z == 120) {
                this.eof = true;
                this.ascii = null;
                this.b = null;
                this.n = 0;
                return -1;
            }
            if (z == 122) {
                this.b[0] = 0;
                this.b[1] = 0;
                this.b[2] = 0;
                this.b[3] = 0;
                this.n = 4;
            } else {
                this.ascii[0] = z;
                int k = 1;
                while (k < 5) {
                    do {
                        if ((zz = (byte)this.in.read()) != -1) continue;
                        this.eof = true;
                        return -1;
                    } while ((z = (byte)zz) == 10 || z == 13 || z == 32);
                    this.ascii[k] = z;
                    if (z == 126 | z == 120) break;
                    ++k;
                }
                this.n = k - 1;
                if (this.n == 0) {
                    this.eof = true;
                    this.ascii = null;
                    this.b = null;
                    return -1;
                }
                if (k < 5) {
                    ++k;
                    while (k < 5) {
                        this.ascii[k] = 33;
                        ++k;
                    }
                    this.eof = true;
                }
                long t = 0L;
                k = 0;
                while (k < 5) {
                    z = (byte)(this.ascii[k] - 33);
                    if (z < 0 || z > 93) {
                        this.n = 0;
                        this.eof = true;
                        this.ascii = null;
                        this.b = null;
                        throw new IOException("Invalid data in Ascii85 stream");
                    }
                    t = t * 85L + (long)z;
                    ++k;
                }
                k = 3;
                while (k >= 0) {
                    this.b[k] = (byte)(t & 0xFFL);
                    t >>>= 8;
                    --k;
                }
            }
        }
        return this.b[this.index++] & 0xFF;
    }

    public final int read(byte[] data, int offset, int len) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        int i = 0;
        while (i < len) {
            if (this.index < this.n) {
                data[i + offset] = this.b[this.index++];
            } else {
                int t = this.read();
                if (t == -1) {
                    return i;
                }
                data[i + offset] = (byte)t;
            }
            ++i;
        }
        return len;
    }

    public int available() throws IOException {
        throw new IOException("method not supported");
    }

    public void close() throws IOException {
        this.ascii = null;
        this.eof = true;
        this.b = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("method not supported");
    }

    public long skip(long bytes) throws IOException {
        throw new IOException("method not supported");
    }
}

