/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDFunction;

public class PDSampledFunction
extends PDFunction {
    public static final COSName DK_BitsPerSample = COSName.constant("BitsPerSample");
    public static final COSName DK_Decode = COSName.constant("Decode");
    public static final COSName DK_Encode = COSName.constant("Encode");
    public static final COSName DK_Order = COSName.constant("Order");
    public static final COSName DK_Size = COSName.constant("Size");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private byte[] samples;

    protected PDSampledFunction(COSObject object) {
        super(object);
    }

    public COSArray cosGetDecode() {
        return this.cosGetDict().get(DK_Decode).asArray();
    }

    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    public COSArray cosGetEncode() {
        return this.cosGetDict().get(DK_Encode).asArray();
    }

    public float[] evaluate(float[] input) {
        float[] intermediate = new float[input.length];
        this.prepareInput(input, intermediate);
        float[] output = this.stepInterpolateOutput(intermediate, 0, 0, 0);
        this.prepareOutput(output);
        return output;
    }

    public int getBitsPerSample() {
        return this.cosGetDict().get(DK_BitsPerSample).asNumber().intValue();
    }

    public float getDecodeMax(int dimension) {
        COSArray decode = this.cosGetDecode();
        if (decode == null) {
            return this.getRangeMax(dimension);
        }
        return decode.get(dimension * 2 + 1).asNumber().floatValue();
    }

    public float getDecodeMin(int dimension) {
        COSArray decode = this.cosGetDecode();
        if (decode == null) {
            return this.getRangeMin(dimension);
        }
        return this.cosGetDecode().get(dimension * 2).asNumber().floatValue();
    }

    public float getEncodeMax(int dimension) {
        COSArray encode = this.cosGetEncode();
        if (encode == null) {
            return this.getSize(dimension) - 1;
        }
        return this.cosGetEncode().get(dimension * 2 + 1).asNumber().floatValue();
    }

    public float getEncodeMin(int dimension) {
        COSArray encode = this.cosGetEncode();
        if (encode == null) {
            return 0.0f;
        }
        return this.cosGetEncode().get(dimension * 2).asNumber().floatValue();
    }

    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    protected int getSample(int bitPos) {
        int bytePos = bitPos >> 3;
        int bitShift = 7 - bitPos & 7;
        int result = 0;
        int i = 0;
        while (i < this.getBitsPerSample()) {
            result <<= 1;
            int sample = this.getSamples()[bytePos] >> bitShift & 1;
            result += sample;
            if (bitShift == 0) {
                ++bytePos;
                bitShift = 7;
            } else {
                --bitShift;
            }
            ++i;
        }
        return result;
    }

    protected byte[] getSamples() {
        if (this.samples == null) {
            this.samples = this.cosGetStream().getDecodedBytes();
        }
        return this.samples;
    }

    public COSArray getSize() {
        return this.cosGetDict().get(DK_Size).asArray();
    }

    public int getSize(int dimension) {
        return this.getSize().get(dimension).asNumber().intValue();
    }

    protected float interpolate(float x, float xmin, float xmax, float ymin, float ymax) {
        return ymin + (x - xmin) * (ymax - ymin) / (xmax - xmin);
    }

    protected float[] lookup(int sampleIndex) {
        int bitPos = this.getBitsPerSample() * this.getOutputSize() * sampleIndex;
        float[] output = new float[this.getOutputSize()];
        int index = 0;
        while (index < output.length) {
            output[index] = this.getSample(bitPos);
            ++index;
            bitPos += this.getBitsPerSample();
        }
        return output;
    }

    protected void prepareInput(float[] values, float[] intermediate) {
        int i = 0;
        while (i < values.length) {
            intermediate[i] = this.clip(values[i], this.getDomainMin(i), this.getDomainMax(i));
            intermediate[i] = this.interpolate(intermediate[i], this.getDomainMin(i), this.getDomainMax(i), this.getEncodeMin(i), this.getEncodeMax(i));
            intermediate[i] = this.clip(intermediate[i], 0.0f, this.getSize(i) - 1);
            ++i;
        }
    }

    protected void prepareOutput(float[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = this.interpolate(values[i], 0.0f, (float)Math.pow(2.0, this.getBitsPerSample()), this.getDecodeMin(i), this.getDecodeMax(i));
            values[i] = this.clip(values[i], this.getRangeMin(i), this.getRangeMax(i));
            ++i;
        }
    }

    protected float[] stepInterpolateOutput(float[] input, int lowBase, int highBase, int step) {
        float[] highSample;
        float[] lowSample;
        int dimension = input.length - step - 1;
        int offset = 1;
        int index = 0;
        while (index < dimension) {
            offset *= this.getSize(index);
            ++index;
        }
        if (dimension > -1) {
            int lowOffset = offset * (int)Math.floor(input[dimension]);
            int highOffset = offset * (int)Math.ceil(input[dimension]);
            lowSample = this.stepInterpolateOutput(input, lowBase + lowOffset, lowBase + highOffset, step + 1);
            if (step == 0) {
                return lowSample;
            }
            highSample = this.stepInterpolateOutput(input, highBase + lowOffset, highBase + highOffset, step + 1);
        } else {
            lowSample = this.lookup(lowBase);
            highSample = highBase == lowBase ? lowSample : this.lookup(highBase);
        }
        float[] result = new float[this.getOutputSize()];
        index = 0;
        while (index < result.length) {
            float low = lowSample[index];
            float high = highSample[index];
            float fract = (float)((double)input[step - 1] - Math.floor(input[step - 1]));
            result[index] = low + fract * (high - low);
            ++index;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class<?> instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSStream.create(null);
        }
    }
}

