/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class ReminderHookBase
extends PermanentNodeHookAdapter {
    public static final String PLUGIN_LABEL = "plugins/TimeManagementReminder.xml";
    private static final int CLOCK_INVISIBLE = 0;
    private static final int CLOCK_VISIBLE = 1;
    private static final int REMOVE_CLOCK = -1;
    private static final String REMINDUSERAT = "REMINDUSERAT";
    private long remindUserAt = 0L;
    private Timer timer;
    private static ImageIcon clockIcon = null;
    private static ImageIcon bellIcon;
    private static ImageIcon flagIcon;
    private final String STATE_TOOLTIP = TimerBlinkTask.class.getName() + "_STATE_";
    private String mStateTooltipName = null;

    @Override
    public void loadFrom(XMLElement child) {
        super.loadFrom(child);
        HashMap hash = this.loadNameValuePairs(child);
        if (hash.containsKey(REMINDUSERAT)) {
            String remindAt = (String)hash.get(REMINDUSERAT);
            this.setRemindUserAt(new Long(remindAt));
        }
    }

    @Override
    public void save(XMLElement xml) {
        super.save(xml);
        HashMap<String, Long> nameValuePairs = new HashMap<String, Long>();
        nameValuePairs.put(REMINDUSERAT, new Long(this.remindUserAt));
        this.saveNameValuePairs(nameValuePairs, xml);
    }

    @Override
    public void shutdownMapHook() {
        this.setToolTip(this.getNode(), this.getName(), null);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.displayState(-1, this.getNode(), true);
        super.shutdownMapHook();
    }

    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        if (this.remindUserAt == 0L) {
            return;
        }
        if (this.timer == null) {
            this.scheduleTimer(node);
        }
        this.logger.info("Invoke for node: " + node.getObjectId(this.getController()));
    }

    private void scheduleTimer(MindMapNode node) {
        this.scheduleTimer(node, new TimerBlinkTask(false));
    }

    private void scheduleTimer(MindMapNode node, TimerTask task) {
        this.timer = new Timer();
        Date date = new Date(this.remindUserAt);
        this.timer.schedule(task, date);
        Object[] messageArguments = new Object[]{date};
        MessageFormat formatter = new MessageFormat(this.getResourceString("plugins/TimeManagement.xml_reminderNode_tooltip"));
        String message = formatter.format(messageArguments);
        this.setToolTip(node, this.getName(), message);
        this.displayState(1, this.getNode(), false);
    }

    private ImageIcon getClockIcon() {
        if (clockIcon == null) {
            clockIcon = MindIcon.factory("clock2").getIcon();
        }
        return clockIcon;
    }

    private ImageIcon getBellIcon() {
        if (bellIcon == null) {
            bellIcon = MindIcon.factory("bell").getIcon();
        }
        return bellIcon;
    }

    private ImageIcon getFlagIcon() {
        if (flagIcon == null) {
            flagIcon = MindIcon.factory("flag").getIcon();
        }
        return flagIcon;
    }

    public void displayState(int stateAdded, MindMapNode pNode, boolean recurse) {
        ImageIcon icon = null;
        if (stateAdded == 1) {
            icon = this.getClockIcon();
        } else if (stateAdded == 0) {
            icon = pNode == this.getNode() ? this.getBellIcon() : this.getFlagIcon();
        }
        pNode.setStateIcon(this.getStateKey(), icon);
        this.nodeRefresh(pNode);
        if (recurse && !pNode.isRoot()) {
            this.displayState(stateAdded, pNode.getParentNode(), recurse);
        }
    }

    protected abstract void nodeRefresh(MindMapNode var1);

    protected abstract void setToolTip(MindMapNode var1, String var2, String var3);

    public long getRemindUserAt() {
        return this.remindUserAt;
    }

    public void setRemindUserAt(long remindUserAt) {
        this.remindUserAt = remindUserAt;
    }

    public String getStateKey() {
        if (this.mStateTooltipName == null) {
            this.mStateTooltipName = this.STATE_TOOLTIP;
        }
        return this.mStateTooltipName;
    }

    public class TimerBlinkTask
    extends TimerTask {
        private boolean stateAdded = false;

        public TimerBlinkTask(boolean stateAdded) {
            this.stateAdded = stateAdded;
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimerBlinkTask.this.stateAdded = !TimerBlinkTask.this.stateAdded;
                    ReminderHookBase.this.setRemindUserAt(System.currentTimeMillis() + 3000L);
                    ReminderHookBase.this.scheduleTimer(ReminderHookBase.this.getNode(), new TimerBlinkTask(TimerBlinkTask.this.stateAdded));
                    ReminderHookBase.this.displayState(TimerBlinkTask.this.stateAdded ? 1 : 0, ReminderHookBase.this.getNode(), true);
                }
            });
        }
    }

    protected class CheckReminder
    extends TimerTask {
        CheckReminder() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReminderHookBase.this.getController().centerNode(ReminderHookBase.this.getNode());
                    Object[] messageArguments = new Object[]{ReminderHookBase.this.getNode().getShortText(ReminderHookBase.this.getController())};
                    MessageFormat formatter = new MessageFormat(ReminderHookBase.this.getResourceString("plugins/TimeManagement.xml_reminderNode_showNode"));
                    String message = formatter.format(messageArguments);
                    int result = JOptionPane.showConfirmDialog(ReminderHookBase.this.getController().getFrame().getJFrame(), message, "Freemind", 0);
                    if (result == 0) {
                        ReminderHookBase.this.setRemindUserAt(System.currentTimeMillis() + 600000L);
                        ReminderHookBase.this.scheduleTimer(ReminderHookBase.this.getNode());
                        return;
                    }
                    ReminderHookBase.this.nodeChanged(ReminderHookBase.this.getNode());
                    ReminderHookBase.this.getNode().removeHook(ReminderHookBase.this);
                }
            });
        }
    }
}

