/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.collab.FileUpdateListener;

public class FileUpdateMonitor
extends Thread {
    final int WAIT = 4000;
    static int tmpNum = 0;
    int no = 0;
    HashMap<String, Entry> entries = new HashMap();
    boolean running;

    public FileUpdateMonitor() {
        this.setPriority(1);
    }

    public void run() {
        this.running = true;
        while (this.running) {
            Iterator<String> i = this.entries.keySet().iterator();
            while (i.hasNext()) {
                Entry e = this.entries.get(i.next());
                try {
                    if (!e.hasBeenUpdated()) continue;
                    e.notifyListener();
                }
                catch (IOException ex) {
                    e.notifyFileRemoved();
                }
            }
            try {
                FileUpdateMonitor.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopMonitoring() {
        this.running = false;
    }

    public String addUpdateListener(FileUpdateListener ul, File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File not found");
        }
        ++this.no;
        String key = "" + this.no;
        this.entries.put(key, new Entry(ul, file));
        return key;
    }

    public boolean hasBeenModified(String handle) throws IllegalArgumentException {
        Entry o = this.entries.get(handle);
        if (o == null) {
            return false;
        }
        try {
            return o.hasBeenUpdated();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void perturbTimestamp(String handle) {
        Entry o = this.entries.get(handle);
        if (o == null) {
            return;
        }
        --o.timeStamp;
    }

    public void removeUpdateListener(String handle) {
        this.entries.remove(handle);
    }

    public void updateTimeStamp(String key) throws IllegalArgumentException {
        Entry o = this.entries.get(key);
        if (o == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        Entry entry = o;
        entry.updateTimeStamp();
    }

    public void changeFile(String key, File file) throws IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new IOException("File not found");
        }
        Entry o = this.entries.get(key);
        if (o == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        o.file = file;
    }

    public File getTempFile(String key) throws IllegalArgumentException {
        Entry o = this.entries.get(key);
        if (o == null) {
            throw new IllegalArgumentException("Entry not found");
        }
        return o.tmpFile;
    }

    static synchronized File getTempFile() {
        File f = null;
        try {
            f = File.createTempFile("jabref", null);
            f.deleteOnExit();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return f;
    }

    class Entry {
        FileUpdateListener listener;
        File file;
        File tmpFile;
        long timeStamp;
        long fileSize;

        public Entry(FileUpdateListener ul, File f) {
            this.listener = ul;
            this.file = f;
            this.timeStamp = this.file.lastModified();
            this.fileSize = this.file.length();
            this.tmpFile = FileUpdateMonitor.getTempFile();
            this.tmpFile.deleteOnExit();
            this.copy();
        }

        public boolean hasBeenUpdated() throws IOException {
            long modified = this.file.lastModified();
            long fileSizeNow = this.file.length();
            if (modified == 0L) {
                throw new IOException("File deleted");
            }
            return this.timeStamp != modified || this.fileSize != fileSizeNow;
        }

        public void updateTimeStamp() {
            this.timeStamp = this.file.lastModified();
            if (this.timeStamp == 0L) {
                this.notifyFileRemoved();
            }
            this.fileSize = this.file.length();
            this.copy();
        }

        public boolean copy() {
            boolean res = false;
            try {
                res = Util.copyFile(this.file, this.tmpFile, true);
            }
            catch (IOException ex) {
                Globals.logger("Cannot copy to temporary file '" + this.tmpFile.getPath() + "'");
            }
            return res;
        }

        public void notifyListener() {
            this.timeStamp = this.file.lastModified();
            this.fileSize = this.file.length();
            this.listener.fileUpdated();
        }

        public void notifyFileRemoved() {
            this.listener.fileRemoved();
        }
    }
}

