/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileDialogs;

class CustomExportDialog
extends JDialog {
    JTextField name = new JTextField(60);
    JTextField layoutFile = new JTextField(60);
    JTextField extension = new JTextField(60);
    JLabel nl = new JLabel(Globals.lang("Export name") + ":");
    JLabel nr = new JLabel(Globals.lang("Main layout file") + ":");
    JLabel nf = new JLabel(Globals.lang("File extension") + ":");
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    JButton browse = new JButton(Globals.lang("Browse"));
    JPanel main = new JPanel();
    JPanel buttons = new JPanel();
    private boolean ok_pressed = false;
    private int index;
    private JabRefFrame parent;
    private String oldName;
    private String oldRegexp;
    private String oldField;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();

    public CustomExportDialog(JabRefFrame parent_, String name_, String layoutFile_, String extension_) {
        this(parent_);
        this.name.setText(name_);
        this.layoutFile.setText(layoutFile_);
        this.extension.setText(extension_);
    }

    public CustomExportDialog(JabRefFrame parent_) {
        super(parent_, Globals.lang("Edit custom export"), true);
        this.parent = parent_;
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (CustomExportDialog.this.layoutFile.getText().equals("") || CustomExportDialog.this.name.getText().equals("") || CustomExportDialog.this.extension.getText().equals("") || !CustomExportDialog.this.layoutFile.getText().endsWith(".layout")) {
                    return;
                }
                CustomExportDialog.this.ok_pressed = true;
                CustomExportDialog.this.dispose();
            }
        };
        this.ok.addActionListener(okListener);
        this.name.addActionListener(okListener);
        this.layoutFile.addActionListener(okListener);
        this.extension.addActionListener(okListener);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                CustomExportDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File directory = new File(Globals.prefs.get("exportWorkingDirectory"));
                String chosenStr = FileDialogs.getNewFile(CustomExportDialog.this.parent, directory, ".layout", 0, false);
                if (chosenStr == null) {
                    return;
                }
                File chosen = new File(chosenStr);
                Globals.prefs.put("exportWorkingDirectory", chosen.getParent());
                CustomExportDialog.this.layoutFile.setText(chosen.getPath());
            }
        });
        ActionMap am = this.main.getActionMap();
        InputMap im = this.main.getInputMap(2);
        im.put(this.parent.prefs().getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        this.main.setLayout(this.gbl);
        this.main.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Export properties")));
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(3, 5, 3, 5);
        this.con.anchor = 13;
        this.con.fill = 0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.nl, this.con);
        this.main.add(this.nl);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.nr, this.con);
        this.main.add(this.nr);
        this.con.gridy = 2;
        this.gbl.setConstraints(this.nf, this.con);
        this.main.add(this.nf);
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.anchor = 17;
        this.con.fill = 2;
        this.con.gridy = 0;
        this.con.gridx = 1;
        this.gbl.setConstraints(this.name, this.con);
        this.main.add(this.name);
        this.con.gridy = 1;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.layoutFile, this.con);
        this.main.add(this.layoutFile);
        this.con.gridx = 2;
        this.con.weightx = 0.0;
        this.gbl.setConstraints(this.browse, this.con);
        this.main.add(this.browse);
        this.con.weightx = 1.0;
        this.con.gridwidth = 2;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.gbl.setConstraints(this.extension, this.con);
        this.main.add(this.extension);
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        this.getContentPane().add((Component)this.main, "Center");
        this.getContentPane().add((Component)this.buttons, "South");
        this.setSize(600, 170);
        Util.placeDialog(this, this.parent);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public int index() {
        return this.index;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldName() {
        return this.oldName;
    }

    public String oldRegexp() {
        return this.oldRegexp;
    }

    public String layoutFile() {
        return this.layoutFile.getText();
    }

    public String name() {
        return this.name.getText();
    }

    public String extension() {
        String ext = this.extension.getText();
        if (ext.startsWith(".")) {
            return ext;
        }
        if (ext.startsWith("*.")) {
            return ext.substring(1);
        }
        return "." + ext;
    }
}

