/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.util.Vector;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.FieldFormatter;

public class LatexFieldFormatter
implements FieldFormatter {
    StringBuffer sb;
    int col;
    final int STARTCOL = 4;
    private boolean neverFailOnHashes = false;

    public void setNeverFailOnHashes(boolean neverFailOnHashes) {
        this.neverFailOnHashes = neverFailOnHashes;
    }

    public String format(String text, String fieldName) throws IllegalArgumentException {
        if (Globals.prefs.putBracesAroundCapitals(fieldName) && !"__string".equals(fieldName)) {
            text = Util.putBracesAroundCapitals(text);
        }
        boolean resolveStrings = true;
        if (Globals.prefs.getBoolean("resolveStringsAllFields")) {
            String[] exceptions = Globals.prefs.getStringArray("doNotResolveStringsFor");
            for (int i = 0; i < exceptions.length; ++i) {
                if (!exceptions[i].equals(fieldName)) continue;
                resolveStrings = false;
                break;
            }
        } else {
            boolean bl = resolveStrings = BibtexFields.isStandardField(fieldName) || "__string".equals(fieldName);
        }
        if (!resolveStrings) {
            int brc = 0;
            boolean ok = true;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '{') {
                    ++brc;
                }
                if (c == '}') {
                    --brc;
                }
                if (brc >= 0) continue;
                ok = false;
                break;
            }
            if (brc > 0) {
                ok = false;
            }
            if (!ok) {
                throw new IllegalArgumentException("Curly braces { and } must be balanced.");
            }
            this.sb = new StringBuffer("{");
            if (!Globals.prefs.isNonWrappableField(fieldName)) {
                this.sb.append(Util.wrap2(text, 65));
            } else {
                this.sb.append(text);
            }
            this.sb.append('}');
            return this.sb.toString();
        }
        this.sb = new StringBuffer();
        int pivot = 0;
        this.col = 4;
        this.checkBraces(text);
        while (pivot < text.length()) {
            int pos2;
            int goFrom = pivot;
            int pos1 = pivot;
            while (goFrom == pos1) {
                pos1 = text.indexOf(35, goFrom);
                if (pos1 > 0 && text.charAt(pos1 - 1) == '\\') {
                    goFrom = pos1 + 1;
                    ++pos1;
                    continue;
                }
                goFrom = pos1 - 1;
            }
            if (pos1 == -1) {
                pos1 = text.length();
                pos2 = -1;
            } else {
                pos2 = text.indexOf(35, pos1 + 1);
                if (pos2 == -1) {
                    if (!this.neverFailOnHashes) {
                        throw new IllegalArgumentException(Globals.lang("The # character is not allowed in BibTeX fields") + ".\n" + Globals.lang("In JabRef, use pairs of # characters to indicate a string.") + "\n" + Globals.lang("Note that the entry causing the problem has been selected."));
                    }
                    pos1 = text.length();
                }
            }
            if (pos1 > pivot) {
                this.writeText(text, pivot, pos1);
            }
            if (pos1 < text.length() && pos2 - 1 > pos1) {
                this.writeStringLabel(text, pos1 + 1, pos2, pos1 == pivot, pos2 + 1 == text.length());
            }
            if (pos2 > -1) {
                pivot = pos2 + 1;
                continue;
            }
            pivot = pos1 + 1;
        }
        if (!Globals.prefs.isNonWrappableField(fieldName)) {
            return Util.wrap2(this.sb.toString(), 65);
        }
        return this.sb.toString();
    }

    private void writeText(String text, int start_pos, int end_pos) {
        this.sb.append('{');
        boolean escape = false;
        boolean inCommandName = false;
        boolean inCommand = false;
        boolean inCommandOption = false;
        int nestedEnvironments = 0;
        StringBuffer commandName = new StringBuffer();
        for (int i = start_pos; i < end_pos; ++i) {
            char c = text.charAt(i);
            if (Character.isLetter(c) && (escape || inCommandName)) {
                inCommandName = true;
                if (!inCommandOption) {
                    commandName.append(c);
                }
            } else if ((!Character.isWhitespace(c) || !inCommand && !inCommandOption) && inCommandName) {
                if (c == '[') {
                    inCommandOption = true;
                } else if (inCommandOption && c == ']') {
                    inCommandOption = false;
                } else if (!inCommandOption && c == '{') {
                    inCommandName = false;
                    inCommand = true;
                } else {
                    commandName.delete(0, commandName.length());
                    inCommandName = false;
                }
            }
            if (inCommand && c == '}') {
                if (commandName.toString().equals("begin")) {
                    ++nestedEnvironments;
                }
                if (nestedEnvironments > 0 && commandName.toString().equals("end")) {
                    --nestedEnvironments;
                }
                commandName.delete(0, commandName.length());
                inCommand = false;
            }
            if (!(c != '&' || escape || inCommand && commandName.toString().equals("url") || nestedEnvironments != 0)) {
                this.sb.append("\\&");
            } else {
                this.sb.append(c);
            }
            escape = c == '\\';
        }
        this.sb.append('}');
    }

    private void writeStringLabel(String text, int start_pos, int end_pos, boolean first, boolean last) {
        this.putIn((first ? "" : " # ") + text.substring(start_pos, end_pos) + (last ? "" : " # "));
    }

    private void putIn(String s) {
        this.sb.append(Util.wrap2(s, 65));
    }

    private void checkBraces(String text) throws IllegalArgumentException {
        Vector<Integer> left = new Vector<Integer>(5, 3);
        Vector<Integer> right = new Vector<Integer>(5, 3);
        int current = -1;
        while ((current = text.indexOf(123, current + 1)) != -1) {
            left.add(new Integer(current));
        }
        while ((current = text.indexOf(125, current + 1)) != -1) {
            right.add(new Integer(current));
        }
        if (right.size() > 0 && left.size() == 0) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (right.size() > 0 && (Integer)right.elementAt(0) < (Integer)left.elementAt(0)) {
            throw new IllegalArgumentException("'}' character ends string prematurely.");
        }
        if (left.size() != right.size()) {
            throw new IllegalArgumentException("Braces don't match.");
        }
    }
}

