/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryComparator;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileMenuItem;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.gui.IconComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsDialog {
    private JabRefFrame frame;
    private JDialog diag;
    private String[] fields = new String[]{"author", "title", "year", "journal"};
    protected final int FILE_COL = 0;
    protected final int URL_COL = 1;
    protected final int PAD = 2;
    private JLabel fileLabel = new JLabel(GUIGlobals.getImage("psSmall"));
    private JLabel urlLabel = new JLabel(GUIGlobals.getImage("wwwSmall"));
    protected Rectangle toRect = new Rectangle(0, 0, 1, 1);
    private EventTableModel<BibtexEntry> model;
    private EventList<BibtexEntry> entries = new BasicEventList<BibtexEntry>();
    private SortedList<BibtexEntry> sortedEntries;
    private HashMap<BibtexEntry, BasePanel> entryHome = new HashMap();
    private JTable entryTable;
    protected UIFSplitPane contentPane = new UIFSplitPane(0);
    PreviewPanel preview;

    public SearchResultsDialog(JabRefFrame frame, String title) {
        this.frame = frame;
        this.init(title);
    }

    private void init(String title) {
        this.diag = new JDialog(this.frame, title, false);
        int activePreview = Globals.prefs.getInt("activePreview");
        this.preview = new PreviewPanel(null, new MetaData(), activePreview == 0 ? Globals.prefs.get("preview0") : Globals.prefs.get("preview1"));
        this.sortedEntries = new SortedList<BibtexEntry>(this.entries, new EntryComparator(false, true, "author"));
        this.model = new EventTableModel<BibtexEntry>(this.sortedEntries, new EntryTableFormat());
        this.entryTable = new JTable(this.model);
        GeneralRenderer renderer = new GeneralRenderer(Color.white);
        this.entryTable.setDefaultRenderer(JLabel.class, renderer);
        this.entryTable.setDefaultRenderer(String.class, renderer);
        this.setWidths();
        TableComparatorChooser<BibtexEntry> tableSorter = new TableComparatorChooser<BibtexEntry>(this.entryTable, this.sortedEntries, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        this.setupComparatorChooser(tableSorter);
        JScrollPane sp = new JScrollPane(this.entryTable);
        EventSelectionModel<BibtexEntry> selectionModel = new EventSelectionModel<BibtexEntry>(this.sortedEntries);
        this.entryTable.setSelectionModel(selectionModel);
        selectionModel.getSelected().addListEventListener(new EntrySelectionListener());
        this.entryTable.addMouseListener(new TableClickListener());
        this.contentPane.setTopComponent(sp);
        this.contentPane.setBottomComponent(this.preview);
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchResultsDialog.this.diag.dispose();
            }
        };
        ActionMap am = this.contentPane.getActionMap();
        InputMap im = this.contentPane.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
        this.diag.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                SearchResultsDialog.this.contentPane.setDividerLocation(0.5);
            }

            public void windowClosing(WindowEvent event) {
                Globals.prefs.putInt("searchDialogWidth", ((SearchResultsDialog)SearchResultsDialog.this).diag.getSize().width);
                Globals.prefs.putInt("searchDialogHeight", ((SearchResultsDialog)SearchResultsDialog.this).diag.getSize().height);
            }
        });
        this.diag.getContentPane().add((Component)this.contentPane, "Center");
        this.diag.setSize(new Dimension(Globals.prefs.getInt("searchDialogWidth"), Globals.prefs.getInt("searchDialogHeight")));
        this.diag.setLocationRelativeTo(this.frame);
    }

    public void setVisible(boolean visible) {
        this.diag.setVisible(visible);
    }

    public void selectFirstEntry() {
        if (this.entryTable.getRowCount() > 0) {
            this.entryTable.setRowSelectionInterval(0, 0);
        } else {
            this.contentPane.setDividerLocation(1.0);
        }
    }

    public synchronized void clear() {
        this.entries.clear();
        this.entryHome.clear();
    }

    protected void setupComparatorChooser(TableComparatorChooser<BibtexEntry> comparatorChooser) {
        int i;
        List comparators = comparatorChooser.getComparatorsForColumn(0);
        comparators.clear();
        comparators = comparatorChooser.getComparatorsForColumn(1);
        comparators.clear();
        for (i = 2; i < 2; ++i) {
            comparators = comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            if (i == 0) {
                comparators.add(new IconComparator(new String[]{"file"}));
                continue;
            }
            if (i != 1) continue;
            comparators.add(new IconComparator(new String[]{"url"}));
        }
        for (i = 2; i < 2 + this.fields.length; ++i) {
            comparators = comparatorChooser.getComparatorsForColumn(i);
            comparators.clear();
            comparators.add(new FieldComparator(this.fields[i - 2]));
        }
        this.sortedEntries.getReadWriteLock().writeLock().lock();
        comparatorChooser.appendComparator(2, 0, false);
        this.sortedEntries.getReadWriteLock().writeLock().unlock();
    }

    protected void setWidths() {
        int i;
        TableColumnModel cm = this.entryTable.getColumnModel();
        for (i = 0; i < 2; ++i) {
            cm.getColumn(i).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
            cm.getColumn(i).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (i = 0; i < this.fields.length; ++i) {
            int width = BibtexFields.getFieldLength(this.fields[i]);
            cm.getColumn(i + 2).setPreferredWidth(width);
        }
    }

    public synchronized void addEntries(List<BibtexEntry> newEntries, BasePanel panel) {
        for (BibtexEntry entry : newEntries) {
            this.entries.add(entry);
            this.entryHome.put(entry, panel);
        }
    }

    public synchronized void addEntry(BibtexEntry entry, BasePanel panel) {
        this.entries.add(entry);
        this.entryHome.put(entry, panel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryTableFormat
    implements AdvancedTableFormat<BibtexEntry> {
        @Override
        public int getColumnCount() {
            return 2 + SearchResultsDialog.this.fields.length;
        }

        @Override
        public String getColumnName(int column) {
            if (column >= 2) {
                return Util.nCase(SearchResultsDialog.this.fields[column - 2]);
            }
            return "";
        }

        @Override
        public Object getColumnValue(BibtexEntry entry, int column) {
            if (column < 2) {
                switch (column) {
                    case 0: {
                        String o = entry.getField("file");
                        if (o != null) {
                            FileListTableModel model = new FileListTableModel();
                            model.setContent(o);
                            SearchResultsDialog.this.fileLabel.setToolTipText(model.getToolTipHTMLRepresentation());
                            if (model.getRowCount() > 0) {
                                SearchResultsDialog.this.fileLabel.setIcon(model.getEntry(0).getType().getIcon());
                            }
                            return SearchResultsDialog.this.fileLabel;
                        }
                        return null;
                    }
                    case 1: {
                        String o = entry.getField("url");
                        if (o != null) {
                            SearchResultsDialog.this.urlLabel.setToolTipText(o);
                            return SearchResultsDialog.this.urlLabel;
                        }
                        return null;
                    }
                }
                return null;
            }
            String field = SearchResultsDialog.this.fields[column - 2];
            if ((field.equals("author") || field.equals("editor")) && SearchResultsDialog.this.frame.basePanel() != null) {
                return ((SearchResultsDialog)SearchResultsDialog.this).frame.basePanel().tableFormat.formatName(entry.getField(field));
            }
            return entry.getField(field);
        }

        @Override
        public Class<?> getColumnClass(int i) {
            if (i < 2) {
                return JLabel.class;
            }
            return String.class;
        }

        @Override
        public Comparator<?> getColumnComparator(int i) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySelectionListener
    implements ListEventListener<BibtexEntry> {
        EntrySelectionListener() {
        }

        @Override
        public void listChanged(ListEvent<BibtexEntry> listEvent) {
            if (listEvent.getSourceList().size() == 1) {
                BibtexEntry entry = (BibtexEntry)listEvent.getSourceList().get(0);
                BasePanel p = (BasePanel)SearchResultsDialog.this.entryHome.get(entry);
                SearchResultsDialog.this.preview.setMetaData(p.metaData());
                SearchResultsDialog.this.preview.setEntry(entry);
                SearchResultsDialog.this.contentPane.setDividerLocation(0.5);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchResultsDialog.this.preview.scrollRectToVisible(SearchResultsDialog.this.toRect);
                    }
                });
            }
        }
    }

    class TableClickListener
    extends MouseAdapter {
        TableClickListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
                return;
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
                return;
            }
            int row = SearchResultsDialog.this.entryTable.rowAtPoint(e.getPoint());
            if (e.getClickCount() == 2) {
                BibtexEntry toShow = (BibtexEntry)SearchResultsDialog.this.model.getElementAt(row);
                BasePanel p = (BasePanel)SearchResultsDialog.this.entryHome.get(toShow);
                SearchResultsDialog.this.frame.showBasePanel(p);
                p.highlightEntry(toShow);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.processPopupTrigger(e);
                return;
            }
            int col = SearchResultsDialog.this.entryTable.columnAtPoint(e.getPoint());
            int row = SearchResultsDialog.this.entryTable.rowAtPoint(e.getPoint());
            if (col < 2) {
                BibtexEntry entry = (BibtexEntry)SearchResultsDialog.this.sortedEntries.get(row);
                BasePanel p = (BasePanel)SearchResultsDialog.this.entryHome.get(entry);
                switch (col) {
                    case 0: {
                        String o = entry.getField("file");
                        if (o == null) break;
                        FileListTableModel tableModel = new FileListTableModel();
                        tableModel.setContent(o);
                        if (tableModel.getRowCount() == 0) {
                            return;
                        }
                        FileListEntry fl = tableModel.getEntry(0);
                        new ExternalFileMenuItem(SearchResultsDialog.this.frame, entry, "", fl.getLink(), null, p.metaData(), fl.getType()).actionPerformed(null);
                        break;
                    }
                    case 1: {
                        String link = entry.getField("url");
                        try {
                            if (link == null) break;
                            Util.openExternalViewer(p.metaData(), link, "url");
                            break;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }

        public void processPopupTrigger(MouseEvent e) {
            BibtexEntry entry = (BibtexEntry)SearchResultsDialog.this.sortedEntries.get(SearchResultsDialog.this.entryTable.rowAtPoint(e.getPoint()));
            BasePanel p = (BasePanel)SearchResultsDialog.this.entryHome.get(entry);
            int col = SearchResultsDialog.this.entryTable.columnAtPoint(e.getPoint());
            JPopupMenu menu = new JPopupMenu();
            int count = 0;
            if (col == 0) {
                String o = entry.getField("file");
                FileListTableModel fileList = new FileListTableModel();
                fileList.setContent(o);
                for (int i = 0; i < fileList.getRowCount(); ++i) {
                    FileListEntry flEntry = fileList.getEntry(i);
                    String description = flEntry.getDescription();
                    if (description == null || description.trim().length() == 0) {
                        description = flEntry.getLink();
                    }
                    menu.add(new ExternalFileMenuItem(p.frame(), entry, description, flEntry.getLink(), (Icon)flEntry.getType().getIcon(), p.metaData(), flEntry.getType()));
                    ++count;
                }
            }
            if (count > 0) {
                menu.show(SearchResultsDialog.this.entryTable, e.getX(), e.getY());
            }
        }
    }
}

