/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiteSeerCitationHandler
extends DefaultHandler {
    protected boolean correctDirection;
    protected boolean getCitation;
    protected Map<String, Boolean> citationList;

    public CiteSeerCitationHandler(Map<String, Boolean> citationHashTable) {
        this.citationList = citationHashTable;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.getCitation) {
            String target = new String(ch, start, length);
            if (this.citationList.get(target) == null) {
                this.citationList.put(target, Boolean.TRUE);
            }
            this.getCitation = false;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.correctDirection = false;
        this.getCitation = false;
    }

    @Override
    public void startElement(String name, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("oai_citeseer:relation")) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (attrName.equals("type") && attrValue.equals("Is Referenced By")) {
                    this.correctDirection = true;
                    continue;
                }
                if (!attrName.equals("type") || !attrValue.equals("References")) continue;
                this.correctDirection = false;
            }
        } else if (qName.equals("oai_citeseer:uri") && this.correctDirection) {
            this.getCitation = true;
        }
    }
}

