/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.export.layout.LayoutFormatter;

public class HTMLConverter
implements LayoutFormatter {
    private HashMap<String, String> escapedSymbols = new HashMap();
    private final int MAX_TAG_LENGTH = 30;

    public HTMLConverter() {
        this.escapedSymbols.put("&ldquo;", "``");
        this.escapedSymbols.put("&rdquo;", "''");
        this.escapedSymbols.put("&lsquo;", "``");
        this.escapedSymbols.put("&rsquo;", "''");
        this.escapedSymbols.put("&nbsp;", " ");
        this.escapedSymbols.put("&quot;", "\"");
        this.escapedSymbols.put("&amp;", "&");
        this.escapedSymbols.put("&lt;", "<");
        this.escapedSymbols.put("&gt;", ">");
    }

    public String format(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                i = this.readTag(text, sb, i);
                continue;
            }
            sb.append(c);
        }
        text = sb.toString();
        Set<String> patterns = this.escapedSymbols.keySet();
        for (String pattern : patterns) {
            text = text.replaceAll(pattern, this.escapedSymbols.get(pattern));
        }
        Pattern escapedPattern = Pattern.compile("&#([x]*\\d+);");
        Matcher m = escapedPattern.matcher(text);
        block12: while (m.find()) {
            int num = Integer.decode(m.group(1).replace("x", "#"));
            switch (num) {
                case 37: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "%");
                    continue block12;
                }
                case 38: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "&");
                    continue block12;
                }
                case 916: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "$\\delta$");
                    continue block12;
                }
                case 956: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "$\\mu$");
                    continue block12;
                }
                case 8208: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "-");
                    continue block12;
                }
                case 8211: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "--");
                    continue block12;
                }
                case 8212: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "---");
                    continue block12;
                }
                case 8217: {
                    text = text.replaceAll("&#" + m.group(1) + ";", "'");
                    continue block12;
                }
            }
            System.err.println("HTML escaped char not converted " + m.group(1) + ": " + Integer.toString(num));
        }
        return text.trim();
    }

    private int readTag(String text, StringBuffer sb, int position) {
        int index = text.indexOf(62, position);
        if (index > position && index - position < 30) {
            return index;
        }
        return position;
    }
}

