/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.imports.CustomImportList;
import net.sf.jabref.imports.ImportCustomizationDialog;
import net.sf.jabref.imports.ImportFormat;

class ZipFileChooser
extends JDialog {
    private JButton okButton = new JButton(Globals.lang("Ok"));
    private JButton cancelButton = new JButton(Globals.lang("Cancel"));
    private JTable table;
    private JabRefPreferences prefs = Globals.prefs;
    private ZipFileChooser zipFileChooser;
    private ImportCustomizationDialog importCustomizationDialog;

    public Dimension getSize() {
        return new Dimension(400, 300);
    }

    private ZipEntry[] getSelectableZipEntries(ZipFile zipFile) {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            entries.add(entry);
        }
        return entries.toArray(new ZipEntry[0]);
    }

    public ZipFileChooser(ImportCustomizationDialog owner, ZipFile zipFile) throws HeadlessException {
        super(owner, Globals.lang("Select file from ZIP-archive"), false);
        this.importCustomizationDialog = owner;
        this.zipFileChooser = this;
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZipFileChooser.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = ZipFileChooser.this.table.getSelectedRow();
                if (row != -1) {
                    ZipFileChooserTableModel model = (ZipFileChooserTableModel)ZipFileChooser.this.table.getModel();
                    ZipEntry tempZipEntry = model.getZipEntry(row);
                    CustomImportList.Importer importer = ((ZipFileChooser)ZipFileChooser.this).prefs.customImports.new CustomImportList.Importer();
                    importer.setBasePath(model.getZipFile().getName());
                    String className = tempZipEntry.getName().substring(0, tempZipEntry.getName().lastIndexOf(46));
                    importer.setClassName(className);
                    try {
                        ImportFormat importFormat = importer.getInstance();
                        importer.setName(importFormat.getFormatName());
                        importer.setCliId(importFormat.getCLIId());
                        ZipFileChooser.this.importCustomizationDialog.addOrReplaceImporter(importer);
                        ZipFileChooser.this.dispose();
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                        JOptionPane.showMessageDialog(ZipFileChooser.this.zipFileChooser, Globals.lang("Could not instantiate %0 %1", importer.getName() + ":\n", exc.getMessage()));
                    }
                } else {
                    JOptionPane.showMessageDialog(ZipFileChooser.this.zipFileChooser, Globals.lang("Please select an importer."));
                }
            }
        });
        ZipFileChooserTableModel tableModel = new ZipFileChooserTableModel(zipFile, this.getSelectableZipEntries(zipFile));
        this.table = new JTable(tableModel);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(200);
        cm.getColumn(1).setPreferredWidth(150);
        cm.getColumn(2).setPreferredWidth(100);
        JScrollPane sp = new JScrollPane(this.table, 20, 31);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 150));
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)sp, "Center");
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.okButton);
        optionsPanel.add(this.cancelButton);
        optionsPanel.add(Box.createHorizontalStrut(5));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)optionsPanel, "South");
        this.setSize(this.getSize());
        this.pack();
        Util.placeDialog(this, owner);
        new FocusRequester(this.table);
    }

    class ZipFileChooserTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{Globals.lang("Name"), Globals.lang("Last modified"), Globals.lang("Size")};
        private ZipEntry[] rows = null;
        private ZipFile zipFile = null;

        ZipFileChooserTableModel(ZipFile zipFile, ZipEntry[] rows) {
            this.rows = rows;
            this.zipFile = zipFile;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.rows.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public ZipEntry getZipEntry(int rowIndex) {
            return this.rows[rowIndex];
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            ZipEntry entry = this.getZipEntry(rowIndex);
            if (columnIndex == 0) {
                value = entry.getName();
            } else if (columnIndex == 1) {
                value = SimpleDateFormat.getDateTimeInstance().format(new Date(entry.getTime()));
            } else if (columnIndex == 2) {
                value = new Long(entry.getSize());
            }
            return value;
        }
    }
}

