/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.label;

import java.util.StringTokenizer;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.label.DefaultLabelRule;
import net.sf.jabref.label.KeyWord;

public class InproceedingsLabelRule
extends DefaultLabelRule {
    public String applyRule(BibtexEntry oldEntry) {
        String newLabel = "";
        StringTokenizer authorTokens = null;
        try {
            authorTokens = new StringTokenizer(oldEntry.getField("author"), ",");
            newLabel = newLabel + authorTokens.nextToken().toLowerCase().replaceAll(" ", "").replaceAll("\\.", "");
        }
        catch (Throwable t) {
            System.out.println("error getting author: " + t);
        }
        try {
            if (oldEntry.getField("year") != null) {
                newLabel = newLabel + String.valueOf(oldEntry.getField("year"));
            }
        }
        catch (Throwable t) {
            System.out.println("error getting year: " + t);
        }
        try {
            if (oldEntry.getField("booktitle") != null) {
                authorTokens = new StringTokenizer(oldEntry.getField("booktitle").replaceAll(",", " ").replaceAll("/", " "));
                String tempString = authorTokens.nextToken();
                tempString = tempString.replaceAll(",", "");
                boolean done = false;
                while (tempString != null && !done) {
                    if ((tempString = tempString.replaceAll(",", "").trim()).trim().length() > 3 && !KeyWord.getKeyWord().isKeyWord(tempString)) {
                        done = true;
                        continue;
                    }
                    if (authorTokens.hasMoreTokens()) {
                        tempString = authorTokens.nextToken();
                        continue;
                    }
                    done = true;
                }
                if (tempString != null && tempString.indexOf("null") < 0) {
                    newLabel = newLabel + String.valueOf(tempString.toLowerCase());
                }
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        return newLabel;
    }
}

