/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveDuplicateLabelDialog {
    JDialog diag;
    JButton ok = new JButton(Globals.lang("Ok"));
    JButton cancel = new JButton(Globals.lang("Cancel"));
    List<JCheckBox> cbs = new ArrayList<JCheckBox>();
    private boolean okPressed = false;
    static final String layout = "<font face=\"arial\"><b><i>\\bibtextype</i><a name=\"\\bibtexkey\">\\begin{bibtexkey} (\\bibtexkey)</a>\\end{bibtexkey}</b><br>\n\\begin{author} \\format[HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\author}<BR>\\end{author}\n\\begin{editor} \\format[HTMLChars,AuthorAbbreviator,AuthorAndsReplacer]{\\editor} <i>(\\format[IfPlural(Eds.,Ed.)]{\\editor})</i><BR>\\end{editor}\n\\begin{title} \\format[HTMLChars]{\\title} \\end{title}<BR>\n\\begin{chapter} \\format[HTMLChars]{\\chapter}<BR>\\end{chapter}\n\\begin{journal} <em>\\format[HTMLChars]{\\journal}, </em>\\end{journal}\n\\begin{booktitle} <em>\\format[HTMLChars]{\\booktitle}, </em>\\end{booktitle}\n\\begin{school} <em>\\format[HTMLChars]{\\school}, </em>\\end{school}\n\\begin{institution} <em>\\format[HTMLChars]{\\institution}, </em>\\end{institution}\n\\begin{publisher} <em>\\format[HTMLChars]{\\publisher}, </em>\\end{publisher}\n\\begin{year}<b>\\year</b>\\end{year}\\begin{volume}<i>, \\volume</i>\\end{volume}\\begin{pages}, \\format[FormatPagesForHTML]{\\pages} \\end{pages}\n<p></p></font>";

    public ResolveDuplicateLabelDialog(BasePanel panel, String key, List<BibtexEntry> entries) {
        this.diag = new JDialog(panel.frame(), Globals.lang("Duplicate BibTeX key"), true);
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
        b.append((Component)new JLabel(Globals.lang("Duplicate key") + ": " + key), 3);
        b.nextLine();
        b.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        boolean first = true;
        for (BibtexEntry entry : entries) {
            JCheckBox cb = new JCheckBox(Globals.lang("Generate key"), !first);
            b.append(cb);
            PreviewPanel pp = new PreviewPanel(null, entry, null, new MetaData(), layout);
            pp.setPreferredSize(new Dimension(800, 90));
            b.append(new JScrollPane(pp));
            b.nextLine();
            this.cbs.add(cb);
            first = false;
        }
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.ok);
        bb.addGridded(this.cancel);
        bb.addGlue();
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)b.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolveDuplicateLabelDialog.this.okPressed = true;
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ResolveDuplicateLabelDialog.this.diag.dispose();
            }
        };
        ActionMap am = b.getPanel().getActionMap();
        InputMap im = b.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public List<JCheckBox> getCheckBoxes() {
        return this.cbs;
    }

    public void show() {
        this.okPressed = false;
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }
}

