/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestSemanticPredicateEvaluation
extends BaseTest {
    public void testSimpleCyclicDFAWithPredicate() throws Exception {
        String grammar = "grammar foo;\na : {false}? 'x'* 'y' {System.out.println(\"alt1\");}\n  | {true}?  'x'* 'y' {System.out.println(\"alt2\");}\n  ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "xxxy", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"alt2\n", (String)found);
    }

    public void testSimpleCyclicDFAWithInstanceVarPredicate() throws Exception {
        String grammar = "grammar foo;\n@members {boolean v=true;}\na : {false}? 'x'* 'y' {System.out.println(\"alt1\");}\n  | {v}?     'x'* 'y' {System.out.println(\"alt2\");}\n  ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "xxxy", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"alt2\n", (String)found);
    }

    public void testPredicateValidation() throws Exception {
        String grammar = "grammar foo;\n@members {\npublic void reportError(RecognitionException e) {\n    System.out.println(\"error: \"+e.toString());\n}\n}\n\na : {false}? 'x'\n  ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "x", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"error: FailedPredicateException(a,{false}?)\n", (String)found);
    }

    public void testLexerPreds() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? 'a'  {System.out.println(\"token 1\");} ;\nB : {!p}? 'a' {System.out.println(\"token 2\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "a", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"token 2\n", (String)found);
    }

    public void testLexerPreds2() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : {p}? 'a' {System.out.println(\"token 1\");} ;\nB : ('a'|'b')+ {System.out.println(\"token 2\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "a", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"token 1\n", (String)found);
    }

    public void testLexerPredInExitBranch() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ('a' {System.out.print(\"1\");})*\n    {p}?\n    ('a' {System.out.print(\"2\");})* ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aaa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"222\n", (String)found);
    }

    public void testLexerPredInExitBranch2() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ({p}? 'a' {System.out.print(\"1\");})*\n    ('a' {System.out.print(\"2\");})* ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aaa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"111\n", (String)found);
    }

    public void testLexerPredInExitBranch3() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=true;}\na : (A|B)+ ;\nA : ({p}? 'a' {System.out.print(\"1\");} | )\n    ('a' {System.out.print(\"2\");})* ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aaa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"122\n", (String)found);
    }

    public void testLexerPredInExitBranch4() throws Exception {
        String grammar = "grammar foo;a : (A|B)+ ;\nA @init {int n=0;} : ({n<2}? 'a' {System.out.print(n++);})+\n    ('a' {System.out.print(\"x\");})* ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aaaaa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"01xxx\n", (String)found);
    }

    public void testLexerPredsInCyclicDFA() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? ('a')+ 'x'  {System.out.println(\"token 1\");} ;\nB :      ('a')+ 'x' {System.out.println(\"token 2\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aax", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"token 2\n", (String)found);
    }

    public void testLexerPredsInCyclicDFA2() throws Exception {
        String grammar = "grammar foo;@lexer::members {boolean p=false;}\na : (A|B)+ ;\nA : {p}? ('a')+ 'x' ('y')? {System.out.println(\"token 1\");} ;\nB :      ('a')+ 'x' {System.out.println(\"token 2\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aax", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"token 2\n", (String)found);
    }

    public void testGatedPred() throws Exception {
        String grammar = "grammar foo;a : (A|B)+ ;\nA : {true}?=> 'a' {System.out.println(\"token 1\");} ;\nB : {false}?=>('a'|'b')+ {System.out.println(\"token 2\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"token 1\ntoken 1\n", (String)found);
    }

    public void testGatedPred2() throws Exception {
        String grammar = "grammar foo;\n@lexer::members {boolean sig=false;}\na : (A|B)+ ;\nA : 'a' {System.out.print(\"A\"); sig=true;} ;\nB : 'b' ;\nC : {sig}?=> ('a'|'b') {System.out.print(\"C\");} ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"AC\n", (String)found);
    }

    public void testPredWithActionTranslation() throws Exception {
        String grammar = "grammar foo;\na : b[2] ;\nb[int i]\n  : {$i==1}?   'a' {System.out.println(\"alt 1\");}\n  | {$b.i==2}? 'a' {System.out.println(\"alt 2\");}\n  ;\n";
        String found = this.execParser("foo.g", grammar, "fooParser", "fooLexer", "a", "aa", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"alt 2\n", (String)found);
    }

    public void _test() throws Exception {
        String grammar = "grammar T;\noptions {output=AST;}\na :  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String found = this.execParser("t.g", grammar, "T", "TLexer", "a", "abc 34", false);
        TestSemanticPredicateEvaluation.assertEquals((String)"\n", (String)found);
    }
}

