/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfviewer.ArrayEntry;
import org.pdfbox.pdfviewer.MapEntry;

public class PDFTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object nodeValue, boolean isSelected, boolean expanded, boolean leaf, int row, boolean componentHasFocus) {
        nodeValue = this.convertToTreeObject(nodeValue);
        return super.getTreeCellRendererComponent(tree, nodeValue, isSelected, expanded, leaf, row, componentHasFocus);
    }

    private Object convertToTreeObject(Object nodeValue) {
        if (nodeValue instanceof MapEntry) {
            MapEntry entry = (MapEntry)nodeValue;
            COSName key = (COSName)entry.getKey();
            COSBase value = (COSBase)entry.getValue();
            nodeValue = key.getName() + ":" + this.convertToTreeObject(value);
        } else if (nodeValue instanceof COSFloat) {
            nodeValue = "" + ((COSFloat)nodeValue).floatValue();
        } else if (nodeValue instanceof COSInteger) {
            nodeValue = "" + ((COSInteger)nodeValue).intValue();
        } else if (nodeValue instanceof COSString) {
            nodeValue = ((COSString)nodeValue).getString();
        } else if (nodeValue instanceof COSName) {
            nodeValue = ((COSName)nodeValue).getName();
        } else if (nodeValue instanceof ArrayEntry) {
            ArrayEntry entry = (ArrayEntry)nodeValue;
            nodeValue = "[" + entry.getIndex() + "]" + this.convertToTreeObject(entry.getValue());
        } else if (nodeValue instanceof COSNull) {
            nodeValue = "null";
        } else if (nodeValue instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)nodeValue;
            nodeValue = nodeValue instanceof COSStream ? "Stream" : "Dictionary";
            COSName type = (COSName)dict.getDictionaryObject(COSName.TYPE);
            if (type != null) {
                nodeValue = nodeValue + "(" + type.getName();
                COSName subType = (COSName)dict.getDictionaryObject(COSName.SUBTYPE);
                if (subType != null) {
                    nodeValue = nodeValue + ":" + subType.getName();
                }
                nodeValue = nodeValue + ")";
            }
        } else if (nodeValue instanceof COSArray) {
            nodeValue = "Array";
        } else if (nodeValue instanceof COSString) {
            nodeValue = ((COSString)nodeValue).getString();
        }
        return nodeValue;
    }
}

