/*
 * Decompiled with CFR 0.152.
 */
package spin.off;

import java.lang.reflect.Method;
import java.util.EventListener;
import spin.Evaluator;
import spin.Invocation;
import spin.Spin;

public class ListenerSpinOver
extends Evaluator {
    private Evaluator evaluator;

    public ListenerSpinOver() {
        this(Spin.getDefaultOffEvaluator());
    }

    public ListenerSpinOver(Evaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void evaluate(Invocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (this.isListenerAdditionOrRemoval(method)) {
            Class<?>[] types = method.getParameterTypes();
            Object[] args = invocation.getArguments();
            for (int t = 0; t < types.length; ++t) {
                if (!this.isListener(types[t])) continue;
                args[t] = this.spinOver(args[t]);
            }
        }
        this.evaluator.evaluate(invocation);
    }

    protected boolean isListenerAdditionOrRemoval(Method method) {
        String name = method.getName();
        return name.endsWith("Listener") && (name.startsWith("add") || name.startsWith("remove"));
    }

    protected boolean isListener(Class type) {
        return type.isInterface() && EventListener.class.isAssignableFrom(type);
    }

    protected Object spinOver(Object object) {
        return Spin.over(object);
    }
}

