/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class SwtCompatibleRaster
extends WritableRaster {
    protected int bandOffset;
    int[] bitMasks;
    int[] bitOffsets;
    protected byte[] data;
    protected int[] dataOffsets;
    int dbOffset;
    int dbOffsetPacked;
    boolean inOrder;
    private int maxX;
    private int maxY;
    boolean packed = false;
    protected int pixelStride;
    protected int scanlineStride;
    int type;

    public SwtCompatibleRaster(SampleModel paramSampleModel, DataBuffer paramDataBuffer, Point origin) {
        this(paramSampleModel, paramDataBuffer, new Rectangle(origin.x, origin.y, paramSampleModel.getWidth(), paramSampleModel.getHeight()), origin, null);
    }

    public SwtCompatibleRaster(SampleModel paramSampleModel, DataBuffer paramDataBuffer, Rectangle aRegion, Point origin, WritableRaster paramParent) {
        super(paramSampleModel, paramDataBuffer, aRegion, origin, paramParent);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(this.dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("SwtCompatibleRasters must have byte DataBuffers");
        }
        DataBufferByte dbb = (DataBufferByte)this.dataBuffer;
        this.data = dbb.getData();
        int xOffset = aRegion.x - origin.x;
        int yOffset = aRegion.y - origin.y;
        if (this.sampleModel instanceof PixelInterleavedSampleModel || this.sampleModel instanceof ComponentSampleModel && this.isInterleaved((ComponentSampleModel)this.sampleModel)) {
            ComponentSampleModel csm = (ComponentSampleModel)this.sampleModel;
            this.scanlineStride = csm.getScanlineStride();
            this.pixelStride = csm.getPixelStride();
            this.dataOffsets = csm.getBandOffsets();
            int i = 0;
            while (i < this.getNumDataElements()) {
                int n = i++;
                this.dataOffsets[n] = this.dataOffsets[n] + (xOffset * this.pixelStride + yOffset * this.scanlineStride);
            }
        } else if (this.sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)this.sampleModel;
            this.packed = true;
            this.bitMasks = sppsm.getBitMasks();
            this.bitOffsets = sppsm.getBitOffsets();
            this.scanlineStride = sppsm.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dbb.getOffset();
            this.dataOffsets[0] = this.dataOffsets[0] + (xOffset * this.pixelStride + yOffset * this.scanlineStride);
        } else {
            throw new RasterFormatException("SwtCompatibleRasters must have PixelInterleavedSampleModel, SinglePixelPackedSampleModel or interleaved ComponentSampleModel.  Sample model is " + this.sampleModel);
        }
        this.bandOffset = this.dataOffsets[0];
        this.dbOffsetPacked = this.dataBuffer.getOffset() - this.sampleModelTranslateY * this.scanlineStride - this.sampleModelTranslateX * this.pixelStride;
        this.dbOffset = this.dbOffsetPacked - (xOffset * this.pixelStride + yOffset * this.scanlineStride);
        this.inOrder = false;
        if (this.numDataElements == this.pixelStride) {
            this.inOrder = true;
            int i = 1;
            while (i < this.numDataElements) {
                if (this.dataOffsets[i] - this.dataOffsets[0] != i) {
                    this.inOrder = false;
                    break;
                }
                ++i;
            }
        }
        this.verify(false);
    }

    public SwtCompatibleRaster(SampleModel paramSampleModel, Point origin) {
        super(paramSampleModel, origin);
    }

    public Raster createChild(int x, int y, int width, int height, int x0, int y0, int[] bandList) {
        return this.createWritableChild(x, y, width, height, x0, y0, bandList);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException("negative " + (w <= 0 ? "width" : "height"));
        }
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(w, h);
        return new SwtCompatibleRaster(sm, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int x, int y, int width, int height, int x0, int y0, int[] bandList) {
        if (x < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (y < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (x + width < x || x + width > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (y + height < y || y + height > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sm = bandList != null ? this.sampleModel.createSubsetSampleModel(bandList) : this.sampleModel;
        int deltaX = x0 - x;
        int deltaY = y0 - y;
        return new SwtCompatibleRaster(sm, this.dataBuffer, new Rectangle(x0, y0, width, height), new Point(this.sampleModelTranslateX + deltaX, this.sampleModelTranslateY + deltaY), this);
    }

    public byte[] getByteData(int x, int y, int w, int h, byte[] outData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (outData == null) {
            outData = new byte[this.numDataElements * w * h];
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) * this.pixelStride;
        int off = 0;
        if (this.inOrder) {
            yoff += this.dataOffsets[0];
            int rowBytes = w * this.pixelStride;
            if (this.scanlineStride == rowBytes) {
                System.arraycopy(this.data, yoff, outData, off, rowBytes * h);
            } else {
                int ystart = 0;
                while (ystart < h) {
                    System.arraycopy(this.data, yoff, outData, off, rowBytes);
                    off += rowBytes;
                    ++ystart;
                    yoff += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            yoff += this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    outData[off++] = this.data[xoff];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    outData[off++] = this.data[xoff];
                    outData[off++] = this.data[xoff + d1];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int d2 = this.dataOffsets[2] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    outData[off++] = this.data[xoff];
                    outData[off++] = this.data[xoff + d1];
                    outData[off++] = this.data[xoff + d2];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int d2 = this.dataOffsets[2] - this.dataOffsets[0];
            int d3 = this.dataOffsets[3] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    outData[off++] = this.data[xoff];
                    outData[off++] = this.data[xoff + d1];
                    outData[off++] = this.data[xoff + d2];
                    outData[off++] = this.data[xoff + d3];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else {
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    int c = 0;
                    while (c < this.numDataElements) {
                        outData[off++] = this.data[this.dataOffsets[c] + xoff];
                        ++c;
                    }
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
        return outData;
    }

    public byte[] getByteData(int x, int y, int w, int h, int band, byte[] outData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (outData == null) {
            outData = new byte[w * h];
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) * this.pixelStride + this.dataOffsets[band];
        int off = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == w) {
                System.arraycopy(this.data, yoff, outData, 0, w * h);
            } else {
                int ystart = 0;
                while (ystart < h) {
                    System.arraycopy(this.data, yoff, outData, off, w);
                    off += w;
                    ++ystart;
                    yoff += this.scanlineStride;
                }
            }
        } else {
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    outData[off++] = this.data[xoff];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
        return outData;
    }

    public Object getDataElements(int x, int y, int w, int h, Object obj) {
        return this.getByteData(x, y, w, h, (byte[])obj);
    }

    public Object getDataElements(int actualX, int actualY, Object obj) {
        byte[] outData = obj == null ? new byte[this.numDataElements] : (byte[])obj;
        if (actualX < this.minX || actualY < this.minY || actualX >= this.maxX || actualY >= this.maxY) {
            int band = 0;
            while (band < this.numDataElements) {
                outData[band] = 0;
                ++band;
            }
            return outData;
        }
        int off = (actualY - this.minY) * this.scanlineStride + (actualX - this.minX) * this.pixelStride;
        int band = 0;
        while (band < this.numDataElements) {
            outData[band] = this.data[this.dataOffsets[band] + off];
            ++band;
        }
        return outData;
    }

    public int getDataOffset(int band) {
        return this.dataOffsets[band];
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] pixels = iArray != null ? iArray : new int[w * h * this.numBands];
        int lineOffset = y * this.scanlineStride + x * this.pixelStride;
        int dstOffset = 0;
        if (this.packed) {
            lineOffset += this.dbOffsetPacked;
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    byte value = this.data[lineOffset + i];
                    int k = 0;
                    while (k < this.numBands) {
                        pixels[dstOffset++] = (value & this.bitMasks[k]) >>> this.bitOffsets[k];
                        ++k;
                    }
                    ++i;
                }
                lineOffset += this.scanlineStride;
                ++j;
            }
        } else {
            lineOffset += this.dbOffset;
            int d0 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        pixels[dstOffset++] = this.data[pixelOffset] & 0xFF;
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 2) {
                int d1 = this.dataOffsets[1] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        pixels[dstOffset++] = this.data[pixelOffset] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d1] & 0xFF;
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 3) {
                int d1 = this.dataOffsets[1] - d0;
                int d2 = this.dataOffsets[2] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        pixels[dstOffset++] = this.data[pixelOffset] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d1] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d2] & 0xFF;
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 4) {
                int d1 = this.dataOffsets[1] - d0;
                int d2 = this.dataOffsets[2] - d0;
                int d3 = this.dataOffsets[3] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        pixels[dstOffset++] = this.data[pixelOffset] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d1] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d2] & 0xFF;
                        pixels[dstOffset++] = this.data[pixelOffset + d3] & 0xFF;
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else {
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset;
                    int i = 0;
                    while (i < w) {
                        int k = 0;
                        while (k < this.numBands) {
                            pixels[dstOffset++] = this.data[pixelOffset + this.dataOffsets[k]] & 0xFF;
                            ++k;
                        }
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            }
        }
        return pixels;
    }

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getSample(int x, int y, int b) {
        if (x < this.minX || y < this.minY || x >= this.maxX || y >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int offset = y * this.scanlineStride + x + this.dbOffsetPacked;
            byte sample = this.data[offset];
            return (sample & this.bitMasks[b]) >>> this.bitOffsets[b];
        }
        int offset = y * this.scanlineStride + x * this.pixelStride + this.dbOffset;
        return this.data[offset + this.dataOffsets[b]] & 0xFF;
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] samples = iArray != null ? iArray : new int[w * h];
        int lineOffset = y * this.scanlineStride + x * this.pixelStride;
        int dstOffset = 0;
        if (this.packed) {
            lineOffset += this.dbOffsetPacked;
            int bitMask = this.bitMasks[b];
            int bitOffset = this.bitOffsets[b];
            int j = 0;
            while (j < h) {
                int sampleOffset = lineOffset;
                int i = 0;
                while (i < w) {
                    byte value = this.data[sampleOffset++];
                    samples[dstOffset++] = (value & bitMask) >>> bitOffset;
                    ++i;
                }
                lineOffset += this.scanlineStride;
                ++j;
            }
        } else {
            lineOffset += this.dbOffset + this.dataOffsets[b];
            int j = 0;
            while (j < h) {
                int sampleOffset = lineOffset;
                int i = 0;
                while (i < w) {
                    samples[dstOffset++] = this.data[sampleOffset] & 0xFF;
                    sampleOffset += this.pixelStride;
                    ++i;
                }
                lineOffset += this.scanlineStride;
                ++j;
            }
        }
        return samples;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    private boolean isInterleaved(ComponentSampleModel sm) {
        int minOffset;
        int numBands = this.sampleModel.getNumBands();
        if (numBands == 1) {
            return true;
        }
        int[] bankIndices = sm.getBankIndices();
        int i = 0;
        while (i < numBands) {
            if (bankIndices[i] != 0) {
                return false;
            }
            ++i;
        }
        int[] bandOffsets = sm.getBandOffsets();
        int maxOffset = minOffset = bandOffsets[0];
        int i2 = 1;
        while (i2 < numBands) {
            int offset = bandOffsets[i2];
            if (offset < minOffset) {
                minOffset = offset;
            }
            if (offset > maxOffset) {
                maxOffset = offset;
            }
            ++i2;
        }
        return maxOffset - minOffset < sm.getPixelStride();
    }

    public void putByteData(int x, int y, int w, int h, byte[] inData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) * this.pixelStride;
        int off = 0;
        if (this.inOrder) {
            yoff += this.dataOffsets[0];
            int rowBytes = w * this.pixelStride;
            if (rowBytes == this.scanlineStride) {
                System.arraycopy(inData, 0, this.data, yoff, rowBytes * h);
            } else {
                int ystart = 0;
                while (ystart < h) {
                    System.arraycopy(inData, off, this.data, yoff, rowBytes);
                    off += rowBytes;
                    ++ystart;
                    yoff += this.scanlineStride;
                }
            }
        } else if (this.numDataElements == 1) {
            yoff += this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    this.data[xoff] = inData[off++];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 2) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    this.data[xoff] = inData[off++];
                    this.data[xoff + d1] = inData[off++];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 3) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int d2 = this.dataOffsets[2] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    this.data[xoff] = inData[off++];
                    this.data[xoff + d1] = inData[off++];
                    this.data[xoff + d2] = inData[off++];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else if (this.numDataElements == 4) {
            yoff += this.dataOffsets[0];
            int d1 = this.dataOffsets[1] - this.dataOffsets[0];
            int d2 = this.dataOffsets[2] - this.dataOffsets[0];
            int d3 = this.dataOffsets[3] - this.dataOffsets[0];
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    this.data[xoff] = inData[off++];
                    this.data[xoff + d1] = inData[off++];
                    this.data[xoff + d2] = inData[off++];
                    this.data[xoff + d3] = inData[off++];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        } else {
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    int c = 0;
                    while (c < this.numDataElements) {
                        this.data[this.dataOffsets[c] + xoff] = inData[off++];
                        ++c;
                    }
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
    }

    public void putByteData(int x, int y, int w, int h, int band, byte[] inData) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int yoff = (y - this.minY) * this.scanlineStride + (x - this.minX) * this.pixelStride + this.dataOffsets[band];
        int off = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == w) {
                System.arraycopy(inData, 0, this.data, yoff, w * h);
            } else {
                int ystart = 0;
                while (ystart < h) {
                    System.arraycopy(inData, off, this.data, yoff, w);
                    off += w;
                    ++ystart;
                    yoff += this.scanlineStride;
                }
            }
        } else {
            int ystart = 0;
            while (ystart < h) {
                int xoff = yoff;
                int xstart = 0;
                while (xstart < w) {
                    this.data[xoff] = inData[off++];
                    ++xstart;
                    xoff += this.pixelStride;
                }
                ++ystart;
                yoff += this.scanlineStride;
            }
        }
    }

    private void setDataElements(int dstX, int dstY, int srcX, int srcY, int width, int height, Raster inRaster) {
        if (width <= 0 || height <= 0) {
            return;
        }
        int srcOffX = inRaster.getMinX();
        int srcOffY = inRaster.getMinY();
        Object tdata = null;
        if (inRaster instanceof SwtCompatibleRaster) {
            SwtCompatibleRaster bct = (SwtCompatibleRaster)inRaster;
            byte[] bdata = bct.getDataStorage();
            if (this.inOrder && bct.inOrder && this.pixelStride == bct.pixelStride) {
                int toff = bct.getDataOffset(0);
                int tss = bct.getScanlineStride();
                int tps = bct.getPixelStride();
                int srcOffset = toff + (srcY - srcOffY) * tss + (srcX - srcOffX) * tps;
                int dstOffset = this.dataOffsets[0] + (dstY - this.minY) * this.scanlineStride + (dstX - this.minX) * this.pixelStride;
                int nbytes = width * this.pixelStride;
                int tmpY = 0;
                while (tmpY < height) {
                    System.arraycopy(bdata, srcOffset, this.data, dstOffset, nbytes);
                    srcOffset += tss;
                    dstOffset += this.scanlineStride;
                    ++tmpY;
                }
                return;
            }
        }
        int startY = 0;
        while (startY < height) {
            tdata = inRaster.getDataElements(srcOffX, srcOffY + startY, width, 1, tdata);
            this.setDataElements(dstX, dstY + startY, width, 1, tdata);
            ++startY;
        }
    }

    public void setDataElements(int x, int y, int w, int h, Object obj) {
        this.putByteData(x, y, w, h, (byte[])obj);
    }

    public void setDataElements(int x, int y, Object obj) {
        if (x < this.minX || y < this.minY || x >= this.maxX || y >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] inData = (byte[])obj;
        int off = (y - this.minY) * this.scanlineStride + (x - this.minX) * this.pixelStride;
        int i = 0;
        while (i < this.numDataElements) {
            this.data[this.dataOffsets[i] + off] = inData[i];
            ++i;
        }
    }

    public void setDataElements(int x, int y, Raster inRaster) {
        int srcOffX = inRaster.getMinX();
        int srcOffY = inRaster.getMinY();
        int dstOffX = x + srcOffX;
        int dstOffY = y + srcOffY;
        int width = inRaster.getWidth();
        int height = inRaster.getHeight();
        if (dstOffX < this.minX || dstOffY < this.minY || dstOffX + width > this.maxX || dstOffY + height > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(dstOffX, dstOffY, srcOffX, srcOffY, width, height, inRaster);
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int lineOffset = y * this.scanlineStride + x * this.pixelStride;
        int srcOffset = 0;
        if (this.packed) {
            lineOffset += this.dbOffsetPacked;
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    int value = 0;
                    int k = 0;
                    while (k < this.numBands) {
                        int srcValue = iArray[srcOffset++];
                        value |= srcValue << this.bitOffsets[k] & this.bitMasks[k];
                        ++k;
                    }
                    this.data[lineOffset + i] = (byte)value;
                    ++i;
                }
                lineOffset += this.scanlineStride;
                ++j;
            }
        } else {
            lineOffset += this.dbOffset;
            int d0 = this.dataOffsets[0];
            if (this.numBands == 1) {
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        this.data[pixelOffset] = (byte)iArray[srcOffset++];
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 2) {
                int d1 = this.dataOffsets[1] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        this.data[pixelOffset] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d1] = (byte)iArray[srcOffset++];
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 3) {
                int d1 = this.dataOffsets[1] - d0;
                int d2 = this.dataOffsets[2] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        this.data[pixelOffset] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d1] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d2] = (byte)iArray[srcOffset++];
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else if (this.numBands == 4) {
                int d1 = this.dataOffsets[1] - d0;
                int d2 = this.dataOffsets[2] - d0;
                int d3 = this.dataOffsets[3] - d0;
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset + d0;
                    int i = 0;
                    while (i < w) {
                        this.data[pixelOffset] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d1] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d2] = (byte)iArray[srcOffset++];
                        this.data[pixelOffset + d3] = (byte)iArray[srcOffset++];
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            } else {
                int j = 0;
                while (j < h) {
                    int pixelOffset = lineOffset;
                    int i = 0;
                    while (i < w) {
                        int k = 0;
                        while (k < this.numBands) {
                            this.data[pixelOffset + this.dataOffsets[k]] = (byte)iArray[srcOffset++];
                            ++k;
                        }
                        pixelOffset += this.pixelStride;
                        ++i;
                    }
                    lineOffset += this.scanlineStride;
                    ++j;
                }
            }
        }
    }

    public void setRect(int dx, int dy, Raster srcRaster) {
        if (!(srcRaster instanceof SwtCompatibleRaster)) {
            super.setRect(dx, dy, srcRaster);
            return;
        }
        int width = srcRaster.getWidth();
        int height = srcRaster.getHeight();
        int srcOffX = srcRaster.getMinX();
        int srcOffY = srcRaster.getMinY();
        int dstOffX = dx + srcOffX;
        int dstOffY = dy + srcOffY;
        if (dstOffX < this.minX) {
            int skipX = this.minX - dstOffX;
            width -= skipX;
            srcOffX += skipX;
            dstOffX = this.minX;
        }
        if (dstOffY < this.minY) {
            int skipY = this.minY - dstOffY;
            height -= skipY;
            srcOffY += skipY;
            dstOffY = this.minY;
        }
        if (dstOffX + width > this.maxX) {
            width = this.maxX - dstOffX;
        }
        if (dstOffY + height > this.maxY) {
            height = this.maxY - dstOffY;
        }
        this.setDataElements(dstOffX, dstOffY, srcOffX, srcOffY, width, height, srcRaster);
    }

    public void setSample(int x, int y, int b, int s) {
        if (x < this.minX || y < this.minY || x >= this.maxX || y >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (this.packed) {
            int offset = y * this.scanlineStride + x + this.dbOffsetPacked;
            int bitMask = this.bitMasks[b];
            byte value = this.data[offset];
            value = (byte)(value & ~bitMask);
            this.data[offset] = value = (byte)(value | s << this.bitOffsets[b] & bitMask);
        } else {
            int offset = y * this.scanlineStride + x * this.pixelStride + this.dbOffset;
            this.data[offset + this.dataOffsets[b]] = (byte)s;
        }
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray) {
        if (x < this.minX || y < this.minY || x + w > this.maxX || y + h > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int lineOffset = y * this.scanlineStride + x * this.pixelStride;
        int srcOffset = 0;
        if (this.packed) {
            lineOffset += this.dbOffsetPacked;
            int bitMask = this.bitMasks[b];
            int j = 0;
            while (j < h) {
                int sampleOffset = lineOffset;
                int i = 0;
                while (i < w) {
                    byte value = this.data[sampleOffset];
                    value = (byte)(value & ~bitMask);
                    int sample = iArray[srcOffset++];
                    value = (byte)(value | sample << this.bitOffsets[b] & bitMask);
                    this.data[sampleOffset++] = value;
                    ++i;
                }
                lineOffset += this.scanlineStride;
                ++j;
            }
        } else {
            lineOffset += this.dbOffset + this.dataOffsets[b];
            int i = 0;
            while (i < h) {
                int sampleOffset = lineOffset;
                int j = 0;
                while (j < w) {
                    this.data[sampleOffset] = (byte)iArray[srcOffset++];
                    sampleOffset += this.pixelStride;
                    ++j;
                }
                lineOffset += this.scanlineStride;
                ++i;
            }
        }
    }

    public String toString() {
        return new String("SwtCompatibleRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements + " dataOff[0] = " + this.dataOffsets[0]);
    }

    private void verify(boolean strictCheck) {
        int maxSize = 0;
        int i = 0;
        while (i < this.numDataElements) {
            int size = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i];
            if (size > maxSize) {
                maxSize = size;
            }
            ++i;
        }
        if (this.data.length < maxSize) {
            throw new RasterFormatException("Data array too small (should be " + maxSize + " )");
        }
    }
}

