/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LocatorTools {
    public static final String PATH_SEPARATOR = ";";

    public static ILocator[] createLocators(String paths, ILocatorFactory factory) throws IOException {
        if (factory == null) {
            factory = LocatorFactory.get();
        }
        ArrayList<ILocator> locators = new ArrayList<ILocator>();
        StringTokenizer t = new StringTokenizer(paths, PATH_SEPARATOR);
        while (t.hasMoreTokens()) {
            String path = t.nextToken();
            locators.add(factory.createLocator(path));
        }
        ILocator[] result = new ILocator[locators.size()];
        return locators.toArray(result);
    }

    public static final byte[] getBytes(ILocator locator) throws IOException {
        if (locator instanceof ByteArrayLocator) {
            return ((ByteArrayLocator)locator).getBytes();
        }
        InputStream is = null;
        try {
            is = locator.getInputStream();
            byte[] byArray = StreamTools.toByteArray(is);
            return byArray;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static final File getFile(ILocator locator) throws IOException {
        if (locator instanceof FileLocator) {
            return ((FileLocator)locator).getFile();
        }
        throw new IOException("can't create file for '" + locator.getFullName() + "'");
    }

    private LocatorTools() {
    }
}

