/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.TextTranslator;
import freemind.main.HtmlTools;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class ScriptEditorProperty
extends PropertyBean
implements PropertyControl,
ActionListener {
    String description;
    String label;
    String script;
    JButton mButton;
    final JPopupMenu menu = new JPopupMenu();
    private final MindMapController mMindMapController;
    private static Logger logger = null;

    public ScriptEditorProperty(String description, String label, MindMapController pMindMapController) {
        this.description = description;
        this.label = label;
        this.mMindMapController = pMindMapController;
        if (logger == null) {
            logger = this.mMindMapController.getFrame().getLogger(this.getClass().getName());
        }
        this.mButton = new JButton();
        this.mButton.addActionListener(this);
        this.script = "";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setValue(String value) {
        this.setScriptValue(value);
    }

    @Override
    public String getValue() {
        return HtmlTools.unicodeToHTMLUnicodeEntity(HtmlTools.toXMLEscapedText(this.script));
    }

    @Override
    public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
        JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mButton);
        label.setToolTipText(pTranslator.getText(this.getDescription()));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        for (MindMapController.MindMapControllerPlugin plugin : this.mMindMapController.getPlugins()) {
            ScriptEditorStarter starter;
            String resultScript;
            if (!(plugin instanceof ScriptEditorStarter) || (resultScript = (starter = (ScriptEditorStarter)plugin).startEditor(this.script)) == null) continue;
            this.script = resultScript;
            this.firePropertyChangeEvent();
        }
    }

    private void setScriptValue(String result) {
        if (result == null) {
            result = "";
        }
        this.script = HtmlTools.toXMLUnescapedText(HtmlTools.unescapeHTMLUnicodeEntity(result));
        logger.fine("Setting script to " + this.script);
        this.mButton.setText(this.script);
    }

    @Override
    public void setEnabled(boolean pEnabled) {
        this.mButton.setEnabled(pEnabled);
    }

    public static interface ScriptEditorStarter
    extends MindMapController.MindMapControllerPlugin {
        public String startEditor(String var1);
    }
}

