/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.dialogs;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import freemind.common.BooleanProperty;
import freemind.common.ColorProperty;
import freemind.common.ComboProperty;
import freemind.common.FontProperty;
import freemind.common.IconProperty;
import freemind.common.NextLineProperty;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.ScriptEditorProperty;
import freemind.common.SeparatorProperty;
import freemind.common.StringProperty;
import freemind.common.TextTranslator;
import freemind.common.ThreeCheckBoxProperty;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.PatternChild;
import freemind.controller.actions.generated.instance.PatternEdgeColor;
import freemind.controller.actions.generated.instance.PatternEdgeStyle;
import freemind.controller.actions.generated.instance.PatternEdgeWidth;
import freemind.controller.actions.generated.instance.PatternIcon;
import freemind.controller.actions.generated.instance.PatternNodeBackgroundColor;
import freemind.controller.actions.generated.instance.PatternNodeColor;
import freemind.controller.actions.generated.instance.PatternNodeFontBold;
import freemind.controller.actions.generated.instance.PatternNodeFontItalic;
import freemind.controller.actions.generated.instance.PatternNodeFontName;
import freemind.controller.actions.generated.instance.PatternNodeFontSize;
import freemind.controller.actions.generated.instance.PatternNodeStyle;
import freemind.controller.actions.generated.instance.PatternNodeText;
import freemind.controller.actions.generated.instance.PatternPropertyBase;
import freemind.controller.actions.generated.instance.PatternScript;
import freemind.main.FreeMind;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.ApplyPatternAction;
import freemind.modes.mindmapmode.actions.IconAction;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;

public class StylePatternFrame
extends JPanel
implements TextTranslator,
PropertyChangeListener {
    private static final String[] EDGE_STYLES = new String[]{"linear", "bezier", "sharp_linear", "sharp_bezier"};
    private static final String[] EDGE_WIDTHS = new String[]{"EdgeWidth_parent", "EdgeWidth_thin", "EdgeWidth_1", "EdgeWidth_2", "EdgeWidth_4", "EdgeWidth_8"};
    private static final String NODE_BACKGROUND_COLOR = "nodebackgroundcolor";
    private static final String SET_RESOURCE = "set_property_text";
    private static final String SET_NODE_BACKGROUND_COLOR = "set_property_text";
    private static final String NODE_COLOR = "nodecolor";
    private static final String SET_NODE_COLOR = "set_property_text";
    private static final String SET_NODE_STYLE = "set_property_text";
    private static final String NODE_STYLE = "nodestyle";
    private static final String NODE_FONT_NAME = "nodefontname";
    private static final String SET_NODE_FONT_NAME = "set_property_text";
    private static final String NODE_FONT_SIZE = "nodefontsize";
    private static final String SET_NODE_FONT_SIZE = "set_property_text";
    private static final String NODE_FONT_BOLD = "nodefontbold";
    private static final String SET_NODE_FONT_BOLD = "set_property_text";
    private static final String NODE_FONT_ITALIC = "nodefontitalic";
    private static final String SET_NODE_FONT_ITALIC = "set_property_text";
    private static final String SET_NODE_TEXT = "set_property_text";
    private static final String NODE_TEXT = "nodetext";
    private static final String SET_EDGE_WIDTH = "set_property_text";
    private static final String EDGE_WIDTH = "edgewidth";
    private static final String SET_EDGE_STYLE = "set_property_text";
    private static final String EDGE_STYLE = "edgestyle";
    private static final String SET_EDGE_COLOR = "set_property_text";
    private static final String EDGE_COLOR = "edgecolor";
    private static final String CLEAR_ALL_SETTERS = "clear_all_setters";
    private static final String SET_ICON = "set_property_text";
    private static final String ICON = "icon";
    private static final String NODE_NAME = "patternname";
    private static final String SET_CHILD_PATTERN = "set_property_text";
    private static final String CHILD_PATTERN = "childpattern";
    private static final String SET_SCRIPT = "setscript";
    private static final String SCRIPT = "script";
    private final TextTranslator mTranslator;
    private Vector mControls;
    private ThreeCheckBoxProperty mSetNodeColor;
    private ColorProperty mNodeColor;
    private ThreeCheckBoxProperty mSetNodeBackgroundColor;
    private ColorProperty mNodeBackgroundColor;
    private ThreeCheckBoxProperty mSetNodeStyle;
    private ComboProperty mNodeStyle;
    private ThreeCheckBoxProperty mSetNodeFontName;
    private FontProperty mNodeFontName;
    private ThreeCheckBoxProperty mSetNodeFontBold;
    private BooleanProperty mNodeFontBold;
    private ThreeCheckBoxProperty mSetNodeFontItalic;
    private BooleanProperty mNodeFontItalic;
    private ThreeCheckBoxProperty mSetNodeFontSize;
    private ComboProperty mNodeFontSize;
    private ThreeCheckBoxProperty mSetNodeText;
    private StringProperty mNodeText;
    private ThreeCheckBoxProperty mSetEdgeWidth;
    private ComboProperty mEdgeWidth;
    private ThreeCheckBoxProperty mSetEdgeStyle;
    private ComboProperty mEdgeStyle;
    private ThreeCheckBoxProperty mSetEdgeColor;
    private ColorProperty mEdgeColor;
    private ThreeCheckBoxProperty mSetIcon;
    private IconProperty mIcon;
    private ThreeCheckBoxProperty mSetChildPattern;
    private ComboProperty mChildPattern;
    private ThreeCheckBoxProperty mSetScriptPattern;
    private ScriptEditorProperty mScriptPattern;
    private StringProperty mName;
    private Vector mIconInformationVector;
    private HashMap mPropertyChangePropagation = new HashMap();
    private ThreeCheckBoxProperty mClearSetters;
    private final MindMapController mMindMapController;
    private final StylePatternFrameType mType;
    private String[] sizes = new String[]{"2", "4", "6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "30", "36", "48", "72"};
    private List mPatternList;

    public StylePatternFrame(TextTranslator pTranslator, MindMapController pMindMapController, StylePatternFrameType pType) throws HeadlessException {
        this.mTranslator = pTranslator;
        this.mMindMapController = pMindMapController;
        this.mType = pType;
    }

    public void init() {
        CardLayout cardLayout = new CardLayout();
        JPanel rightStack = new JPanel(cardLayout);
        String form = "right:max(40dlu;p), 4dlu, 20dlu, 7dlu,right:max(40dlu;p), 4dlu, 80dlu, 7dlu";
        FormLayout rightLayout = new FormLayout(form, "");
        DefaultFormBuilder rightBuilder = new DefaultFormBuilder(rightLayout);
        rightBuilder.setDefaultDialogBorder();
        this.mControls = this.getControls();
        for (PropertyControl control : this.mControls) {
            control.layout(rightBuilder, this);
        }
        rightStack.add((Component)rightBuilder.getPanel(), "testTab");
        this.add((Component)rightStack, "Center");
    }

    public void addListeners() {
        for (PropertyControl control : this.mControls) {
            if (!(control instanceof PropertyBean)) continue;
            PropertyBean bean = (PropertyBean)((Object)control);
            bean.addPropertyChangeListener(this);
        }
        this.mClearSetters.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pEvt) {
                for (ThreeCheckBoxProperty booleanProp : StylePatternFrame.this.mPropertyChangePropagation.keySet()) {
                    booleanProp.setValue(StylePatternFrame.this.mClearSetters.getValue());
                }
            }
        });
    }

    private Vector getControls() {
        Vector<PropertyControl> controls = new Vector<PropertyControl>();
        controls.add(new SeparatorProperty("General"));
        this.mClearSetters = new ThreeCheckBoxProperty("clear_all_setters.tooltip", CLEAR_ALL_SETTERS);
        this.mClearSetters.setValue("true");
        controls.add(this.mClearSetters);
        if (StylePatternFrameType.WITH_NAME_AND_CHILDS.equals(this.mType)) {
            this.mName = new StringProperty("patternname.tooltip", NODE_NAME);
            controls.add(this.mName);
            this.mSetChildPattern = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
            controls.add(this.mSetChildPattern);
            Vector childNames = new Vector();
            this.mChildPattern = new ComboProperty("childpattern.tooltip", CHILD_PATTERN, childNames, childNames);
            controls.add(this.mChildPattern);
        }
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("NodeColors"));
        this.mSetNodeColor = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeColor);
        FreeMind fmMain = (FreeMind)this.mMindMapController.getFrame();
        this.mNodeColor = new ColorProperty("nodecolor.tooltip", NODE_COLOR, fmMain.getDefaultProperty("standardnodetextcolor"), this);
        controls.add(this.mNodeColor);
        this.mSetNodeBackgroundColor = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeBackgroundColor);
        this.mNodeBackgroundColor = new ColorProperty("nodebackgroundcolor.tooltip", NODE_BACKGROUND_COLOR, fmMain.getDefaultProperty("standardbackgroundcolor"), this);
        controls.add(this.mNodeBackgroundColor);
        controls.add(new SeparatorProperty("NodeStyles"));
        this.mSetNodeStyle = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeStyle);
        this.mNodeStyle = new ComboProperty("nodestyle.tooltip", NODE_STYLE, MindMapNode.NODE_STYLES, this);
        controls.add(this.mNodeStyle);
        this.mIconInformationVector = new Vector();
        MindMapController controller = this.mMindMapController;
        Vector iconActions = controller.iconActions;
        Enumeration e = iconActions.elements();
        while (e.hasMoreElements()) {
            IconAction action = (IconAction)e.nextElement();
            MindIcon info = action.getMindIcon();
            this.mIconInformationVector.add(info);
        }
        this.mSetIcon = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetIcon);
        this.mIcon = new IconProperty("icon.tooltip", ICON, this.mMindMapController.getFrame(), this.mIconInformationVector);
        controls.add(this.mIcon);
        controls.add(new NextLineProperty());
        controls.add(new SeparatorProperty("NodeFont"));
        this.mSetNodeFontName = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeFontName);
        this.mNodeFontName = new FontProperty("nodefontname.tooltip", NODE_FONT_NAME, this);
        controls.add(this.mNodeFontName);
        this.mSetNodeFontSize = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeFontSize);
        Vector<String> sizesVector = new Vector<String>();
        for (int i = 0; i < this.sizes.length; ++i) {
            sizesVector.add(this.sizes[i]);
        }
        this.mNodeFontSize = new ComboProperty("nodefontsize.tooltip", NODE_FONT_SIZE, this.sizes, sizesVector);
        controls.add(this.mNodeFontSize);
        this.mSetNodeFontBold = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeFontBold);
        this.mNodeFontBold = new BooleanProperty("nodefontbold.tooltip", NODE_FONT_BOLD);
        controls.add(this.mNodeFontBold);
        this.mSetNodeFontItalic = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeFontItalic);
        this.mNodeFontItalic = new BooleanProperty("nodefontitalic.tooltip", NODE_FONT_ITALIC);
        controls.add(this.mNodeFontItalic);
        this.mSetNodeText = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetNodeText);
        this.mNodeText = new StringProperty("nodetext.tooltip", NODE_TEXT);
        controls.add(this.mNodeText);
        controls.add(new SeparatorProperty("EdgeControls"));
        this.mSetEdgeWidth = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetEdgeWidth);
        this.mEdgeWidth = new ComboProperty("edgewidth.tooltip", EDGE_WIDTH, EDGE_WIDTHS, this);
        controls.add(this.mEdgeWidth);
        this.mSetEdgeStyle = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetEdgeStyle);
        this.mEdgeStyle = new ComboProperty("edgestyle.tooltip", EDGE_STYLE, EDGE_STYLES, this);
        controls.add(this.mEdgeStyle);
        this.mSetEdgeColor = new ThreeCheckBoxProperty("set_property_text.tooltip", "set_property_text");
        controls.add(this.mSetEdgeColor);
        this.mEdgeColor = new ColorProperty("edgecolor.tooltip", EDGE_COLOR, fmMain.getDefaultProperty("standardedgecolor"), this);
        controls.add(this.mEdgeColor);
        controls.add(new SeparatorProperty("ScriptingControl"));
        this.mSetScriptPattern = new ThreeCheckBoxProperty("setscript.tooltip", SET_SCRIPT);
        controls.add(this.mSetScriptPattern);
        this.mScriptPattern = new ScriptEditorProperty("script.tooltip", SCRIPT, this.mMindMapController);
        controls.add(this.mScriptPattern);
        this.mPropertyChangePropagation.put(this.mSetNodeColor, this.mNodeColor);
        this.mPropertyChangePropagation.put(this.mSetNodeBackgroundColor, this.mNodeBackgroundColor);
        this.mPropertyChangePropagation.put(this.mSetNodeStyle, this.mNodeStyle);
        this.mPropertyChangePropagation.put(this.mSetNodeFontName, this.mNodeFontName);
        this.mPropertyChangePropagation.put(this.mSetNodeFontSize, this.mNodeFontSize);
        this.mPropertyChangePropagation.put(this.mSetNodeFontBold, this.mNodeFontBold);
        this.mPropertyChangePropagation.put(this.mSetNodeFontItalic, this.mNodeFontItalic);
        this.mPropertyChangePropagation.put(this.mSetNodeText, this.mNodeText);
        this.mPropertyChangePropagation.put(this.mSetEdgeColor, this.mEdgeColor);
        this.mPropertyChangePropagation.put(this.mSetEdgeStyle, this.mEdgeStyle);
        this.mPropertyChangePropagation.put(this.mSetEdgeWidth, this.mEdgeWidth);
        this.mPropertyChangePropagation.put(this.mSetIcon, this.mIcon);
        this.mPropertyChangePropagation.put(this.mSetScriptPattern, this.mScriptPattern);
        if (StylePatternFrameType.WITH_NAME_AND_CHILDS.equals(this.mType)) {
            this.mPropertyChangePropagation.put(this.mSetChildPattern, this.mChildPattern);
        }
        return controls;
    }

    private Vector getPatternNames() {
        Vector<String> childNames = new Vector<String>();
        for (Pattern pattern : this.mPatternList) {
            childNames.add(pattern.getName());
        }
        return childNames;
    }

    @Override
    public String getText(String pKey) {
        return this.mTranslator.getText("PatternDialog." + pKey);
    }

    public void setPattern(Pattern pattern) {
        FreeMind fmMain = (FreeMind)this.mMindMapController.getFrame();
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeColor(), this.mSetNodeColor, this.mNodeColor, fmMain.getDefaultProperty("standardnodetextcolor"));
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeBackgroundColor(), this.mSetNodeBackgroundColor, this.mNodeBackgroundColor, fmMain.getDefaultProperty("standardbackgroundcolor"));
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeStyle(), this.mSetNodeStyle, this.mNodeStyle, "as_parent");
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeText(), this.mSetNodeText, this.mNodeText, "");
        this.setPatternControls((PatternPropertyBase)pattern.getPatternEdgeColor(), this.mSetEdgeColor, this.mEdgeColor, fmMain.getDefaultProperty("standardedgecolor"));
        this.setPatternControls((PatternPropertyBase)pattern.getPatternEdgeStyle(), this.mSetEdgeStyle, this.mEdgeStyle, EDGE_STYLES[0]);
        this.setPatternControls((PatternPropertyBase)pattern.getPatternEdgeWidth(), this.mSetEdgeWidth, this.mEdgeWidth, EDGE_WIDTHS[0], new EdgeWidthTransformer());
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeFontName(), this.mSetNodeFontName, this.mNodeFontName, this.mMindMapController.getController().getDefaultFontFamilyName());
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeFontSize(), this.mSetNodeFontSize, this.mNodeFontSize, this.sizes[0]);
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeFontBold(), this.mSetNodeFontBold, this.mNodeFontBold, "true");
        this.setPatternControls((PatternPropertyBase)pattern.getPatternNodeFontItalic(), this.mSetNodeFontItalic, this.mNodeFontItalic, "true");
        MindIcon firstInfo = (MindIcon)this.mIconInformationVector.get(0);
        this.setPatternControls((PatternPropertyBase)pattern.getPatternIcon(), this.mSetIcon, this.mIcon, firstInfo.getName());
        this.setPatternControls((PatternPropertyBase)pattern.getPatternScript(), this.mSetScriptPattern, this.mScriptPattern, "");
        if (StylePatternFrameType.WITH_NAME_AND_CHILDS.equals(this.mType)) {
            this.mName.setValue(pattern.getName());
            this.setPatternControls((PatternPropertyBase)pattern.getPatternChild(), this.mSetChildPattern, this.mChildPattern, this.mPatternList.size() > 0 ? ((Pattern)this.mPatternList.get(0)).getName() : null);
        }
        for (ThreeCheckBoxProperty prop : this.mPropertyChangePropagation.keySet()) {
            this.propertyChange(new PropertyChangeEvent(prop, prop.getLabel(), null, prop.getValue()));
        }
    }

    private void setPatternControls(PatternPropertyBase patternProperty, PropertyBean threeCheckBoxProperty, PropertyBean property, String defaultValue) {
        this.setPatternControls(patternProperty, threeCheckBoxProperty, property, defaultValue, new IdentityTransformer());
    }

    private void setPatternControls(PatternPropertyBase patternProperty, PropertyBean threeCheckBoxProperty, PropertyBean property, String defaultValue, ValueTransformator transformer) {
        if (patternProperty == null) {
            property.setValue(defaultValue);
            threeCheckBoxProperty.setValue("don_t_touch");
            return;
        }
        if (patternProperty.getValue() == null) {
            property.setValue(defaultValue);
            threeCheckBoxProperty.setValue("false");
            return;
        }
        property.setValue(transformer.transform(patternProperty.getValue()));
        threeCheckBoxProperty.setValue("true");
    }

    private String transformEdgeWidth(String pEdgeWidth) {
        if (pEdgeWidth == null) {
            return null;
        }
        int edgeWidth = ApplyPatternAction.edgeWidthStringToInt(pEdgeWidth);
        HashMap transformator = this.getEdgeWidthTransformation();
        for (String widthString : transformator.keySet()) {
            Integer width = (Integer)transformator.get(widthString);
            if (edgeWidth != width) continue;
            return widthString;
        }
        return null;
    }

    private String transformStringToWidth(String value) {
        HashMap transformator = this.getEdgeWidthTransformation();
        int intWidth = (Integer)transformator.get(value);
        return ApplyPatternAction.edgeWidthIntToString(intWidth);
    }

    private HashMap getEdgeWidthTransformation() {
        HashMap<String, Integer> transformator = new HashMap<String, Integer>();
        transformator.put(EDGE_WIDTHS[0], new Integer(-1));
        transformator.put(EDGE_WIDTHS[1], new Integer(0));
        transformator.put(EDGE_WIDTHS[2], new Integer(1));
        transformator.put(EDGE_WIDTHS[3], new Integer(2));
        transformator.put(EDGE_WIDTHS[4], new Integer(4));
        transformator.put(EDGE_WIDTHS[5], new Integer(8));
        return transformator;
    }

    public Pattern getResultPattern() {
        Pattern pattern = new Pattern();
        return this.getResultPattern(pattern);
    }

    public Pattern getResultPattern(Pattern pattern) {
        pattern.setPatternNodeColor((PatternNodeColor)this.getPatternResult((PatternPropertyBase)new PatternNodeColor(), this.mSetNodeColor, this.mNodeColor));
        pattern.setPatternNodeBackgroundColor((PatternNodeBackgroundColor)this.getPatternResult((PatternPropertyBase)new PatternNodeBackgroundColor(), this.mSetNodeBackgroundColor, this.mNodeBackgroundColor));
        pattern.setPatternNodeStyle((PatternNodeStyle)this.getPatternResult((PatternPropertyBase)new PatternNodeStyle(), this.mSetNodeStyle, this.mNodeStyle));
        pattern.setPatternNodeText((PatternNodeText)this.getPatternResult((PatternPropertyBase)new PatternNodeText(), this.mSetNodeText, this.mNodeText));
        pattern.setPatternEdgeColor((PatternEdgeColor)this.getPatternResult((PatternPropertyBase)new PatternEdgeColor(), this.mSetEdgeColor, this.mEdgeColor));
        pattern.setPatternEdgeStyle((PatternEdgeStyle)this.getPatternResult((PatternPropertyBase)new PatternEdgeStyle(), this.mSetEdgeStyle, this.mEdgeStyle));
        pattern.setPatternEdgeWidth((PatternEdgeWidth)this.getPatternResult((PatternPropertyBase)new PatternEdgeWidth(), this.mSetEdgeWidth, this.mEdgeWidth, new EdgeWidthBackTransformer()));
        pattern.setPatternNodeFontName((PatternNodeFontName)this.getPatternResult((PatternPropertyBase)new PatternNodeFontName(), this.mSetNodeFontName, this.mNodeFontName));
        pattern.setPatternNodeFontSize((PatternNodeFontSize)this.getPatternResult((PatternPropertyBase)new PatternNodeFontSize(), this.mSetNodeFontSize, this.mNodeFontSize));
        pattern.setPatternNodeFontBold((PatternNodeFontBold)this.getPatternResult((PatternPropertyBase)new PatternNodeFontBold(), this.mSetNodeFontBold, this.mNodeFontBold));
        pattern.setPatternNodeFontItalic((PatternNodeFontItalic)this.getPatternResult((PatternPropertyBase)new PatternNodeFontItalic(), this.mSetNodeFontItalic, this.mNodeFontItalic));
        pattern.setPatternIcon((PatternIcon)this.getPatternResult((PatternPropertyBase)new PatternIcon(), this.mSetIcon, this.mIcon));
        pattern.setPatternScript((PatternScript)this.getPatternResult((PatternPropertyBase)new PatternScript(), this.mSetScriptPattern, this.mScriptPattern));
        if (StylePatternFrameType.WITH_NAME_AND_CHILDS.equals(this.mType)) {
            pattern.setName(this.mName.getValue());
            pattern.setPatternChild((PatternChild)this.getPatternResult((PatternPropertyBase)new PatternChild(), this.mSetChildPattern, this.mChildPattern));
        }
        return pattern;
    }

    private PatternPropertyBase getPatternResult(PatternPropertyBase baseProperty, ThreeCheckBoxProperty threeCheckBoxProperty, PropertyBean property) {
        IdentityTransformer transformer = new IdentityTransformer();
        return this.getPatternResult(baseProperty, threeCheckBoxProperty, property, transformer);
    }

    private PatternPropertyBase getPatternResult(PatternPropertyBase baseProperty, ThreeCheckBoxProperty threeCheckBoxProperty, PropertyBean property, ValueTransformator transformer) {
        String checkboxResult = threeCheckBoxProperty.getValue();
        if (checkboxResult == null) {
            return null;
        }
        if (checkboxResult.equals("don_t_touch")) {
            return null;
        }
        if (checkboxResult.equals("false")) {
            return baseProperty;
        }
        baseProperty.setValue(transformer.transform(property.getValue()));
        return baseProperty;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pEvt) {
        if (this.mPropertyChangePropagation.containsKey(pEvt.getSource())) {
            ThreeCheckBoxProperty booleanProp = (ThreeCheckBoxProperty)pEvt.getSource();
            PropertyControl bean = (PropertyControl)this.mPropertyChangePropagation.get(booleanProp);
            bean.setEnabled("true".equals(booleanProp.getValue()));
            return;
        }
    }

    public void setPatternList(List patternList) {
        this.mPatternList = patternList;
        Vector childNames = this.getPatternNames();
        this.mChildPattern.updateComboBoxEntries(childNames, childNames);
    }

    private final class EdgeWidthBackTransformer
    implements ValueTransformator {
        private EdgeWidthBackTransformer() {
        }

        @Override
        public String transform(String value) {
            return StylePatternFrame.this.transformStringToWidth(value);
        }
    }

    private final class EdgeWidthTransformer
    implements ValueTransformator {
        private EdgeWidthTransformer() {
        }

        @Override
        public String transform(String value) {
            return StylePatternFrame.this.transformEdgeWidth(value);
        }
    }

    private final class IdentityTransformer
    implements ValueTransformator {
        private IdentityTransformer() {
        }

        @Override
        public String transform(String value) {
            return value;
        }
    }

    private static interface ValueTransformator {
        public String transform(String var1);
    }

    public static final class StylePatternFrameType {
        public static StylePatternFrameType WITHOUT_NAME_AND_CHILDS = new StylePatternFrameType();
        public static StylePatternFrameType WITH_NAME_AND_CHILDS = new StylePatternFrameType();

        private StylePatternFrameType() {
        }
    }
}

