/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BookmarkMindMapNode;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class EditMonitoringDirAction
extends AbstractMonitoringAction {
    private String oldDirectory;
    private ArrayList<MindMapNode> nodesFromOldDirectory;
    JTree tree;

    public EditMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_edit"), controller);
    }

    public EditMonitoringDirAction(MindMapController controller, JTree tree) {
        super(LocalizationSupport.message("splmm_monitoringDir_edit"), controller);
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String link;
        this.selected = this.tree != null ? SciPloreUtils.getMonitoringNodeFromPath(this.tree.getSelectionPath()) : this.controller.getSelected();
        this.oldDirectory = link = SciPloreUtils.getLink(this.controller.getController(), this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH));
        int result = this.ShowFileChooser(new File(this.oldDirectory));
        if (result == 0) {
            int deleteQuestion;
            if (this.directory != null) {
                new EventSenderThread(SciPloreUtils.EVENT_EDIT_MON_DIR, this.directory.getPath());
            } else {
                new EventSenderThread(SciPloreUtils.EVENT_EDIT_MON_DIR, "");
            }
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
            this.selected.getAttributes().setValue(this.selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_PATH), this.directory);
            if (this.isNotUnsavedMapWithRelativePathes()) {
                MindMapMapModel model = (MindMapMapModel)this.selected.getMap();
                model.setAutomaticSaveLock(true);
                this.ExecuteMyTask(new MyTask(), this);
                model.setAutomaticSaveLock(false);
            }
            if ((deleteQuestion = JOptionPane.showConfirmDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_deleteNodes"), "", 0)) == 0) {
                for (MindMapNode node : this.nodesFromOldDirectory) {
                    this.controller.deleteNode(node);
                }
            }
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
        }
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            EditMonitoringDirAction.this.nodesFromOldDirectory = EditMonitoringDirAction.this.getNodesToRemove(EditMonitoringDirAction.this.selected, new File(EditMonitoringDirAction.this.oldDirectory), EditMonitoringDirAction.this.directory);
            EditMonitoringDirAction.this.bibTexMap = BookmarkMindMapNode.ReadBibtexFile();
            EditMonitoringDirAction.this.controller = (MindMapController)EditMonitoringDirAction.this.selected.getMap().getModeController();
            Map<String, Collection<MindMapNode>> nodesLinkedToMonFiles = EditMonitoringDirAction.this.getMonFileLinkedNodes(EditMonitoringDirAction.this.controller.getRootNode(), new HashMap<String, Collection<MindMapNode>>());
            if (this.canceled) {
                return null;
            }
            List<File> filesFromMonDir = EditMonitoringDirAction.this.getMonDirFiles(EditMonitoringDirAction.this.directory);
            if (this.canceled) {
                return null;
            }
            List<File> importedFiles = EditMonitoringDirAction.this.importNewMonDirFiles(nodesLinkedToMonFiles, filesFromMonDir);
            if (this.canceled) {
                return null;
            }
            if (SplmmPreferences.getAutoImport().booleanValue()) {
                filesFromMonDir = EditMonitoringDirAction.this.removeImportedFiles(filesFromMonDir, importedFiles);
                if (this.canceled) {
                    return null;
                }
                filesFromMonDir = EditMonitoringDirAction.this.removeUpToDateFiles(filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
                EditMonitoringDirAction.this.importNewBookMarks(this, filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
                EditMonitoringDirAction.this.setAllNodesUpToDate(filesFromMonDir, nodesLinkedToMonFiles);
                if (this.canceled) {
                    return null;
                }
            }
            EditMonitoringDirAction.this.pasteAllNodes(this);
            return null;
        }
    }
}

