/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import splmm.BookmarkMindMapNode;
import splmm.SciPloreUtils;

public class BibTex {
    private String key;
    private String path;
    private String title;
    private String authors;
    private String year;
    private String journal;
    private String booktitle;

    public BibTex() {
    }

    public BibTex(String key, String path) {
        this.key = key;
        this.path = path;
    }

    public BibTex(String key, String path, String title) {
        this.key = key;
        this.path = path;
        this.title = title;
    }

    public String getBooktitle() {
        return this.booktitle;
    }

    public void setBooktitle(String booktitle) {
        this.booktitle = booktitle;
    }

    public String getAuthors() {
        return this.authors;
    }

    public void setAuthors(String authors) {
        this.authors = authors;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getJournal() {
        return this.journal;
    }

    public void setJournal(String journal) {
        this.journal = journal;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return this.key + " " + this.path;
    }

    public HashMap<String, Collection<BibTex>> readBibtex(File file) {
        HashMap<String, Collection<BibTex>> bibTexMap = new HashMap<String, Collection<BibTex>>();
        if (file != null && file.exists() && file.getName().endsWith("bib")) {
            try {
                String charset = Charset.defaultCharset().name();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                CharsetDetector cd = new CharsetDetector();
                cd.setText((InputStream)bis);
                CharsetMatch cm = cd.detect();
                if (cm != null) {
                    charset = cm.getName();
                }
                bis.close();
                ParserResult result = OpenDatabaseAction.loadDatabase((File)file, (String)charset);
                BibtexDatabase db = result.getDatabase();
                for (BibtexEntry entry : db.getEntries()) {
                    String[] paths;
                    String files = entry.getField("file");
                    if (files == null || files.isEmpty()) continue;
                    for (String path : paths = files.split("(?<!\\\\);")) {
                        if ((path = this.parsePath(path)) == null) continue;
                        String osName = System.getProperty("os.name");
                        if (this.isRelativePath(path, osName)) {
                            path = this.CreateAbsolutePath(file, path);
                        } else if (!osName.substring(0, 3).equals("Win") && !path.startsWith("/")) {
                            path = "/" + path;
                        }
                        if (path.contains("\\:")) {
                            path = path.replace("\\:", ":");
                        }
                        String title = this.parseTitle(this.parseSpecialChars(entry.getField("title")));
                        BibTex bib = new BibTex(entry.getCiteKey(), path, title);
                        bib.setAuthors(this.parseSpecialChars(entry.getField("author")));
                        bib.setYear(entry.getField("year"));
                        bib.setJournal(this.parseJournal(this.parseSpecialChars(entry.getField("journal"))));
                        bib.setBooktitle(this.parseSpecialChars(entry.getField("booktitle")));
                        Collection<BibTex> values = bibTexMap.get(path);
                        if (values == null) {
                            values = new ArrayList<BibTex>();
                            bibTexMap.put(path, values);
                        }
                        values.add(bib);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return bibTexMap;
    }

    private String parseJournal(String journal) {
        if (journal == null) {
            return null;
        }
        journal = journal.replace("{", "");
        journal = journal.replace("}", "");
        return journal;
    }

    private String parseTitle(String title) {
        if (title != null) {
            title = title.replaceAll("\\{", "");
            title = title.replaceAll("\\}", "");
            title = title.replaceAll("\t", " ");
            title = title.replaceAll("\r\n", "");
            return title;
        }
        return null;
    }

    private String parsePath(String path) {
        if (path != null) {
            String fileType = "";
            if ((path = this.parseSpecialChars(path)).contains("backslash") || path.matches("([a-zA-Z]\\\\:/).*")) {
                path = this.parseMendely(path);
            }
            try {
                if (path.matches("[^:]*:([a-zA-Z]\\\\:){1}[^:]*:([aA][pP][pP][lL][iI][cC][aA][tT][iI][oO][nN]/)?[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(path.indexOf(":") + 1, splitIndex);
                } else if (path.matches("([a-zA-Z]\\\\:){1}[^:]*:([aA][pP][pP][lL][iI][cC][aA][tT][iI][oO][nN]/)?[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(0, splitIndex);
                } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:[^:]*:([aA][pP][pP][lL][iI][cC][aA][tT][iI][oO][nN]/)?[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(path.indexOf(":") + 1, splitIndex);
                } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:([aA][pP][pP][lL][iI][cC][aA][tT][iI][oO][nN]/)?[pP][dD][fF]")) {
                    int splitIndex = path.lastIndexOf(":");
                    fileType = path.substring(splitIndex + 1);
                    path = path.substring(0, splitIndex);
                } else if (path.endsWith(".pdf") || path.endsWith(".PDF")) {
                    fileType = "pdf";
                    if (path.matches("[^:]*:([a-zA-Z]\\\\:).*")) {
                        path = path.substring(path.indexOf(":") + 1);
                    } else if (!path.matches("([a-zA-Z]\\\\:).*") && path.matches("[^:]*:.*")) {
                        path = path.substring(path.indexOf(":") + 1);
                    }
                } else if (path.matches("[:][a-zA-Z][:].*[:][pP][dD][fF]")) {
                    fileType = "pdf";
                    int splitIndex = path.lastIndexOf(":");
                    path = path.substring(path.indexOf(":") + 1, splitIndex);
                }
            }
            catch (IndexOutOfBoundsException e) {
                SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                return null;
            }
            path = path.replaceAll("\\\\;", ";");
            path = path.replaceAll("\r\n", "");
            path = path.replaceAll("\t", " ");
            path = path.replace("\\\\", "\\");
            path = path.replaceAll("^[:]\\_", "_");
            if (fileType.matches("([aA][pP][pP][lL][iI][cC][aA][tT][iI][oO][nN]/)?[pP][dD][fF]")) {
                return path;
            }
        }
        return null;
    }

    private String parseMendely(String path) {
        path = path.replace("$\\backslash$", "");
        path = path.replace("\\", "");
        path = path.replace('/', '\\');
        return path;
    }

    private String parseSpecialChars(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("\\\\\"[{]([a-zA-Z])[}]", "$1\u0308");
        s = s.replaceAll("\\\\`[{]([a-zA-Z])[}]", "$1\u0300");
        s = s.replaceAll("\\\\\u00c2\u00b4[{]([a-zA-Z])[}]", "$1\u0301");
        s = s.replaceAll("\\\\'[{]([a-zA-Z])[}]", "$1\u0301");
        s = s.replaceAll("\\\\\\^[{]([a-zA-Z])[}]", "$1\u0302");
        s = s.replaceAll("\\\\~[{]([a-zA-Z])[}]", "$1\u0303");
        s = s.replaceAll("\\\\=[{]([a-zA-Z])[}]", "$1\u0304");
        s = s.replaceAll("\\\\\\.[{]([a-zA-Z])[}]", "$1\u0307");
        s = s.replaceAll("\\\\u[{]([a-zA-Z])[}]", "$1\u030c");
        s = s.replaceAll("\\\\v[{]([a-zA-Z])[}]", "$1\u0306");
        s = s.replaceAll("\\\\H[{]([a-zA-Z])[}]", "$1\u030b");
        s = s.replaceAll("\\\\t[{]([a-zA-Z])([a-zA-Z])[}]", "$1\u0361$2");
        s = s.replaceAll("\\\\c[{]([a-zA-Z])[}]", "$1\u0355");
        s = s.replaceAll("\\\\d[{]([a-zA-Z])[}]", "$1\u0323");
        if ((s = s.replaceAll("\\\\b[{]([a-zA-Z])[}]", "$1\u0331")).contains("\\ss")) {
            s = s.replace("\\ss", "\u00df");
        }
        if (s.contains("\\AE")) {
            s = s.replace("\\AE", "\u00c6");
        }
        if (s.contains("\\ae")) {
            s = s.replace("\\ae", "\u00e6");
        }
        if (s.contains("\\OE")) {
            s = s.replace("\\OE", "\u0152");
        }
        if (s.contains("\\oe")) {
            s = s.replace("\\oe", "\u0153");
        }
        if (s.contains("\\O")) {
            s = s.replace("\\O", "\u00d8");
        }
        if (s.contains("\\o")) {
            s = s.replace("\\o", "\u00f8");
        }
        if (s.contains("\\L")) {
            s = s.replace("\\L", "\u0141");
        }
        if (s.contains("\\l")) {
            s = s.replace("\\l", "\u0142");
        }
        if (s.contains("\\AA")) {
            s = s.replace("\\AA", "\u00c5");
        }
        if (s.contains("\\aa")) {
            s = s.replace("\\aa", "\u00e5");
        }
        return s;
    }

    private String CreateAbsolutePath(File file, String path) {
        try {
            File parentFolder = new File(file.getParent());
            File pdf = new File(parentFolder, path);
            return pdf.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            String absolutePath = file.getAbsolutePath();
            absolutePath = absolutePath.replace(file.getName(), "");
            return absolutePath + path;
        }
    }

    private boolean isRelativePath(String path, String osname) {
        if (osname.contains("Win")) {
            return !path.contains(":");
        }
        if (!osname.substring(0, 3).equals("Win")) {
            return !path.startsWith("/");
        }
        return new File(path).isAbsolute();
    }

    public static RefKeyState addBibtexData(MindMapNode node, HashMap<String, Collection<BibTex>> bibTexMap) {
        String link = SciPloreUtils.getLink(node, node.getMap().getModeController().getController());
        if (link != null && !link.isEmpty()) {
            Iterator<BibTex> i$;
            File file = new File(link);
            Collection<BibTex> values = bibTexMap.get(link);
            if (values != null && values.size() >= 1 && (i$ = values.iterator()).hasNext()) {
                BibTex bib = i$.next();
                RefKeyState state = BibTex.setAttribute(node, bib.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                BibTex.setAttribute(node, bib.getTitle(), "splmm_reftitle");
                BibTex.setAttribute(node, bib.getAuthors(), "splmm_refauthors");
                BibTex.setAttribute(node, bib.getYear(), "splmm_refyear");
                BibTex.setAttribute(node, bib.getJournal(), "splmm_publishedin");
                BibTex.setAttribute(node, bib.getBooktitle(), "splmm_publishedin");
                return state;
            }
        }
        return RefKeyState.noRefkey;
    }

    private static RefKeyState setAttribute(MindMapNode node, String value, String attributeKey) {
        if (node == null || attributeKey == null || attributeKey.isEmpty()) {
            return RefKeyState.noRefkey;
        }
        if (value == null && attributeKey.equals(SciPloreUtils.SPLMM_REFKEY_NAME)) {
            value = "";
        }
        if (value == null && !attributeKey.equals(SciPloreUtils.SPLMM_REFKEY_NAME)) {
            return RefKeyState.noRefkey;
        }
        Attribute pAttribute = new Attribute(attributeKey, value);
        if (node.getAttributeKeyList().size() == 0) {
            node.createAttributeTableModel();
        }
        if (BibTex.HasSplmmAttribute(attributeKey, node)) {
            Attribute splmmAttribute = BibTex.GetSplmmAttribute(attributeKey, node);
            splmmAttribute.setValue(value);
            node.getMap().getModeController().nodeChanged(node);
            BookmarkMindMapNode.SetOptimalColumnWidth(node);
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && splmmAttribute.getValue().equalsIgnoreCase(value)) {
                return RefKeyState.oldRefkey;
            }
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && !splmmAttribute.getValue().equalsIgnoreCase(value)) {
                return RefKeyState.newRefkey;
            }
        } else {
            node.getAttributes().addRowNoUndo(pAttribute);
            node.getMap().getModeController().nodeChanged(node);
            BookmarkMindMapNode.SetOptimalColumnWidth(node);
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME)) {
                return RefKeyState.newRefkey;
            }
        }
        return RefKeyState.noRefkey;
    }

    private static Attribute GetSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return a;
        }
        return null;
    }

    private static boolean HasSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public static enum RefKeyState {
        noRefkey,
        oldRefkey,
        newRefkey;

    }
}

