/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.IAnnotationOutlet;
import de.intarsys.pdf.cos.COSName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.Service;

public class StandardAnnotationOutlet
implements IAnnotationOutlet {
    private Map<COSName, IAnnotationFactory> instances = new HashMap<COSName, IAnnotationFactory>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected StandardAnnotationOutlet() {
    }

    protected IAnnotationFactory[] findProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        ArrayList<IAnnotationFactory> result = new ArrayList<IAnnotationFactory>();
        Iterator ps = Service.providers(IAnnotationFactory.class, (ClassLoader)loader);
        while (ps.hasNext()) {
            try {
                result.add((IAnnotationFactory)ps.next());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result.toArray(new IAnnotationFactory[result.size()]);
    }

    public synchronized IAnnotationFactory[] getAnnotationFactories() {
        this.init();
        return this.instances.values().toArray(new IAnnotationFactory[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAnnotationFactory[] providers = this.findProviders();
        int i = 0;
        while (i < providers.length) {
            IAnnotationFactory provider = providers[i];
            this.registerAnnotationFactory(provider);
            ++i;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public synchronized IAnnotationFactory lookupAnnotationFactory(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    public synchronized void registerAnnotationFactory(IAnnotationFactory factory) {
        this.instances.put(factory.getAnnotationType(), factory);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    public synchronized void unregisterAnnotationFactory(IAnnotationFactory factory) {
        this.instances.remove(factory.getAnnotationType());
    }
}

