/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.appearance;

import de.intarsys.pdf.app.appearance.IAppearanceCreator;
import de.intarsys.pdf.app.appearance.IAppearanceCreatorRegistry;
import de.intarsys.pdf.cos.COSName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.Service;

public class StandardAppearanceCreatorRegistry
implements IAppearanceCreatorRegistry {
    private Map<COSName, IAppearanceCreator> instances = new HashMap<COSName, IAppearanceCreator>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected StandardAppearanceCreatorRegistry() {
    }

    protected IAppearanceCreator[] findProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        ArrayList<IAppearanceCreator> result = new ArrayList<IAppearanceCreator>();
        Iterator ps = Service.providers(IAppearanceCreator.class, (ClassLoader)loader);
        while (ps.hasNext()) {
            try {
                result.add((IAppearanceCreator)ps.next());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result.toArray(new IAppearanceCreator[result.size()]);
    }

    public synchronized IAppearanceCreator[] getAppearanceCreators() {
        this.init();
        return this.instances.values().toArray(new IAppearanceCreator[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAppearanceCreator[] providers = this.findProviders();
        int i = 0;
        while (i < providers.length) {
            IAppearanceCreator provider = providers[i];
            this.registerAppearanceCreator(provider);
            ++i;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public synchronized IAppearanceCreator lookupAppearanceCreator(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    public synchronized void registerAppearanceCreator(IAppearanceCreator creator) {
        this.instances.put(creator.getAnnotationType(), creator);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    public synchronized void unregisterAppearanceCreator(IAppearanceCreator creator) {
        this.instances.remove(creator.getAnnotationType());
    }
}

