/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import de.intarsys.pdf.pd.AbstractBitFlags;

public class PermissionFlags
extends AbstractBitFlags {
    public static int Bit_Print = 4;
    public static int Bit_Modify = 8;
    public static int Bit_Copy = 16;
    public static int Bit_ModifyAnnotation = 32;
    public static int Bit_FillForm = 256;
    public static int Bit_Extract = 512;
    public static int Bit_Assemble = 1024;
    public static int Bit_PrintHighQuality = 2048;
    protected StandardSecurityHandler handler;

    public PermissionFlags(int value) {
        super(value);
    }

    public PermissionFlags(StandardSecurityHandler handler) {
        super(handler.getEncryption(), null);
        this.handler = handler;
    }

    public StandardSecurityHandler getHandler() {
        return this.handler;
    }

    protected int getValueInObject() {
        return this.getHandler().basicGetPermissionFlags();
    }

    public boolean mayAssemble() {
        return this.isSetAnd(Bit_Assemble);
    }

    public boolean mayCopy() {
        return this.isSetAnd(Bit_Copy);
    }

    public boolean mayExtract() {
        return this.isSetAnd(Bit_Extract);
    }

    public boolean mayFillForm() {
        return this.isSetAnd(Bit_FillForm);
    }

    public boolean mayModify() {
        return this.isSetAnd(Bit_Modify);
    }

    public boolean mayModifyAnnotation() {
        return this.isSetAnd(Bit_ModifyAnnotation);
    }

    public boolean mayPrint() {
        return this.isSetAnd(Bit_Print);
    }

    public boolean mayPrintHighQuality() {
        return this.isSetAnd(Bit_PrintHighQuality);
    }

    public void setMayAssemble(boolean value) {
        this.set(Bit_Assemble, value);
    }

    public void setMayCopy(boolean value) {
        this.set(Bit_Copy, value);
    }

    public void setMayExtract(boolean value) {
        this.set(Bit_Extract, value);
    }

    public void setMayFillForm(boolean value) {
        this.set(Bit_FillForm, value);
    }

    public void setMayModify(boolean value) {
        this.set(Bit_Modify, value);
    }

    public void setMayModifyAnnotation(boolean value) {
        this.set(Bit_ModifyAnnotation, value);
    }

    public void setMayPrint(boolean value) {
        this.set(Bit_Print, value);
    }

    public void setMayPrintHighQuality(boolean value) {
        this.set(Bit_PrintHighQuality, value);
    }

    protected void setValueInObject(int newValue) {
        try {
            this.getHandler().basicSetPermissionFlags(newValue);
        }
        catch (COSSecurityException e) {
            throw new SecurityException("security exception", e);
        }
    }
}

