/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDFileSpecification;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.SubmitFormFlags;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDActionSubmitForm
extends PDAction {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_ActionType_SubmitForm = COSName.constant("SubmitForm");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName DK_Flags = COSName.constant("Flags");
    private SubmitFormFlags flags;

    protected PDActionSubmitForm(COSObject object) {
        super(object);
    }

    public COSName cosGetExpectedActionType() {
        return CN_ActionType_SubmitForm;
    }

    public void setCanonicalFormat(boolean flag) {
        this.getFlags().setCanonicalFormat(flag);
    }

    public boolean isCanonicalFormat() {
        return this.getFlags().isCanonicalFormat();
    }

    public void setEmbedForm(boolean flag) {
        this.getFlags().setEmbedForm(flag);
    }

    public boolean isEmbedForm() {
        return this.getFlags().isEmbedForm();
    }

    public void setExclFKey(boolean flag) {
        this.getFlags().setExclFKey(flag);
    }

    public boolean isExclFKey() {
        return this.getFlags().isExclFKey();
    }

    public void setExclNonUserAnnots(boolean flag) {
        this.getFlags().setExclNonUserAnnots(flag);
    }

    public boolean isExclNonUserAnnots() {
        return this.getFlags().isExclNonUserAnnots();
    }

    public void setExportFormat(boolean flag) {
        this.getFlags().setExportFormat(flag);
    }

    public boolean isExportFormat() {
        return this.getFlags().isExportFormat();
    }

    public void setGetMethod(boolean flag) {
        this.getFlags().setGetMethod(flag);
    }

    public boolean isGetMethod() {
        return this.getFlags().isGetMethod();
    }

    public void setInclude(boolean flag) {
        this.getFlags().setInclude(flag);
    }

    public boolean isInclude() {
        return this.getFlags().isInclude();
    }

    public void setIncludeAnnotations(boolean flag) {
        this.getFlags().setIncludeAnnotations(flag);
    }

    public boolean isIncludeAnnotations() {
        return this.getFlags().isIncludeAnnotations();
    }

    public void setIncludeAppendSaves(boolean flag) {
        this.getFlags().setIncludeAppendSaves(flag);
    }

    public boolean isIncludeAppendSaves() {
        return this.getFlags().isIncludeAppendSaves();
    }

    public void setIncludeNoValueFields(boolean flag) {
        this.getFlags().setIncludeNoValueFields(flag);
    }

    public boolean isIncludeNoValueFields() {
        return this.getFlags().isIncludeNoValueFields();
    }

    public void setNotDEFINED(boolean flag) {
        this.getFlags().setNotDEFINED(flag);
    }

    public boolean isNotDEFINED() {
        return this.getFlags().isNotDEFINED();
    }

    public void setSubmitCoordinates(boolean flag) {
        this.getFlags().setSubmitCoordinates(flag);
    }

    public boolean isSubmitCoordinates() {
        return this.getFlags().isSubmitCoordinates();
    }

    public void setSubmitPDF(boolean flag) {
        this.getFlags().setSubmitPDF(flag);
    }

    public boolean isSubmitPDF() {
        return this.getFlags().isSubmitPDF();
    }

    public void setUrl(URL url) {
        if (url != null) {
            this.setUrlSpecification(PDFileSpecificationURL.createNew(url));
        } else {
            this.setUrlSpecification(null);
        }
    }

    public URL getUrl() {
        PDFileSpecification fs = this.getUrlSpecification();
        if (fs != null) {
            return ((PDFileSpecificationURL)fs).getURL();
        }
        return null;
    }

    public void setXFDF(boolean flag) {
        this.getFlags().setXFDF(flag);
    }

    public boolean isXFDF() {
        return this.getFlags().isXFDF();
    }

    public static PDActionSubmitForm createNew(URL url) {
        PDActionSubmitForm result = (PDActionSubmitForm)META.createNew();
        result.setUrl(url);
        return result;
    }

    protected SubmitFormFlags getFlags() {
        if (this.flags == null) {
            this.flags = new SubmitFormFlags(this);
        }
        return this.flags;
    }

    public List getFields() {
        COSArray array = this.cosGetField(DK_Fields).asArray();
        if (array != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator i = array.iterator();
            while (i.hasNext()) {
                COSObject entry = (COSObject)i.next();
                if (entry instanceof COSDictionary) {
                    PDAcroFormField field = (PDAcroFormField)PDAcroFormField.META.createFromCos(entry);
                    result.add(field.getQualifiedName());
                    continue;
                }
                result.add(entry.stringValue());
            }
            return result;
        }
        return null;
    }

    protected int basicGetFlags() {
        return this.getFieldInt(DK_Flags, 0);
    }

    protected PDFileSpecification getUrlSpecification() {
        COSObject cosObject = this.cosGetField(DK_F);
        if (cosObject.isNull()) {
            return null;
        }
        return (PDFileSpecificationURL)PDFileSpecificationURL.META.createFromCos(cosObject);
    }

    protected void setFields(List newFields) {
    }

    protected void basicSetFlags(int newFlags) {
        if (newFlags != 0) {
            this.cosSetField(DK_Flags, COSInteger.create(newFlags));
        } else {
            this.cosRemoveField(DK_Flags);
        }
    }

    protected void setUrlSpecification(PDFileSpecification newUrl) {
        this.setFieldObject(DK_F, newUrl);
    }

    public static class MetaClass
    extends PDAction.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

