/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDEmbeddedFile;
import de.intarsys.pdf.pd.PDFileSpecificationURL;
import de.intarsys.pdf.pd.PDObject;

public class PDFileSpecification
extends PDObject {
    public static final COSName CN_Type_Filespec = COSName.constant("Filespec");
    public static final COSName CN_Type_Alt_Filespec = COSName.constant("F");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_FS = COSName.constant("FS");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName CN_F_DOS = COSName.constant("DOS");
    public static final COSName CN_F_Mac = COSName.constant("Mac");
    public static final COSName CN_F_Unix = COSName.constant("Unix");
    public static final COSName CN_FS_URL = COSName.constant("URL");
    public static final COSName DK_EF = COSName.constant("EF");
    public static final COSName DK_RF = COSName.constant("RF");
    private COSName fileSystem = null;

    protected PDFileSpecification(COSObject object) {
        super(object);
    }

    public void setFileSystem(COSName bs) {
        this.fileSystem = bs;
    }

    public COSName getFileSystem() {
        return this.fileSystem;
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Filespec;
    }

    protected void initializeFromCos() {
        super.initializeFromCos();
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_FS, this.getFileSystem());
    }

    public String getFile() {
        COSString cosFile = this.cosGetField(DK_F).asString();
        if (cosFile == null) {
            return null;
        }
        return cosFile.stringValue();
    }

    public PDEmbeddedFile getEmbeddedFile(COSName flavor) {
        COSDictionary embeddedFileDict = this.getEmbeddedFiles();
        if (embeddedFileDict == null) {
            return null;
        }
        return (PDEmbeddedFile)PDEmbeddedFile.META.createFromCos(embeddedFileDict.get(flavor));
    }

    public void setEmbeddedFile(COSName flavor, PDEmbeddedFile embeddedFile) {
        COSDictionary embeddedFileDict = this.getEmbeddedFiles();
        if (embeddedFileDict == null) {
            embeddedFileDict = COSDictionary.create();
            this.cosSetField(DK_EF, embeddedFileDict);
        }
        embeddedFileDict.put(flavor, embeddedFile.cosGetObject());
    }

    public String getFileSpecificationString(COSName flavor) {
        return this.cosGetField(flavor).stringValue();
    }

    public void setFileSpecificationString(COSName flavor, String spec) {
        this.setFieldString(flavor, spec);
    }

    public COSDictionary getEmbeddedFiles() {
        return this.cosGetField(DK_EF).asDictionary();
    }

    public void setFile(String file) {
        this.setFieldString(DK_F, file);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        public Class getRootClass() {
            return PDFileSpecification.class;
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSName fileSystem = ((COSDictionary)object).get(DK_FS).asName();
            if (CN_FS_URL.equals(fileSystem)) {
                return PDFileSpecificationURL.META;
            }
            return META;
        }
    }
}

