/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;

public abstract class STXRefEntry
implements Comparable {
    private final int objectNumber;
    private final short generationNumber;

    protected STXRefEntry(int objectNumber, int generationNumber) {
        this.objectNumber = objectNumber;
        this.generationNumber = (short)generationNumber;
    }

    public abstract void accept(IXRefEntryVisitor var1) throws XRefEntryVisitorException;

    public int compareTo(Object obj) {
        if (obj instanceof STXRefEntry) {
            return this.getObjectNumber() - ((STXRefEntry)obj).getObjectNumber();
        }
        return -1;
    }

    public abstract STXRefEntry copy();

    public abstract STXRefEntryOccupied fill(int var1);

    public abstract long getColumn1();

    public abstract int getColumn2();

    public int getGenerationNumber() {
        return this.generationNumber & 0xFFFF;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public abstract boolean isFree();

    public abstract COSObject load(STDocument var1, ISystemSecurityHandler var2) throws IOException, COSLoadException;

    public String toString() {
        return String.valueOf(this.getObjectNumber()) + " " + this.getGenerationNumber() + " R";
    }

    protected abstract void unlink();
}

