/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Contact;
import org.sciplore.resources.DocumentPerson;
import org.sciplore.resources.Institution;
import org.sciplore.resources.PersonHomonym;
import org.sciplore.resources.PersonXref;
import org.sciplore.resources.Resource;

@Entity
@Table(name="persons")
@Inheritance(strategy=InheritanceType.JOINED)
@FetchProfile(name="person-with-documents", fetchOverrides={@FetchProfile.FetchOverride(entity=Person.class, association="documents", mode=FetchMode.JOIN), @FetchProfile.FetchOverride(entity=DocumentPerson.class, association="document", mode=FetchMode.JOIN)})
public class Person
extends Resource {
    @OneToMany(mappedBy="person", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Contact> contacts = new HashSet<Contact>();
    private Date dob;
    @OneToMany(mappedBy="person")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<DocumentPerson> documents = new HashSet<DocumentPerson>();
    @OneToMany(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<PersonHomonym> homonyms = new HashSet<PersonHomonym>();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="institution_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Institution institution;
    private String nameFirst;
    private String nameLast;
    private String nameMiddle;
    @Column(nullable=false)
    private Short valid = 1;
    @OneToMany(mappedBy="person", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<PersonXref> xrefs = new HashSet<PersonXref>();

    public Person getPerson(Person p) {
        if (p.getId() != null) {
            return this.getPerson(p.getId());
        }
        return this.getPerson(p.getNameFirst());
    }

    public Person getPerson(Integer id) {
        this.getSession().enableFetchProfile("person-with-documents");
        Person p = (Person)this.getSession().get(Person.class, (Serializable)id);
        this.getSession().disableFetchProfile("person-with-documents");
        return p;
    }

    public Person getPerson(String name) {
        return (Person)this.getSession().createCriteria(Person.class).add((Criterion)Restrictions.like((String)"nameFirst", (Object)name)).setMaxResults(1).uniqueResult();
    }

    public Person() {
    }

    public Person(Session s) {
        this.setSession(s);
    }

    public Person(Session s, Integer id) {
        this.setSession(s);
        this.id = id;
    }

    public Person(Session s, Integer id, String nameLast, String nameMiddle, String nameFirst) {
        this.setSession(s);
        this.id = id;
        this.nameLast = nameLast;
        this.nameMiddle = nameMiddle;
        this.nameFirst = nameFirst;
    }

    public Person(String name) {
        this.setName(name);
    }

    public void addContact(Contact contact) {
        this.contacts.add(contact);
    }

    public void addDocument(DocumentPerson dp) {
        this.documents.add(dp);
    }

    public void addHomonym(PersonHomonym homonym) {
        this.homonyms.add(homonym);
    }

    public void addHomonym(String homonym) {
        this.homonyms.add(new PersonHomonym(this.getSession(), homonym));
    }

    public void addXref(PersonXref x) {
        this.xrefs.add(x);
    }

    public Set<Contact> getContacts() {
        return this.contacts;
    }

    public Date getDob() {
        return this.dob;
    }

    public Set<DocumentPerson> getDocuments() {
        return this.documents;
    }

    public Set<PersonHomonym> getHomonyms() {
        return this.homonyms;
    }

    public Integer getId() {
        return this.id;
    }

    public Institution getInstitution() {
        return this.institution;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getNameMiddle() {
        return this.nameMiddle;
    }

    public Short getValid() {
        return this.valid;
    }

    public Set<PersonXref> getXrefs() {
        return this.xrefs;
    }

    public void setContacts(Set<Contact> contacts) {
        this.contacts = contacts;
    }

    public void setDob(Date dob) {
        this.dob = dob;
    }

    public void setDocuments(Set<DocumentPerson> documents) {
        this.documents = documents;
    }

    public void setHomonyms(Set<PersonHomonym> homonyms) {
        this.homonyms = homonyms;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    public Person setName(String name) {
        this.nameFirst = name;
        return this;
    }

    public void setNameFirst(String nameFirst) {
        this.nameFirst = nameFirst;
    }

    public void setNameLast(String nameLast) {
        this.nameLast = nameLast;
    }

    public void setNameMiddle(String nameMiddle) {
        this.nameMiddle = nameMiddle;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }

    public void setXrefs(Set<PersonXref> xrefs) {
        this.xrefs = xrefs;
    }

    public String toString() {
        String name = new String();
        if (this.getNameFirst() != null) {
            name = String.valueOf(name) + this.getNameFirst();
        }
        if (this.getNameMiddle() != null) {
            if (name.compareTo("") != 0) {
                name = String.valueOf(name) + " ";
            }
            name = String.valueOf(name) + this.getNameMiddle();
        }
        if (this.getNameLast() != null) {
            if (name.compareTo("") != 0) {
                name = String.valueOf(name) + " ";
            }
            name = String.valueOf(name) + this.getNameLast();
        }
        return name;
    }
}

