/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.uif_lite.component.UIFSplitPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FileHistory;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyBindingsDialog;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MarkEntriesAction;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.SearchManager2;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.ExportCustomizationDialog;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.SaveAllAction;
import net.sf.jabref.export.SaveDatabaseAction;
import net.sf.jabref.external.ExternalFileTypeEditor;
import net.sf.jabref.external.PushToApplicationButton;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.gui.DatabasePropertiesDialog;
import net.sf.jabref.gui.EntryCustomizationDialog2;
import net.sf.jabref.gui.GenFieldsCustomizer;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.gui.SortTabsAction;
import net.sf.jabref.gui.WaitForSaveOperation;
import net.sf.jabref.imports.CiteSeerFetcher;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.GeneralFetcher;
import net.sf.jabref.imports.ImportCustomizationDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormats;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.journals.ManageJournalsAction;
import net.sf.jabref.label.ArticleLabelRule;
import net.sf.jabref.label.BookLabelRule;
import net.sf.jabref.label.IncollectionLabelRule;
import net.sf.jabref.label.InproceedingsLabelRule;
import net.sf.jabref.label.LabelMaker;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstallerAction;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.sql.DbImportAction;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.MassSetFieldAction;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog;
import net.sf.jabref.wizard.integrity.gui.IntegrityWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JabRefFrame
extends JFrame
implements OutputPrinter {
    UIFSplitPane contentPane = new UIFSplitPane();
    JabRefPreferences prefs = Globals.prefs;
    PrefsDialog3 prefsDialog = null;
    private int lastTabbedPanelSelectionIndex = -1;
    public SidePaneManager sidePaneManager;
    JTabbedPane tabbedPane = new JTabbedPane();
    final Insets marg = new Insets(1, 0, 2, 0);
    ToolBar tlb = new ToolBar();
    JMenuBar mb = new JMenuBar();
    JMenu pluginMenu = JabRefFrame.subMenu("Plugins");
    boolean addedToPluginMenu = false;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel statusLine = new JLabel("", 2);
    JLabel statusLabel = new JLabel(Globals.lang("Status") + ":", 2);
    JProgressBar progressBar = new JProgressBar();
    private FileHistory fileHistory = new FileHistory(this.prefs, this);
    LabelMaker labelMaker;
    public HelpDialog helpDiag = new HelpDialog(this);
    public JToggleButton groupToggle;
    public JToggleButton searchToggle;
    public JToggleButton previewToggle;
    public JToggleButton highlightAny;
    public JToggleButton highlightAll;
    OpenDatabaseAction open = new OpenDatabaseAction(this, true);
    AbstractAction close = new CloseDatabaseAction();
    AbstractAction quit = new CloseAction();
    AbstractAction selectKeys = new SelectKeysAction();
    AbstractAction newDatabaseAction = new NewDatabaseAction();
    AbstractAction newSubDatabaseAction = new NewSubDatabaseAction();
    AbstractAction integrityCheckAction = new IntegrityCheckAction();
    AbstractAction help = new HelpAction("JabRef help", this.helpDiag, GUIGlobals.baseFrameHelp, Globals.lang("JabRef help"), this.prefs.getKey("Help"));
    AbstractAction contents = new HelpAction("Help contents", this.helpDiag, GUIGlobals.helpContents, Globals.lang("Help contents"), GUIGlobals.getIconUrl("helpContents"));
    AbstractAction about = new HelpAction("About JabRef", this.helpDiag, GUIGlobals.aboutPage, Globals.lang("About JabRef"), GUIGlobals.getIconUrl("about"));
    AbstractAction editEntry = new GeneralAction("edit", "Edit entry", Globals.lang("Edit entry"), this.prefs.getKey("Edit entry"));
    AbstractAction focusTable = new GeneralAction("focusTable", "Focus entry table", Globals.lang("Move the keyboard focus to the entry table"), this.prefs.getKey("Focus entry table"));
    AbstractAction save = new GeneralAction("save", "Save database", Globals.lang("Save database"), this.prefs.getKey("Save database"));
    AbstractAction saveAs = new GeneralAction("saveAs", "Save database as ...", Globals.lang("Save database as ..."), this.prefs.getKey("Save database as ..."));
    AbstractAction saveAll = new SaveAllAction(this);
    AbstractAction saveSelectedAs = new GeneralAction("saveSelectedAs", "Save selected as ...", Globals.lang("Save selected as ..."), GUIGlobals.getIconUrl("saveAs"));
    AbstractAction exportAll = ExportFormats.getExportAction(this, false);
    AbstractAction exportSelected = ExportFormats.getExportAction(this, true);
    AbstractAction importCurrent = ImportFormats.getImportAction(this, false);
    AbstractAction importNew = ImportFormats.getImportAction(this, true);
    AbstractAction nextTab = new ChangeTabAction(true);
    AbstractAction prevTab = new ChangeTabAction(false);
    AbstractAction sortTabs = new SortTabsAction(this);
    AbstractAction undo = new GeneralAction("undo", "Undo", Globals.lang("Undo"), this.prefs.getKey("Undo"));
    AbstractAction redo = new GeneralAction("redo", "Redo", Globals.lang("Redo"), this.prefs.getKey("Redo"));
    AbstractAction forward = new GeneralAction("forward", "Forward", Globals.lang("Forward"), "right", this.prefs.getKey("Forward"));
    AbstractAction back = new GeneralAction("back", "Back", Globals.lang("Back"), "left", this.prefs.getKey("Back"));
    AbstractAction delete = new GeneralAction("delete", "Delete", Globals.lang("Delete"), this.prefs.getKey("Delete"));
    AbstractAction copy = new EditAction("copy", GUIGlobals.getIconUrl("copy"));
    AbstractAction paste = new EditAction("paste", GUIGlobals.getIconUrl("paste"));
    AbstractAction cut = new EditAction("cut", GUIGlobals.getIconUrl("cut"));
    AbstractAction mark = new GeneralAction("markEntries", "Mark entries", Globals.lang("Mark entries"), this.prefs.getKey("Mark entries"));
    AbstractAction unmark = new GeneralAction("unmarkEntries", "Unmark entries", Globals.lang("Unmark entries"), this.prefs.getKey("Unmark entries"));
    AbstractAction unmarkAll = new GeneralAction("unmarkAll", "Unmark all");
    AbstractAction manageSelectors = new GeneralAction("manageSelectors", "Manage content selectors");
    AbstractAction saveSessionAction = new SaveSessionAction();
    AbstractAction loadSessionAction = new LoadSessionAction();
    AbstractAction incrementalSearch = new GeneralAction("incSearch", "Incremental search", Globals.lang("Start incremental search"), this.prefs.getKey("Incremental search"));
    AbstractAction normalSearch = new GeneralAction("search", "Search", Globals.lang("Search"), this.prefs.getKey("Search"));
    AbstractAction toggleSearch = new GeneralAction("toggleSearch", "Search", Globals.lang("Toggle search panel"));
    AbstractAction fetchCiteSeer = new FetchCiteSeerAction();
    AbstractAction importCiteSeer = new ImportCiteSeerAction();
    AbstractAction copyKey = new GeneralAction("copyKey", "Copy BibTeX key", this.prefs.getKey("Copy BibTeX key"));
    AbstractAction copyCiteKey = new GeneralAction("copyCiteKey", "Copy \\cite{BibTeX key}", this.prefs.getKey("Copy \\cite{BibTeX key}"));
    AbstractAction mergeDatabaseAction = new GeneralAction("mergeDatabase", "Append database", Globals.lang("Append contents from a BibTeX database into the currently viewed database"), GUIGlobals.getIconUrl("open"));
    AbstractAction selectAll = new GeneralAction("selectAll", "Select all", this.prefs.getKey("Select all"));
    AbstractAction replaceAll = new GeneralAction("replaceAll", "Replace string", this.prefs.getKey("Replace string"));
    AbstractAction editPreamble = new GeneralAction("editPreamble", "Edit preamble", Globals.lang("Edit preamble"), this.prefs.getKey("Edit preamble"));
    AbstractAction editStrings = new GeneralAction("editStrings", "Edit strings", Globals.lang("Edit strings"), this.prefs.getKey("Edit strings"));
    AbstractAction toggleGroups = new GeneralAction("toggleGroups", "Toggle groups interface", Globals.lang("Toggle groups interface"), this.prefs.getKey("Toggle groups interface"));
    AbstractAction togglePreview = new GeneralAction("togglePreview", "Toggle entry preview", Globals.lang("Toggle entry preview"), this.prefs.getKey("Toggle entry preview"));
    AbstractAction toggleHighlightAny = new GeneralAction("toggleHighlightGroupsMatchingAny", "Highlight groups matching any selected entry", Globals.lang("Highlight groups matching any selected entry"), GUIGlobals.getIconUrl("groupsHighlightAny"));
    AbstractAction toggleHighlightAll = new GeneralAction("toggleHighlightGroupsMatchingAll", "Highlight groups matching all selected entries", Globals.lang("Highlight groups matching all selected entries"), GUIGlobals.getIconUrl("groupsHighlightAll"));
    AbstractAction switchPreview = new GeneralAction("switchPreview", "Switch preview layout", this.prefs.getKey("Switch preview layout"));
    AbstractAction makeKeyAction = new GeneralAction("makeKey", "Autogenerate BibTeX keys", Globals.lang("Autogenerate BibTeX keys"), this.prefs.getKey("Autogenerate BibTeX keys"));
    AbstractAction writeXmpAction = new GeneralAction("writeXMP", "Write XMP-metadata to PDFs", Globals.lang("Will write XMP-metadata to the PDFs linked from selected entries."), this.prefs.getKey("Write XMP"));
    AbstractAction openFile = new GeneralAction("openExternalFile", "Open file", Globals.lang("Open file"), this.prefs.getKey("Open file"));
    AbstractAction openPdf = new GeneralAction("openFile", "Open PDF or PS", Globals.lang("Open PDF or PS"), this.prefs.getKey("Open PDF or PS"));
    AbstractAction openUrl = new GeneralAction("openUrl", "Open URL or DOI", Globals.lang("Open URL or DOI"), this.prefs.getKey("Open URL or DOI"));
    AbstractAction openSpires = new GeneralAction("openSpires", "Open SPIRES entry", Globals.lang("Open SPIRES entry"), this.prefs.getKey("Open SPIRES entry"));
    AbstractAction dupliCheck = new GeneralAction("dupliCheck", "Find duplicates");
    AbstractAction plainTextImport = new GeneralAction("plainTextImport", "New entry from plain text", this.prefs.getKey("New from plain text"));
    AbstractAction customExpAction = new CustomizeExportsAction();
    AbstractAction customImpAction = new CustomizeImportsAction();
    AbstractAction customFileTypesAction = ExternalFileTypeEditor.getAction(this);
    AbstractAction exportToClipboard = new GeneralAction("exportToClipboard", "Export selected entries to clipboard");
    AbstractAction autoSetPdf = new GeneralAction("autoSetPdf", Globals.lang("Synchronize %0 links", "PDF"), Globals.prefs.getKey("Synchronize PDF"));
    AbstractAction autoSetPs = new GeneralAction("autoSetPs", Globals.lang("Synchronize %0 links", "PS"), Globals.prefs.getKey("Synchronize PS"));
    AbstractAction autoSetFile = new GeneralAction("autoSetFile", Globals.lang("Synchronize file links"), Globals.prefs.getKey("Synchronize files"));
    AbstractAction abbreviateMedline = new GeneralAction("abbreviateMedline", "Abbreviate journal names (MEDLINE)", Globals.lang("Abbreviate journal names of the selected entries (MEDLINE abbreviation)"));
    AbstractAction abbreviateIso = new GeneralAction("abbreviateIso", "Abbreviate journal names (ISO)", Globals.lang("Abbreviate journal names of the selected entries (ISO abbreviation)"), Globals.prefs.getKey("Abbreviate"));
    AbstractAction unabbreviate = new GeneralAction("unabbreviate", "Unabbreviate journal names", Globals.lang("Unabbreviate journal names of the selected entries"), Globals.prefs.getKey("Unabbreviate"));
    AbstractAction manageJournals = new ManageJournalsAction(this);
    AbstractAction databaseProperties = new DatabasePropertiesAction();
    AbstractAction upgradeExternalLinks = new GeneralAction("upgradeLinks", "Upgrade external links", Globals.lang("Upgrade external PDF/PS links to use the '%0' field.", "file"));
    AbstractAction errorConsole = Globals.errorConsole.getAction(this);
    AbstractAction test = new GeneralAction("test", "Test");
    AbstractAction dbConnect = new GeneralAction("dbConnect", "Connect to external SQL database", Globals.lang("Connect to external SQL database"), GUIGlobals.getIconUrl("dbConnect"));
    AbstractAction dbExport = new GeneralAction("dbExport", "Export to external SQL database", Globals.lang("Export to external SQL database"), GUIGlobals.getIconUrl("dbExport"));
    AbstractAction dbImport = new DbImportAction(this).getAction();
    AbstractAction increaseFontSize = new IncreaseTableFontSizeAction();
    AbstractAction decreseFontSize = new DecreaseTableFontSizeAction();
    AbstractAction installPlugin = new PluginInstallerAction(this);
    AbstractAction resolveDuplicateKeys = new GeneralAction("resolveDuplicateKeys", "Resolve duplicate BibTeX keys", Globals.lang("Find and remove duplicate BibTeX keys"), this.prefs.getKey("Resolve duplicate BibTeX keys"));
    PushToApplicationButton pushExternalButton;
    CiteSeerFetcher citeSeerFetcher;
    List<EntryFetcher> fetchers = new LinkedList<EntryFetcher>();
    List<Action> fetcherActions = new LinkedList<Action>();
    SearchManager2 searchManager;
    public GroupSelector groupSelector;
    JMenu importMenu = JabRefFrame.subMenu("Import into current database");
    JMenu importNewMenu = JabRefFrame.subMenu("Import into new database");
    JMenu exportMenu = JabRefFrame.subMenu("Export");
    JMenu customExportMenu = JabRefFrame.subMenu("Custom export");
    JMenu newDatabaseMenu = JabRefFrame.subMenu("New database");
    JMenu checkAndFix = JabRefFrame.subMenu("Scan database...");
    NewEntryAction newEntryAction = new NewEntryAction(this.prefs.getKey("New entry"));
    NewEntryAction[] newSpecificEntryAction = new NewEntryAction[]{new NewEntryAction("article", this.prefs.getKey("New article")), new NewEntryAction("book", this.prefs.getKey("New book")), new NewEntryAction("phdthesis", this.prefs.getKey("New phdthesis")), new NewEntryAction("inbook", this.prefs.getKey("New inbook")), new NewEntryAction("mastersthesis", this.prefs.getKey("New mastersthesis")), new NewEntryAction("proceedings", this.prefs.getKey("New proceedings")), new NewEntryAction("inproceedings"), new NewEntryAction("conference"), new NewEntryAction("incollection"), new NewEntryAction("booklet"), new NewEntryAction("manual"), new NewEntryAction("techreport"), new NewEntryAction("unpublished", this.prefs.getKey("New unpublished")), new NewEntryAction("misc"), new NewEntryAction("other")};
    AboutAction aboutAction = new AboutAction();
    protected List<Object> openDatabaseOnlyActions = new LinkedList<Object>();
    protected List<Object> severalDatabasesOnlyActions = new LinkedList<Object>();
    protected int previousTabCount = -1;
    CloseDatabaseAction closeDatabaseAction = new CloseDatabaseAction();
    AbstractAction showPrefs = new ShowPrefsAction();

    public JabRefFrame() {
        this.init();
        this.updateEnabledState();
    }

    private void init() {
        this.macOSXRegistration();
        UIManager.put("FileChooser.readOnly", Globals.prefs.getBoolean("filechooserDisableRename"));
        MyGlassPane glassPane = new MyGlassPane();
        this.setGlassPane(glassPane);
        this.setTitle(GUIGlobals.frameTitle);
        this.setIconImage(GUIGlobals.getImage("jabrefIcon").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                new CloseAction().actionPerformed(null);
            }
        });
        this.initLabelMaker();
        this.initSidePane();
        this.initLayout();
        this.initActions();
        this.setBounds(0, 0, (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth(), (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        this.setExtendedState(6);
        if (Globals.prefs.getBoolean("rememberWindowLocation")) {
            int sizeX = this.prefs.getInt("sizeX");
            int sizeY = this.prefs.getInt("sizeY");
            int posX = this.prefs.getInt("posX");
            int posY = this.prefs.getInt("posY");
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length == 1) {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                int height = (int)dim.getHeight();
                int width = (int)dim.getWidth();
                if (posX + sizeX > width) {
                    if (sizeX <= width) {
                        posX = width - sizeX;
                    } else {
                        posX = this.prefs.getIntDefault("posX");
                        sizeX = this.prefs.getIntDefault("sizeX");
                    }
                }
                if (posY + sizeY > height) {
                    if (sizeY <= height) {
                        posY = height - sizeY;
                    } else {
                        posY = this.prefs.getIntDefault("posY");
                        sizeY = this.prefs.getIntDefault("sizeY");
                    }
                }
            }
            this.setBounds(posX, posY, sizeX, sizeY);
        }
        this.tabbedPane.setBorder(null);
        this.tabbedPane.setForeground(GUIGlobals.inActiveTabbed);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JabRefFrame.this.markActiveBasePanel();
                BasePanel bp = JabRefFrame.this.basePanel();
                if (bp != null) {
                    JabRefFrame.this.groupToggle.setSelected(JabRefFrame.this.sidePaneManager.isComponentVisible("groups"));
                    JabRefFrame.this.searchToggle.setSelected(JabRefFrame.this.sidePaneManager.isComponentVisible("search"));
                    JabRefFrame.this.previewToggle.setSelected(Globals.prefs.getBoolean("previewEnabled"));
                    JabRefFrame.this.highlightAny.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAny"));
                    JabRefFrame.this.highlightAll.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAll"));
                    Globals.focusListener.setFocused(bp.mainTable);
                    JabRefFrame.this.setWindowTitle();
                    bp.setBackAndForwardEnabledState();
                    new FocusRequester(bp.mainTable);
                }
            }
        });
    }

    public void setWindowTitle() {
        String star;
        BasePanel bp = this.basePanel();
        if (bp == null) {
            this.setTitle(GUIGlobals.frameTitle);
            return;
        }
        String string = star = bp.baseChanged ? "*" : "";
        if (bp.getFile() != null) {
            this.setTitle(GUIGlobals.frameTitle + " - " + bp.getFile().getPath() + star);
        } else {
            this.setTitle(GUIGlobals.frameTitle + " - " + Globals.lang("untitled") + star);
        }
    }

    private void initSidePane() {
        Globals.sidePaneManager = this.sidePaneManager = new SidePaneManager(this);
        Globals.helpDiag = this.helpDiag;
        JabRefPlugin jabrefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabrefPlugin != null) {
            for (_JabRefPlugin.EntryFetcherExtension ext : jabrefPlugin.getEntryFetcherExtensions()) {
                try {
                    EntryFetcher fetcher = ext.getEntryFetcher();
                    if (fetcher == null) continue;
                    this.fetchers.add(fetcher);
                }
                catch (ClassCastException ex) {
                    PluginCore.getManager().disablePlugin(ext.getDeclaringPlugin().getDescriptor());
                    ex.printStackTrace();
                }
            }
        }
        this.citeSeerFetcher = new CiteSeerFetcher(this.sidePaneManager);
        this.groupSelector = new GroupSelector(this, this.sidePaneManager);
        this.searchManager = new SearchManager2(this, this.sidePaneManager);
        this.sidePaneManager.register("CiteSeerProgress", this.citeSeerFetcher);
        this.sidePaneManager.register("groups", this.groupSelector);
        this.sidePaneManager.register("search", this.searchManager);
        if (Globals.prefs.getBoolean("searchPanelVisible")) {
            this.sidePaneManager.show("search");
        }
    }

    public void about() {
        JDialog about = new JDialog(this, Globals.lang("About JabRef"), true);
        JEditorPane jp = new JEditorPane();
        JScrollPane sp = new JScrollPane(jp, 20, 31);
        jp.setEditable(false);
        try {
            jp.setPage(GUIGlobals.class.getResource("/help/About.html"));
            jp.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            ((JEditorPane)e.getSource()).setPage(e.getURL());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            about.getContentPane().add(sp);
            about.setSize(GUIGlobals.aboutSize);
            Util.placeDialog(about, this);
            about.setVisible(true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not load file 'About.html'", "Error", 0);
        }
    }

    public void preferences() {
        AbstractWorker worker = new AbstractWorker(){

            public void run() {
                JabRefFrame.this.output(Globals.lang("Opening preferences..."));
                if (JabRefFrame.this.prefsDialog == null) {
                    JabRefFrame.this.prefsDialog = new PrefsDialog3(JabRefFrame.this);
                    Util.placeDialog(JabRefFrame.this.prefsDialog, JabRefFrame.this);
                } else {
                    JabRefFrame.this.prefsDialog.setValues();
                }
            }

            public void update() {
                JabRefFrame.this.prefsDialog.setVisible(true);
                JabRefFrame.this.output("");
            }
        };
        worker.getWorker().run();
        worker.getCallBack().update();
    }

    public JabRefPreferences prefs() {
        return this.prefs;
    }

    public void quit() {
        int i;
        boolean close = true;
        Vector<String> filenames = new Vector<String>();
        if (this.tabbedPane.getTabCount() > 0) {
            for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                block16: {
                    if (this.baseAt((int)i).baseChanged) {
                        this.tabbedPane.setSelectedIndex(i);
                        int answer = JOptionPane.showConfirmDialog(this, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                        if (answer == 2 || answer == -1) {
                            close = false;
                            return;
                        }
                        if (answer == 0) {
                            try {
                                SaveDatabaseAction saveAction = new SaveDatabaseAction(this.basePanel());
                                saveAction.runCommand();
                                if (!saveAction.isCancelled() && saveAction.isSuccess()) break block16;
                                this.output(Globals.lang("Unable to save database"));
                                close = false;
                            }
                            catch (Throwable ex) {
                                close = false;
                                break;
                            }
                        }
                    }
                }
                if (this.baseAt(i).getFile() == null) continue;
                filenames.add(this.baseAt(i).getFile().getAbsolutePath());
            }
        }
        if (close) {
            for (i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!this.baseAt(i).isSaving()) continue;
                WaitForSaveOperation w = new WaitForSaveOperation(this);
                w.show();
                if (!w.cancelled()) continue;
                return;
            }
            this.dispose();
            this.prefs.putInt("posX", this.getLocation().x);
            this.prefs.putInt("posY", this.getLocation().y);
            this.prefs.putInt("sizeX", this.getSize().width);
            this.prefs.putInt("sizeY", this.getSize().height);
            this.prefs.putBoolean("windowMaximised", this.getExtendedState() == 6);
            this.prefs.putBoolean("rememberWindowLocation", !Globals.prefs.getBoolean("windowMaximised"));
            this.prefs.putBoolean("searchPanelVisible", this.sidePaneManager.isComponentVisible("search"));
            int width = this.contentPane.getDividerLocation();
            if (width > 0) {
                this.prefs.putInt("sidePaneWidth", width);
            }
            if (this.prefs.getBoolean("openLastEdited")) {
                if (filenames.size() == 0) {
                    this.prefs.remove("lastEdited");
                } else {
                    String[] names = new String[filenames.size()];
                    for (int i2 = 0; i2 < filenames.size(); ++i2) {
                        names[i2] = (String)filenames.elementAt(i2);
                    }
                    this.prefs.putStringArray("lastEdited", names);
                }
            }
            this.fileHistory.storeHistory();
            this.prefs.customExports.store();
            this.prefs.customImports.store();
            BibtexEntryType.saveCustomEntryTypes(this.prefs);
            if (Globals.autoSaveManager != null) {
                Globals.autoSaveManager.clearAutoSaves();
            }
            if (this.basePanel() != null) {
                this.searchManager.updatePrefs();
            }
            this.prefs.flush();
            System.exit(0);
        }
    }

    private void macOSXRegistration() {
        if (Globals.osName.equals("Mac OS X")) {
            try {
                Class<?> osxAdapter = Class.forName("osxadapter.OSXAdapter");
                Class[] defArgs = new Class[]{JabRefFrame.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                if (registerMethod != null) {
                    Object[] args = new Object[]{this};
                    registerMethod.invoke(osxAdapter, args);
                }
                defArgs[0] = Boolean.TYPE;
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                if (prefsEnableMethod != null) {
                    Object[] args = new Object[]{Boolean.TRUE};
                    prefsEnableMethod.invoke(osxAdapter, args);
                }
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    private void initLayout() {
        this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.setProgressBarVisible(false);
        this.pushExternalButton = new PushToApplicationButton(this, PushToApplicationButton.applications);
        this.fillMenu();
        this.createToolBar();
        this.getContentPane().setLayout(this.gbl);
        this.contentPane.setDividerSize(2);
        this.contentPane.setBorder(null);
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 0;
        this.setJMenuBar(this.mb);
        this.con.anchor = 11;
        this.gbl.setConstraints(this.tlb, this.con);
        this.getContentPane().add(this.tlb);
        Component lim = Box.createGlue();
        this.gbl.setConstraints(lim, this.con);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.fill = 1;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 0, 0, 0);
        lim = Box.createGlue();
        this.gbl.setConstraints(lim, this.con);
        this.getContentPane().add(lim);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.contentPane, this.con);
        this.getContentPane().add(this.contentPane);
        this.contentPane.setRightComponent(this.tabbedPane);
        this.contentPane.setLeftComponent(this.sidePaneManager.getPanel());
        this.sidePaneManager.updateView();
        JPanel status = new JPanel();
        status.setLayout(this.gbl);
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(0, 2, 0, 0);
        this.gbl.setConstraints(this.statusLabel, this.con);
        status.add(this.statusLabel);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 4, 0, 0);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.statusLine, this.con);
        status.add(this.statusLine);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.progressBar, this.con);
        status.add(this.progressBar);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.statusLabel.setForeground(GUIGlobals.validFieldColor.darker());
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(status, this.con);
        this.getContentPane().add(status);
        EntryTableTransferHandler xfer = new EntryTableTransferHandler(null, this, null);
        this.tabbedPane.setTransferHandler(xfer);
        this.tlb.setTransferHandler(xfer);
        this.mb.setTransferHandler(xfer);
        this.sidePaneManager.getPanel().setTransferHandler(xfer);
    }

    private void initLabelMaker() {
        this.labelMaker = new LabelMaker();
        this.labelMaker.addRule(new ArticleLabelRule(), BibtexEntryType.ARTICLE);
        this.labelMaker.addRule(new BookLabelRule(), BibtexEntryType.BOOK);
        this.labelMaker.addRule(new IncollectionLabelRule(), BibtexEntryType.INCOLLECTION);
        this.labelMaker.addRule(new InproceedingsLabelRule(), BibtexEntryType.INPROCEEDINGS);
    }

    public BasePanel baseAt(int i) {
        return (BasePanel)this.tabbedPane.getComponentAt(i);
    }

    public void showBaseAt(int i) {
        this.tabbedPane.setSelectedIndex(i);
    }

    public void showBasePanel(BasePanel bp) {
        this.tabbedPane.setSelectedComponent(bp);
    }

    public BasePanel basePanel() {
        return (BasePanel)this.tabbedPane.getSelectedComponent();
    }

    public int baseCount() {
        return this.tabbedPane.getComponentCount();
    }

    private void markActiveBasePanel() {
        int now = this.tabbedPane.getSelectedIndex();
        int len = this.tabbedPane.getTabCount();
        if (this.lastTabbedPanelSelectionIndex > -1 && this.lastTabbedPanelSelectionIndex < len) {
            this.tabbedPane.setForegroundAt(this.lastTabbedPanelSelectionIndex, GUIGlobals.inActiveTabbed);
        }
        if (now > -1 && now < len) {
            this.tabbedPane.setForegroundAt(now, GUIGlobals.activeTabbed);
        }
        this.lastTabbedPanelSelectionIndex = now;
    }

    private int getTabIndex(JComponent comp) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != comp) continue;
            return i;
        }
        return -1;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getTabTitle(JComponent comp) {
        return this.tabbedPane.getTitleAt(this.getTabIndex(comp));
    }

    public String getTabTooltip(JComponent comp) {
        return this.tabbedPane.getToolTipTextAt(this.getTabIndex(comp));
    }

    public void setTabTitle(JComponent comp, String title, String toolTip) {
        int index = this.getTabIndex(comp);
        this.tabbedPane.setTitleAt(index, title);
        this.tabbedPane.setToolTipTextAt(index, toolTip);
    }

    public void setUpImportMenus() {
        this.setUpImportMenu(this.importMenu, false);
        this.setUpImportMenu(this.importNewMenu, true);
    }

    private void fillMenu() {
        int i;
        this.mb.setBorder(null);
        JMenu file = JabRefFrame.subMenu("File");
        JMenu sessions = JabRefFrame.subMenu("Sessions");
        JMenu edit = JabRefFrame.subMenu("Edit");
        JMenu bibtex = JabRefFrame.subMenu("BibTeX");
        JMenu view = JabRefFrame.subMenu("View");
        JMenu tools = JabRefFrame.subMenu("Tools");
        JMenu web = JabRefFrame.subMenu("Web search");
        JMenu options = JabRefFrame.subMenu("Options");
        JMenu newSpec = JabRefFrame.subMenu("New entry...");
        JMenu helpMenu = JabRefFrame.subMenu("Help");
        this.setUpImportMenus();
        this.newDatabaseMenu.add(this.newDatabaseAction);
        this.newDatabaseMenu.add(this.newSubDatabaseAction);
        file.add(this.newDatabaseAction);
        file.add(this.open);
        file.add(this.mergeDatabaseAction);
        file.add(this.save);
        file.add(this.saveAs);
        file.add(this.saveAll);
        file.add(this.saveSelectedAs);
        file.addSeparator();
        file.add(this.importNew);
        file.add(this.importCurrent);
        file.add(this.exportAll);
        file.add(this.exportSelected);
        file.add(this.dbConnect);
        file.add(this.dbImport);
        file.add(this.dbExport);
        file.addSeparator();
        file.add(this.databaseProperties);
        file.addSeparator();
        sessions.add(this.loadSessionAction);
        sessions.add(this.saveSessionAction);
        file.add(sessions);
        file.add(this.fileHistory);
        file.addSeparator();
        file.add(this.close);
        file.add(this.quit);
        this.mb.add(file);
        edit.add(this.undo);
        edit.add(this.redo);
        edit.addSeparator();
        edit.add(this.cut);
        edit.add(this.copy);
        edit.add(this.paste);
        edit.add(this.delete);
        edit.add(this.copyKey);
        edit.add(this.copyCiteKey);
        edit.addSeparator();
        edit.add(this.mark);
        JMenu markSpecific = JabRefFrame.subMenu("Mark specific color");
        for (i = 0; i < Util.MAX_MARKING_LEVEL; ++i) {
            markSpecific.add(new MarkEntriesAction(this, i).getMenuItem());
        }
        edit.add(markSpecific);
        edit.add(this.unmark);
        edit.add(this.unmarkAll);
        edit.addSeparator();
        edit.add(this.selectAll);
        this.mb.add(edit);
        view.add(this.back);
        view.add(this.forward);
        view.add(this.focusTable);
        view.add(this.nextTab);
        view.add(this.prevTab);
        view.add(this.sortTabs);
        view.addSeparator();
        view.add(this.increaseFontSize);
        view.add(this.decreseFontSize);
        view.addSeparator();
        view.add(this.toggleGroups);
        view.add(this.togglePreview);
        view.add(this.switchPreview);
        view.addSeparator();
        view.add(this.toggleHighlightAny);
        view.add(this.toggleHighlightAll);
        this.mb.add(view);
        bibtex.add(this.newEntryAction);
        for (i = 0; i < this.newSpecificEntryAction.length; ++i) {
            newSpec.add(this.newSpecificEntryAction[i]);
        }
        bibtex.add(newSpec);
        bibtex.add(this.plainTextImport);
        bibtex.addSeparator();
        bibtex.add(this.editEntry);
        bibtex.add(this.importCiteSeer);
        bibtex.add(this.editPreamble);
        bibtex.add(this.editStrings);
        this.mb.add(bibtex);
        tools.add(this.normalSearch);
        tools.add(this.incrementalSearch);
        tools.add(this.replaceAll);
        tools.add(new MassSetFieldAction(this));
        tools.add(this.makeKeyAction);
        tools.add(this.checkAndFix);
        this.checkAndFix.add(this.dupliCheck);
        this.checkAndFix.add(this.resolveDuplicateKeys);
        this.checkAndFix.add(this.autoSetFile);
        this.checkAndFix.add(this.autoSetPdf);
        this.checkAndFix.add(this.autoSetPs);
        this.checkAndFix.add(this.integrityCheckAction);
        this.checkAndFix.addSeparator();
        this.checkAndFix.add(this.upgradeExternalLinks);
        tools.addSeparator();
        tools.add(this.manageSelectors);
        tools.add(this.pushExternalButton.getMenuAction());
        tools.add(this.writeXmpAction);
        tools.addSeparator();
        tools.add(this.openFile);
        tools.add(this.openPdf);
        tools.add(this.openUrl);
        tools.addSeparator();
        tools.add(this.newSubDatabaseAction);
        tools.addSeparator();
        tools.add(this.abbreviateIso);
        tools.add(this.abbreviateMedline);
        tools.add(this.unabbreviate);
        this.mb.add(tools);
        web.add(this.fetchCiteSeer);
        for (EntryFetcher fetcher : this.fetchers) {
            GeneralFetcher generalFetcher = new GeneralFetcher(this.sidePaneManager, this, fetcher);
            generalFetcher.setHelpResourceOwner(fetcher.getClass());
            web.add(generalFetcher.getAction());
            this.fetcherActions.add(generalFetcher.getAction());
        }
        this.mb.add(web);
        options.add(this.showPrefs);
        CustomizeEntryTypeAction customizeAction = new CustomizeEntryTypeAction();
        GenFieldsCustomizationAction genFieldsCustomization = new GenFieldsCustomizationAction();
        options.add(customizeAction);
        options.add(genFieldsCustomization);
        options.add(this.customExpAction);
        options.add(this.customImpAction);
        options.add(this.customFileTypesAction);
        options.add(this.manageJournals);
        this.pluginMenu.add(this.installPlugin);
        this.mb.add(this.pluginMenu);
        this.mb.add(options);
        helpMenu.add(this.help);
        helpMenu.add(this.contents);
        helpMenu.addSeparator();
        helpMenu.add(this.about);
        this.mb.add(helpMenu);
        helpMenu.addSeparator();
        helpMenu.add(this.errorConsole);
    }

    public static JMenu subMenu(String name) {
        JMenu res;
        int i = (name = Globals.menuTitle(name)).indexOf(38);
        if (i >= 0) {
            res = new JMenu(name.substring(0, i) + name.substring(i + 1));
            char mnemonic = Character.toUpperCase(name.charAt(i + 1));
            res.setMnemonic((int)mnemonic);
        } else {
            res = new JMenu(name);
        }
        return res;
    }

    public void addPluginMenuItem(JMenuItem item) {
        if (!this.addedToPluginMenu) {
            this.pluginMenu.addSeparator();
            this.addedToPluginMenu = true;
        }
        this.pluginMenu.add(item);
    }

    private void createToolBar() {
        this.tlb.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.tlb.setBorder(null);
        this.tlb.setRollover(true);
        this.tlb.setFloatable(false);
        this.tlb.addAction(this.newDatabaseAction);
        this.tlb.addAction(this.open);
        this.tlb.addAction(this.save);
        this.tlb.addAction(this.saveAll);
        this.tlb.addSeparator();
        this.tlb.addAction(this.cut);
        this.tlb.addAction(this.copy);
        this.tlb.addAction(this.paste);
        this.tlb.addAction(this.undo);
        this.tlb.addAction(this.redo);
        this.tlb.addSeparator();
        this.tlb.addAction(this.back);
        this.tlb.addAction(this.forward);
        this.tlb.addSeparator();
        this.tlb.addAction(this.newEntryAction);
        this.tlb.addAction(this.editEntry);
        this.tlb.addAction(this.editPreamble);
        this.tlb.addAction(this.editStrings);
        this.tlb.addAction(this.makeKeyAction);
        this.tlb.addSeparator();
        this.tlb.addAction(this.mark);
        this.tlb.addAction(this.unmark);
        this.tlb.addSeparator();
        this.searchToggle = new JToggleButton(this.toggleSearch);
        this.searchToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.searchToggle.setMargin(this.marg);
        }
        this.tlb.add(this.searchToggle);
        this.previewToggle = new JToggleButton(this.togglePreview);
        this.previewToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.previewToggle.setMargin(this.marg);
        }
        this.tlb.add(this.previewToggle);
        this.tlb.addSeparator();
        this.groupToggle = new JToggleButton(this.toggleGroups);
        this.groupToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.groupToggle.setMargin(this.marg);
        }
        this.tlb.add(this.groupToggle);
        this.highlightAny = new JToggleButton(this.toggleHighlightAny);
        this.highlightAny.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAny.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAny);
        this.highlightAll = new JToggleButton(this.toggleHighlightAll);
        this.highlightAll.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAll.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAll);
        this.tlb.addSeparator();
        this.tlb.add(this.pushExternalButton.getComponent());
        this.tlb.addAction(this.openFile);
        this.tlb.add(Box.createHorizontalGlue());
        this.tlb.addAction(this.closeDatabaseAction);
    }

    public void output(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JabRefFrame.this.statusLine.setText(s);
                JabRefFrame.this.statusLine.repaint();
            }
        });
    }

    public void stopShowingSearchResults() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).stopShowingSearchResults();
        }
    }

    protected void initActions() {
        this.openDatabaseOnlyActions = new LinkedList<Object>();
        this.openDatabaseOnlyActions.addAll(Arrays.asList(this.manageSelectors, this.mergeDatabaseAction, this.newSubDatabaseAction, this.close, this.save, this.saveAs, this.saveSelectedAs, this.undo, this.redo, this.cut, this.delete, this.copy, this.paste, this.mark, this.unmark, this.unmarkAll, this.editEntry, this.importCiteSeer, this.selectAll, this.copyKey, this.copyCiteKey, this.editPreamble, this.editStrings, this.toggleGroups, this.toggleSearch, this.makeKeyAction, this.normalSearch, this.incrementalSearch, this.replaceAll, this.importMenu, this.exportMenu, this.fetchCiteSeer, this.openPdf, this.openUrl, this.openFile, this.openSpires, this.togglePreview, this.dupliCheck, this.highlightAll, this.highlightAny, this.newEntryAction, this.plainTextImport, this.closeDatabaseAction, this.switchPreview, this.integrityCheckAction, this.autoSetPdf, this.autoSetPs, this.toggleHighlightAny, this.toggleHighlightAll, this.databaseProperties, this.abbreviateIso, this.abbreviateMedline, this.unabbreviate, this.exportAll, this.exportSelected, this.importCurrent, this.saveAll, this.dbConnect, this.dbExport, this.focusTable));
        this.openDatabaseOnlyActions.addAll(this.fetcherActions);
        this.openDatabaseOnlyActions.addAll(Arrays.asList(this.newSpecificEntryAction));
        this.severalDatabasesOnlyActions = new LinkedList<Object>();
        this.severalDatabasesOnlyActions.addAll(Arrays.asList(this.nextTab, this.prevTab, this.sortTabs));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                JabRefFrame.this.updateEnabledState();
            }
        });
    }

    public static void setEnabled(List<Object> list, boolean enabled) {
        for (Object o : list) {
            if (o instanceof Action) {
                ((Action)o).setEnabled(enabled);
            }
            if (!(o instanceof Component)) continue;
            ((Component)o).setEnabled(enabled);
        }
    }

    protected void updateEnabledState() {
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount != this.previousTabCount) {
            this.previousTabCount = tabCount;
            JabRefFrame.setEnabled(this.openDatabaseOnlyActions, tabCount > 0);
            JabRefFrame.setEnabled(this.severalDatabasesOnlyActions, tabCount > 1);
        }
        if (tabCount == 0) {
            this.back.setEnabled(false);
            this.forward.setEnabled(false);
        }
    }

    public void setupAllTables() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel bf = this.baseAt(i);
            if (bf.database == null) continue;
            bf.setupMainPanel();
        }
    }

    public BasePanel addTab(BibtexDatabase db, File file, HashMap<String, String> meta, String encoding, boolean raisePanel) {
        BasePanel bp = new BasePanel(this, db, file, meta, encoding);
        this.addTab(bp, file, raisePanel);
        return bp;
    }

    public BasePanel addTab(BibtexDatabase db, File file, MetaData meta, String encoding, boolean raisePanel) {
        BasePanel bp = new BasePanel(this, db, file, meta, encoding);
        this.addTab(bp, file, raisePanel);
        return bp;
    }

    public void addTab(BasePanel bp, File file, boolean raisePanel) {
        this.tabbedPane.add(file != null ? file.getName() : Globals.lang(GUIGlobals.untitledTitle), bp);
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, file != null ? file.getAbsolutePath() : null);
        if (raisePanel) {
            this.tabbedPane.setSelectedComponent(bp);
        }
    }

    public void closeCurrentTab() {
        this.closeDatabaseAction.actionPerformed(null);
    }

    public void closeCurrentTabNoWarning() {
        this.closeDatabaseAction.close();
    }

    public void addImportedEntries(final BasePanel panel, final List<BibtexEntry> entries, String filename, final boolean openInNew) {
        if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || entries.size() > 1)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImportInspectionDialog diag = new ImportInspectionDialog(JabRefFrame.this, panel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), openInNew);
                    diag.addEntries(entries);
                    diag.entryListComplete();
                    Util.placeDialog(diag, JabRefFrame.this);
                    diag.setVisible(true);
                    diag.toFront();
                }
            });
        } else {
            this.addBibEntries(entries, filename, openInNew);
            if (panel != null && entries.size() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        panel.highlightEntry((BibtexEntry)entries.get(0));
                    }
                });
            }
        }
    }

    public int addBibEntries(List<BibtexEntry> bibentries, String filename, boolean intoNew) {
        if (bibentries == null || bibentries.size() == 0) {
            JOptionPane.showMessageDialog(this, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            return 0;
        }
        int addedEntries = 0;
        Util.setAutomaticFields(bibentries, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), Globals.prefs.getBoolean("markImportedEntries"));
        if (intoNew || this.tabbedPane.getTabCount() == 0) {
            BibtexDatabase database = new BibtexDatabase();
            for (BibtexEntry entry : bibentries) {
                try {
                    entry.setId(Util.createNeutralId());
                    database.insertEntry(entry);
                }
                catch (KeyCollisionException ex) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            HashMap<String, String> meta = new HashMap<String, String>();
            BasePanel bp = new BasePanel(this, database, null, meta, Globals.prefs.get("defaultEncoding"));
            addedEntries = database.getEntryCount();
            this.tabbedPane.add(GUIGlobals.untitledTitle, bp);
            bp.markBaseChanged();
            this.tabbedPane.setSelectedComponent(bp);
            if (filename != null) {
                this.output(Globals.lang("Imported database") + " '" + filename + "' " + Globals.lang("with") + " " + database.getEntryCount() + " " + Globals.lang("entries into new database") + ".");
            }
        } else {
            boolean checkForDuplicates = true;
            BasePanel basePanel = this.basePanel();
            BibtexDatabase database = basePanel.database;
            int oldCount = database.getEntryCount();
            NamedCompound ce = new NamedCompound(Globals.lang("Import entries"));
            block5: for (BibtexEntry entry : bibentries) {
                boolean dupli = false;
                if (checkForDuplicates) {
                    Iterator<String> i2 = database.getKeySet().iterator();
                    while (i2.hasNext()) {
                        BibtexEntry existingEntry = database.getEntryById(i2.next());
                        if (!DuplicateCheck.isDuplicate(entry, existingEntry)) continue;
                        DuplicateResolverDialog drd = new DuplicateResolverDialog(this, existingEntry, entry, 2);
                        drd.setVisible(true);
                        int res = drd.getSelected();
                        if (res == 2) {
                            dupli = true;
                            break;
                        }
                        if (res == 1) {
                            database.removeEntry(existingEntry.getId());
                            ce.addEdit(new UndoableRemoveEntry(database, existingEntry, basePanel));
                            break;
                        }
                        if (res == 5) break block5;
                    }
                }
                if (dupli) continue;
                try {
                    entry.setId(Util.createNeutralId());
                    database.insertEntry(entry);
                    ce.addEdit(new UndoableInsertEntry(database, entry, basePanel));
                    ++addedEntries;
                }
                catch (KeyCollisionException ex) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            if (addedEntries > 0) {
                ce.end();
                basePanel.undoManager.addEdit(ce);
                basePanel.markBaseChanged();
                if (filename != null) {
                    this.output(Globals.lang("Imported database") + " '" + filename + "' " + Globals.lang("with") + " " + (database.getEntryCount() - oldCount) + " " + Globals.lang("entries into new database") + ".");
                }
            }
        }
        return addedEntries;
    }

    private void setUpImportMenu(JMenu importMenu, boolean intoNew_) {
        boolean intoNew = intoNew_;
        importMenu.removeAll();
        importMenu.add(new ImportMenuItem(this, intoNew));
        importMenu.addSeparator();
        SortedSet<ImportFormat> customImporters = Globals.importFormatReader.getCustomImportFormats();
        JMenu submenu = new JMenu(Globals.lang("Custom importers"));
        submenu.setMnemonic(83);
        for (ImportFormat imFo : customImporters) {
            submenu.add(new ImportMenuItem(this, intoNew, imFo));
        }
        if (customImporters.size() > 0) {
            submenu.addSeparator();
        }
        submenu.add(this.customImpAction);
        importMenu.add(submenu);
        importMenu.addSeparator();
        for (ImportFormat imFo : Globals.importFormatReader.getBuiltInInputFormats()) {
            importMenu.add(new ImportMenuItem(this, intoNew, imFo));
        }
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public void setPreviewActive(boolean enabled) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).setPreviewActive(enabled);
        }
    }

    public void removeCachedEntryEditors() {
        for (int j = 0; j < this.tabbedPane.getTabCount(); ++j) {
            BasePanel bp = (BasePanel)this.tabbedPane.getComponentAt(j);
            bp.entryEditors.clear();
        }
    }

    public void block() {
        this.getGlassPane().setVisible(true);
    }

    public void unblock() {
        this.getGlassPane().setVisible(false);
    }

    public void setProgressBarVisible(final boolean visible) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setVisible(visible);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JabRefFrame.this.progressBar.setVisible(visible);
                }
            });
        }
    }

    public void setProgressBarValue(final int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JabRefFrame.this.progressBar.setValue(value);
                }
            });
        }
    }

    public void setProgressBarIndeterminate(final boolean value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setIndeterminate(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JabRefFrame.this.progressBar.setIndeterminate(value);
                }
            });
        }
    }

    public void setProgressBarMaximum(final int value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setMaximum(value);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JabRefFrame.this.progressBar.setMaximum(value);
                }
            });
        }
    }

    @Override
    public void showMessage(Object message, String title, int msgType) {
        JOptionPane.showMessageDialog(this, message, title, msgType);
    }

    @Override
    public void setStatus(String s) {
        this.output(s);
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private class MyGlassPane
    extends JPanel {
        public MyGlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }

        public boolean isOpaque() {
            return false;
        }
    }

    class DecreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public DecreaseTableFontSizeAction() {
            this.putValue("Name", "Decrease table font size");
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Decrease table font size"));
        }

        public void actionPerformed(ActionEvent event) {
            Font newFont;
            int currentSize = GUIGlobals.CURRENTFONT.getSize();
            if (currentSize < 2) {
                return;
            }
            GUIGlobals.CURRENTFONT = newFont = new Font(GUIGlobals.CURRENTFONT.getFamily(), GUIGlobals.CURRENTFONT.getStyle(), currentSize - 1);
            Globals.prefs.putInt("fontSize", currentSize - 1);
            for (int i = 0; i < JabRefFrame.this.baseCount(); ++i) {
                JabRefFrame.this.baseAt(i).updateTableFont();
            }
        }
    }

    class IncreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public IncreaseTableFontSizeAction() {
            this.putValue("Name", "Increase table font size");
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Increase table font size"));
        }

        public void actionPerformed(ActionEvent event) {
            Font newFont;
            int currentSize = GUIGlobals.CURRENTFONT.getSize();
            GUIGlobals.CURRENTFONT = newFont = new Font(GUIGlobals.CURRENTFONT.getFamily(), GUIGlobals.CURRENTFONT.getStyle(), currentSize + 1);
            Globals.prefs.putInt("fontSize", currentSize + 1);
            for (int i = 0; i < JabRefFrame.this.baseCount(); ++i) {
                JabRefFrame.this.baseAt(i).updateTableFont();
            }
        }
    }

    class DatabasePropertiesAction
    extends MnemonicAwareAction {
        DatabasePropertiesDialog propertiesDialog = null;

        public DatabasePropertiesAction() {
            this.putValue("Name", "Database properties");
        }

        public void actionPerformed(ActionEvent e) {
            if (this.propertiesDialog == null) {
                this.propertiesDialog = new DatabasePropertiesDialog(JabRefFrame.this);
            }
            this.propertiesDialog.setPanel(JabRefFrame.this.basePanel());
            Util.placeDialog(this.propertiesDialog, JabRefFrame.this);
            this.propertiesDialog.setVisible(true);
        }
    }

    class GenFieldsCustomizationAction
    extends MnemonicAwareAction {
        public GenFieldsCustomizationAction() {
            this.putValue("Name", "Set up general fields");
        }

        public void actionPerformed(ActionEvent e) {
            GenFieldsCustomizer gf = new GenFieldsCustomizer(JabRefFrame.this);
            Util.placeDialog(gf, JabRefFrame.this);
            gf.setVisible(true);
        }
    }

    class CustomizeEntryTypeAction
    extends MnemonicAwareAction {
        public CustomizeEntryTypeAction() {
            this.putValue("Name", "Customize entry types");
        }

        public void actionPerformed(ActionEvent e) {
            EntryCustomizationDialog2 dl = new EntryCustomizationDialog2(JabRefFrame.this);
            Util.placeDialog(dl, JabRefFrame.this);
            dl.setVisible(true);
        }
    }

    class CustomizeImportsAction
    extends MnemonicAwareAction {
        public CustomizeImportsAction() {
            this.putValue("Name", "Manage custom imports");
        }

        public void actionPerformed(ActionEvent e) {
            ImportCustomizationDialog ecd = new ImportCustomizationDialog(JabRefFrame.this);
            ecd.setVisible(true);
        }
    }

    class CustomizeExportsAction
    extends MnemonicAwareAction {
        public CustomizeExportsAction() {
            this.putValue("Name", "Manage custom exports");
        }

        public void actionPerformed(ActionEvent e) {
            ExportCustomizationDialog ecd = new ExportCustomizationDialog(JabRefFrame.this);
            ecd.setVisible(true);
        }
    }

    class EditAction
    extends MnemonicAwareAction {
        private String command;

        public EditAction(String command, URL icon) {
            super(new ImageIcon(icon));
            this.command = command;
            String nName = Util.nCase(command);
            this.putValue("Name", nName);
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey(nName));
            this.putValue("ShortDescription", Globals.lang(nName));
        }

        public void actionPerformed(ActionEvent e) {
            JComponent source = Globals.focusListener.getFocused();
            try {
                source.getActionMap().get(this.command).actionPerformed(new ActionEvent(source, 0, this.command));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class ChangeTabAction
    extends MnemonicAwareAction {
        private boolean next;

        public ChangeTabAction(boolean next) {
            this.putValue("Name", next ? "Next tab" : "Previous tab");
            this.next = next;
            this.putValue("AcceleratorKey", next ? JabRefFrame.this.prefs.getKey("Next tab") : JabRefFrame.this.prefs.getKey("Previous tab"));
        }

        public void actionPerformed(ActionEvent e) {
            int newI;
            int i = JabRefFrame.this.tabbedPane.getSelectedIndex();
            int n = newI = this.next ? i + 1 : i - 1;
            if (newI < 0) {
                newI = JabRefFrame.this.tabbedPane.getTabCount() - 1;
            }
            if (newI == JabRefFrame.this.tabbedPane.getTabCount()) {
                newI = 0;
            }
            JabRefFrame.this.tabbedPane.setSelectedIndex(newI);
        }
    }

    class LoadSessionAction
    extends MnemonicAwareAction {
        boolean running;

        public LoadSessionAction() {
            super(GUIGlobals.getImage("loadSession"));
            this.running = false;
            this.putValue("Name", "Load session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Load session"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.prefs.get("savedSession") == null) {
                JabRefFrame.this.output(Globals.lang("No saved session found."));
                return;
            }
            if (this.running) {
                return;
            }
            this.running = true;
            JabRefFrame.this.output(Globals.lang("Loading session..."));
            new Thread(){

                public void run() {
                    HashSet<String> currentFiles = new HashSet<String>();
                    if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                        for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                            if (JabRefFrame.this.baseAt(i).getFile() == null) continue;
                            currentFiles.add(JabRefFrame.this.baseAt(i).getFile().getPath());
                        }
                    }
                    int i0 = JabRefFrame.this.tabbedPane.getTabCount();
                    String[] names = JabRefFrame.this.prefs.getStringArray("savedSession");
                    for (int i = 0; i < names.length; ++i) {
                        File file;
                        if (currentFiles.contains(names[i]) || !(file = new File(names[i])).exists()) continue;
                        JabRefFrame.this.open.openIt(file, i == 0);
                    }
                    JabRefFrame.this.output(Globals.lang("Files opened") + ": " + (JabRefFrame.this.tabbedPane.getTabCount() - i0));
                    LoadSessionAction.this.running = false;
                }
            }.start();
        }
    }

    class SaveSessionAction
    extends MnemonicAwareAction {
        public SaveSessionAction() {
            super(GUIGlobals.getImage("save"));
            this.putValue("Name", "Save session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Save session"));
        }

        public void actionPerformed(ActionEvent e) {
            Vector<String> filenames = new Vector<String>();
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    if (JabRefFrame.this.tabbedPane.getTitleAt(i).equals(GUIGlobals.untitledTitle)) {
                        JabRefFrame.this.tabbedPane.setSelectedIndex(i);
                        int answer = JOptionPane.showConfirmDialog(JabRefFrame.this, Globals.lang("This untitled database must be saved first to be included in the saved session. Save now?"), Globals.lang("Save database"), 0);
                        if (answer == 0) {
                            try {
                                JabRefFrame.this.basePanel().runCommand("save");
                            }
                            catch (Throwable ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (JabRefFrame.this.baseAt(i).getFile() == null) continue;
                    filenames.add(JabRefFrame.this.baseAt(i).getFile().getPath());
                }
            }
            if (filenames.size() == 0) {
                JabRefFrame.this.output(Globals.lang("Not saved (empty session)") + ".");
                return;
            }
            String[] names = new String[filenames.size()];
            for (int i = 0; i < filenames.size(); ++i) {
                names[i] = (String)filenames.elementAt(i);
            }
            JabRefFrame.this.prefs.putStringArray("savedSession", names);
            JabRefFrame.this.output(Globals.lang("Saved session") + ".");
        }
    }

    class ShowPrefsAction
    extends MnemonicAwareAction {
        public ShowPrefsAction() {
            super(GUIGlobals.getImage("preferences"));
            this.putValue("Name", "Preferences");
            this.putValue("ShortDescription", Globals.lang("Preferences"));
        }

        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.preferences();
        }
    }

    class IntegrityCheckAction
    extends AbstractAction {
        public IntegrityCheckAction() {
            super(Globals.menuTitle("Integrity check"), GUIGlobals.getImage("integrityCheck"));
        }

        public void actionPerformed(ActionEvent e) {
            BasePanel bp;
            BibtexDatabase refBase;
            Component selComp = JabRefFrame.this.tabbedPane.getSelectedComponent();
            if (selComp != null && (refBase = (bp = (BasePanel)selComp).getDatabase()) != null) {
                IntegrityWizard wizard = new IntegrityWizard(JabRefFrame.this, JabRefFrame.this.basePanel());
                Util.placeDialog(wizard, JabRefFrame.this);
                wizard.setVisible(true);
            }
        }
    }

    class NewSubDatabaseAction
    extends MnemonicAwareAction {
        public NewSubDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New subdatabase based on AUX file");
            this.putValue("ShortDescription", Globals.lang("New BibTeX subdatabase"));
        }

        public void actionPerformed(ActionEvent e) {
            FromAuxDialog dialog = new FromAuxDialog(JabRefFrame.this, "", true, JabRefFrame.this.tabbedPane);
            Util.placeDialog(dialog, JabRefFrame.this);
            dialog.setVisible(true);
            if (dialog.okPressed()) {
                BasePanel bp = new BasePanel(JabRefFrame.this, dialog.getGenerateDB(), null, (HashMap<String, String>)null, Globals.prefs.get("defaultEncoding"));
                JabRefFrame.this.tabbedPane.add(Globals.lang(GUIGlobals.untitledTitle), bp);
                JabRefFrame.this.tabbedPane.setSelectedComponent(bp);
                JabRefFrame.this.output(Globals.lang("New database created."));
            }
        }
    }

    class FetchCiteSeerAction
    extends MnemonicAwareAction {
        public FetchCiteSeerAction() {
            super(GUIGlobals.getImage("citeseer"));
            this.putValue("Name", "Fetch citations from CiteSeer");
            this.putValue("ShortDescription", Globals.lang("Fetch Articles Citing your Database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Fetch citations from CiteSeer"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.citeSeerFetcher.activateCitationFetcher()) {
                JabRefFrame.this.sidePaneManager.show("CiteSeerProgress");
                new Thread(){
                    BasePanel newBp;
                    BasePanel targetBp;
                    BibtexDatabase newDatabase;
                    BibtexDatabase targetDatabase;
                    Runnable updateComponent = new Runnable(){

                        private void setSortingByCitationCount() {
                            newBp.sortingByCiteSeerResults = true;
                        }

                        public void run() {
                            this.setSortingByCitationCount();
                            JabRefFrame.this.tabbedPane.add(Globals.lang(GUIGlobals.untitledTitle), newBp);
                            JabRefFrame.this.tabbedPane.setSelectedComponent(newBp);
                            JabRefFrame.this.output(Globals.lang("Fetched all citations from target database."));
                            JabRefFrame.this.citeSeerFetcher.deactivateCitationFetcher();
                        }
                    };

                    public void run() {
                        try {
                            this.newBp = new BasePanel(JabRefFrame.this);
                            this.targetBp = (BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent();
                            this.newDatabase = this.newBp.getDatabase();
                            this.targetDatabase = this.targetBp.getDatabase();
                            int errorCode = JabRefFrame.this.citeSeerFetcher.populate(this.newDatabase, this.targetDatabase);
                            if (this.newDatabase.getEntryCount() > 0) {
                                SwingUtilities.invokeLater(this.updateComponent);
                            } else if (errorCode == 0) {
                                SwingUtilities.invokeLater(JabRefFrame.this.citeSeerFetcher.getEmptyFetchSetDialog());
                            } else {
                                JabRefFrame.this.citeSeerFetcher.deactivateCitationFetcher();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(JabRefFrame.this.tabbedPane.getSelectedComponent(), Globals.lang("A CiteSeer fetch operation is currently in progress.") + "  " + Globals.lang("Please wait until it has finished."), Globals.lang("CiteSeer Fetch Error"), 2);
            }
        }
    }

    class ImportCiteSeerAction
    extends MnemonicAwareAction {
        public ImportCiteSeerAction() {
            super(GUIGlobals.getImage("citeseer"));
            this.putValue("Name", "Import Fields from CiteSeer");
            this.putValue("ShortDescription", Globals.lang("Import Fields from CiteSeer Database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Import Fields from CiteSeer"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.citeSeerFetcher.activateImportFetcher()) {
                new Thread(){
                    BasePanel currentBp;
                    int[] clickedOn = null;

                    public void run() {
                        this.currentBp = (BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent();
                        int rowCount = this.currentBp.mainTable.getSelectedRowCount();
                        if (rowCount >= 1) {
                            this.clickedOn = this.currentBp.mainTable.getSelectedRows();
                        } else {
                            JOptionPane.showMessageDialog(this.currentBp.frame(), Globals.lang("You must select at least one row to perform this operation."), Globals.lang("CiteSeer Import Error"), 2);
                        }
                        if (this.clickedOn != null) {
                            JabRefFrame.this.citeSeerFetcher.beginImportCiteSeerProgress();
                            NamedCompound citeseerNamedCompound = new NamedCompound(Globals.lang("CiteSeer Import Fields"));
                            boolean newValues = JabRefFrame.this.citeSeerFetcher.importCiteSeerEntries(this.clickedOn, citeseerNamedCompound);
                            if (newValues) {
                                citeseerNamedCompound.end();
                                this.currentBp.undoManager.addEdit(citeseerNamedCompound);
                            }
                            UpdateComponent updateComponent = new UpdateComponent(newValues);
                            SwingUtilities.invokeLater(updateComponent);
                        }
                        JabRefFrame.this.citeSeerFetcher.deactivateImportFetcher();
                    }

                    class UpdateComponent
                    implements Runnable {
                        boolean changesMade;

                        UpdateComponent(boolean changesMade) {
                            this.changesMade = changesMade;
                        }

                        public void run() {
                            JabRefFrame.this.citeSeerFetcher.endImportCiteSeerProgress();
                            if (this.changesMade) {
                                currentBp.markBaseChanged();
                            }
                            JabRefFrame.this.output(Globals.lang("Completed Import Fields from CiteSeer."));
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(JabRefFrame.this.tabbedPane.getSelectedComponent(), Globals.lang("A CiteSeer import operation is currently in progress.") + "  " + Globals.lang("Please wait until it has finished."), Globals.lang("CiteSeer Import Error"), 2);
            }
        }
    }

    class NewDatabaseAction
    extends MnemonicAwareAction {
        public NewDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New database");
            this.putValue("ShortDescription", Globals.lang("New BibTeX database"));
        }

        public void actionPerformed(ActionEvent e) {
            BibtexDatabase database = new BibtexDatabase();
            JabRefFrame.this.addTab(database, null, (HashMap<String, String>)null, Globals.prefs.get("defaultEncoding"), true);
            JabRefFrame.this.output(Globals.lang("New database created."));
        }
    }

    class CloseDatabaseAction
    extends MnemonicAwareAction {
        public CloseDatabaseAction() {
            super(GUIGlobals.getImage("close"));
            this.putValue("Name", "Close database");
            this.putValue("ShortDescription", Globals.lang("Close the current database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Close database"));
        }

        public void actionPerformed(ActionEvent e) {
            boolean close = true;
            if (JabRefFrame.this.basePanel() == null) {
                return;
            }
            if (JabRefFrame.this.basePanel().baseChanged) {
                int answer = JOptionPane.showConfirmDialog(JabRefFrame.this, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                if (answer == 2 || answer == -1) {
                    close = false;
                }
                if (answer == 0) {
                    try {
                        SaveDatabaseAction saveAction = new SaveDatabaseAction(JabRefFrame.this.basePanel());
                        saveAction.runCommand();
                        if (saveAction.isCancelled() || !saveAction.isSuccess()) {
                            close = false;
                        }
                    }
                    catch (Throwable ex) {
                        close = false;
                    }
                }
            }
            if (close) {
                this.close();
            }
        }

        public void close() {
            BasePanel pan = JabRefFrame.this.basePanel();
            pan.cleanUp();
            AutoSaveManager.deleteAutoSaveFile(pan);
            JabRefFrame.this.tabbedPane.remove(pan);
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                JabRefFrame.this.markActiveBasePanel();
            }
            JabRefFrame.this.setWindowTitle();
            JabRefFrame.this.updateEnabledState();
            JabRefFrame.this.output(Globals.lang("Closed database") + ".");
            System.gc();
        }
    }

    class CloseAction
    extends MnemonicAwareAction {
        public CloseAction() {
            this.putValue("Name", "Quit");
            this.putValue("ShortDescription", Globals.lang("Quit JabRef"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Quit JabRef"));
        }

        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.quit();
        }
    }

    class SelectKeysAction
    extends AbstractAction {
        public SelectKeysAction() {
            super(Globals.lang("Customize key bindings"));
        }

        public void actionPerformed(ActionEvent e) {
            KeyBindingsDialog d = new KeyBindingsDialog(new HashMap<String, String>(JabRefFrame.this.prefs.getKeyBindings()), JabRefFrame.this.prefs.getDefaultKeys());
            d.setDefaultCloseOperation(3);
            d.pack();
            Util.placeDialog(d, JabRefFrame.this);
            d.setVisible(true);
            if (d.getAction()) {
                JabRefFrame.this.prefs.setNewKeyBindings(d.getNewKeyBindings());
                JOptionPane.showMessageDialog(JabRefFrame.this, Globals.lang("Your new key bindings have been stored.") + "\n" + Globals.lang("You must restart JabRef for the new key bindings to work properly."), Globals.lang("Key bindings changed"), 1);
            }
        }
    }

    class NewEntryAction
    extends MnemonicAwareAction {
        String type;
        KeyStroke keyStroke;

        public NewEntryAction(KeyStroke key) {
            super(GUIGlobals.getImage("add"));
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", "New entry");
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang("New BibTeX entry"));
        }

        public NewEntryAction(String type_) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", Util.nCase(type_));
            this.type = type_;
        }

        public NewEntryAction(String type_, KeyStroke key) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", Util.nCase(type_));
            this.putValue("AcceleratorKey", key);
            this.type = type_;
        }

        public void actionPerformed(ActionEvent e) {
            String thisType = this.type;
            if (thisType == null) {
                EntryTypeDialog etd = new EntryTypeDialog(JabRefFrame.this);
                Util.placeDialog(etd, JabRefFrame.this);
                etd.setVisible(true);
                BibtexEntryType tp = etd.getChoice();
                if (tp == null) {
                    return;
                }
                thisType = tp.getName();
            }
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).newEntry(BibtexEntryType.getType(thisType));
            } else {
                Util.pr("Action 'New entry' must be disabled when no database is open.");
            }
        }
    }

    class GeneralAction
    extends MnemonicAwareAction {
        private String command;

        public GeneralAction(String command, String text, String description, URL icon) {
            super(new ImageIcon(icon));
            this.command = command;
            this.putValue("Name", text);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public GeneralAction(String command, String text, String description, String imageName, KeyStroke key) {
            super(GUIGlobals.getImage(imageName));
            this.command = command;
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public GeneralAction(String command, String text) {
            this.putValue("Name", text);
            this.command = command;
        }

        public GeneralAction(String command, String text, KeyStroke key) {
            this.command = command;
            this.putValue("Name", text);
            this.putValue("AcceleratorKey", key);
        }

        public GeneralAction(String command, String text, String description) {
            this.command = command;
            ImageIcon icon = GUIGlobals.getImage(command);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            this.putValue("Name", text);
            this.putValue("ShortDescription", Globals.lang(description));
        }

        public GeneralAction(String command, String text, String description, KeyStroke key) {
            this.command = command;
            ImageIcon icon = GUIGlobals.getImage(command);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            this.putValue("Name", text);
            this.putValue("ShortDescription", Globals.lang(description));
            this.putValue("AcceleratorKey", key);
        }

        public void actionPerformed(ActionEvent e) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                try {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).runCommand(this.command);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            } else {
                Util.pr("Action '" + this.command + "' must be disabled when no " + "database is open.");
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(Globals.lang("About JabRef"));
        }

        public void actionPerformed(ActionEvent e) {
            JabRefFrame.this.about();
        }
    }

    class ToolBar
    extends JToolBar {
        ToolBar() {
        }

        void addAction(Action a) {
            JButton b = new JButton(a);
            b.setText(null);
            if (!Globals.ON_MAC) {
                b.setMargin(JabRefFrame.this.marg);
            }
            this.add(b);
        }
    }
}

