/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.undo.NamedCompound;

public class MarkEntriesAction
extends AbstractWorker
implements ActionListener {
    private JabRefFrame frame;
    final int level;
    private JMenuItem menuItem;
    private int besLength = 0;

    public MarkEntriesAction(JabRefFrame frame, int level) {
        this.frame = frame;
        this.level = level;
        this.menuItem = new JMenuItem("               ");
        this.menuItem.setMnemonic(String.valueOf(level + 1).charAt(0));
        this.menuItem.setBackground(Globals.prefs.getColor("markedEntryBackground" + this.level));
        this.menuItem.addActionListener(this);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.init();
            this.getWorker().run();
            this.getCallBack().update();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void run() {
        BasePanel panel = this.frame.basePanel();
        NamedCompound ce = new NamedCompound(Globals.lang("Mark entries"));
        BibtexEntry[] bes = panel.getSelectedEntries();
        this.besLength = bes.length;
        for (int i = 0; i < bes.length; ++i) {
            Util.markEntry(bes[i], this.level + 1, false, ce);
        }
        ce.end();
        panel.undoManager.addEdit(ce);
    }

    public void update() {
        this.frame.basePanel().markBaseChanged();
        this.frame.output(Globals.lang("Marked selected") + " " + Globals.lang(this.besLength > 0 ? "entry" : "entries"));
    }
}

