/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.UnknownExternalFileType;

public class ExternalFileMenuItem
extends JMenuItem
implements ActionListener {
    private BibtexEntry entry;
    final String link;
    final MetaData metaData;
    ExternalFileType fileType;
    final JabRefFrame frame;
    private String fieldName = null;

    public ExternalFileMenuItem(JabRefFrame frame, BibtexEntry entry, String name, String link, Icon icon, MetaData metaData, ExternalFileType fileType) {
        super(name, icon);
        this.frame = frame;
        this.entry = entry;
        this.link = link;
        this.metaData = metaData;
        this.fileType = fileType;
        this.addActionListener(this);
    }

    public ExternalFileMenuItem(JabRefFrame frame, BibtexEntry entry, String name, String link, Icon icon, MetaData metaData, String fieldName) {
        this(frame, entry, name, link, icon, metaData, (ExternalFileType)null);
        this.fieldName = fieldName;
    }

    public void actionPerformed(ActionEvent e) {
        boolean success = this.openLink();
        if (!success) {
            this.frame.output(Globals.lang("Unable to open link."));
        }
    }

    public boolean openLink() {
        this.frame.output(Globals.lang("External viewer called") + ".");
        try {
            ExternalFileType type = this.fileType;
            if (this.fileType == null) {
                if (this.fieldName != null) {
                    Util.openExternalViewer(this.frame.basePanel().metaData(), this.link, this.fieldName);
                    return true;
                }
                File file = new File(this.link);
                String name = file.getName();
                int pos = name.indexOf(46);
                String extension = pos >= 0 && pos < name.length() - 1 ? name.substring(pos + 1).trim().toLowerCase() : null;
                this.fileType = type = Globals.prefs.getExternalFileTypeByExt(extension);
            }
            if (type instanceof UnknownExternalFileType) {
                return Util.openExternalFileUnknown(this.frame, this.entry, this.metaData, this.link, (UnknownExternalFileType)type);
            }
            return Util.openExternalFileAnyFormat(this.metaData, this.link, type);
        }
        catch (IOException e1) {
            if (this.fileType != null && this.fileType.getOpenWith() != null && this.fileType.getOpenWith().length() > 0 && e1.getMessage().indexOf(this.fileType.getOpenWith()) >= 0) {
                JOptionPane.showMessageDialog(this.frame, Globals.lang("Unable to open link. The application '%0' associated with the file type '%1' could not be called.", this.fileType.getOpenWith(), this.fileType.getName()), Globals.lang("Could not open link"), 0);
                return false;
            }
            e1.printStackTrace();
            return false;
        }
    }
}

