/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UnsupportedVersionException;
import net.sf.jabref.util.QuotedStringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "ExplicitGroup:";
    private final Set<BibtexEntry> m_entries = new HashSet<BibtexEntry>();

    public ExplicitGroup(String name, int context) {
        super(name, context);
    }

    public static AbstractGroup fromString(String s, BibtexDatabase db, int version) throws Exception {
        if (!s.startsWith(ID)) {
            throw new Exception("Internal error: ExplicitGroup cannot be created from \"" + s + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        QuotedStringTokenizer tok = new QuotedStringTokenizer(s.substring(ID.length()), ";", '\\');
        switch (version) {
            case 0: 
            case 1: 
            case 2: {
                ExplicitGroup newGroup = new ExplicitGroup(tok.nextToken(), 0);
                newGroup.addEntries(tok, db);
                return newGroup;
            }
            case 3: {
                String name = tok.nextToken();
                int context = Integer.parseInt(tok.nextToken());
                ExplicitGroup newGroup = new ExplicitGroup(name, context);
                newGroup.addEntries(tok, db);
                return newGroup;
            }
        }
        throw new UnsupportedVersionException("ExplicitGroup", version);
    }

    protected void addEntries(QuotedStringTokenizer tok, BibtexDatabase db) {
        while (tok.hasMoreTokens()) {
            BibtexEntry[] entries = db.getEntriesByKey(Util.unquote(tok.nextToken(), '\\'));
            for (int i = 0; i < entries.length; ++i) {
                this.m_entries.add(entries[i]);
            }
        }
    }

    @Override
    public SearchRule getSearchRule() {
        return this;
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public AbstractUndoableEdit add(BibtexEntry[] entries) {
        if (entries.length == 0) {
            return null;
        }
        HashSet<BibtexEntry> entriesBeforeEdit = new HashSet<BibtexEntry>(this.m_entries);
        for (int i = 0; i < entries.length; ++i) {
            this.m_entries.add(entries[i]);
        }
        return new UndoableChangeAssignment(entriesBeforeEdit, this.m_entries);
    }

    public boolean addEntry(BibtexEntry entry) {
        return this.m_entries.add(entry);
    }

    @Override
    public AbstractUndoableEdit remove(BibtexEntry[] entries) {
        if (entries.length == 0) {
            return null;
        }
        HashSet<BibtexEntry> entriesBeforeEdit = new HashSet<BibtexEntry>(this.m_entries);
        for (int i = 0; i < entries.length; ++i) {
            this.m_entries.remove(entries[i]);
        }
        return new UndoableChangeAssignment(entriesBeforeEdit, this.m_entries);
    }

    public boolean removeEntry(BibtexEntry entry) {
        return this.m_entries.remove(entry);
    }

    @Override
    public boolean contains(BibtexEntry entry) {
        return this.m_entries.contains(entry);
    }

    @Override
    public boolean contains(Map<String, String> searchOptions, BibtexEntry entry) {
        return this.contains(entry);
    }

    @Override
    public int applyRule(Map<String, String> searchStrings, BibtexEntry bibtexEntry) {
        return this.contains(searchStrings, bibtexEntry) ? 1 : 0;
    }

    @Override
    public AbstractGroup deepCopy() {
        ExplicitGroup copy = new ExplicitGroup(this.m_name, this.m_context);
        copy.m_entries.addAll(this.m_entries);
        return copy;
    }

    public boolean equals(Object o) {
        String key;
        if (!(o instanceof ExplicitGroup)) {
            return false;
        }
        ExplicitGroup other = (ExplicitGroup)o;
        if (this.m_entries.size() != other.m_entries.size()) {
            return false;
        }
        HashSet<String> keys = new HashSet<String>();
        for (BibtexEntry entry : this.m_entries) {
            key = entry.getCiteKey();
            if (key == null) continue;
            keys.add(key);
        }
        for (BibtexEntry entry : other.m_entries) {
            key = entry.getCiteKey();
            if (key == null || keys.remove(key)) continue;
            return false;
        }
        if (!keys.isEmpty()) {
            return false;
        }
        return other.m_name.equals(this.m_name) && other.getHierarchicalContext() == this.getHierarchicalContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ID).append(Util.quote(this.m_name, ";", '\\')).append(";").append(this.m_context).append(";");
        TreeSet<String> sortedKeys = new TreeSet<String>();
        Iterator<BibtexEntry> it = this.m_entries.iterator();
        while (it.hasNext()) {
            String s = it.next().getCiteKey();
            if (s == null || s.equals("")) continue;
            sortedKeys.add(s);
        }
        it = sortedKeys.iterator();
        while (it.hasNext()) {
            sb.append(Util.quote((String)((Object)it.next()), ";", '\\')).append(";");
        }
        return sb.toString();
    }

    public void clearAssignments() {
        this.m_entries.clear();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String getDescription() {
        return ExplicitGroup.getDescriptionForPreview();
    }

    public static String getDescriptionForPreview() {
        return Globals.lang("This group contains entries based on manual assignment. Entries can be assigned to this group by selecting them then using either drag and drop or the context menu. Entries can be removed from this group by selecting them then using the context menu. Every entry assigned to this group must have a unique key. The key may be changed at any time as long as it remains unique.");
    }

    @Override
    public String getShortDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<b>").append(this.getName()).append(Globals.lang("</b> - static group"));
        switch (this.getHierarchicalContext()) {
            case 2: {
                sb.append(Globals.lang(", includes subgroups"));
                break;
            }
            case 1: {
                sb.append(Globals.lang(", refines supergroup"));
                break;
            }
        }
        return sb.toString();
    }

    @Override
    public void refreshForNewDatabase(BibtexDatabase db) {
        HashSet<BibtexEntry> newSet = new HashSet<BibtexEntry>();
        for (BibtexEntry entry : this.m_entries) {
            BibtexEntry sameEntry = db.getEntryByKey(entry.getCiteKey());
            newSet.add(sameEntry);
        }
        this.m_entries.clear();
        this.m_entries.addAll(newSet);
    }

    public Set<BibtexEntry> getEntries() {
        return this.m_entries;
    }

    @Override
    public String getTypeId() {
        return ID;
    }
}

