/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.imports.BooleanAssign;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CiteSeerUndoHandler
extends DefaultHandler {
    NamedCompound citeseerNamedCompound = null;
    BibtexEntry bibEntry = null;
    String nextField = null;
    boolean nextAssign = false;
    BasePanel panel = null;
    BooleanAssign overwriteAll;
    BooleanAssign overwriteNone;
    BooleanAssign recordFound;
    String newAuthors = null;
    int citeseerCitationCount = 0;

    private boolean overwriteDialog(String oldValue, String newValue, String fieldName) {
        boolean retval = false;
        Object[] possibilities = new Object[]{"Yes", "Yes to All", "No", "No to All"};
        final JOptionPane optionPane = new JOptionPane("Do you want to overwrite the value '" + oldValue + "' \nwith the value '" + newValue + "' \nfor the " + fieldName + " field?", 3, -1, null, possibilities, "No");
        final JDialog dialog = new JDialog(this.panel.frame(), "Overwrite Value", true);
        dialog.setContentPane(optionPane);
        dialog.setDefaultCloseOperation(0);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setVisible(true);
        String userChoice = (String)optionPane.getValue();
        if (userChoice.equals("Yes to All")) {
            this.overwriteAll.setValue(true);
            retval = true;
        } else if (userChoice.equals("Yes")) {
            retval = true;
        } else if (userChoice.equals("No to All")) {
            this.overwriteNone.setValue(true);
        }
        return retval;
    }

    public CiteSeerUndoHandler(NamedCompound newCompound, BibtexEntry be, BasePanel basePanel, BooleanAssign assignment, BooleanAssign overwriteAll, BooleanAssign overwriteNone) {
        this.citeseerNamedCompound = newCompound;
        this.bibEntry = be;
        this.panel = basePanel;
        this.recordFound = assignment;
        this.recordFound.setValue(false);
        this.overwriteAll = overwriteAll;
        this.overwriteNone = overwriteNone;
    }

    public CiteSeerUndoHandler(NamedCompound newCompound, BibtexEntry be, BasePanel basePanel, BooleanAssign assignment) {
        this(newCompound, be, basePanel, assignment, new BooleanAssign(false), new BooleanAssign(false));
    }

    public void characters(char[] ch, int start, int length) {
        if (this.nextAssign) {
            String target = new String(ch, start, length);
            if (this.nextField.equals("title")) {
                if (this.makeOverwriteChoice(this.bibEntry.getField(this.nextField), target, this.nextField)) {
                    UndoableFieldChange fieldChange = new UndoableFieldChange(this.bibEntry, this.nextField, this.bibEntry.getField(this.nextField), target);
                    this.citeseerNamedCompound.addEdit(fieldChange);
                    this.bibEntry.setField(this.nextField, target);
                }
            } else if (this.nextField.equals("year")) {
                if (this.makeOverwriteChoice(this.bibEntry.getField(this.nextField), String.valueOf(target.substring(0, 4)), this.nextField)) {
                    UndoableFieldChange fieldChange = new UndoableFieldChange(this.bibEntry, this.nextField, this.bibEntry.getField(this.nextField), String.valueOf(target.substring(0, 4)));
                    this.citeseerNamedCompound.addEdit(fieldChange);
                    this.bibEntry.setField(this.nextField, String.valueOf(target.substring(0, 4)));
                }
            } else if (this.nextField.equals("citeseerurl") && this.makeOverwriteChoice(this.bibEntry.getField(this.nextField), target, this.nextField)) {
                UndoableFieldChange fieldChange = new UndoableFieldChange(this.bibEntry, this.nextField, this.bibEntry.getField(this.nextField), target);
                this.citeseerNamedCompound.addEdit(fieldChange);
                this.bibEntry.setField(this.nextField, target);
            }
            this.nextAssign = false;
        }
    }

    private boolean makeOverwriteChoice(String oldValue, String newValue, String fieldName) {
        boolean overwrite = oldValue == null || oldValue.equals("") ? true : (oldValue.equals(newValue) ? false : (this.overwriteAll.getValue() ? true : (this.overwriteNone.getValue() ? false : this.overwriteDialog(oldValue, newValue, fieldName))));
        if (overwrite) {
            this.recordFound.setValue(true);
        }
        return overwrite;
    }

    public void startElement(String name, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("oai_citeseer:relation")) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getQName(i);
                String attrValue = attrs.getValue(i);
                if (!attrName.equals("type") || !attrValue.equals("Is Referenced By")) continue;
                ++this.citeseerCitationCount;
            }
        } else if (qName.equals("oai_citeseer:author")) {
            this.addAuthor(attrs.getValue("name"));
        } else if (qName.equals("dc:title")) {
            this.nextField = "title";
            this.nextAssign = true;
        } else if (qName.equals("dc:date")) {
            this.nextField = "year";
            this.nextAssign = true;
        } else if (qName.equals("dc:identifier")) {
            this.nextField = "citeseerurl";
            this.nextAssign = true;
        }
    }

    public void endDocument() {
        if (this.newAuthors != null && this.makeOverwriteChoice(this.bibEntry.getField("author"), this.newAuthors, "author")) {
            UndoableFieldChange fieldChange = new UndoableFieldChange(this.bibEntry, "author", this.bibEntry.getField("author"), this.newAuthors);
            this.citeseerNamedCompound.addEdit(fieldChange);
            this.bibEntry.setField("author", this.newAuthors);
        }
        String newCount = new Integer(this.citeseerCitationCount).toString();
        UndoableFieldChange fieldChange = new UndoableFieldChange(this.bibEntry, "citeseercitationcount", this.bibEntry.getField("citeseercitationcount"), newCount);
        this.citeseerNamedCompound.addEdit(fieldChange);
        this.bibEntry.setField("citeseercitationcount", newCount);
    }

    private void addAuthor(String newAuthor) {
        this.newAuthors = this.newAuthors == null ? newAuthor : this.newAuthors + " and " + newAuthor;
    }
}

