/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.undo.NamedCompound;

public class AbbreviateAction
extends AbstractWorker {
    BasePanel panel;
    String message = "";
    boolean iso;

    public AbbreviateAction(BasePanel panel, boolean iso) {
        this.panel = panel;
        this.iso = iso;
    }

    public void init() {
        this.panel.output("Abbreviating...");
    }

    public void run() {
        BibtexEntry[] entries = this.panel.getSelectedEntries();
        if (entries == null) {
            return;
        }
        NamedCompound ce = new NamedCompound("Abbreviate journal names");
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!Globals.journalAbbrev.abbreviate(this.panel.database(), entries[i], "journal", ce, this.iso)) continue;
            ++count;
        }
        if (count > 0) {
            ce.end();
            this.panel.undoManager.addEdit(ce);
            this.panel.markBaseChanged();
            this.message = Globals.lang("Abbreviated %0 journal names.", String.valueOf(count));
        } else {
            this.message = Globals.lang("No journal names could be abbreviated.");
        }
    }

    public void update() {
        this.panel.output(this.message);
    }
}

