/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;

public class UndoableRemoveString
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private BibtexString string;
    private BasePanel panel;

    public UndoableRemoveString(BasePanel panel, BibtexDatabase base, BibtexString string) {
        this.base = base;
        this.string = string;
        this.panel = panel;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("remove string ");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("remove string ");
    }

    public void undo() {
        super.undo();
        try {
            this.base.addString(this.string);
        }
        catch (KeyCollisionException ex) {
            ex.printStackTrace();
        }
        this.panel.updateStringDialog();
    }

    public void redo() {
        super.redo();
        this.base.removeString(this.string.getId());
        this.panel.updateStringDialog();
    }
}

