/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;

public class IntervalSet
implements IntSet {
    public static final IntervalSet empty = new IntervalSet();
    protected List intervals = new ArrayList(2);

    public static IntervalSet of(int a) {
        IntervalSet s = new IntervalSet();
        s.add(a);
        return s;
    }

    public static IntervalSet of(int a, int b) {
        IntervalSet s = new IntervalSet();
        s.add(a, b);
        return s;
    }

    public void add(int el) {
        this.add(el, el);
    }

    public void add(int a, int b) {
        this.add(Interval.create(a, b));
    }

    protected void add(Interval addition) {
        if (addition.b < addition.a) {
            return;
        }
        ListIterator<Interval> iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval r = (Interval)iter.next();
            if (addition.equals(r)) {
                return;
            }
            if (addition.adjacent(r) || !addition.disjoint(r)) {
                Interval next;
                Interval bigger = addition.union(r);
                iter.set(bigger);
                if (iter.hasNext() && (bigger.adjacent(next = (Interval)iter.next()) || !bigger.disjoint(next))) {
                    iter.remove();
                    iter.previous();
                    iter.set(bigger.union(next));
                }
                return;
            }
            if (!addition.startsBeforeDisjoint(r)) continue;
            iter.previous();
            iter.add(addition);
            return;
        }
        this.intervals.add(addition);
    }

    public void addAll(IntSet set) {
        if (set == null) {
            return;
        }
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't add non IntSet (" + set.getClass().getName() + ") to IntervalSet");
        }
        IntervalSet other = (IntervalSet)set;
        Iterator iter = other.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            this.add(I.a, I.b);
        }
    }

    public IntSet complement(int minElement, int maxElement) {
        return this.complement(IntervalSet.of(minElement, maxElement));
    }

    public IntSet complement(IntSet vocabulary) {
        if (vocabulary == null) {
            return null;
        }
        if (!(vocabulary instanceof IntervalSet)) {
            throw new IllegalArgumentException("can't complement with non IntervalSet (" + vocabulary.getClass().getName() + ')');
        }
        IntervalSet vocabularyIS = (IntervalSet)vocabulary;
        int maxElement = vocabularyIS.getMaxElement();
        IntervalSet compl = new IntervalSet();
        if (this.intervals.size() == 0) {
            return compl;
        }
        Interval first = (Interval)this.intervals.get(0);
        if (first.a > 0) {
            IntervalSet s = IntervalSet.of(0, first.a - 1);
            IntervalSet a = (IntervalSet)s.and(vocabularyIS);
            compl.addAll(a);
        }
        int i = 1;
        while (i < this.intervals.size()) {
            Interval previous = (Interval)this.intervals.get(i - 1);
            Interval current = (Interval)this.intervals.get(i);
            IntervalSet s = IntervalSet.of(previous.b + 1, current.a - 1);
            IntervalSet a = (IntervalSet)s.and(vocabularyIS);
            compl.addAll(a);
            ++i;
        }
        Interval last = (Interval)this.intervals.get(this.intervals.size() - 1);
        if (last.b < maxElement) {
            IntervalSet s = IntervalSet.of(last.b + 1, maxElement);
            IntervalSet a = (IntervalSet)s.and(vocabularyIS);
            compl.addAll(a);
        }
        return compl;
    }

    public IntSet subtract(IntSet other) {
        return this.and(((IntervalSet)other).complement(0, 65534));
    }

    public IntSet or(IntSet a) {
        return null;
    }

    public IntSet and(IntSet other) {
        if (other == null) {
            return null;
        }
        ArrayList myIntervals = (ArrayList)this.intervals;
        ArrayList theirIntervals = (ArrayList)((IntervalSet)other).intervals;
        IntervalSet intersection = null;
        int mySize = myIntervals.size();
        int theirSize = theirIntervals.size();
        int i = 0;
        int j = 0;
        while (i < mySize && j < theirSize) {
            Interval theirs;
            Interval mine = (Interval)myIntervals.get(i);
            if (mine.startsBeforeDisjoint(theirs = (Interval)theirIntervals.get(j))) {
                ++i;
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                ++j;
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++j;
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                ++i;
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                ++j;
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            ++i;
        }
        if (intersection == null) {
            return empty;
        }
        return intersection;
    }

    public IntSet and_OLD(IntSet other) {
        if (other == null) {
            return null;
        }
        ListIterator thisIter = this.intervals.listIterator();
        ListIterator otherIter = ((IntervalSet)other).intervals.listIterator();
        Interval mine = null;
        Interval theirs = null;
        if (thisIter.hasNext()) {
            mine = (Interval)thisIter.next();
        }
        if (otherIter.hasNext()) {
            theirs = (Interval)otherIter.next();
        }
        IntervalSet intersection = null;
        while (mine != null && theirs != null) {
            if (mine.startsBeforeDisjoint(theirs)) {
                mine = null;
                if (!thisIter.hasNext()) continue;
                mine = (Interval)thisIter.next();
                continue;
            }
            if (theirs.startsBeforeDisjoint(mine)) {
                theirs = null;
                if (!otherIter.hasNext()) continue;
                theirs = (Interval)otherIter.next();
                continue;
            }
            if (mine.properlyContains(theirs)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                theirs = null;
                if (!otherIter.hasNext()) continue;
                theirs = (Interval)otherIter.next();
                continue;
            }
            if (theirs.properlyContains(mine)) {
                if (intersection == null) {
                    intersection = new IntervalSet();
                }
                intersection.add(mine.intersection(theirs));
                mine = null;
                if (!thisIter.hasNext()) continue;
                mine = (Interval)thisIter.next();
                continue;
            }
            if (mine.disjoint(theirs)) continue;
            if (intersection == null) {
                intersection = new IntervalSet();
            }
            intersection.add(mine.intersection(theirs));
            if (mine.startsAfterNonDisjoint(theirs)) {
                theirs = null;
                if (!otherIter.hasNext()) continue;
                theirs = (Interval)otherIter.next();
                continue;
            }
            if (!theirs.startsAfterNonDisjoint(mine)) continue;
            mine = null;
            if (!thisIter.hasNext()) continue;
            mine = (Interval)thisIter.next();
        }
        if (intersection == null) {
            return empty;
        }
        return intersection;
    }

    public boolean member(int el) {
        ListIterator iter = this.intervals.listIterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            if (el < I.a) break;
            if (el < I.a || el > I.b) continue;
            return true;
        }
        return false;
    }

    public boolean isNil() {
        boolean bl = false;
        if (this.intervals == null || this.intervals.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public int getSingleElement() {
        if (this.intervals != null && this.intervals.size() == 1) {
            Interval I = (Interval)this.intervals.get(0);
            if (I.a == I.b) {
                return I.a;
            }
        }
        return -6;
    }

    public int getMaxElement() {
        if (this.isNil()) {
            return -6;
        }
        Interval last = (Interval)this.intervals.get(this.intervals.size() - 1);
        return last.b;
    }

    public int getMinElement() {
        if (this.isNil()) {
            return -6;
        }
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            int a = I.a;
            int b = I.b;
            int v = a;
            while (v <= b) {
                if (v >= 0) {
                    return v;
                }
                ++v;
            }
        }
        return -6;
    }

    public List getIntervals() {
        return this.intervals;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IntervalSet)) {
            return false;
        }
        IntervalSet other = (IntervalSet)obj;
        return this.intervals.equals(other.intervals);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Grammar g) {
        StringBuffer buf = new StringBuffer();
        if (this.intervals == null || this.intervals.size() == 0) {
            return "{}";
        }
        if (this.intervals.size() > 1) {
            buf.append("{");
        }
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            int a = I.a;
            int b = I.b;
            if (a == b) {
                if (g != null) {
                    buf.append(g.getTokenDisplayName(a));
                } else {
                    buf.append(a);
                }
            } else if (g != null) {
                buf.append(g.getTokenDisplayName(a) + ".." + g.getTokenDisplayName(b));
            } else {
                buf.append(a + ".." + b);
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.intervals.size() > 1) {
            buf.append("}");
        }
        return buf.toString();
    }

    public int size() {
        int n = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            int a = I.a;
            int b = I.b;
            n += b - a + 1;
        }
        return n;
    }

    public List toList() {
        ArrayList<Integer> values = new ArrayList<Integer>();
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            int a = I.a;
            int b = I.b;
            int v = a;
            while (v <= b) {
                values.add(Utils.integer(v));
                ++v;
            }
        }
        return values;
    }

    public int[] toArray() {
        int[] values = new int[this.size()];
        Iterator iter = this.intervals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Interval I = (Interval)iter.next();
            int a = I.a;
            int b = I.b;
            int v = a;
            while (v <= b) {
                values[i] = v++;
                ++i;
            }
        }
        return values;
    }

    public void remove(int el) {
        throw new NoSuchMethodError("IntervalSet.remove() unimplemented");
    }
}

