/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.io.FileInputStream;
import java.security.KeyStore;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;

public class DecryptPKI {
    public static void main(String[] args) throws Exception {
        DecryptPKI d = new DecryptPKI();
        d.decrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrypt(String[] args) throws Exception {
        if (args.length < 2) {
            DecryptPKI.usage();
        } else {
            String password = "";
            String alias = null;
            String input = null;
            String certfile = null;
            String output = null;
            PDDocument doc = null;
            for (int i = 0; i < args.length; ++i) {
                String key = args[i];
                if (key.equals("-P")) {
                    password = args[++i];
                    continue;
                }
                if (key.equals("-A")) {
                    alias = args[++i];
                    continue;
                }
                if (input == null) {
                    input = key;
                    continue;
                }
                if (certfile == null) {
                    certfile = key;
                    continue;
                }
                if (output == null) {
                    output = key;
                    continue;
                }
                DecryptPKI.usage();
            }
            try {
                if (certfile == null || input == null) {
                    DecryptPKI.usage();
                }
                if (output == null) {
                    output = input;
                }
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(new FileInputStream(certfile), password.toCharArray());
                PublicKeyDecryptionMaterial pdm = new PublicKeyDecryptionMaterial(ks, alias, password);
                doc = PDDocument.load(input);
                if (!doc.isEncrypted()) {
                    throw new Error("Error: Document is not encrypted.");
                }
                doc.openProtection(pdm);
                AccessPermission currentPerm = doc.getCurrentAccessPermission();
                if (!currentPerm.isOwnerPermission()) {
                    throw new Error("Error: You were not allowed to extract content of the document");
                }
                doc.save(output);
            }
            finally {
                if (doc != null) {
                    doc.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java org.pdfbox.DecryptPKI [options] <inputfile> <certfile> [outputfile]");
        System.err.println("   -A <alias>                            \t the alias of the key in the certificate file (mandatory if several keys are available)");
        System.err.println("   -P <password>                            the password to open the certificate and extract the private key from it.");
    }
}

