/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.util.ImageParameters;
import org.pdfbox.util.PDFOperator;

public class ContentStreamWriter {
    private OutputStream output;
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] EOL = System.getProperty("line.separator").getBytes();

    public ContentStreamWriter(OutputStream out) {
        this.output = out;
    }

    public void writeTokens(List tokens, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            Object o = tokens.get(i);
            this.writeObject(o);
            this.output.write(32);
        }
        this.output.flush();
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof COSString) {
            ((COSString)o).writePDF(this.output);
        } else if (o instanceof COSFloat) {
            ((COSFloat)o).writePDF(this.output);
        } else if (o instanceof COSInteger) {
            ((COSInteger)o).writePDF(this.output);
        } else if (o instanceof COSBoolean) {
            ((COSBoolean)o).writePDF(this.output);
        } else if (o instanceof COSName) {
            ((COSName)o).writePDF(this.output);
        } else if (o instanceof COSArray) {
            COSArray array = (COSArray)o;
            this.output.write(COSWriter.ARRAY_OPEN);
            for (int i = 0; i < array.size(); ++i) {
                this.writeObject(array.get(i));
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.ARRAY_CLOSE);
        } else if (o instanceof COSDictionary) {
            COSDictionary obj = (COSDictionary)o;
            this.output.write(COSWriter.DICT_OPEN);
            Iterator i = obj.keyList().iterator();
            while (i.hasNext()) {
                COSName name = (COSName)i.next();
                COSBase value = obj.getItem(name);
                if (value == null) continue;
                this.writeObject(name);
                this.output.write(SPACE);
                this.writeObject(value);
                this.output.write(SPACE);
            }
            this.output.write(COSWriter.DICT_CLOSE);
            this.output.write(SPACE);
        } else if (o instanceof PDFOperator) {
            PDFOperator op = (PDFOperator)o;
            if (op.getOperation().equals("BI")) {
                this.output.write("BI".getBytes());
                ImageParameters params = op.getImageParameters();
                COSDictionary dic = params.getDictionary();
                Iterator iter = dic.keyList().iterator();
                while (iter.hasNext()) {
                    COSName key = (COSName)iter.next();
                    COSBase value = dic.getDictionaryObject(key);
                    key.writePDF(this.output);
                    this.output.write(SPACE);
                    this.writeObject(value);
                    this.output.write(EOL);
                }
                this.output.write("ID".getBytes());
                this.output.write(EOL);
                this.output.write(op.getImageData());
            } else {
                this.output.write(op.getOperation().getBytes());
                this.output.write(EOL);
            }
        } else {
            throw new IOException("Error:Unknown type in content stream:" + o);
        }
    }

    public void writeTokens(List tokens) throws IOException {
        this.writeTokens(tokens, 0, tokens.size());
    }
}

