/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.annotation;

import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.graphics.color.PDGamma;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.pdfbox.pdmodel.interactive.annotation.PDBorderEffectDictionary;

public class PDAnnotationSquareCircle
extends PDAnnotationMarkup {
    public static final String SUB_TYPE_SQUARE = "Square";
    public static final String SUB_TYPE_CIRCLE = "Circle";

    private PDAnnotationSquareCircle() {
    }

    public PDAnnotationSquareCircle(String subType) {
        this.setSubtype(subType);
    }

    public PDAnnotationSquareCircle(COSDictionary field) {
        super(field);
    }

    public void setInteriorColour(PDGamma ic) {
        this.getDictionary().setItem("IC", (COSObjectable)ic);
    }

    public PDGamma getInteriorColour() {
        COSArray ic = (COSArray)this.getDictionary().getItem(COSName.getPDFName("IC"));
        if (ic != null) {
            return new PDGamma(ic);
        }
        return null;
    }

    public void setBorderEffect(PDBorderEffectDictionary be) {
        this.getDictionary().setItem("BE", (COSObjectable)be);
    }

    public PDBorderEffectDictionary getBorderEffect() {
        COSDictionary be = (COSDictionary)this.getDictionary().getDictionaryObject("BE");
        if (be != null) {
            return new PDBorderEffectDictionary(be);
        }
        return null;
    }

    public void setRectDifference(PDRectangle rd) {
        this.getDictionary().setItem("RD", (COSObjectable)rd);
    }

    public PDRectangle getRectDifference() {
        COSArray rd = (COSArray)this.getDictionary().getDictionaryObject("RD");
        if (rd != null) {
            return new PDRectangle(rd);
        }
        return null;
    }

    public void setSubtype(String subType) {
        this.getDictionary().setName(COSName.SUBTYPE, subType);
    }

    public String getSubtype() {
        return this.getDictionary().getNameAsString(COSName.SUBTYPE);
    }
}

